/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.j2d;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.packrect.BackingStoreManager;
import com.sun.opengl.impl.packrect.Rect;
import com.sun.opengl.impl.packrect.RectVisitor;
import com.sun.opengl.impl.packrect.RectanglePacker;
import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.FPSAnimator;
import com.sun.opengl.util.j2d.TextureRenderer;
import com.sun.opengl.util.texture.Texture;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class TextRenderer {
    private static final boolean DEBUG = Debug.debug("TextRenderer");
    static final int kSize = 256;
    private static final int CYCLES_PER_FLUSH = 100;
    private static final float MAX_VERTICAL_FRAGMENTATION = 0.7f;
    static final int kQuadsPerBuffer = 100;
    static final int kCoordsPerVertVerts = 3;
    static final int kCoordsPerVertTex = 2;
    static final int kVertsPerQuad = 4;
    static final int kTotalBufferSizeVerts = 400;
    static final int kTotalBufferSizeCoordsVerts = 1200;
    static final int kTotalBufferSizeCoordsTex = 800;
    static final int kTotalBufferSizeBytesVerts = 4800;
    static final int kTotalBufferSizeBytesTex = 3200;
    static final int kSizeInBytes_OneVertices_VertexData = 12;
    static final int kSizeInBytes_OneVertices_TexData = 8;
    private Font font;
    private boolean antialiased;
    private boolean useFractionalMetrics;
    private boolean mipmap;
    private RectanglePacker packer;
    private boolean haveMaxSize;
    private RenderDelegate renderDelegate;
    private TextureRenderer cachedBackingStore;
    private Graphics2D cachedGraphics;
    private FontRenderContext cachedFontRenderContext;
    private Map stringLocations = new HashMap();
    private GlyphProducer mGlyphProducer;
    private boolean splitAtSpaces = false;
    private int spaceWidth = -1;
    private List tokenizationResults = new ArrayList();
    private int numRenderCycles;
    private boolean inBeginEndPair;
    private boolean isOrthoMode;
    private int beginRenderingWidth;
    private int beginRenderingHeight;
    private boolean beginRenderingDepthTestDisabled;
    private boolean haveCachedColor;
    private float cachedR;
    private float cachedG;
    private float cachedB;
    private float cachedA;
    private Color cachedColor;
    private boolean needToResetColor;
    private Frame dbgFrame;
    private boolean debugged;
    Pipelined_QuadRenderer mPipelinedQuadRenderer;

    public TextRenderer(Font font) {
        this(font, false, false, null, false);
    }

    public TextRenderer(Font font, boolean bl) {
        this(font, false, false, null, bl);
    }

    public TextRenderer(Font font, boolean bl, boolean bl2) {
        this(font, bl, bl2, null, false);
    }

    public TextRenderer(Font font, boolean bl, boolean bl2, RenderDelegate renderDelegate) {
        this(font, bl, bl2, renderDelegate, false);
    }

    public TextRenderer(Font font, boolean bl, boolean bl2, RenderDelegate renderDelegate, boolean bl3) {
        this.font = font;
        this.antialiased = bl;
        this.useFractionalMetrics = bl2;
        this.mipmap = bl3;
        this.packer = new RectanglePacker(new Manager(), 256, 256);
        if (renderDelegate == null) {
            renderDelegate = new DefaultRenderDelegate();
        }
        this.renderDelegate = renderDelegate;
        this.mGlyphProducer = new GlyphProducer(this.getFontRenderContext(), font.getNumGlyphs());
    }

    public Rectangle2D getBounds(String string) {
        return this.getBounds((CharSequence)string);
    }

    public Rectangle2D getBounds(CharSequence charSequence) {
        Rect rect = null;
        rect = (Rect)this.stringLocations.get(charSequence);
        if (rect != null) {
            TextData textData = (TextData)rect.getUserData();
            return new Rectangle2D.Double(-textData.origin().x, -textData.origin().y, rect.w(), rect.h());
        }
        return TextRenderer.normalize(this.renderDelegate.getBounds(charSequence, this.font, this.getFontRenderContext()));
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        if (this.cachedFontRenderContext == null) {
            this.cachedFontRenderContext = this.getGraphics2D().getFontRenderContext();
        }
        return this.cachedFontRenderContext;
    }

    public void beginRendering(int n, int n2) throws GLException {
        this.beginRendering(n, n2, true);
    }

    public void beginRendering(int n, int n2, boolean bl) throws GLException {
        this.beginRendering(true, n, n2, bl);
    }

    public void begin3DRendering() throws GLException {
        this.beginRendering(false, 0, 0, false);
    }

    public void setColor(Color color) throws GLException {
        boolean bl;
        boolean bl2 = bl = this.haveCachedColor && this.cachedColor != null && color.equals(this.cachedColor);
        if (!bl) {
            this.flushGlyphPipeline();
        }
        this.getBackingStore().setColor(color);
        this.haveCachedColor = true;
        this.cachedColor = color;
    }

    public void setColor(float f, float f2, float f3, float f4) throws GLException {
        boolean bl;
        boolean bl2 = bl = this.haveCachedColor && this.cachedColor == null && f == this.cachedR && f2 == this.cachedG && f3 == this.cachedB && f4 == this.cachedA;
        if (!bl) {
            this.flushGlyphPipeline();
        }
        this.getBackingStore().setColor(f, f2, f3, f4);
        this.haveCachedColor = true;
        this.cachedR = f;
        this.cachedG = f2;
        this.cachedB = f3;
        this.cachedA = f4;
        this.cachedColor = null;
    }

    public void draw(CharSequence charSequence, int n, int n2) throws GLException {
        this.draw3D(charSequence, (float)n, (float)n2, 0.0f, 1.0f);
    }

    public void draw(String string, int n, int n2) throws GLException {
        this.draw3D(string, (float)n, (float)n2, 0.0f, 1.0f);
    }

    public void draw3D(CharSequence charSequence, float f, float f2, float f3, float f4) {
        this.internal_draw3D(charSequence, f, f2, f3, f4);
    }

    public void draw3D(String string, float f, float f2, float f3, float f4) {
        this.internal_draw3D(string, f, f2, f3, f4);
    }

    public float getCharWidth(char c) {
        return this.mGlyphProducer.getGlyphPixelWidth(c);
    }

    public void flush() {
        this.flushGlyphPipeline();
    }

    public void endRendering() throws GLException {
        this.endRendering(true);
    }

    private int getSpaceWidth() {
        if (this.spaceWidth < 0) {
            Graphics2D graphics2D = this.getGraphics2D();
            FontRenderContext fontRenderContext = this.getFontRenderContext();
            GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, " ");
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(0);
            this.spaceWidth = (int)glyphMetrics.getAdvanceX();
        }
        return this.spaceWidth;
    }

    public void end3DRendering() throws GLException {
        this.endRendering(false);
    }

    public void dispose() throws GLException {
        this.packer.dispose();
        this.packer = null;
        this.cachedBackingStore = null;
        this.cachedGraphics = null;
        this.cachedFontRenderContext = null;
        if (this.dbgFrame != null) {
            this.dbgFrame.dispose();
        }
    }

    private static Rectangle2D normalize(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double((int)Math.floor(rectangle2D.getMinX() - 1.0), (int)Math.floor(rectangle2D.getMinY() - 1.0), (int)Math.ceil(rectangle2D.getWidth() + 2.0), (int)Math.ceil(rectangle2D.getHeight()) + 2);
    }

    private TextureRenderer getBackingStore() {
        TextureRenderer textureRenderer = (TextureRenderer)this.packer.getBackingStore();
        if (textureRenderer != this.cachedBackingStore) {
            if (this.cachedGraphics != null) {
                this.cachedGraphics.dispose();
                this.cachedGraphics = null;
                this.cachedFontRenderContext = null;
            }
            this.cachedBackingStore = textureRenderer;
        }
        return this.cachedBackingStore;
    }

    private Graphics2D getGraphics2D() {
        TextureRenderer textureRenderer = this.getBackingStore();
        if (this.cachedGraphics == null) {
            this.cachedGraphics = textureRenderer.createGraphics();
            this.cachedGraphics.setComposite(AlphaComposite.Src);
            this.cachedGraphics.setColor(Color.WHITE);
            this.cachedGraphics.setFont(this.font);
            this.cachedGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialiased ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.cachedGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.useFractionalMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        return this.cachedGraphics;
    }

    private void beginRendering(boolean bl, int n, int n2, boolean bl2) {
        if (DEBUG && !this.debugged) {
            this.debug();
        }
        this.inBeginEndPair = true;
        this.isOrthoMode = bl;
        this.beginRenderingWidth = n;
        this.beginRenderingHeight = n2;
        this.beginRenderingDepthTestDisabled = bl2;
        if (bl) {
            this.getBackingStore().beginOrthoRendering(n, n2, bl2);
        } else {
            this.getBackingStore().begin3DRendering();
        }
        GL gL = GLU.getCurrentGL();
        gL.glPushClientAttrib(-1);
        if (!this.haveMaxSize) {
            int[] nArray = new int[1];
            gL.glGetIntegerv(3379, nArray, 0);
            this.packer.setMaxSize(nArray[0], nArray[0]);
            this.haveMaxSize = true;
        }
        if (this.needToResetColor && this.haveCachedColor) {
            if (this.cachedColor == null) {
                this.getBackingStore().setColor(this.cachedR, this.cachedG, this.cachedB, this.cachedA);
            } else {
                this.getBackingStore().setColor(this.cachedColor);
            }
            this.needToResetColor = false;
        }
        if (this.mipmap && !this.getBackingStore().isUsingAutoMipmapGeneration()) {
            if (DEBUG) {
                System.err.println("Disabled mipmapping in TextRenderer");
            }
            this.mipmap = false;
        }
    }

    private void endRendering(boolean bl) throws GLException {
        this.flushGlyphPipeline();
        this.inBeginEndPair = false;
        GL gL = GLU.getCurrentGL();
        gL.glPopClientAttrib();
        if (gL.isExtensionAvailable("GL_VERSION_1_5")) {
            gL.glBindBuffer(34962, 0);
        }
        if (bl) {
            this.getBackingStore().endOrthoRendering();
        } else {
            this.getBackingStore().end3DRendering();
        }
        if (++this.numRenderCycles >= 100) {
            this.numRenderCycles = 0;
            if (DEBUG) {
                System.err.println("Clearing unused entries in endRendering()");
            }
            this.clearUnusedEntries();
        }
    }

    private void tokenize(CharSequence charSequence) {
        this.tokenizationResults.clear();
        if (!this.splitAtSpaces) {
            this.tokenizationResults.add(((Object)charSequence).toString());
        } else {
            int n = 0;
            boolean bl = false;
            int n2 = charSequence.length();
            for (int i = 0; i < n2; ++i) {
                if (charSequence.charAt(i) != ' ') continue;
                if (n < i) {
                    this.tokenizationResults.add(((Object)charSequence.subSequence(n, i)).toString());
                } else {
                    this.tokenizationResults.add(null);
                }
                n = i + 1;
            }
            if (n == 0) {
                this.tokenizationResults.add(charSequence);
            } else if (n < n2) {
                this.tokenizationResults.add(((Object)charSequence.subSequence(n, n2)).toString());
            }
        }
    }

    private void clearUnusedEntries() {
        final ArrayList arrayList = new ArrayList();
        this.packer.visit(new RectVisitor(){

            public void visit(Rect rect) {
                TextData textData = (TextData)rect.getUserData();
                if (textData.used()) {
                    textData.clearUsed();
                } else {
                    arrayList.add(rect);
                }
            }
        });
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Rect rect = (Rect)iterator.next();
            this.packer.remove(rect);
            this.stringLocations.remove(((TextData)rect.getUserData()).string());
            int n = ((TextData)rect.getUserData()).unicodeID;
            if (n <= 0) continue;
            this.mGlyphProducer.clearCacheEntry(n);
        }
        float f = this.packer.verticalFragmentationRatio();
        if (!arrayList.isEmpty() && f > 0.7f) {
            if (DEBUG) {
                System.err.println("Compacting TextRenderer backing store due to vertical fragmentation " + f);
            }
            this.packer.compact();
        }
        if (DEBUG) {
            this.getBackingStore().markDirty(0, 0, this.getBackingStore().getWidth(), this.getBackingStore().getHeight());
        }
    }

    private void internal_draw3D(CharSequence charSequence, float f, float f2, float f3, float f4) {
        int n = 1;
        while (n != 3) {
            GlyphsList glyphsList = this.mGlyphProducer.getGlyphs(charSequence);
            if (n == 1) {
                f += this.drawGlyphs(glyphsList, f, f2, f3, f4);
                charSequence = glyphsList.remaining;
                n = glyphsList.nextState;
                continue;
            }
            if (n != 2) continue;
            this.draw3D_ROBUST(charSequence, f, f2, f3, f4);
            n = 3;
        }
    }

    private void flushGlyphPipeline() {
        if (this.mPipelinedQuadRenderer != null) {
            this.mPipelinedQuadRenderer.draw();
        }
    }

    private float drawGlyphs(GlyphsList glyphsList, float f, float f2, float f3, float f4) {
        float f5 = 0.0f;
        try {
            if (this.mPipelinedQuadRenderer == null) {
                this.mPipelinedQuadRenderer = new Pipelined_QuadRenderer();
            }
            TextureRenderer textureRenderer = this.getBackingStore();
            for (int i = 0; i < glyphsList.length; ++i) {
                Rect rect = glyphsList.textureSourceRect[i];
                TextData textData = (TextData)rect.getUserData();
                textData.markUsed();
                float f6 = f + f5 - f4 * (float)textData.origin().x;
                float f7 = f2 - f4 * (float)(rect.h() - textData.origin().y);
                int n = rect.x();
                int n2 = textureRenderer.getHeight() - rect.y() - rect.h();
                int n3 = rect.w();
                int n4 = rect.h();
                float f8 = (float)n / (float)textureRenderer.getWidth();
                float f9 = 1.0f - (float)n2 / (float)textureRenderer.getHeight();
                float f10 = (float)(n + n3) / (float)textureRenderer.getWidth();
                float f11 = 1.0f - (float)(n2 + n4) / (float)textureRenderer.getHeight();
                this.mPipelinedQuadRenderer.glTexCoord2f(f8, f9);
                this.mPipelinedQuadRenderer.glVertex3f(f6, f7, f3);
                this.mPipelinedQuadRenderer.glTexCoord2f(f10, f9);
                this.mPipelinedQuadRenderer.glVertex3f(f6 + (float)n3 * f4, f7, f3);
                this.mPipelinedQuadRenderer.glTexCoord2f(f10, f11);
                this.mPipelinedQuadRenderer.glVertex3f(f6 + (float)n3 * f4, f7 + (float)n4 * f4, f3);
                this.mPipelinedQuadRenderer.glTexCoord2f(f8, f11);
                this.mPipelinedQuadRenderer.glVertex3f(f6, f7 + (float)n4 * f4, f3);
                f5 += glyphsList.advances[i] * f4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f5;
    }

    private float drawGlyphsSIMPLE(GlyphsList glyphsList, float f, float f2, float f3, float f4) {
        TextureRenderer textureRenderer = this.getBackingStore();
        int n = 0;
        for (int i = 0; i < glyphsList.length; ++i) {
            Rect rect = glyphsList.textureSourceRect[i];
            if (rect == null) continue;
            TextData textData = (TextData)rect.getUserData();
            textData.markUsed();
            textureRenderer.draw3DRect(f + (float)n - f4 * (float)textData.origin().x, f2 - f4 * (float)(rect.h() - textData.origin().y), f3, rect.x(), textureRenderer.getHeight() - rect.y() - rect.h(), rect.w(), rect.h(), f4);
            n += (int)(glyphsList.advances[i] * f4 + 0.5f);
        }
        return n;
    }

    private void draw3D_ROBUST(CharSequence charSequence, float f, float f2, float f3, float f4) {
        this.tokenize(charSequence);
        int n = 0;
        Iterator iterator = this.tokenizationResults.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string != null) {
                Object object;
                Object object2;
                Rect rect = (Rect)this.stringLocations.get(string);
                if (rect == null) {
                    object2 = this.getGraphics2D();
                    object = TextRenderer.normalize(this.renderDelegate.getBounds(string, this.font, this.getFontRenderContext()));
                    Point point = new Point((int)(-((RectangularShape)object).getMinX()), (int)(-((RectangularShape)object).getMinY()));
                    rect = new Rect(0, 0, (int)((RectangularShape)object).getWidth(), (int)((RectangularShape)object).getHeight(), new TextData(string, point, -1));
                    this.packer.add(rect);
                    this.stringLocations.put(string, rect);
                    object2 = this.getGraphics2D();
                    int n2 = rect.x() + point.x;
                    int n3 = rect.y() + point.y;
                    ((Graphics2D)object2).setComposite(AlphaComposite.Clear);
                    ((Graphics)object2).fillRect(rect.x(), rect.y(), rect.w(), rect.h());
                    ((Graphics2D)object2).setComposite(AlphaComposite.Src);
                    this.renderDelegate.draw((Graphics2D)object2, string, n2, n3);
                    this.getBackingStore().markDirty(rect.x(), rect.y(), rect.w(), rect.h());
                }
                object2 = this.getBackingStore();
                object = (TextData)rect.getUserData();
                ((TextData)object).markUsed();
                ((TextureRenderer)object2).draw3DRect(f + (float)n - f4 * (float)((TextData)object).origin().x, f2 - f4 * (float)(rect.h() - ((TextData)object).origin().y), f3, rect.x(), ((TextureRenderer)object2).getHeight() - rect.y() - rect.h(), rect.w(), rect.h(), f4);
                n = (int)((float)n + (float)rect.w() * f4);
            }
            n = (int)((float)n + (float)this.getSpaceWidth() * f4);
        }
    }

    private void debug() {
        this.dbgFrame = new Frame("TextRenderer Debug Output");
        GLCanvas gLCanvas = new GLCanvas(new GLCapabilities(), null, GLContext.getCurrent(), null);
        gLCanvas.addGLEventListener(new DebugListener(this.dbgFrame));
        this.dbgFrame.add(gLCanvas);
        final FPSAnimator fPSAnimator = new FPSAnimator(gLCanvas, 10);
        this.dbgFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        2.access$100(this.this$1).stop();
                    }
                }).start();
            }

            static /* synthetic */ FPSAnimator access$100(2 var0) {
                return var0.fPSAnimator;
            }
        });
        this.dbgFrame.setSize(256, 256);
        this.dbgFrame.setVisible(true);
        fPSAnimator.start();
        this.debugged = true;
    }

    class DebugListener
    implements GLEventListener {
        private GLU glu = new GLU();
        private Frame frame;

        DebugListener(Frame frame) {
            this.frame = frame;
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glClear(16640);
            if (TextRenderer.this.packer == null) {
                return;
            }
            TextureRenderer textureRenderer = TextRenderer.this.getBackingStore();
            int n = textureRenderer.getWidth();
            int n2 = textureRenderer.getHeight();
            textureRenderer.beginOrthoRendering(n, n2);
            textureRenderer.drawOrthoRect(0, 0);
            textureRenderer.endOrthoRendering();
            if (this.frame.getWidth() != n || this.frame.getHeight() != n2) {
                EventQueue.invokeLater(new Runnable(this, n, n2){
                    private final /* synthetic */ int val$w;
                    private final /* synthetic */ int val$h;
                    private final /* synthetic */ DebugListener this$1;
                    {
                        this.this$1 = debugListener;
                        this.val$w = n;
                        this.val$h = n2;
                    }

                    public void run() {
                        DebugListener.access$2500(this.this$1).setSize(this.val$w, this.val$h);
                    }
                });
            }
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        static /* synthetic */ Frame access$2500(DebugListener debugListener) {
            return debugListener.frame;
        }
    }

    public static class DefaultRenderDelegate
    implements RenderDelegate {
        public boolean intensityOnly() {
            return true;
        }

        public Rectangle2D getBounds(CharSequence charSequence, Font font, FontRenderContext fontRenderContext) {
            return this.getBounds(font.createGlyphVector(fontRenderContext, new MapCharSequenceToGlyphVector(charSequence)), fontRenderContext);
        }

        public Rectangle2D getBounds(String string, Font font, FontRenderContext fontRenderContext) {
            return this.getBounds(font.createGlyphVector(fontRenderContext, string), fontRenderContext);
        }

        public Rectangle2D getBounds(GlyphVector glyphVector, FontRenderContext fontRenderContext) {
            return glyphVector.getPixelBounds(fontRenderContext, 0.0f, 0.0f);
        }

        public void drawGlyphVector(Graphics2D graphics2D, GlyphVector glyphVector, int n, int n2) {
            graphics2D.drawGlyphVector(glyphVector, n, n2);
        }

        public void draw(Graphics2D graphics2D, String string, int n, int n2) {
            graphics2D.drawString(string, n, n2);
        }
    }

    private static class DrawingState {
        public static final int fast = 1;
        public static final int robust = 2;
        public static final int finished = 3;

        private DrawingState() {
        }
    }

    class GlyphProducer {
        final int undefined = -2;
        final int needComplex = -1;
        FontRenderContext fontRenderContext;
        GlyphsList glyphsOutput = new GlyphsList();
        GlyphsUploadList glyphsToUpload = new GlyphsUploadList();
        char[] unicodes;
        int[] unicodes2Glyphs;
        char[] singleUnicode;
        Rect[] glyphRectForTextureMapping;
        float[] advances;
        MapCharSequenceToGlyphVector iter = new MapCharSequenceToGlyphVector();
        char[] tempChars = new char[1];

        GlyphProducer(FontRenderContext fontRenderContext, int n) {
            this.fontRenderContext = fontRenderContext;
            if (this.advances == null) {
                this.advances = new float[n];
                this.glyphRectForTextureMapping = new Rect[n];
                this.unicodes2Glyphs = new int[512];
                this.singleUnicode = new char[1];
                this.clearAllCacheEntries();
            }
        }

        public void clearCacheEntry(int n) {
            this.unicodes2Glyphs[n] = -2;
        }

        public void clearAllCacheEntries() {
            for (int i = 0; i < this.unicodes2Glyphs.length; ++i) {
                this.unicodes2Glyphs[i] = -2;
            }
        }

        public void allocateSpace(int n) {
            n = Math.max(n, 100);
            if (this.unicodes == null || this.unicodes.length < n) {
                this.unicodes = new char[n];
            }
            this.glyphsToUpload.allocateSpace(n);
            this.glyphsOutput.allocateSpace(n);
        }

        float getGlyphPixelWidth(char c) {
            int n = -2;
            if (c < this.unicodes2Glyphs.length) {
                n = this.unicodes2Glyphs[c];
            }
            if (n != -2) {
                return this.advances[n];
            }
            this.tempChars[0] = c;
            GlyphVector glyphVector = TextRenderer.this.font.createGlyphVector(this.fontRenderContext, this.tempChars);
            return glyphVector.getGlyphMetrics(0).getAdvance();
        }

        GlyphsList puntToRobust(CharSequence charSequence) {
            this.glyphsOutput.nextState = 2;
            this.glyphsOutput.remaining = charSequence;
            return this.glyphsOutput;
        }

        GlyphsList getGlyphs(CharSequence charSequence) {
            float f = TextRenderer.this.font.getSize();
            if (f > 128.0f) {
                this.glyphsOutput.nextState = 2;
                this.glyphsOutput.remaining = charSequence;
            }
            int n = charSequence.length();
            this.allocateSpace(n);
            this.iter.initFromCharSequence(charSequence);
            GlyphVector glyphVector = TextRenderer.this.font.createGlyphVector(this.fontRenderContext, this.iter);
            boolean bl = glyphVector.getLayoutFlags() != 0;
            int n2 = glyphVector.getNumGlyphs();
            if (bl) {
                return this.puntToRobust(charSequence);
            }
            TextureRenderer textureRenderer = TextRenderer.this.getBackingStore();
            float f2 = 0.0f;
            float f3 = textureRenderer.getWidth() * textureRenderer.getHeight();
            for (int i = 0; i < n2; ++i) {
                float f4;
                Object object;
                Object object2;
                char c = charSequence.charAt(i);
                if (c >= this.unicodes2Glyphs.length) {
                    return this.puntToRobust(charSequence);
                }
                int n3 = this.unicodes2Glyphs[c];
                if (n3 == -2) {
                    object2 = glyphVector.getGlyphMetrics(i);
                    this.singleUnicode[0] = c;
                    object = TextRenderer.this.font.createGlyphVector(this.fontRenderContext, this.singleUnicode);
                    n3 = ((GlyphVector)object).getGlyphCode(0);
                    this.advances[n3] = f4 = ((GlyphMetrics)object2).getAdvance();
                    this.glyphsToUpload.prepGlyphForUpload(c, n3, TextRenderer.this.renderDelegate.getBounds((GlyphVector)object, this.fontRenderContext), i, (GlyphVector)object);
                    f2 += f4;
                } else {
                    this.glyphsOutput.textureSourceRect[i] = object2 = this.glyphRectForTextureMapping[n3];
                    object = (TextData)((Rect)object2).getUserData();
                    ((TextData)object).markUsed();
                    f4 = this.advances[n3];
                }
                this.glyphsOutput.advances[i] = f4;
                this.glyphsOutput.totalAdvance += f4;
                if (!(f2 * f > 0.25f * f3)) continue;
                this.glyphsToUpload.uploadAnyNewGlyphs(this.glyphsOutput, this);
                this.glyphsOutput.length = i + 1;
                this.glyphsOutput.remaining = charSequence.subSequence(i + 1, n);
                this.glyphsOutput.nextState = 1;
                return this.glyphsOutput;
            }
            this.glyphsOutput.length = n2;
            this.glyphsToUpload.uploadAnyNewGlyphs(this.glyphsOutput, this);
            this.glyphsOutput.nextState = 3;
            return this.glyphsOutput;
        }
    }

    static class GlyphsList {
        int nextState;
        CharSequence remaining;
        float[] advances;
        float totalAdvance;
        Rect[] textureSourceRect;
        int length;

        GlyphsList() {
        }

        public void allocateSpace(int n) {
            int n2 = Math.max(n, 100);
            if (this.advances == null || this.advances.length < n2) {
                this.advances = new float[n2];
                this.textureSourceRect = new Rect[n2];
            }
        }
    }

    class GlyphsUploadList {
        int numberOfNewGlyphs;
        GlyphVector[] glyphVector;
        Rectangle2D[] glyphBounds;
        int[] renderIndex;
        int[] newGlyphs;
        char[] newUnicodes;

        GlyphsUploadList() {
        }

        void prepGlyphForUpload(char c, int n, Rectangle2D rectangle2D, int n2, GlyphVector glyphVector) {
            int n3 = this.numberOfNewGlyphs++;
            this.newUnicodes[n3] = c;
            this.newGlyphs[n3] = n;
            this.glyphBounds[n3] = rectangle2D;
            this.renderIndex[n3] = n2;
            this.glyphVector[n3] = glyphVector;
        }

        void uploadAnyNewGlyphs(GlyphsList glyphsList, GlyphProducer glyphProducer) {
            for (int i = 0; i < this.numberOfNewGlyphs; ++i) {
                if (glyphProducer.unicodes2Glyphs[this.newUnicodes[i]] == glyphProducer.undefined) {
                    Rectangle2D rectangle2D = TextRenderer.normalize(this.glyphBounds[i]);
                    Point point = new Point((int)(-rectangle2D.getMinX()), (int)(-rectangle2D.getMinY()));
                    Rect rect = new Rect(0, 0, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), new TextData(null, point, this.newUnicodes[i]));
                    GlyphVector glyphVector = this.glyphVector[i];
                    this.glyphVector[i] = null;
                    TextRenderer.this.packer.add(rect);
                    glyphProducer.glyphRectForTextureMapping[this.newGlyphs[i]] = rect;
                    glyphsList.textureSourceRect[this.renderIndex[i]] = rect;
                    glyphProducer.unicodes2Glyphs[this.newUnicodes[i]] = this.newGlyphs[i];
                    Graphics2D graphics2D = TextRenderer.this.getGraphics2D();
                    int n = rect.x() + point.x;
                    int n2 = rect.y() + point.y;
                    graphics2D.setComposite(AlphaComposite.Clear);
                    graphics2D.fillRect(rect.x(), rect.y(), rect.w(), rect.h());
                    graphics2D.setComposite(AlphaComposite.Src);
                    TextRenderer.this.renderDelegate.drawGlyphVector(graphics2D, glyphVector, n, n2);
                    TextRenderer.this.getBackingStore().markDirty(rect.x(), rect.y(), rect.w(), rect.h());
                    continue;
                }
                glyphsList.textureSourceRect[this.renderIndex[i]] = glyphProducer.glyphRectForTextureMapping[this.newGlyphs[i]];
            }
            this.numberOfNewGlyphs = 0;
        }

        public void allocateSpace(int n) {
            int n2 = Math.max(n, 100);
            if (this.glyphVector == null || this.glyphVector.length < n2) {
                this.glyphVector = new GlyphVector[n2];
                this.glyphBounds = new Rectangle2D[n2];
                this.renderIndex = new int[n2];
                this.newGlyphs = new int[n2];
                this.newUnicodes = new char[n2];
            }
        }
    }

    class Manager
    implements BackingStoreManager {
        private Graphics2D g;

        Manager() {
        }

        public Object allocateBackingStore(int n, int n2) {
            TextureRenderer textureRenderer = TextRenderer.this.renderDelegate.intensityOnly() ? TextureRenderer.createAlphaOnlyRenderer(n, n2, TextRenderer.this.mipmap) : new TextureRenderer(n, n2, true, TextRenderer.this.mipmap);
            if (DEBUG) {
                System.err.println(" TextRenderer allocating backing store " + n + " x " + n2);
            }
            return textureRenderer;
        }

        public void deleteBackingStore(Object object) {
            ((TextureRenderer)object).dispose();
        }

        public boolean preExpand(Rect rect, int n) {
            if (n == 0) {
                if (DEBUG) {
                    System.err.println("Clearing unused entries in preExpand(): attempt number " + n);
                }
                TextRenderer.this.clearUnusedEntries();
                return true;
            }
            return false;
        }

        public void additionFailed(Rect rect, int n) {
            TextRenderer.this.packer.clear();
            TextRenderer.this.stringLocations.clear();
            TextRenderer.this.mGlyphProducer.clearAllCacheEntries();
            if (DEBUG) {
                System.err.println(" *** Cleared all text because addition failed ***");
            }
        }

        public void beginMovement(Object object, Object object2) {
            Object object3;
            if (TextRenderer.this.inBeginEndPair) {
                TextRenderer.this.flush();
                object3 = GLU.getCurrentGL();
                object3.glPopClientAttrib();
                if (object3.isExtensionAvailable("GL_VERSION_1_5")) {
                    object3.glBindBuffer(34962, 0);
                }
                if (TextRenderer.this.isOrthoMode) {
                    ((TextureRenderer)object).endOrthoRendering();
                } else {
                    ((TextureRenderer)object).end3DRendering();
                }
            }
            object3 = (TextureRenderer)object2;
            this.g = ((TextureRenderer)object3).createGraphics();
        }

        public void move(Object object, Rect rect, Object object2, Rect rect2) {
            TextureRenderer textureRenderer = (TextureRenderer)object;
            TextureRenderer textureRenderer2 = (TextureRenderer)object2;
            if (textureRenderer == textureRenderer2) {
                this.g.copyArea(rect.x(), rect.y(), rect.w(), rect.h(), rect2.x() - rect.x(), rect2.y() - rect.y());
            } else {
                Image image = textureRenderer.getImage();
                this.g.drawImage(image, rect2.x(), rect2.y(), rect2.x() + rect2.w(), rect2.y() + rect2.h(), rect.x(), rect.y(), rect.x() + rect.w(), rect.y() + rect.h(), null);
            }
        }

        public void endMovement(Object object, Object object2) {
            this.g.dispose();
            TextureRenderer textureRenderer = (TextureRenderer)object2;
            textureRenderer.markDirty(0, 0, textureRenderer.getWidth(), textureRenderer.getHeight());
            if (TextRenderer.this.inBeginEndPair) {
                if (TextRenderer.this.isOrthoMode) {
                    ((TextureRenderer)object2).beginOrthoRendering(TextRenderer.this.beginRenderingWidth, TextRenderer.this.beginRenderingHeight, TextRenderer.this.beginRenderingDepthTestDisabled);
                } else {
                    ((TextureRenderer)object2).begin3DRendering();
                }
                GL gL = GLU.getCurrentGL();
                gL.glPushClientAttrib(-1);
                if (TextRenderer.this.haveCachedColor) {
                    if (TextRenderer.this.cachedColor == null) {
                        ((TextureRenderer)object2).setColor(TextRenderer.this.cachedR, TextRenderer.this.cachedG, TextRenderer.this.cachedB, TextRenderer.this.cachedA);
                    } else {
                        ((TextureRenderer)object2).setColor(TextRenderer.this.cachedColor);
                    }
                }
            } else {
                TextRenderer.this.needToResetColor = true;
            }
        }
    }

    private static class MapCharSequenceToGlyphVector
    implements CharacterIterator {
        CharSequence mSequence;
        int mLength;
        int mCurrentIndex;

        MapCharSequenceToGlyphVector() {
        }

        MapCharSequenceToGlyphVector(CharSequence charSequence) {
            this.initFromCharSequence(charSequence);
        }

        public void initFromCharSequence(CharSequence charSequence) {
            this.mSequence = charSequence;
            this.mLength = this.mSequence.length();
            this.mCurrentIndex = 0;
        }

        public char last() {
            this.mCurrentIndex = Math.max(0, this.mLength - 1);
            return this.current();
        }

        public char current() {
            if (this.mLength == 0 || this.mCurrentIndex >= this.mLength) {
                return '\uffff';
            }
            return this.mSequence.charAt(this.mCurrentIndex);
        }

        public char next() {
            ++this.mCurrentIndex;
            return this.current();
        }

        public char previous() {
            this.mCurrentIndex = Math.max(this.mCurrentIndex - 1, 0);
            return this.current();
        }

        public char setIndex(int n) {
            this.mCurrentIndex = n;
            return this.current();
        }

        public int getBeginIndex() {
            return 0;
        }

        public int getEndIndex() {
            return this.mLength;
        }

        public int getIndex() {
            return this.mCurrentIndex;
        }

        public Object clone() {
            MapCharSequenceToGlyphVector mapCharSequenceToGlyphVector = new MapCharSequenceToGlyphVector(this.mSequence);
            mapCharSequenceToGlyphVector.mCurrentIndex = this.mCurrentIndex;
            return mapCharSequenceToGlyphVector;
        }

        public char first() {
            if (this.mLength == 0) {
                return '\uffff';
            }
            this.mCurrentIndex = 0;
            return this.current();
        }
    }

    class Pipelined_QuadRenderer {
        int mOutstandingGlyphsVerticesPipeline = 0;
        FloatBuffer mTexCoords;
        FloatBuffer mVertCoords;
        boolean usingVBOs;
        int mVBO_For_ResuableTileVertices;
        int mVBO_For_ResuableTileTexCoords;

        Pipelined_QuadRenderer() {
            GL gL = GLU.getCurrentGL();
            this.mVertCoords = BufferUtil.newFloatBuffer(1200);
            this.mTexCoords = BufferUtil.newFloatBuffer(800);
            this.usingVBOs = gL.isExtensionAvailable("GL_VERSION_1_5");
            if (this.usingVBOs) {
                int[] nArray = new int[2];
                gL.glGenBuffers(2, IntBuffer.wrap(nArray));
                this.mVBO_For_ResuableTileVertices = nArray[0];
                this.mVBO_For_ResuableTileTexCoords = nArray[1];
                gL.glBindBuffer(34962, this.mVBO_For_ResuableTileVertices);
                gL.glBufferData(34962, 4800, null, 35040);
                gL.glBindBuffer(34962, this.mVBO_For_ResuableTileTexCoords);
                gL.glBufferData(34962, 3200, null, 35040);
            }
        }

        public void glTexCoord2f(float f, float f2) {
            this.mTexCoords.put(f);
            this.mTexCoords.put(f2);
        }

        public void glVertex3f(float f, float f2, float f3) {
            this.mVertCoords.put(f);
            this.mVertCoords.put(f2);
            this.mVertCoords.put(f3);
            ++this.mOutstandingGlyphsVerticesPipeline;
            if (this.mOutstandingGlyphsVerticesPipeline >= 400) {
                this.draw();
            }
        }

        private void draw() {
            if (this.mOutstandingGlyphsVerticesPipeline > 0) {
                GL gL = GLU.getCurrentGL();
                TextureRenderer textureRenderer = TextRenderer.this.getBackingStore();
                Texture texture = textureRenderer.getTexture();
                this.mVertCoords.rewind();
                this.mTexCoords.rewind();
                gL.glEnableClientState(32884);
                if (this.usingVBOs) {
                    gL.glBindBuffer(34962, this.mVBO_For_ResuableTileVertices);
                    gL.glBufferSubData(34962, 0, this.mOutstandingGlyphsVerticesPipeline * 12, this.mVertCoords);
                    gL.glVertexPointer(3, 5126, 0, 0L);
                } else {
                    gL.glVertexPointer(3, 5126, 0, this.mVertCoords);
                }
                gL.glClientActiveTexture(33984);
                gL.glEnableClientState(32888);
                if (this.usingVBOs) {
                    gL.glBindBuffer(34962, this.mVBO_For_ResuableTileTexCoords);
                    gL.glBufferSubData(34962, 0, this.mOutstandingGlyphsVerticesPipeline * 8, this.mTexCoords);
                    gL.glTexCoordPointer(2, 5126, 0, 0L);
                } else {
                    gL.glTexCoordPointer(2, 5126, 0, this.mTexCoords);
                }
                gL.glDrawArrays(7, 0, this.mOutstandingGlyphsVerticesPipeline);
                this.mVertCoords.rewind();
                this.mTexCoords.rewind();
                this.mOutstandingGlyphsVerticesPipeline = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void drawIMMEDIATE() {
            if (this.mOutstandingGlyphsVerticesPipeline <= 0) return;
            TextureRenderer textureRenderer = TextRenderer.this.getBackingStore();
            Texture texture = textureRenderer.getTexture();
            GL gL = GLU.getCurrentGL();
            gL.glBegin(7);
            try {
                try {
                    int n = this.mOutstandingGlyphsVerticesPipeline / 4;
                    this.mVertCoords.rewind();
                    this.mTexCoords.rewind();
                    for (int i = 0; i < n; ++i) {
                        gL.glTexCoord2f(this.mTexCoords.get(), this.mTexCoords.get());
                        gL.glVertex3f(this.mVertCoords.get(), this.mVertCoords.get(), this.mVertCoords.get());
                        gL.glTexCoord2f(this.mTexCoords.get(), this.mTexCoords.get());
                        gL.glVertex3f(this.mVertCoords.get(), this.mVertCoords.get(), this.mVertCoords.get());
                        gL.glTexCoord2f(this.mTexCoords.get(), this.mTexCoords.get());
                        gL.glVertex3f(this.mVertCoords.get(), this.mVertCoords.get(), this.mVertCoords.get());
                        gL.glTexCoord2f(this.mTexCoords.get(), this.mTexCoords.get());
                        gL.glVertex3f(this.mVertCoords.get(), this.mVertCoords.get(), this.mVertCoords.get());
                    }
                    Object var7_7 = null;
                    gL.glEnd();
                    this.mVertCoords.rewind();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var7_8 = null;
                    gL.glEnd();
                    this.mVertCoords.rewind();
                    this.mTexCoords.rewind();
                    this.mOutstandingGlyphsVerticesPipeline = 0;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                gL.glEnd();
                this.mVertCoords.rewind();
                this.mTexCoords.rewind();
                this.mOutstandingGlyphsVerticesPipeline = 0;
                throw throwable;
            }
            this.mTexCoords.rewind();
            this.mOutstandingGlyphsVerticesPipeline = 0;
        }
    }

    public static interface RenderDelegate {
        public boolean intensityOnly();

        public Rectangle2D getBounds(String var1, Font var2, FontRenderContext var3);

        public Rectangle2D getBounds(CharSequence var1, Font var2, FontRenderContext var3);

        public Rectangle2D getBounds(GlyphVector var1, FontRenderContext var2);

        public void draw(Graphics2D var1, String var2, int var3, int var4);

        public void drawGlyphVector(Graphics2D var1, GlyphVector var2, int var3, int var4);
    }

    static class TextData {
        int unicodeID;
        private String str;
        private Point origin;
        private boolean used;

        TextData(String string, Point point, int n) {
            this.str = string;
            this.origin = point;
            this.unicodeID = n;
        }

        String string() {
            return this.str;
        }

        Point origin() {
            return this.origin;
        }

        boolean used() {
            return this.used;
        }

        void markUsed() {
            this.used = true;
        }

        void clearUsed() {
            this.used = false;
        }
    }
}

