/*
 * Decompiled with CFR 0.152.
 */
package atlantis;

import atlantis.Atlantis;
import atlantis.event.AEventSource;
import atlantis.event.AImageProducer;
import atlantis.utils.ALogger;
import java.awt.Dimension;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

class ACommandLine {
    private final HelpFormatter formatter = new HelpFormatter();
    private final Options options = new Options();
    private final String usage = "Atlantis [OPTIONS] [[-s]SOURCE]";
    private final String headerMsg;
    private final String footerMsg;

    public ACommandLine() {
        this.options.addOption(new Option("a", false, "show HLTAutoKey tracks"));
        OptionBuilder.withArgName("file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("read configuration from specified file");
        OptionBuilder.withLongOpt("config");
        this.options.addOption(OptionBuilder.create("c"));
        String debugDescr = "log messages of level to 'stdout', optionally to file destination. Message levels are " + ALogger.getStringLevels() + " (INFO is default)";
        OptionBuilder.hasArg();
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName("level [destination]");
        OptionBuilder.withDescription(debugDescr);
        OptionBuilder.withLongOpt("debug");
        this.options.addOption(OptionBuilder.create('d'));
        this.options.addOption(new Option("h", "help", false, "display this help message"));
        OptionBuilder.withArgName("projections");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription("colon seperated list of projections for the demo mode (e.g \"-j YX:VP\"). Available projections/actions are YX, VP(\u03a6\u03b7), RZ(\u03c1Z), FR(\u03a6\u03c1), FZ(\u03a6Z), XZ(X'Z), YZ(Y'Z), LegoPlot, NE(next event)");
        OptionBuilder.withLongOpt("projection");
        this.options.addOption(OptionBuilder.create("j"));
        String loopDescr = "Set event navigation mode, supported values are " + AEventSource.NavigationMode.LOOP.toString() + ", " + AEventSource.NavigationMode.RANDOM.toString() + ", " + AEventSource.NavigationMode.SEQUENTIAL.toString();
        OptionBuilder.withArgName("mode");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(loopDescr);
        OptionBuilder.withLongOpt("loop");
        this.options.addOption(OptionBuilder.create("l"));
        OptionBuilder.withArgName("file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("read colourmap from specified file");
        OptionBuilder.withLongOpt("colormap");
        this.options.addOption(OptionBuilder.create("m"));
        String overviewDescr = "output event image into directory dir (default: current directory) of dimensions width x height (default: 800x828). If height is not specified the aspect ratio of the canvas is used. If scale is given, images will be scaled by that factor (use for thumbnails). If a filename is given, that file will be overwritten, otherwise a new file will be created for each event.";
        OptionBuilder.hasOptionalArgs(4);
        OptionBuilder.withArgName("[dir] [width[xheight]] [scale] [filename]");
        OptionBuilder.withDescription(overviewDescr);
        OptionBuilder.withLongOpt("output");
        this.options.addOption(OptionBuilder.create('o'));
        OptionBuilder.withArgName("seconds");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("pause inbetween events and/or projections options");
        OptionBuilder.withLongOpt("pause");
        this.options.addOption(OptionBuilder.create("p"));
        String sourceDescr = "Set initial event source, e.g\n*    [file://]<filename>\n*     http://<url>\n*   xmlrpc://<server>:<port>\n*   oncrpc://<server>[:port][:stream]";
        OptionBuilder.withArgName("source");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(sourceDescr);
        OptionBuilder.withLongOpt("source");
        this.options.addOption(OptionBuilder.create("s"));
        this.options.addOption(new Option("x", "updateconfig", false, "update user's configuration file"));
        OptionBuilder.withArgName("maxwidth");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("maximum screen width used by Atlantis");
        OptionBuilder.withLongOpt("maxwidth");
        this.options.addOption(OptionBuilder.create("w"));
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("port");
        OptionBuilder.withDescription("Run a server on port <port> which accepts event data from a client and returns images");
        OptionBuilder.withLongOpt("imgserver");
        this.options.addOption(OptionBuilder.create('I'));
        this.headerMsg = "\nMandatory arguments to long options are mandatory for short options too.\n";
        this.footerMsg = "\nAtlFast objects were supported up to AtlantisJava-09-05-28 via \"Fast\" option.\nBeginner simplified GUI was supported up to AtlantisJava-09-05-28 via \"Beginner\" option.\nCTB 2004 geometry was supported up to AtlantisJava-09-07-42 via -t, --testbeam option.\n";
    }

    void process(String[] args) {
        GnuParser parser = new GnuParser();
        try {
            String[] unspecifiedOpts;
            String val;
            String[] vals;
            CommandLine cmdLine = parser.parse(this.options, args);
            if (cmdLine.hasOption('a')) {
                Atlantis.showHLTAutoKeys = true;
            }
            if (cmdLine.hasOption('c')) {
                Atlantis.configCommandLine = cmdLine.getOptionValue('c', null);
            }
            if (cmdLine.hasOption('d')) {
                vals = cmdLine.getOptionValues('d');
                String level = vals[0];
                if (!ALogger.getStringLevels().contains(level)) {
                    throw new ParseException("Invalid logging level " + level);
                }
                String destination = null;
                if (vals.length == 2) {
                    destination = vals[1];
                }
                ALogger.initialize(level, destination);
            }
            if (cmdLine.hasOption('h')) {
                this.formatter.printHelp("Atlantis [OPTIONS] [[-s]SOURCE]", this.headerMsg, this.options, this.footerMsg);
                System.exit(0);
            }
            if (cmdLine.hasOption('I')) {
                Atlantis.imageServerPort = Integer.parseInt(cmdLine.getOptionValue('I'));
                if (Atlantis.imageServerPort < 0) {
                    throw new ParseException("Port number " + cmdLine.getOptionValue('I') + " is not valid for -I option");
                }
                if (cmdLine.hasOption('j') || cmdLine.hasOption('p')) {
                    throw new ParseException("Can not use option -I with -j or -p options");
                }
            }
            if (cmdLine.hasOption('j')) {
                Atlantis.selectedProjections = cmdLine.getOptionValue('j', "");
            }
            if (cmdLine.hasOption('l')) {
                String loopMode = cmdLine.getOptionValue('l', null);
                if (loopMode == null) {
                    throw new ParseException("Option -l needs an argument");
                }
                Atlantis.initialMode = AEventSource.NavigationMode.valueOf(loopMode);
            }
            if (cmdLine.hasOption('m')) {
                Atlantis.colormapCommandLine = cmdLine.getOptionValue('m', null);
            }
            if (cmdLine.hasOption('o')) {
                vals = cmdLine.getOptionValues('o');
                try {
                    String dir = System.getProperty("user.dir");
                    if (vals != null && vals.length > 0) {
                        dir = vals[0];
                    }
                    Dimension dim = new Dimension(800, 828);
                    if (vals != null && vals.length > 1) {
                        short width = Short.parseShort(vals[1].split("x")[0]);
                        int height = -1;
                        if (vals[1].split("x").length > 1) {
                            height = Short.parseShort(vals[1].split("x")[1]);
                        }
                        dim = new Dimension(width, height);
                    }
                    double scale = 1.0;
                    if (vals != null && vals.length > 2) {
                        scale = Double.parseDouble(vals[2]);
                    }
                    String fixedFile = null;
                    if (vals != null && vals.length > 3) {
                        fixedFile = vals[3];
                    }
                    Atlantis.imageProducer = new AImageProducer(dir, dim, scale, fixedFile);
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Invalid parameters to option -o");
                }
                catch (IndexOutOfBoundsException iob) {
                    throw new ParseException("Invalid dimension parameter to option -o");
                }
                catch (AImageProducer.InstantiationException iex) {
                    throw new ParseException("Invalid configuration for option -o: " + iex.getMessage());
                }
            }
            if (cmdLine.hasOption('s')) {
                Atlantis.initialEventSource = cmdLine.getOptionValue('s');
            }
            if (cmdLine.hasOption('p')) {
                val = cmdLine.getOptionValue('p', null);
                try {
                    Atlantis.loopInterval = Integer.parseInt(val);
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Invalid seconds value " + val + " for -p option");
                }
            }
            if (cmdLine.hasOption('w')) {
                val = cmdLine.getOptionValue('w', null);
                try {
                    Atlantis.MAX_WIDTH = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Invalid width value " + val + " for -w option");
                }
            }
            if (cmdLine.hasOption('x')) {
                Atlantis.updateConfig = true;
            }
            if ((unspecifiedOpts = cmdLine.getArgs()).length > 0) {
                if (unspecifiedOpts.length != 1 || cmdLine.hasOption('s') || cmdLine.hasOption('I')) {
                    throw new ParseException("Can only specify one event source");
                }
                Atlantis.initialEventSource = unspecifiedOpts[0];
            }
        }
        catch (ParseException ex) {
            System.err.println("\n" + ex.getMessage() + "\n");
            this.formatter.printHelp("Atlantis [OPTIONS] [[-s]SOURCE]", this.headerMsg, this.options, this.footerMsg);
            System.exit(1);
        }
    }
}

