/*
 * Decompiled with CFR 0.152.
 */
package atlantis;

import atlantis.ACommandLine;
import atlantis.canvas.ACanvas;
import atlantis.config.AConfigUpdater;
import atlantis.config.ADefaultValues;
import atlantis.event.AEventManager;
import atlantis.event.AEventSource;
import atlantis.event.AImageProducer;
import atlantis.event.oncrpc.AONCRPCEventSource;
import atlantis.event.xmlrpc.AServerXMLRPC;
import atlantis.event.xmlrpc.AServerXMLRPCEventSource;
import atlantis.geometry.AAtlasDetector;
import atlantis.geometry.ADetectorSystem;
import atlantis.gui.AColorMap;
import atlantis.gui.ADemoDialog;
import atlantis.gui.ADemoLoop;
import atlantis.gui.AEventLoopDialog;
import atlantis.gui.AEventQueue;
import atlantis.gui.AExceptionHandler;
import atlantis.gui.AGUI;
import atlantis.gui.AStartupWindow;
import atlantis.hypatia.HControlWindow;
import atlantis.hypatia.HDemoWindow;
import atlantis.hypatia.HInvariantMassWindow;
import atlantis.hypatia.HSimplifiedControlWindow;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.list.AListManager;
import atlantis.parameters.APar;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.AAtlantisException;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import atlantis.utils.xml.AXMLErrorHandler;
import atlantis.utils.xml.AXMLUtils;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Atlantis {
    private static ALogger logger = null;
    public static String versionAtlantisJava = "$HeadURL: svn+ssh://svn.cern.ch/reps/atlasoff/graphics/AtlantisJava/trunk/src/atlantis/Atlantis.java $";
    public static final String FILE_SEPAR = System.getProperty("file.separator");
    public static final String LINE_SEPAR = System.getProperty("line.separator");
    public static final String USER_HOME_DIR = System.getProperty("user.home");
    public static boolean showHLTAutoKeys = false;
    public static int SIMPLE_OUTPUT = 0;
    public static int MAX_WIDTH = 0;
    private static AEventManager eventManager = null;
    private static ADetectorSystem detector = null;
    private static ACanvas canvas = null;
    private static AGUI gui = null;
    public static HInvariantMassWindow invariantMassWindow = null;
    public static HControlWindow controlWindow = null;
    public static HSimplifiedControlWindow simplifiedControlWindow = null;
    public static HTrackMomentaWindow trackMomentaWindow = null;
    public static HDemoWindow demoWindow = null;
    public static String demoEventPath = "";
    private static int twoThirdHeightCanvas;
    private static int windowTitlebarHeight;
    private static Rectangle screenSize;
    private static final String JDK_VERSION_ERROR_MSG = "Atlantis requires Java (JDK or JRE) version 1.5 or newer.\nPlease visit: http://java.sun.com/j2se/1.5/ and download Java 1.5";
    private static final String INIT_ERROR_MSG = "Error during Atlantis initialization.\n(configuration file related issues might be\ncorrected by running with -x (updating customised configuration)).\nSee console output for more information.";
    public static final String LIVE_POINT_1_EVENTS_URL = "http://atlas-live.cern.ch/event_files/Default";
    public static final String USER_CONFIG_FILE_PATH;
    public static final String DISTRIB_DEFAULT_CONFIG_FILE;
    public static final String CONFIG_CHECKSUM_FILE_PATH;
    protected static boolean updateConfig;
    protected static String configCommandLine;
    protected static String colormapCommandLine;
    protected static String selectedProjections;
    protected static Integer loopInterval;
    protected static AEventSource.NavigationMode initialMode;
    protected static String initialEventSource;
    protected static AImageProducer imageProducer;
    protected static int imageServerPort;
    public static final boolean atlantisWithOpenGL = false;

    public static boolean isAtlantisHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static Integer getLoopInterval() {
        return loopInterval;
    }

    public static AImageProducer getEventHistory() {
        return imageProducer;
    }

    private static void checkJDKVersion() {
        String version = System.getProperty("java.version");
        if (version == null || version.compareTo("1.5") < 0) {
            AExceptionHandler.processException("fatal", JDK_VERSION_ERROR_MSG);
        }
    }

    private static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception e) {
            AExceptionHandler.processException("Error setting default Look and Feel", e);
        }
    }

    private static void checkAndUpdateConfigCheckSumFile(String distribFile) throws AAtlantisException {
        boolean comparison;
        if (updateConfig) {
            logger.info("Checksum not checked, run with -x, configuration update forced anyway.");
            return;
        }
        logger.info("Checking if the used configuration is up-to-date ...");
        logger.debug("Checking checksum of the configuration file from the Atlantis distribution: " + distribFile);
        logger.debug("Checksum file: " + CONFIG_CHECKSUM_FILE_PATH);
        boolean checkSumExists = new File(CONFIG_CHECKSUM_FILE_PATH).exists();
        if (checkSumExists && (comparison = AConfigUpdater.compareChecksums(distribFile, CONFIG_CHECKSUM_FILE_PATH))) {
            logger.debug("Checksum file - checksum match, no update necessary.");
            updateConfig = false;
            return;
        }
        AConfigUpdater.createChecksumFile(distribFile, CONFIG_CHECKSUM_FILE_PATH);
        logger.debug("Checksum didn't match, updating customised configuration forced.");
        updateConfig = true;
    }

    private static InputStream getXMLConfigAsStream() throws Exception {
        String configToUse = null;
        logger.info("Reading the XML configuration ...");
        String distribFilePath = Atlantis.getHomeDirectory() + DISTRIB_DEFAULT_CONFIG_FILE;
        if (configCommandLine != null) {
            logger.info("Using configuration file specified on the command line: " + configCommandLine);
            Atlantis.checkAndUpdateConfigCheckSumFile(distribFilePath);
            configToUse = configCommandLine;
        } else if (new File(USER_CONFIG_FILE_PATH).exists()) {
            logger.info("Using user's configuration file: " + USER_CONFIG_FILE_PATH);
            Atlantis.checkAndUpdateConfigCheckSumFile(distribFilePath);
            configToUse = USER_CONFIG_FILE_PATH;
        } else {
            logger.info("Using distribution configuration file: " + distribFilePath);
            if (updateConfig) {
                logger.warn("Update custom configuration flag is set, that doesn't make sence - no custom config file available, ignored.");
                updateConfig = false;
            }
            configToUse = distribFilePath;
        }
        try {
            if (updateConfig) {
                logger.info("Updating customised configuration file ...");
                String atlantisHome = Atlantis.getHomeDirectory();
                String customConfigDir = new File(configToUse).getAbsolutePath();
                logger.info("Updating configuration - customised config directory: " + customConfigDir);
                if (customConfigDir.startsWith(atlantisHome)) {
                    logger.debug("Updating configuration - Atlantis home: " + atlantisHome);
                    logger.info("Updating configuration - customised config directory is in the Atlantis home, no need updating it.");
                } else {
                    AConfigUpdater.updateConfigurationFile(distribFilePath, configToUse);
                }
            }
        }
        catch (AAtlantisException aae) {
            logger.error(aae.getMessage());
        }
        InputStream isConfig = null;
        try {
            isConfig = AUtilities.getFileAsStream(configToUse);
        }
        catch (AAtlantisException aae) {
            String m = "Could not read " + configToUse + " reason: " + aae.getMessage();
            throw new Exception(m);
        }
        logger.info("Going to parse XML configuration: " + configToUse);
        return isConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initAtlantis() {
        block22: {
            AStartupWindow startupWin = new AStartupWindow(9);
            try {
                int sleepTime;
                System.setProperty("sun.awt.exception.handler", "AExceptionHandler");
                Toolkit.getDefaultToolkit().getSystemEventQueue().push(new AEventQueue());
                startupWin.updateText("Atlantis initialisation");
                logger.info("Atlantis home: " + Atlantis.getHomeDirectory());
                eventManager = new AEventManager();
                logger.info("Reading Atlantis runtime configuration, file: " + ADefaultValues.CONFIGFILE);
                ADefaultValues.readRuntimeValues();
                startupWin.updateText("Reading Atlantis configuration");
                InputStream isConfig = Atlantis.getXMLConfigAsStream();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(true);
                DocumentBuilder parser = factory.newDocumentBuilder();
                parser.setErrorHandler(new AXMLErrorHandler());
                Document xmlConfigDoc = parser.parse(isConfig);
                Element rootNode = xmlConfigDoc.getDocumentElement();
                Node initializationNode = AXMLUtils.getChild(rootNode, "Initialization");
                startupWin.updateText("Reading colour map");
                AColorMap.readColorMap(colormapCommandLine);
                startupWin.updateText("Building canvas and projections");
                Node canvasNode = AXMLUtils.getChild(initializationNode, "Canvas");
                canvas = new ACanvas(canvasNode);
                logger.info("Building parameters");
                new APar(AXMLUtils.getChild(rootNode, "Parameters")).update(AXMLUtils.getChild(rootNode, "ParameterDifferences"));
                Node interactionsNode = AXMLUtils.getChild(initializationNode, "Interactions");
                AProjectionsManager.initialise(interactionsNode);
                if (APar.get("Minerva", "alternativesimpleoutput").getStatus()) {
                    SIMPLE_OUTPUT = APar.get("Minerva", "simpleoutput").getStatus() ? 3 : 2;
                } else if (APar.get("Minerva", "simpleoutput").getStatus()) {
                    SIMPLE_OUTPUT = 1;
                }
                startupWin.updateText("Reading geometry");
                String geomPrefix = Atlantis.getHomeDirectory() + "geometry" + FILE_SEPAR;
                String geomName = ADefaultValues.get("GeometryName");
                if (!"".equals(geomName)) {
                    geomName = "_" + geomName;
                    String geomNameFull1 = geomPrefix + "AGeometry" + geomName + ".xml";
                    String geomNameFull2 = geomPrefix + "AMuonGeometry" + geomName + ".xml";
                    try {
                        InputStream i = AUtilities.getFileAsStream(geomNameFull1);
                        i = AUtilities.getFileAsStream(geomNameFull2);
                        i = null;
                    }
                    catch (AAtlantisException ae) {
                        geomName = "";
                    }
                }
                String geomIdCalo = geomPrefix + "AGeometry" + geomName + ".xml";
                String geomMuon = geomPrefix + "AMuonGeometry" + geomName + ".xml";
                detector = new AAtlasDetector(geomIdCalo, geomMuon);
                canvas.finalizeConstruction();
                canvas.readCorners(AXMLUtils.getChild(rootNode, "WindowCorners"));
                canvas.setCurrentWindow(canvas.getCurrentWindowName());
                Atlantis.getEventManager().addNewEventListener(canvas);
                controlWindow = new HControlWindow();
                trackMomentaWindow = new HTrackMomentaWindow();
                invariantMassWindow = new HInvariantMassWindow();
                simplifiedControlWindow = new HSimplifiedControlWindow();
                demoWindow = new HDemoWindow();
                startupWin.updateText("Reading intial event");
                Atlantis.getInitialEvent();
                startupWin.updateText("Displaying GUI and Canvas");
                AColorMap.setColorMap(APar.get("Prefs", "ColorMap").getI());
                canvas.setCanvasVisible(true);
                canvas.correctAspectRatios();
                screenSize = canvas.getGraphicsConfiguration().getBounds();
                twoThirdHeightCanvas = 2 * canvas.getRespectiveHeight(canvas.getWidth()) / 3;
                windowTitlebarHeight = Atlantis.canvas.getInsets().top - Atlantis.canvas.getInsets().right;
                invariantMassWindow.setBounds(0, 0, Atlantis.screenSize.width, Atlantis.screenSize.height - canvas.getRespectiveHeight(canvas.getWidth()) - 2 * windowTitlebarHeight);
                trackMomentaWindow.setBounds(canvas.getX() + canvas.getWidth(), invariantMassWindow.getHeight() + windowTitlebarHeight, Atlantis.screenSize.width - canvas.getWidth(), twoThirdHeightCanvas);
                controlWindow.setBounds(canvas.getX() + canvas.getWidth(), invariantMassWindow.getHeight() + twoThirdHeightCanvas + 2 * windowTitlebarHeight, Atlantis.screenSize.width - canvas.getWidth(), twoThirdHeightCanvas / 2);
                simplifiedControlWindow.setBounds(canvas.getX() + canvas.getWidth(), invariantMassWindow.getHeight() + twoThirdHeightCanvas + 2 * windowTitlebarHeight, Atlantis.screenSize.width - canvas.getWidth(), twoThirdHeightCanvas / 2);
                controlWindow.setVisible(true);
                trackMomentaWindow.setVisible(true);
                invariantMassWindow.setVisible(true);
                startupWin.updateText("Atlantis Ready");
                if (initialMode != null) {
                    Atlantis.getEventManager().setNavigationMode(initialMode);
                }
                if (loopInterval != null && selectedProjections == null && !Atlantis.isAtlantisHeadless()) {
                    AEventLoopDialog dialog = AEventLoopDialog.getInstance();
                    dialog.setUpdateInterval(Atlantis.getLoopInterval());
                    dialog.showDialog();
                    dialog.startEventLoop();
                }
                if (selectedProjections != null) {
                    if (selectedProjections.equals("")) {
                        ADemoDialog.getInstance().setDefaultSequence();
                    }
                    if (Atlantis.getLoopInterval() != null) {
                        ADemoDialog.getInstance().setTimerInterval(Atlantis.getLoopInterval());
                    }
                    ADemoDialog.getInstance().setVisible(true);
                    ADemoDialog.getInstance().startDemo();
                }
                if (imageServerPort >= 0) {
                    AServerXMLRPC serv = new AServerXMLRPC(imageServerPort, AServerXMLRPCEventSource.class);
                    serv.start();
                }
                if (imageProducer == null) break block22;
                Atlantis.getEventManager().addNewEventListener(imageProducer);
                if (!Atlantis.isAtlantisHeadless()) break block22;
                boolean stopOnFailure = !(Atlantis.getEventManager().getEventSource() instanceof AONCRPCEventSource);
                int n = sleepTime = loopInterval != null ? loopInterval * 1000 : 0;
                if (sleepTime == 0) {
                    logger.info("No loop intervall given - processing events as fast as possible");
                }
                ADemoLoop loop = new ADemoLoop(sleepTime, new Vector<String>(Arrays.asList("NE")), stopOnFailure);
                loop.startDemoLoop();
                ADemoLoop aDemoLoop = loop;
                synchronized (aDemoLoop) {
                    loop.wait();
                }
            }
            catch (Exception e) {
                logger.fatal(INIT_ERROR_MSG);
                logger.fatal(e.getMessage(), e);
                AExceptionHandler.processException(INIT_ERROR_MSG, e);
            }
            finally {
                if (startupWin != null) {
                    startupWin.dispose();
                }
            }
        }
    }

    public static AEventManager getEventManager() {
        return eventManager;
    }

    public static ADetectorSystem getDetector() {
        return detector;
    }

    public static void setDetector(ADetectorSystem currentDetector) {
        detector = currentDetector;
    }

    public static void restoreDefaults() {
        APar.restoreDefaults();
        if (Atlantis.getEventManager().getCurrentEvent() != null) {
            Atlantis.getEventManager().getCurrentEvent().setPrimaryVertex();
        }
        AListManager.getInstance().reset();
        AGUI.refresh();
        ACanvas.getCanvas().restoreDefaults();
    }

    public static String getHomeDirectory() {
        String temp = Atlantis.class.getResource("Atlantis.class").getFile();
        if ((temp = temp.substring(5)).indexOf("!") > -1) {
            temp = temp.substring(0, temp.indexOf("!"));
            temp = temp.replaceAll("%20", " ");
            return temp.substring(0, temp.lastIndexOf(47) + 1);
        }
        return System.getProperty("user.dir") + FILE_SEPAR;
    }

    private static void processCommandLineParameters(String[] args) {
        System.out.println("Command line arguments:");
        for (String arg : args) {
            System.out.print(arg + " ");
        }
        System.out.println("\n");
        new ACommandLine().process(args);
    }

    public static void getInitialEvent() {
        String eventPath = initialEventSource;
        if (!eventPath.contains("://")) {
            if (!new File(eventPath).exists()) {
                logger.info("File " + eventPath + " does not exist - trying in " + Atlantis.getHomeDirectory());
                eventPath = Atlantis.getHomeDirectory() + eventPath;
            }
            eventPath = "file://" + eventPath;
        }
        logger.info("Reading the default event from " + eventPath);
        try {
            Atlantis.getEventManager().setEventSource(eventPath);
            Atlantis.getEventManager().nextEvent();
        }
        catch (AEventSource.InvalidEventSourceException ies) {
            String msg = "Can not access " + eventPath + ": " + ies.getMessage();
            logger.error(msg);
            if (Atlantis.isAtlantisHeadless()) {
                return;
            }
            JOptionPane.showMessageDialog(ACanvas.getCanvas(), msg, "Invalid Event Source", 0);
        }
        catch (AEventSource.NoMoreEventsException nme) {
            String msg = "No events in " + eventPath + ": " + nme.getMessage();
            logger.error(msg);
            if (Atlantis.isAtlantisHeadless()) {
                return;
            }
            JOptionPane.showMessageDialog(ACanvas.getCanvas(), msg, "No Events found", 0);
        }
        catch (AEventSource.ReadEventException rex) {
            String msg = "Can not read events from " + eventPath + ": " + rex.getMessage();
            logger.error(msg);
            if (Atlantis.isAtlantisHeadless()) {
                return;
            }
            JOptionPane.showMessageDialog(ACanvas.getCanvas(), msg, "Can not read event", 0);
        }
    }

    private static void setSVNTagInfo() {
        String s = versionAtlantisJava;
        if (!s.contains("tags")) {
            versionAtlantisJava = "AtlantisJava (SVN tag n/a)";
            return;
        }
        s = s.substring(0, s.indexOf("/src"));
        versionAtlantisJava = s = s.substring(s.indexOf("tags/") + 5);
    }

    public static void showInvariantMassWindow(boolean inv) {
        if (inv) {
            invariantMassWindow.setVisible(true);
            trackMomentaWindow.setBounds(Atlantis.screenSize.width - trackMomentaWindow.getWidth(), invariantMassWindow.getHeight() + windowTitlebarHeight, trackMomentaWindow.getWidth(), twoThirdHeightCanvas);
        } else {
            invariantMassWindow.setVisible(false);
            trackMomentaWindow.setBounds(Atlantis.screenSize.width - trackMomentaWindow.getWidth(), 0, trackMomentaWindow.getWidth(), invariantMassWindow.getHeight() + windowTitlebarHeight + twoThirdHeightCanvas);
        }
    }

    public static void showSimplifiedControlPanel(boolean simple) {
        if (simple) {
            controlWindow.setVisible(false);
            simplifiedControlWindow.setVisible(true);
        } else {
            simplifiedControlWindow.setVisible(false);
            controlWindow.setVisible(true);
        }
    }

    public static void readProperties() {
        Properties settings = new Properties();
        try {
            FileReader confFile = new FileReader("configuration" + FILE_SEPAR + "hypatia.ini");
            settings.load(confFile);
        }
        catch (IOException e) {
            System.out.println("Configuration file hypatia.ini cannot be read or missing !");
        }
        if (settings.getProperty("HideInvariantMassWindow").equals("1")) {
            trackMomentaWindow.setInvariantMassWindowCheckBox();
        }
        if (settings.getProperty("SimplifiedControlPanel").equals("1")) {
            trackMomentaWindow.setSimplifiedControlPanelCheckBox();
        }
        if (settings.getProperty("DemoMode").equals("1")) {
            trackMomentaWindow.setDemoCheckBox();
        }
        if (settings.getProperty("HideSimulated").equals("1")) {
            trackMomentaWindow.setHideSimulatedCheckBox();
        }
    }

    public static void main(String[] args) {
        Atlantis.setSVNTagInfo();
        System.out.println("AtlantisJava version (SVN tag): " + versionAtlantisJava);
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        Atlantis.checkJDKVersion();
        Atlantis.setLookAndFeel();
        Atlantis.processCommandLineParameters(args);
        logger = ALogger.getLogger(Atlantis.class);
        Atlantis.initAtlantis();
        Atlantis.readProperties();
    }

    static {
        USER_CONFIG_FILE_PATH = USER_HOME_DIR + FILE_SEPAR + ".Atlantis-config.xml";
        DISTRIB_DEFAULT_CONFIG_FILE = "configuration" + FILE_SEPAR + "config.xml";
        CONFIG_CHECKSUM_FILE_PATH = USER_HOME_DIR + FILE_SEPAR + ".Atlantis-config.chk";
        updateConfig = false;
        configCommandLine = null;
        colormapCommandLine = null;
        selectedProjections = null;
        loopInterval = null;
        initialMode = null;
        initialEventSource = "events" + FILE_SEPAR + "events4.zip";
        imageProducer = null;
        imageServerPort = -1;
    }
}

