/*
 * Decompiled with CFR 0.152.
 */
package atlantis.canvas;

import atlantis.Atlantis;
import atlantis.canvas.ALayout;
import atlantis.canvas.ALayoutChangeListener;
import atlantis.canvas.ATitleMenuBar;
import atlantis.canvas.AWindow;
import atlantis.event.AEvent;
import atlantis.event.ANewEventListener;
import atlantis.gui.AClosingConfirmationDialog;
import atlantis.gui.ACursorFactory;
import atlantis.gui.AGridLayout;
import atlantis.gui.AInteractionToolBar;
import atlantis.gui.APreferencesControl;
import atlantis.interactions.AZMRInteraction;
import atlantis.parameters.APar;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionEventInfo;
import atlantis.projection.AProjectionLegoPlot;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import atlantis.utils.xml.AXMLUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowFocusListener;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ACanvas
extends JPanel
implements ANewEventListener {
    private static ACanvas instance;
    private static final ALogger logger;
    public final double SCREEN_USAGE = 0.55;
    protected boolean customisedCorner = false;
    private JLayeredPane layeredPane;
    private final int baseLayer = 1000;
    private Hashtable<String, ALayout> layouts = new Hashtable();
    private ALayout currentLayout;
    private String startupLayoutName;
    private Vector<ALayoutChangeListener> layoutChangeListeners = new Vector();
    private Stack<ALayout> windowLayoutHistory = new Stack();
    private Stack<String> windowNameHistory = new Stack();
    private Stack<Vector<String>> windowsActive = new Stack();
    private Hashtable<String, AWindow> windowsList;
    private AWindow currentWindow;
    private AWindow paintingWindow;
    private Vector<ChangeListener> windowChangeListeners = new Vector();
    private Vector<ChangeListener> lockChangeListeners = new Vector();
    private ATitleMenuBar title;
    private double oldaspect = 1.0;
    private static JFrame parentWindow;

    public static ACanvas getCanvas() {
        return instance;
    }

    public ACanvas(Node node) {
        if (!Atlantis.isAtlantisHeadless()) {
            parentWindow = new JFrame("HYPATIA - Canvas Window");
            parentWindow.add(this);
        }
        this.title = new ATitleMenuBar();
        if (!Atlantis.isAtlantisHeadless()) {
            parentWindow.setJMenuBar(this.title);
        }
        instance = this;
        if (!Atlantis.isAtlantisHeadless()) {
            parentWindow.setDefaultCloseOperation(0);
            parentWindow.addWindowListener(new AClosingConfirmationDialog(parentWindow));
            AUtilities.setIconImage(parentWindow);
        }
        this.layeredPane = new JLayeredPane();
        this.windowsList = new Hashtable();
        this.readConfig(node);
    }

    public static void setCanvasTitle(String s) {
        parentWindow.setTitle("Canvas Window - " + s);
    }

    public void addParentWindowFocusListener(WindowFocusListener wfl) {
        if (parentWindow != null) {
            parentWindow.addWindowFocusListener(wfl);
        }
    }

    public void setCanvasVisible(boolean v) {
        if (parentWindow != null) {
            parentWindow.setVisible(v);
        } else {
            this.setVisible(v);
        }
    }

    public Rectangle getScreenSize() {
        if (parentWindow != null) {
            return parentWindow.getGraphicsConfiguration().getBounds();
        }
        return new Rectangle(1024, 768);
    }

    public Rectangle getStartupCanvasSize() {
        if (parentWindow == null) {
            return null;
        }
        Rectangle canvpos = parentWindow.getBounds();
        Dimension canvlayoutdim = parentWindow.getPreferredSize();
        Rectangle canvbound = new Rectangle(canvpos.x, canvpos.y, canvlayoutdim.width, canvlayoutdim.height);
        return canvbound;
    }

    public JMenuBar getTitleBar() {
        if (parentWindow == null) {
            return null;
        }
        return parentWindow.getJMenuBar();
    }

    public void bringToFront() {
        if (parentWindow != null) {
            parentWindow.toFront();
        }
    }

    private void readConfig(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName();
            if (nodeName.equals("UsedWindow")) {
                this.readWindow(child);
                continue;
            }
            if (!nodeName.equals("Layout")) continue;
            this.readLayout(child);
        }
        NamedNodeMap attributes = node.getAttributes();
        this.startupLayoutName = attributes.getNamedItem("startupLayout").getNodeValue().trim();
        this.oldaspect = Double.NaN;
        Node n = attributes.getNamedItem("aspectRatio");
        if (n != null) {
            this.oldaspect = Double.parseDouble(attributes.getNamedItem("aspectRatio").getNodeValue().trim());
        }
        logger.debug("Read config file with aspectRatio: " + this.oldaspect);
    }

    public void readWindow(Node node) {
        AWindow w = new AWindow(node, this.getWindowsCount());
        if (this.windowsList.containsKey(w.getName())) {
            throw new Error("Redefinition of window: " + w.getName());
        }
        this.windowsList.put(w.getName(), w);
    }

    public void readLayout(Node node) {
        ALayout layout = new ALayout(node);
        if (this.layouts.containsKey(layout.getName())) {
            throw new Error("Redefinition of layout: " + layout.getName());
        }
        this.layouts.put(layout.getName(), layout);
    }

    public void readCorners(Node corners) {
        if (corners == null) {
            return;
        }
        this.customisedCorner = true;
        NodeList children = corners.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node corner = children.item(i);
            if (corner.getNodeType() != 1) continue;
            NamedNodeMap attributes = corner.getAttributes();
            String windowName = AXMLUtils.tryAttribut(attributes, "windowName");
            double x0 = Double.parseDouble(AXMLUtils.tryAttribut(attributes, "x0"));
            double y0 = Double.parseDouble(AXMLUtils.tryAttribut(attributes, "y0"));
            double x1 = Double.parseDouble(AXMLUtils.tryAttribut(attributes, "x1"));
            double y1 = Double.parseDouble(AXMLUtils.tryAttribut(attributes, "y1"));
            double x2 = Double.parseDouble(AXMLUtils.tryAttribut(attributes, "x2"));
            double y2 = Double.parseDouble(AXMLUtils.tryAttribut(attributes, "y2"));
            Point2D.Double[] c = new Point2D.Double[]{new Point2D.Double(x0, y0), new Point2D.Double(x1, y1), new Point2D.Double(x2, y2)};
            this.getWindow(windowName).setUserCorners(c);
        }
        this.customisedCorner = false;
    }

    public void finalizeConstruction() {
        if (!APar.get("Prefs", "CanvasTitle").getStatus()) {
            this.title.setVisible(false);
        }
        this.setCurrentLayout(this.startupLayoutName);
    }

    public void correctAspectRatios() {
        if (Double.isNaN(this.oldaspect)) {
            return;
        }
        if (!this.currentLayout.getName().equals("FULL SCREEN")) {
            return;
        }
        if (Math.abs(this.getAspectRatio() - this.oldaspect) < 0.01) {
            logger.debug("Aspect ratio of config file same as this display, no correction required");
            return;
        }
        logger.info("Aspect ratio of config file (" + this.oldaspect + ") does not match this display (" + this.getAspectRatio() + ") attempting to correct");
        for (AWindow w : this.windowsList.values()) {
            AProjection p = w.getProjection();
            if (!(p instanceof AProjection2D)) continue;
            ((AProjection2D)p).aspectRatioChange(w, this.oldaspect, this.getAspectRatio());
        }
    }

    public void drawScaledCanvas(Graphics g, int imageWidth, int imageHeight, String type) {
        AZMRInteraction.setPaintCenterDot(false);
        boolean aastatus = APreferencesControl.getAliasMenuItem();
        if (!aastatus) {
            APreferencesControl.setAliasMenuItem(true);
        }
        double factorX = (double)imageWidth / (double)this.getWidth();
        double factorY = (double)imageHeight / (double)this.getHeight();
        if (this.title != null && APar.get("Prefs", "CanvasTitle").getStatus()) {
            int titleWidth = this.title.getWidth();
            int titleHeight = this.title.getHeight();
            if (Atlantis.isAtlantisHeadless()) {
                Dimension d = this.title.getLayout().preferredLayoutSize(this.title);
                titleWidth = (int)d.getWidth();
                titleHeight = (int)d.getHeight();
            }
            this.title.setSize(imageWidth, titleHeight);
            this.title.paint(g);
            this.title.setSize(titleWidth, titleHeight);
            g.translate(0, titleHeight);
            factorY = (double)(imageHeight - titleHeight) / (double)this.getHeight();
        }
        String[] windows = this.getCurrentLayout().getWindowNames();
        for (int i = 0; i < windows.length; ++i) {
            AWindow window = this.getWindow(windows[i]);
            int x = window.getX();
            int y = window.getY();
            int width = window.getWidth();
            int height = window.getHeight();
            if (!this.isReallyOnScreen(window)) continue;
            g.translate((int)(factorX * (double)x), (int)(factorY * (double)y));
            window.setSize((int)(factorX * (double)width), (int)(factorY * (double)height));
            window.validate();
            if (Atlantis.isAtlantisHeadless()) {
                window.getLayout().layoutContainer(window);
                window.invalidateQuietly();
            }
            window.print(g);
            if (x == 0 && y == 0 && (imageWidth > 300 || imageHeight > 250) && APreferencesControl.getAtlasLogoMenuItem()) {
                g.drawImage(ACursorFactory.getInstance().getAtlasLogo(), 32, 4, null);
            }
            window.setSize(width, height);
            window.validate();
            g.translate(-((int)(factorX * (double)x)), -((int)(factorY * (double)y)));
        }
        AZMRInteraction.setPaintCenterDot(true);
        if (!aastatus) {
            APreferencesControl.setAliasMenuItem(aastatus);
        }
    }

    public void restoreDefaults() {
        if (this.currentLayout != null) {
            String[] windows;
            if (!this.currentLayout.getName().equals(this.startupLayoutName)) {
                this.setCurrentLayout(this.startupLayoutName);
            }
            String[] frontWindows = this.currentLayout.getStartupSequence();
            for (String window : windows = this.getKnownWindowNames()) {
                this.windowsList.get(window).restoreDefaults();
            }
            for (String window : frontWindows) {
                this.moveToFrontWindow(window);
            }
        } else {
            throw new Error("Current layout is not defined");
        }
        this.setCurrentWindow(this.currentLayout.getStartupWindow());
        this.correctAspectRatios();
    }

    public String getStartupString() {
        String s = "";
        int maxLayer = 1000 + this.currentLayout.getWindowNames().length;
        for (int i = 1000; i <= maxLayer; ++i) {
            Component[] c = this.layeredPane.getComponentsInLayer(i);
            for (int j = 0; j < c.length; ++j) {
                if (!(c[j] instanceof AWindow) || !this.isReallyOnScreen((AWindow)c[j])) continue;
                s = s + ((AWindow)c[j]).getName();
            }
        }
        return s;
    }

    public void moveToFrontWindow(String windowName) {
        AWindow w;
        if (this.windowsList.containsKey(windowName)) {
            w = this.windowsList.get(windowName);
            int layer = JLayeredPane.getLayer(w);
            Component[] cc = this.layeredPane.getComponentsInLayer(layer);
            int maxLayer = 1000 + this.currentLayout.getWindowNames().length;
            for (int i = layer + 1; i <= maxLayer; ++i) {
                Component[] c = this.layeredPane.getComponentsInLayer(i);
                for (int j = 0; j < c.length; ++j) {
                    this.layeredPane.setLayer(c[j], i - 1);
                }
            }
            for (int j = 0; j < cc.length; ++j) {
                this.layeredPane.setLayer(cc[j], maxLayer);
            }
            this.validate();
            if (!w.isVisible()) {
                w.setVisible(true);
            }
        } else {
            throw new Error("Cannot find window: " + windowName);
        }
        this.hideNonVisible();
        w.repaintFromScratch();
    }

    public AWindow getWindow(String windowName) {
        if (this.windowsList.containsKey(windowName)) {
            return this.windowsList.get(windowName);
        }
        throw new Error("Cannot find window: " + windowName);
    }

    public void repaintOthers(Component current) {
        Enumeration<AWindow> myenum = this.windowsList.elements();
        while (myenum.hasMoreElements()) {
            AWindow window = myenum.nextElement();
            if (window == current || !ACanvas.getCanvas().isReallyOnScreen(window)) continue;
            window.repaint();
        }
    }

    public void hideNonVisible() {
        Enumeration<AWindow> myenum = this.windowsList.elements();
        while (myenum.hasMoreElements()) {
            AWindow window = myenum.nextElement();
            if (!ACanvas.getCanvas().isValidWindowName(window.getName()) || ACanvas.getCanvas().isReallyOnScreen(window) || !window.isVisible()) continue;
            window.setVisible(false);
        }
    }

    public void repaintAllFromScratch() {
        Enumeration<AWindow> myenum = this.windowsList.elements();
        this.hideNonVisible();
        while (myenum.hasMoreElements()) {
            AWindow window = myenum.nextElement();
            if (!ACanvas.getCanvas().isReallyOnScreen(window)) continue;
            if (!window.isVisible()) {
                window.setVisible(true);
            }
            window.repaintFromScratch();
        }
        this.title.repaint();
    }

    public String[] getLayoutNames() {
        Enumeration<String> myenum = this.layouts.keys();
        String[] s = new String[this.layouts.size()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = myenum.nextElement();
        }
        return s;
    }

    public ALayout getLayout(String name) {
        if (this.layouts.containsKey(name)) {
            return this.layouts.get(name);
        }
        throw new Error("getLayout, unknown: " + name);
    }

    public ALayout getCurrentLayout() {
        return this.currentLayout;
    }

    public void setCurrentLayout(String newLayout) {
        if (this.layouts.containsKey(newLayout)) {
            int Y;
            int X;
            int H;
            int W;
            this.currentLayout = this.layouts.get(newLayout);
            Dimension dim = this.currentLayout.getSize();
            this.setLayout(null);
            this.removeAll();
            this.layeredPane.removeAll();
            Rectangle ScreenSize = this.getScreenSize();
            if (newLayout.equals("FULL SCREEN")) {
                W = ScreenSize.width;
                H = ScreenSize.height;
                X = ScreenSize.x;
                Y = ScreenSize.y;
            } else {
                Insets borders = new Insets(0, 0, 0, 0);
                if (!Atlantis.isAtlantisHeadless()) {
                    borders = Toolkit.getDefaultToolkit().getScreenInsets(parentWindow.getGraphicsConfiguration());
                }
                ScreenSize.width -= borders.left + borders.right;
                ScreenSize.height -= borders.top + borders.bottom;
                ScreenSize.x += borders.left;
                ScreenSize.y += borders.top;
                W = (int)((double)ScreenSize.width * 0.55);
                H = W + this.title.getPreferredSize().height;
                X = ScreenSize.x;
                Y = ScreenSize.height - W;
            }
            this.layeredPane.setLayout(new AGridLayout(dim, null));
            String[] usedWindowNames = this.currentLayout.getWindowNames();
            for (int i = 0; i < usedWindowNames.length; ++i) {
                Rectangle constraint = this.currentLayout.getWindowConstraints(usedWindowNames[i]);
                AWindow window = this.windowsList.get(usedWindowNames[i]);
                if (!window.finalized) {
                    window.finalizeConstruction();
                }
                this.layeredPane.setLayer(window, 1000 + i);
                this.layeredPane.add((Component)window, constraint);
            }
            this.setLayout(new BorderLayout());
            this.add(this.layeredPane);
            if (parentWindow != null) {
                parentWindow.setLocation(X, Y);
                parentWindow.setSize(W, H);
                parentWindow.validate();
                parentWindow.repaint();
            } else {
                this.setSize(W, H);
                this.layeredPane.setSize(W, H);
                Dimension d = this.layeredPane.getLayout().preferredLayoutSize(this.layeredPane);
                this.validate();
                this.repaint();
                this.setSize(d);
                this.layeredPane.setSize(d);
                this.layeredPane.getLayout().layoutContainer(this.layeredPane);
            }
            this.fireLayoutChange();
            String[] ss = this.currentLayout.getStartupSequence();
            for (int i = 0; i < ss.length; ++i) {
                this.moveToFrontWindow(ss[i]);
            }
            if (this.currentWindow != null && this.currentLayout.hasWindow(this.currentWindow.getName())) {
                this.setCurrentWindow(this.currentWindow.getName());
            } else {
                this.setCurrentWindow(this.currentLayout.getStartupWindow());
            }
        } else {
            throw new Error("setCurrentLayout: unknown layout name !?");
        }
    }

    private void fireLayoutChange() {
        for (ALayoutChangeListener changeListener : this.layoutChangeListeners) {
            changeListener.layoutChanged(ACanvas.getCanvas());
        }
    }

    public void saveLayout() {
        String[] usedWindowNames;
        this.windowLayoutHistory.push(this.getCurrentLayout());
        this.windowNameHistory.push(this.currentWindow.getName());
        Vector<String> windowsOnScreen = new Vector<String>();
        for (String windowName : usedWindowNames = this.currentLayout.getWindowNames()) {
            AWindow window = this.windowsList.get(windowName);
            if (!this.isReallyOnScreen(window)) continue;
            windowsOnScreen.add(windowName);
        }
        this.windowsActive.push(windowsOnScreen);
    }

    public void unlayout() {
        if (this.windowLayoutHistory.size() > 0) {
            ALayout newLayout = this.windowLayoutHistory.pop();
            String windowName = this.windowNameHistory.pop();
            if (!newLayout.getName().equals(this.currentLayout.getName())) {
                this.setCurrentLayout(newLayout.getName());
                this.setCurrentWindow(windowName);
            }
            Vector<String> windowsOnScreen = this.windowsActive.pop();
            for (String winName : windowsOnScreen) {
                ACanvas.getCanvas().moveToFrontWindow(winName);
            }
        }
    }

    public void addLockChangeListener(ChangeListener listener) {
        this.lockChangeListeners.addElement(listener);
        listener.stateChanged(new ChangeEvent(this));
    }

    public void addLayoutChangeListener(ALayoutChangeListener listener) {
        this.layoutChangeListeners.addElement(listener);
        listener.layoutChanged(ACanvas.getCanvas());
    }

    public void addWindowChangeListener(ChangeListener listener) {
        this.windowChangeListeners.addElement(listener);
        listener.stateChanged(new ChangeEvent(this));
    }

    public boolean isValidWindowName(String name) {
        return this.windowsList.containsKey(name);
    }

    public String[] getKnownWindowNames() {
        Set<String> windowNames = this.windowsList.keySet();
        return windowNames.toArray(new String[windowNames.size()]);
    }

    public String getCurrentWindowName() {
        return this.currentWindow.getName();
    }

    public AWindow getCurrentWindow() {
        return this.currentWindow;
    }

    public AWindow getPaintingWindow() {
        return this.paintingWindow;
    }

    private void fireWindowChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.windowChangeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    void fireLockChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.lockChangeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public int getWindowsCount() {
        return this.windowsList.size();
    }

    public void setCurrentWindow(String newWindowName) {
        if (this.windowsList.containsKey(newWindowName)) {
            if (this.currentWindow != null) {
                this.currentWindow.deselect();
            }
        } else {
            throw new Error("setCurrentWindow, window: " + newWindowName + " , doesn't exist !?");
        }
        this.currentWindow = this.windowsList.get(newWindowName);
        this.currentWindow.select();
        APar.currentIndex = this.currentWindow.getIndex();
        this.moveToFrontWindow(this.currentWindow.getName());
        this.fireWindowChange();
    }

    public void setPaintingWindow(AWindow window) {
        this.paintingWindow = window;
    }

    public void copyWindowSettings(String from, String to) {
        AWindow fromW = this.getWindow(from);
        AWindow toW = this.getWindow(to);
        APar.copyParameters(from, to);
        this.setCurrentWindow(to);
        toW.setProjection(fromW.getProjection());
        toW.setGroup(fromW.getGroupName());
        toW.setScaleStatus(fromW.getScaleStatus());
        if (!(fromW.getProjection() instanceof AProjectionEventInfo)) {
            AInteractionToolBar fromI = fromW.getInteractionToolBar();
            AInteractionToolBar toI = toW.getInteractionToolBar();
            toI.setSelectedGroup(fromI.getSelectedGroupName());
            toI.getSelectedGroup().setGroupState(fromI.getSelectedGroup());
        }
        if (fromW.getProjection() instanceof AProjectionLegoPlot && toW.getProjection() instanceof AProjectionLegoPlot) {
            AProjectionLegoPlot.setxz(toW.getIndex(), AProjectionLegoPlot.getxz(fromW.getIndex()));
            AProjectionLegoPlot.setyz(toW.getIndex(), AProjectionLegoPlot.getyz(fromW.getIndex()));
            toW.getInteractionManager().setContext(toW.getInteractionToolBar().getSelectedGroup());
        }
        toW.setUserCorners(fromW.getUserCorners());
    }

    private AWindow getWindowForLayer(int layer) {
        Component[] c = this.layeredPane.getComponentsInLayer(layer);
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof AWindow)) continue;
            return (AWindow)c[i];
        }
        return null;
    }

    public ATitleMenuBar getATitle() {
        return this.title;
    }

    private AWindow getWindowForPoint(double x, double y) {
        int maxLayer;
        for (int lay = maxLayer = 1000 + this.currentLayout.getWindowNames().length; lay >= 0; --lay) {
            Rectangle r;
            AWindow w = this.getWindowForLayer(lay);
            if (w == null || this.currentLayout == null || !(r = this.currentLayout.getWindowConstraints(w.getName())).contains(x, y)) continue;
            return w;
        }
        return null;
    }

    public boolean isReallyOnScreen(AWindow window) {
        Dimension layoutSize = this.currentLayout.getSize();
        for (int j = 0; j < layoutSize.height; ++j) {
            for (int i = 0; i < layoutSize.width; ++i) {
                if (!this.getWindowForPoint((double)i + 0.5, (double)j + 0.5).equals(window)) continue;
                return true;
            }
        }
        return false;
    }

    public void newEvent(AEvent evt) {
        this.repaintAllFromScratch();
    }

    public double getAspectRatio() {
        Dimension d = this.layeredPane.getSize();
        return d.getHeight() / d.getWidth();
    }

    public int getRespectiveHeight(int width) {
        int canvasWidth = this.getWidth();
        int canvasHeight = this.getHeight();
        double factor = (double)width / (double)canvasWidth;
        if (this.title != null && APar.get("Prefs", "CanvasTitle").getStatus()) {
            int height = this.title.getHeight();
            if (Atlantis.isAtlantisHeadless()) {
                height = (int)this.title.getLayout().preferredLayoutSize(this.title).getHeight();
            }
            return (int)(factor * (double)canvasHeight) + height;
        }
        return (int)(factor * (double)canvasHeight);
    }

    static {
        logger = ALogger.getLogger(ACanvas.class);
        parentWindow = null;
    }
}

