/*
 * Decompiled with CFR 0.152.
 */
package atlantis.canvas;

import atlantis.graphics.AAbstractGraphics2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.AttributedCharacterIterator;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;

public class AGLGraphics
extends AAbstractGraphics2D {
    private int m_clipx = 0;
    private int m_clipy = 0;
    private int m_clipw = 0;
    private int m_cliph = 0;
    private Color m_color = Color.BLACK;
    private GLAutoDrawable m_d;
    private GL m_gl;
    private int m_depth = 1;
    private ComponentColorModel m_colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
    private Font m_font = Font.decode("Arial-BOLD-18");

    public AGLGraphics(AGLGraphics old) {
        this.m_d = old.m_d;
        this.m_gl = this.m_d.getGL();
    }

    public void draw(Shape z) {
        PathIterator pi = z.getPathIterator(null);
        float[] c = new float[6];
        float xpos = 0.0f;
        float ypos = 0.0f;
        while (!pi.isDone()) {
            int type = pi.currentSegment(c);
            switch (type) {
                case 0: {
                    xpos = c[0];
                    ypos = c[1];
                    break;
                }
                case 4: {
                    break;
                }
                case 3: {
                    this.drawLine(c[2], c[3], c[4], c[5]);
                }
                case 2: {
                    this.drawLine(c[0], c[1], c[2], c[3]);
                }
                case 1: {
                    this.drawLine(xpos, ypos, c[0], c[1]);
                    xpos = c[0];
                    ypos = c[1];
                }
            }
            pi.next();
        }
    }

    public AGLGraphics(GLAutoDrawable d) {
        this.m_d = d;
        this.m_gl = this.m_d.getGL();
    }

    public Graphics create() {
        this.m_gl.glMatrixMode(2982);
        this.m_gl.glPushMatrix();
        ++this.m_depth;
        return this;
    }

    public void translate(int x, int y) {
        this.m_gl.glMatrixMode(2982);
        this.m_gl.glTranslatef((float)x, (float)y, 0.0f);
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setColor(Color c) {
        this.m_color = c;
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        float a = (float)c.getAlpha() / 255.0f;
        this.m_d.getGL().glColor4f(r, g, b, a);
    }

    public void setPaintMode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setXORMode(Color c1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Font getFont() {
        return this.m_font;
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    public FontMetrics getFontMetrics(Font f) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Rectangle getClipBounds() {
        return new Rectangle(this.m_clipx, this.m_clipy, this.m_clipw, this.m_cliph);
    }

    public void clipRect(int x, int y, int width, int height) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setClip(int x, int y, int width, int height) {
        this.m_clipx = x;
        this.m_clipy = y;
        this.m_clipw = width;
        this.m_cliph = height;
    }

    public Shape getClip() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setClip(Shape clip) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.drawLine((float)x1, (float)y1, (float)x2, (float)y2);
    }

    public void drawLine(float x1, float y1, float x2, float y2) {
        this.m_gl.glBegin(1);
        this.m_gl.glVertex2f(x1, y1);
        this.m_gl.glVertex2f(x2, y2);
        this.m_gl.glEnd();
    }

    public void fillRect(int x, int y, int width, int height) {
        GL gl = this.m_d.getGL();
        gl.glPolygonMode(1032, 6914);
        gl.glBegin(7);
        gl.glVertex2f((float)x, (float)y);
        gl.glVertex2f((float)(x + width), (float)y);
        gl.glVertex2f((float)(x + width), (float)(y + height));
        gl.glVertex2f((float)x, (float)(y + height));
        gl.glEnd();
    }

    public void clearRect(int x, int y, int width, int height) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void drawOval(int x, int y, int width, int height) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void fillOval(int x, int y, int width, int height) {
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.m_gl.glPolygonMode(1032, 6913);
        this.m_gl.glBegin(9);
        for (int i = 0; i < nPoints; ++i) {
            this.m_gl.glVertex2f((float)xPoints[i], (float)yPoints[i]);
        }
        this.m_gl.glEnd();
    }

    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.m_gl.glPolygonMode(1032, 6914);
        this.m_gl.glBegin(9);
        for (int i = 0; i < nPoints; ++i) {
            this.m_gl.glVertex2d(xPoints[i], yPoints[i]);
        }
        this.m_gl.glEnd();
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.m_gl.glPolygonMode(1032, 6914);
        this.m_gl.glBegin(9);
        for (int i = 0; i < nPoints; ++i) {
            this.m_gl.glVertex2f((float)xPoints[i], (float)yPoints[i]);
        }
        this.m_gl.glEnd();
    }

    public Stroke getStroke() {
        return null;
    }

    public void setStroke(Stroke z) {
    }

    public void drawString(String str, int x, int y) {
        WritableRaster test = Raster.createInterleavedRaster(0, 32, 32, 4, null);
        BufferedImage testi = new BufferedImage(this.m_colorModel, test, false, null);
        Graphics testg = testi.getGraphics();
        FontMetrics fm = testg.getFontMetrics(this.m_font);
        Rectangle2D r = fm.getStringBounds(str, testg);
        WritableRaster raster = Raster.createInterleavedRaster(0, (int)r.getWidth(), (int)r.getHeight(), 4, null);
        BufferedImage bi = new BufferedImage(this.m_colorModel, raster, false, null);
        Graphics big = bi.getGraphics();
        big.setColor(this.m_color);
        big.setFont(this.m_font);
        big.drawString(str, -((int)r.getX()), -((int)r.getY()));
        this.drawImage((Image)bi, x, (int)((double)y - r.getHeight()), null);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        WritableRaster raster = Raster.createInterleavedRaster(0, img.getWidth(observer), img.getHeight(observer), 4, null);
        BufferedImage bi = new BufferedImage(this.m_colorModel, raster, false, null);
        Graphics2D g = bi.createGraphics();
        AffineTransform gt = new AffineTransform();
        gt.translate(0.0, img.getHeight(observer));
        gt.scale(1.0, -1.0);
        g.transform(gt);
        g.drawImage(img, null, null);
        DataBufferByte imgbuf = (DataBufferByte)raster.getDataBuffer();
        this.m_gl.glRasterPos2i(x, y + bi.getHeight());
        this.m_gl.glDrawPixels(img.getWidth(observer), img.getHeight(observer), 6408, 5121, (Buffer)ByteBuffer.wrap(imgbuf.getData()));
        return true;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return true;
    }

    public Object getRenderingHint(RenderingHints.Key z) {
        return null;
    }

    public void setRenderingHint(RenderingHints.Key a, Object z) {
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void dispose() {
        --this.m_depth;
        if (this.m_depth == 0) {
            this.m_depth = 1;
        } else {
            this.m_gl.glMatrixMode(2982);
            this.m_gl.glPopMatrix();
        }
    }

    public void rotate(double a, double b, double z) {
        super.rotate(a, b, z);
    }

    public void rotate(double z) {
        this.m_gl.glMatrixMode(2982);
        this.m_gl.glRotated(z * 360.0 / (Math.PI * 2), 0.0, 0.0, 1.0);
    }
}

