/*
 * Decompiled with CFR 0.152.
 */
package atlantis.canvas;

import atlantis.canvas.ACanvas;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ALayout {
    private String name;
    private Hashtable windowConstraints = new Hashtable();
    private Hashtable pages = new Hashtable();
    private String startupWindow;
    private String[] startupSequence;

    public ALayout(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        this.name = attributes.getNamedItem("name").getNodeValue();
        this.startupWindow = attributes.getNamedItem("startupWindow").getNodeValue();
        this.startupSequence = this.decompose(attributes.getNamedItem("startup").getNodeValue());
        NodeList childrens = node.getChildNodes();
        for (int i = 0; i < childrens.getLength(); ++i) {
            Node child = childrens.item(i);
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName();
            if (nodeName.equals("Window")) {
                this.readWindow(child);
                continue;
            }
            if (!nodeName.equals("Page")) continue;
            this.readPage(child);
        }
    }

    private void readWindow(Node child) {
        NamedNodeMap attributes = child.getAttributes();
        String name = attributes.getNamedItem("name").getNodeValue();
        int hPos = Integer.parseInt(attributes.getNamedItem("hPos").getNodeValue());
        int vPos = Integer.parseInt(attributes.getNamedItem("vPos").getNodeValue());
        int width = Integer.parseInt(attributes.getNamedItem("width").getNodeValue());
        int height = Integer.parseInt(attributes.getNamedItem("height").getNodeValue());
        if (!ACanvas.getCanvas().isValidWindowName(name)) {
            throw new Error("Undefined window name: " + name);
        }
        if (this.windowConstraints.containsKey(name)) {
            throw new Error("Multiple usage of window name: " + name);
        }
        if (hPos < 0 || vPos < 0 || width < 0 || height < 0) {
            throw new Error("Wrong window constraints");
        }
        this.windowConstraints.put(name, new Rectangle(hPos, vPos, width, height));
    }

    private void readPage(Node child) {
        NamedNodeMap attributes = child.getAttributes();
        String name = attributes.getNamedItem("name").getNodeValue();
        String content = attributes.getNamedItem("content").getNodeValue();
        if (this.pages.containsKey(name)) {
            throw new Error("Redefinition of page: " + name);
        }
        String[] wContent = this.decompose(content);
        for (int i = 0; i < wContent.length; ++i) {
            if (ACanvas.getCanvas().isValidWindowName(wContent[i])) continue;
            throw new Error("Unknown window name: " + wContent[i]);
        }
        this.pages.put(name, wContent);
    }

    private String[] decompose(String s) {
        String[] strings = new String[s.length()];
        char[] characters = s.toCharArray();
        for (int i = 0; i < characters.length; ++i) {
            strings[i] = new String(new char[]{characters[i]});
        }
        return strings;
    }

    public String getName() {
        return this.name;
    }

    public String getStartupWindow() {
        return this.startupWindow;
    }

    public String[] getStartupSequence() {
        return this.startupSequence;
    }

    public boolean hasWindow(String wName) {
        return this.windowConstraints.containsKey(wName);
    }

    public String[] getWindowNames() {
        Enumeration wn = this.windowConstraints.keys();
        int size = this.windowConstraints.size();
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            names[i] = (String)wn.nextElement();
        }
        return names;
    }

    public Rectangle getWindowConstraints(String wName) {
        return (Rectangle)this.windowConstraints.get(wName);
    }

    public Dimension getSize() {
        Enumeration myenum = this.windowConstraints.elements();
        int w = 0;
        int h = 0;
        while (myenum.hasMoreElements()) {
            Rectangle r = (Rectangle)myenum.nextElement();
            if (r.x + r.width > w) {
                w = r.x + r.width;
            }
            if (r.y + r.height <= h) continue;
            h = r.y + r.height;
        }
        return new Dimension(w, h);
    }

    public String[] getPageNames() {
        Enumeration myenum = this.pages.keys();
        int size = this.pages.size();
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            names[i] = (String)myenum.nextElement();
        }
        return names;
    }

    public String[] getPageContent(String pageName) {
        return (String[])this.pages.get(pageName);
    }
}

