/*
 * Decompiled with CFR 0.152.
 */
package atlantis.canvas;

import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import java.awt.geom.GeneralPath;

public class AScale {
    private static int[] p = new int[]{2, 2, 5, 5, 5, 10, 10, 10, 20, 20, 50, 50};
    private static int[] ps = new int[]{2, 10, 5, 10, 20, 10, 20, 50, 20, 100, 50, 100};
    public static final int LEFT_TICKS = 0;
    public static final int RIGHT_TICKS = 1;
    public static final int BOTH_TICKS = 2;
    private static float primaryTickSize = 8.0f;
    private static float secondaryTickSize = 5.0f;

    public static void setTickSizes(float primaryTickSize, float secondaryTickSize) {
        AScale.primaryTickSize = primaryTickSize;
        AScale.secondaryTickSize = secondaryTickSize;
    }

    public static float getPrimaryTickSize() {
        return primaryTickSize;
    }

    public static float getSecondaryTickSize() {
        return secondaryTickSize;
    }

    private static void addTickMark(GeneralPath gp, int location, float tickPosition, float tickLength) {
        switch (location) {
            case 1: {
                gp.moveTo(tickPosition, 0.0f);
                gp.lineTo(tickPosition, tickLength);
                break;
            }
            case 0: {
                gp.moveTo(tickPosition, 0.0f);
                gp.lineTo(tickPosition, -tickLength);
                break;
            }
            case 2: {
                gp.moveTo(tickPosition, -tickLength);
                gp.lineTo(tickPosition, tickLength);
            }
        }
    }

    public static void calculateScale(double value0, double value1, int scaleSize, int minPrimary, int minSeparation, int location, GeneralPath primaryTicks, GeneralPath secondaryTicks, String[] label, double[] position, int isVertical, AProjection proj) {
        double range = Math.abs(value1 - value0);
        double m = Math.pow(10.0, Math.ceil(Math.log10(range)));
        double w = scaleSize;
        double minNP = m * (double)minPrimary / range;
        double maxNPNS = w * m / (range * (double)minSeparation);
        int optimal = -1;
        int oldPS = -1;
        int oldP = Integer.MAX_VALUE;
        for (int i = 0; i < p.length; ++i) {
            if (!((double)p[i] > minNP) || !((double)ps[i] < maxNPNS) || p[i] > oldP || ps[i] <= oldPS) continue;
            optimal = i;
            oldP = p[i];
            oldPS = ps[i];
        }
        primaryTicks.reset();
        secondaryTicks.reset();
        primaryTicks.moveTo(0.0f, 0.0f);
        primaryTicks.lineTo((float)w, 0.0f);
        secondaryTicks.moveTo(0.0f, 0.0f);
        secondaryTicks.lineTo((float)w, 0.0f);
        if (optimal > 0) {
            long iv;
            float tickPosition;
            double val;
            long iv2;
            double size = m / (double)ps[optimal];
            long average = (long)(0.5 * (value0 + value1) / size);
            long limit0 = (long)(value0 / size - (double)average) + average;
            long limit1 = (long)(value1 / size - (double)average) + average;
            for (iv2 = Math.min(limit0, limit1); iv2 <= Math.max(limit0, limit1); ++iv2) {
                val = (double)iv2 * size;
                if (proj instanceof AProjection2D) {
                    val = isVertical == 1 ? ((AProjection2D)proj).nonLinearTransform(0.0, val).getY() : ((AProjection2D)proj).nonLinearTransform(val, 0.0).getX();
                }
                tickPosition = AScale.interpolate(val, w, value0, value1);
                AScale.addTickMark(secondaryTicks, location, tickPosition, secondaryTickSize);
            }
            size = m / (double)p[optimal];
            average = (long)(0.5 * (value0 + value1) / size);
            limit0 = (long)(value0 / size - (double)average) + average;
            limit1 = (long)(value1 / size - (double)average) + average;
            for (iv2 = Math.min(limit0, limit1); iv2 <= Math.max(limit0, limit1); ++iv2) {
                val = (double)iv2 * size;
                if (proj instanceof AProjection2D) {
                    val = isVertical == 1 ? ((AProjection2D)proj).nonLinearTransform(0.0, val).getY() : ((AProjection2D)proj).nonLinearTransform(val, 0.0).getX();
                }
                tickPosition = AScale.interpolate(val, w, value0, value1);
                AScale.addTickMark(primaryTicks, location, tickPosition, primaryTickSize);
            }
            int ndigits = (int)Math.floor(Math.log10(size));
            ndigits = -Math.min(ndigits, 0);
            long zero = iv = Math.min(limit0, limit1);
            double val2 = (double)iv * size;
            label[0] = AScale.fixedPrecision(val2, ndigits);
            if (proj instanceof AProjection2D) {
                val2 = isVertical == 1 ? ((AProjection2D)proj).nonLinearTransform(0.0, val2).getY() : ((AProjection2D)proj).nonLinearTransform(val2, 0.0).getX();
            }
            float tickPosition2 = AScale.interpolate(val2, w, value0, value1);
            position[0] = tickPosition2;
            iv = Math.max(limit0, limit1);
            zero *= iv;
            val2 = (double)iv * size;
            label[1] = AScale.fixedPrecision(val2, ndigits);
            if (proj instanceof AProjection2D) {
                val2 = isVertical == 1 ? ((AProjection2D)proj).nonLinearTransform(0.0, val2).getY() : ((AProjection2D)proj).nonLinearTransform(val2, 0.0).getX();
            }
            tickPosition2 = AScale.interpolate(val2, w, value0, value1);
            position[1] = tickPosition2;
            if (zero <= 0L) {
                tickPosition2 = AScale.interpolate(0.0, w, value0, value1);
                label[2] = AScale.fixedPrecision(0.0, ndigits);
                position[2] = tickPosition2;
            } else {
                label[2] = null;
                position[2] = position[1];
            }
        }
    }

    private static float interpolate(double value, double size, double value0, double value1) {
        return (float)(size * (value - value0) / (value1 - value0));
    }

    public static String fixedPrecision(double d, int ndigits) {
        String dstring = Double.toString(d);
        StringBuffer buffer = new StringBuffer(dstring);
        int index = dstring.lastIndexOf(".");
        if (index < 0) {
            buffer.append(".");
            index = buffer.length() - 1;
        }
        buffer.setLength(index + ndigits + 1);
        for (int i = 0; i < buffer.length(); ++i) {
            if (buffer.charAt(i) != '\u0000') continue;
            buffer.setCharAt(i, '0');
        }
        return buffer.toString();
    }
}

