/*
 * Decompiled with CFR 0.152.
 */
package atlantis.canvas;

import atlantis.canvas.AScale;
import atlantis.canvas.AWindow;
import atlantis.graphics.AAbstractGraphics2D;
import atlantis.gui.ACursorFactory;
import atlantis.gui.APreferencesControl;
import atlantis.parameters.AEnumeratorParameter;
import atlantis.parameters.ALinkParameter;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection;
import atlantis.projection.AProjectionEventInfo;
import atlantis.projection.AProjectionLegoPlot;
import atlantis.projection.AProjectionNGE;
import atlantis.projection.AProjectionTrackResidual;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.border.Border;

public class AScaleBorder
implements Border {
    private static final int SELECTED = 2;
    private static final String DELTA = "\u0394";
    private static final String PRIME = "\u00b4";
    private static final String DOT = "\u00b7";
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    public static final int TYPE_PARALLEL_TRANSFORM = 0;
    public static final int TYPE_SWITCHED_TRANSFORM = 1;
    public static final int TYPE_X_SKEW_TRANSFORM = 2;
    public static final int TYPE_Y_SKEW_TRANSFORM = 3;
    public static final int TYPE_SWITCHED_X_SKEW_TRANSFORM = 4;
    public static final int TYPE_SWITCHED_Y_SKEW_TRANSFORM = 5;
    public static final int TYPE_GENERAL_TRANSFORM = 6;
    public static final int TEXT_BASELINE = 0;
    public static final int TEXT_TOP = 1;
    public static final int TEXT_BOTTOM = 3;
    public static final int TEXT_CENTER = 2;
    public static final int TEXT_LEFT = 1;
    public static final int TEXT_RIGHT = 3;
    private GeneralPath[] pTicks = new GeneralPath[2];
    private GeneralPath[] sTicks = new GeneralPath[2];
    private String[] axisLabels = new String[2];
    private String[] axisUnits = new String[2];
    private String[][] labels;
    private double[][] positions;
    private int fontSize = 12;
    private Font labelFont = new Font("SansSerif", 1, 12);
    private static final Stroke thinStroke = new BasicStroke(1.0f);
    private static final Stroke thickStroke = new BasicStroke(2.0f);
    private double[] axisPts = new double[6];
    private boolean scaleChanged;
    private int currentWidth;
    private int currentHeight;
    private double minHoriz;
    private double maxHoriz;
    private double minVert;
    private double maxVert;
    private Insets insets;
    private boolean selected;
    private boolean drawScaleBorder;
    private boolean drawScaleBorder_preference;
    private final AWindow aWindow;

    public AScaleBorder(AWindow theWindow) {
        this.aWindow = theWindow;
        this.minHoriz = 0.0;
        this.maxHoriz = 0.0;
        this.minVert = 0.0;
        this.maxVert = 0.0;
        this.resetInsets();
        this.pTicks[0] = new GeneralPath();
        this.pTicks[1] = new GeneralPath();
        this.sTicks[0] = new GeneralPath();
        this.sTicks[1] = new GeneralPath();
        this.labels = new String[2][3];
        this.positions = new double[2][3];
        this.currentWidth = 0;
        this.currentHeight = 0;
        this.scaleChanged = false;
        this.selected = false;
        this.drawScaleBorder = true;
        this.drawScaleBorder_preference = true;
    }

    public void forceDraw() {
        this.scaleChanged = true;
    }

    public void toggleScale() {
        this.drawScaleBorder_preference = !this.drawScaleBorder_preference;
        AProjection p = this.aWindow.getProjection();
        if (p instanceof AProjectionLegoPlot || p instanceof AProjectionNGE || p instanceof AProjectionEventInfo) {
            return;
        }
        this.drawScaleBorder = !this.drawScaleBorder;
        this.scaleChanged = true;
        this.resetInsets();
    }

    public void hideScale() {
        AProjection p = this.aWindow.getProjection();
        if (APreferencesControl.getHideScalesMenuItem()) {
            this.drawScaleBorder = false;
            this.resetInsets();
        } else if (p instanceof AProjectionLegoPlot || p instanceof AProjectionNGE || p instanceof AProjectionEventInfo) {
            if (this.drawScaleBorder) {
                this.drawScaleBorder = false;
                this.resetInsets();
            }
        } else if (this.drawScaleBorder != this.drawScaleBorder_preference) {
            this.drawScaleBorder = this.drawScaleBorder_preference;
            this.resetInsets();
        }
    }

    public boolean getScaleStatus() {
        return this.drawScaleBorder_preference;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
        this.fontSize = labelFont.getSize();
        this.resetInsets();
    }

    public void setSelected() {
        this.selected = true;
    }

    public void setDeselected() {
        this.selected = false;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLimits(double minHoriz, double maxHoriz, double minVert, double maxVert) {
        this.minHoriz = minHoriz;
        this.maxHoriz = maxHoriz;
        this.minVert = minVert;
        this.maxVert = maxVert;
        this.scaleChanged = true;
    }

    public void setAxisLabels(String horizontalLabel, String verticalLabel) {
        this.axisLabels[0] = horizontalLabel;
        this.axisLabels[1] = verticalLabel;
    }

    public String getHorizontalAxisLabel() {
        return this.axisLabels[0];
    }

    public String getVerticalAxisLabel() {
        return this.axisLabels[1];
    }

    public void setAxisUnits(String horizontalUnits, String verticalUnits) {
        this.axisUnits[0] = horizontalUnits != null ? horizontalUnits : "";
        this.axisUnits[1] = verticalUnits != null ? verticalUnits : "";
    }

    public Insets getBorderInsets(Component c) {
        return (Insets)this.insets.clone();
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D vg = (Graphics2D)g;
        if (vg == null) {
            return;
        }
        Color bg = AWindow.BORDER_BACKGROUND_COLOR;
        if (this.selected) {
            bg = AWindow.BORDER_SELECTED_BACKGROUND_COLOR;
        }
        this.paintBorderFrame(vg, bg, width, height);
        if (this.drawScaleBorder) {
            AProjection p = this.aWindow.getProjection();
            this.scaleChanged = this.scaleChanged || width != this.currentWidth || height != this.currentHeight;
            this.setScales(p.getXLabel(), p.getYLabel(), p.getXUnits(), p.getYUnits(), this.makeTransform(this.aWindow.getUserCorners()), this.aWindow.getWidth(), this.aWindow.getHeight());
            this.paintGrid(vg, p, width, height);
            this.paintScales(vg, p, width, height);
            this.currentWidth = width;
            this.currentHeight = height;
            this.scaleChanged = false;
        }
        if (APreferencesControl.getWindowTitleMenuItem()) {
            this.paintWindowTitle(g, width, height, true);
        }
        if (APreferencesControl.getFisheyeIndicatorMenuItem()) {
            this.paintFishEyeIndicator(g, false, width, height);
        }
    }

    public void printBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D vg = (Graphics2D)g;
        if (vg == null) {
            return;
        }
        Color bg = AWindow.BORDER_BACKGROUND_COLOR;
        this.printBorderFrame(vg, bg, width, height);
        if (this.drawScaleBorder) {
            AProjection p = this.aWindow.getProjection();
            this.scaleChanged = this.scaleChanged || width != this.currentWidth || height != this.currentHeight;
            this.setScales(p.getXLabel(), p.getYLabel(), p.getXUnits(), p.getYUnits(), this.makeTransform(this.aWindow.getUserCorners()), this.aWindow.getWidth(), this.aWindow.getHeight());
            this.printGrid(vg, p, width, height);
            this.printScales(vg, p, width, height);
            this.currentWidth = width;
            this.currentHeight = height;
            this.scaleChanged = false;
        }
        if (APreferencesControl.getWindowTitleMenuItem()) {
            this.paintWindowTitle(g, width, height, false);
        }
        if (APreferencesControl.getFisheyeIndicatorMenuItem()) {
            this.printFishEyeIndicator(g, width, height);
        }
    }

    private void printScales(Graphics2D g, AProjection p, int width, int height) {
        Graphics2D svg = (Graphics2D)g.create();
        if (this.scaleChanged) {
            AScale.calculateScale(this.minHoriz, this.maxHoriz, width - (this.insets.left + this.insets.right), 3, 7, 1, this.pTicks[0], this.sTicks[0], this.labels[0], this.positions[0], 0, p);
        }
        svg.translate(this.insets.left, height - this.insets.bottom + 2);
        if (this.selected) {
            svg.setColor(AWindow.BORDER_SELECTED_FOREGROUND_COLOR);
        } else {
            svg.setColor(AWindow.BORDER_FOREGROUND_COLOR);
        }
        svg.setFont(new Font("SansSerif", 1, 12));
        svg.setStroke(thickStroke);
        svg.draw(this.pTicks[0]);
        svg.setStroke(thinStroke);
        svg.draw(this.sTicks[0]);
        double factorH = 1.0;
        String unitsH = this.axisUnits[0];
        double deltaH = Math.abs(this.maxHoriz - this.minHoriz);
        double maxH = Math.max(Math.abs(this.maxHoriz), Math.abs(this.minHoriz));
        if (unitsH.equals("(cm)")) {
            if (maxH > 200.0) {
                factorH = 0.01;
                unitsH = "(m) ";
            } else if (maxH > 2.0) {
                factorH = 1.0;
                unitsH = "(cm)";
            } else if (maxH > 0.2) {
                factorH = 10.0;
                unitsH = "(mm)";
            } else {
                factorH = 10000.0;
                unitsH = "(\u00b5m)";
            }
        }
        double factorV = 1.0;
        String unitsV = this.axisUnits[1];
        double deltaV = Math.abs(this.maxVert - this.minVert);
        double maxV = Math.max(Math.abs(this.maxVert), Math.abs(this.minVert));
        if (unitsV.equals("(cm)")) {
            if (maxV > 200.0) {
                factorV = 0.01;
                unitsV = "(m) ";
            } else if (maxV > 2.0) {
                factorV = 1.0;
                unitsV = "(cm)";
            } else if (maxV > 0.2) {
                factorV = 10.0;
                unitsV = "(mm)";
            } else {
                factorV = 10000.0;
                unitsV = "(\u00b5m)";
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.labels[0][i] == null) continue;
            this.drawString(svg, "" + this.trim(Double.parseDouble(this.labels[0][i]) * factorH, deltaH * factorH), (float)this.positions[0][i], AScale.getPrimaryTickSize() + 0.2f * (float)this.fontSize, 2, 1, width - this.insets.left - this.insets.right);
        }
        float axisPosition = Math.abs(this.positions[0][2] - this.positions[0][1]) > 0.99 * Math.abs(this.positions[0][2] - this.positions[0][0]) ? (float)(0.5 * (this.positions[0][2] + this.positions[0][1])) : (float)(0.5 * (this.positions[0][2] + this.positions[0][0]));
        this.drawString(svg, this.axisLabels[0] + " " + unitsH, axisPosition, AScale.getPrimaryTickSize() + 0.2f * (float)this.fontSize, 2, 1, width - this.insets.left - this.insets.right);
        svg.dispose();
        svg = (Graphics2D)g.create();
        if (this.scaleChanged) {
            AScale.calculateScale(this.minVert, this.maxVert, height - (this.insets.top + this.insets.bottom), 3, 7, 0, this.pTicks[1], this.sTicks[1], this.labels[1], this.positions[1], 1, p);
        }
        svg.translate(this.insets.left - 2, height - this.insets.bottom);
        svg.rotate(-1.5707963267948966);
        if (this.selected) {
            svg.setColor(AWindow.BORDER_SELECTED_FOREGROUND_COLOR);
        } else {
            svg.setColor(AWindow.BORDER_FOREGROUND_COLOR);
        }
        svg.setFont(new Font("SansSerif", 1, 12));
        svg.setStroke(thickStroke);
        svg.draw(this.pTicks[1]);
        svg.setStroke(thinStroke);
        svg.draw(this.sTicks[1]);
        for (int i = 0; i < 3; ++i) {
            if (this.labels[1][i] == null) continue;
            String tick = "" + this.trim(Double.parseDouble(this.labels[1][i]) * factorV, deltaV * factorV);
            if (p instanceof AProjectionTrackResidual && APar.get("TrackResidual", "Scale").getI() == 1 && !tick.equals("0")) {
                long tmp = Math.round(((AProjectionTrackResidual)p).getResidual().getLogMagnitudeMin() + Math.abs(Double.parseDouble(tick)));
                tick = tick.indexOf("-") == -1 ? "1E" + tmp : "-1E" + tmp;
            }
            this.drawString(svg, tick, (float)this.positions[1][i], -(AScale.getPrimaryTickSize() + 0.2f * (float)this.fontSize), 2, 3, height - this.insets.top - this.insets.bottom);
        }
        axisPosition = Math.abs(this.positions[1][2] - this.positions[1][1]) > 0.99 * Math.abs(this.positions[1][2] - this.positions[1][0]) ? (float)(0.5 * (this.positions[1][2] + this.positions[1][1])) : (float)(0.5 * (this.positions[1][2] + this.positions[1][0]));
        this.drawString(svg, this.axisLabels[1] + " " + unitsV, axisPosition, -(AScale.getPrimaryTickSize() + 0.2f * (float)this.fontSize), 2, 3, height - this.insets.top - this.insets.bottom);
        svg.dispose();
    }

    private void paintScales(Graphics2D g, AProjection p, int width, int height) {
        this.printScales(g, p, width, height);
    }

    private void printGrid(Graphics2D g, AProjection p, int width, int height) {
        Graphics2D svg = (Graphics2D)g.create();
        if (p.getName().equals("VP")) {
            Point2D.Double endp;
            Point2D.Double startp;
            int i;
            svg.setColor(Color.LIGHT_GRAY);
            float[] etaGridPositions = new float[]{-4.9f, -3.2f, -2.5f, -1.375f, -0.8f, 0.8f, 1.375f, 2.5f, 3.2f, 4.9f};
            for (i = 0; i < etaGridPositions.length; ++i) {
                if (!((double)etaGridPositions[i] > this.minHoriz) || !((double)etaGridPositions[i] < this.maxHoriz)) continue;
                startp = this.aWindow.calculateDisplay(etaGridPositions[i], this.minVert);
                endp = this.aWindow.calculateDisplay(etaGridPositions[i], this.maxVert);
                svg.drawLine((int)startp.x, (int)startp.y, (int)endp.x, (int)endp.y);
            }
            i = (int)Math.ceil(this.minVert / 90.0) * 90;
            while ((double)i <= this.maxVert) {
                startp = this.aWindow.calculateDisplay(this.minHoriz, i);
                endp = this.aWindow.calculateDisplay(this.maxHoriz, i);
                if (Math.abs(i) % 360 == 0) {
                    svg.setColor(Color.WHITE);
                    svg.setStroke(thickStroke);
                } else {
                    svg.setColor(Color.LIGHT_GRAY);
                    svg.setStroke(thinStroke);
                }
                svg.drawLine((int)startp.x, (int)startp.y, (int)endp.x, (int)endp.y);
                i += 90;
            }
        }
        svg.dispose();
    }

    private void paintGrid(Graphics2D g, AProjection p, int width, int height) {
        this.printGrid(g, p, width, height);
    }

    private void printBorderFrame(Graphics2D g, Color bg, int width, int height) {
        Graphics2D svg = (Graphics2D)g.create();
        svg.setColor(bg);
        svg.fillRect(0, 0, width, this.insets.top);
        svg.fillRect(0, 0, this.insets.left, height - this.insets.bottom);
        svg.fillRect(width - this.insets.right, 0, this.insets.right, height);
        svg.fillRect(0, height - this.insets.bottom, width, this.insets.bottom);
        svg.dispose();
    }

    private void paintBorderFrame(Graphics2D g, Color bg, int width, int height) {
        this.printBorderFrame(g, bg, width, height);
        Graphics2D svg = (Graphics2D)g.create();
        if (this.selected) {
            svg.setColor(AWindow.BORDER_SELECTED_FRAMELIGHT_COLOR);
            int[] xp = new int[]{0, 0, 11, 0};
            int[] yp = new int[]{height - 12, height, height, height - 12};
            svg.fillPolygon(xp, yp, 4);
            svg.setColor(AWindow.BORDER_SELECTED_FRAME_COLOR);
            svg.drawLine(0, 0, width - 1, 0);
            svg.drawLine(0, 0, 0, height - 10);
            svg.drawLine(width - 1, 0, width - 1, height - 1);
            svg.drawLine(10, height - 1, width - 1, height - 1);
            svg.drawLine(0, height - 10, 9, height - 1);
            svg.setColor(AWindow.BORDER_SELECTED_FRAMELIGHT_COLOR);
            svg.drawLine(10, height - 2, width - 2, height - 2);
            svg.drawLine(1, 1, 1, height - 10);
            svg.setColor(AWindow.BORDER_BACKGROUND_COLOR);
            xp[2] = 8;
            yp[0] = height - 9;
            yp[3] = height - 9;
            svg.fillPolygon(xp, yp, 4);
        }
        svg.dispose();
    }

    private void paintWindowTitle(Graphics g, int width, int height, boolean highlight) {
        Graphics2D svg = (Graphics2D)g.create();
        String s = this.aWindow.getProjection().getName();
        APar.selectWindowParameters(this.aWindow.getName());
        AParameter param = APar.get(s, "Mode");
        int mode = param.getI();
        s = this.aWindow.getProjection().getScreenName();
        s = s + " Projection";
        if (param != null && mode != 0) {
            s = s + " viewing: ";
            s = param instanceof ALinkParameter ? s + ((ALinkParameter)param).getCurrentText() : s + ((AEnumeratorParameter)param).getCurrentText();
        }
        APar.restoreWindowParameters();
        int Offset = 2;
        int boxsize = svg.getFontMetrics().stringWidth(s) + Offset * 2;
        int y = Offset + svg.getFontMetrics().getHeight();
        int x = this.insets.left + (int)Math.round((double)(width - this.insets.left - boxsize) / 2.0);
        if (this.selected && highlight) {
            svg.setColor(AWindow.BORDER_SELECTED_BACKGROUND_COLOR);
            svg.fillRect(x - 2, 1, boxsize + 4, y + 1);
            svg.setColor(AWindow.BORDER_SELECTED_FRAME_COLOR);
            svg.fillRect(x - 1, 0, boxsize + 2, y + 1);
            svg.setColor(AWindow.BORDER_SELECTED_FRAMELIGHT_COLOR);
            svg.fillRect(x, 1, boxsize, y - 1);
            svg.setColor(AWindow.BORDER_SELECTED_BACKGROUND_COLOR);
            svg.fillRect(x + 1, 1, boxsize - 1, y - 2);
            svg.setColor(AWindow.BORDER_SELECTED_FOREGROUND_COLOR);
        } else {
            svg.setColor(AWindow.BORDER_BACKGROUND_COLOR);
            svg.fillRect(x - 2, 0, boxsize + 4, y + 2);
            svg.setColor(AWindow.BORDER_FOREGROUND_COLOR);
        }
        svg.drawString(s, x + Offset, y - 3);
        svg.dispose();
    }

    private void printFishEyeIndicator(Graphics g, int width, int height) {
        this.paintFishEyeIndicator(g, false, width, height);
    }

    private void paintFishEyeIndicator(Graphics g, boolean forceText, int width, int height) {
        boolean fishEyeStatus = false;
        APar.selectWindowParameters(this.aWindow.getName());
        AParameter fishEyePar = APar.get(this.aWindow.getProjection().getName(), "FishEye");
        if (fishEyePar != null) {
            fishEyeStatus = fishEyePar.getStatus();
        }
        APar.restoreWindowParameters();
        if (fishEyeStatus) {
            Graphics2D svg = (Graphics2D)g.create();
            int Offset = 4;
            if (!forceText) {
                Image IndicatorImg = ACursorFactory.getInstance().getFishEyeIndicator();
                int x = width - Offset - IndicatorImg.getWidth(null);
                int y = Offset;
                svg.drawImage(IndicatorImg, x, y, null);
            } else {
                int x = width - Offset - svg.getFontMetrics().stringWidth("FishEye");
                int y = Offset + svg.getFontMetrics().getHeight();
                svg.setColor(Color.red);
                svg.drawString("FishEye", x, y);
            }
            svg.dispose();
        }
    }

    private void resetInsets() {
        int lb = (int)((double)(4.0f + AScale.getPrimaryTickSize()) + 1.5 * (double)this.fontSize);
        int tr = 2;
        this.insets = this.drawScaleBorder ? new Insets(tr, lb, lb, tr) : new Insets(tr, tr, tr, tr);
    }

    public void setScales(String horizLabel, String vertLabel, String horizUnits, String vertUnits, AffineTransform transform, int panelWidth, int panelHeight) {
        int type = AScaleBorder.classifyTransform(transform);
        switch (type) {
            case 0: {
                this.setAxisLabels(horizLabel, vertLabel);
                this.setAxisUnits(horizUnits, vertUnits);
                break;
            }
            case 1: {
                this.setAxisLabels(vertLabel, horizLabel);
                this.setAxisUnits(vertUnits, horizUnits);
                break;
            }
            case 3: {
                this.setAxisLabels(horizLabel + PRIME, DELTA + vertLabel);
                if (horizUnits.equals(vertUnits)) {
                    this.setAxisUnits(horizUnits, vertUnits);
                    break;
                }
                this.setAxisUnits(horizUnits + DOT + vertUnits, vertUnits);
                break;
            }
            case 2: {
                this.setAxisLabels(DELTA + horizLabel, vertLabel + PRIME);
                if (vertUnits.equals(horizUnits)) {
                    this.setAxisUnits(horizUnits, vertUnits);
                    break;
                }
                this.setAxisUnits(horizUnits, vertUnits + DOT + horizUnits);
                break;
            }
            case 5: {
                this.setAxisLabels(vertLabel + PRIME, DELTA + horizLabel);
                if (vertUnits.equals(horizUnits)) {
                    this.setAxisUnits(vertUnits, horizUnits);
                    break;
                }
                this.setAxisUnits(vertUnits + DOT + horizUnits, horizUnits);
                break;
            }
            case 4: {
                this.setAxisLabels(DELTA + vertLabel, horizLabel + PRIME);
                if (horizUnits.equals(vertUnits)) {
                    this.setAxisUnits(vertUnits, horizUnits);
                    break;
                }
                this.setAxisUnits(vertUnits, horizUnits + DOT + vertUnits);
                break;
            }
            default: {
                this.setAxisLabels(horizLabel + PRIME, vertLabel + PRIME);
                if (horizUnits.equals(vertUnits)) {
                    this.setAxisUnits(horizUnits, vertUnits);
                    break;
                }
                this.setAxisUnits(horizUnits + DOT + vertUnits, vertUnits + DOT + horizUnits);
            }
        }
        this.axisPts[0] = 0.0;
        this.axisPts[1] = panelHeight;
        this.axisPts[2] = 0.0;
        this.axisPts[3] = panelHeight;
        this.axisPts[4] = panelWidth;
        this.axisPts[5] = 0.0;
        try {
            AffineTransform ixform = transform.createInverse();
            ixform.transform(this.axisPts, 0, this.axisPts, 0, 1);
            ixform.deltaTransform(this.axisPts, 2, this.axisPts, 2, 2);
            double vdy = this.axisPts[3];
            double vdx = this.axisPts[2];
            double vdist = Math.sqrt(vdx * vdx + vdy * vdy);
            double hdy = this.axisPts[5];
            double hdx = this.axisPts[4];
            double hdist = Math.sqrt(hdx * hdx + hdy * hdy);
            double vmin = 0.0;
            double vmax = 0.0;
            double hmin = 0.0;
            double hmax = 0.0;
            switch (type) {
                case 0: {
                    double vsign = vdy < 0.0 ? 1.0 : -1.0;
                    vmin = this.axisPts[1];
                    vmax = this.axisPts[1] + vsign * vdist;
                    double hsign = hdx > 0.0 ? 1.0 : -1.0;
                    hmin = this.axisPts[0];
                    hmax = this.axisPts[0] + hsign * hdist;
                    break;
                }
                case 1: {
                    double hsign = hdy > 0.0 ? 1.0 : -1.0;
                    hmin = this.axisPts[1];
                    hmax = this.axisPts[1] + hsign * hdist;
                    double vsign = vdx < 0.0 ? 1.0 : -1.0;
                    vmin = this.axisPts[0];
                    vmax = this.axisPts[0] + vsign * vdist;
                    break;
                }
                case 3: {
                    double vsign = vdy > 0.0 ? 1.0 : -1.0;
                    vmax = -vsign * vdist / 2.0;
                    vmin = -vmax;
                    hmin = 0.0;
                    hmax = hdist;
                    break;
                }
                case 2: {
                    double hsign = hdx > 0.0 ? 1.0 : -1.0;
                    hmax = hsign * hdist / 2.0;
                    hmin = -hmax;
                    vmin = 0.0;
                    vmax = vdist;
                    break;
                }
                case 5: {
                    double vsign = vdx > 0.0 ? 1.0 : -1.0;
                    vmax = -vsign * vdist / 2.0;
                    vmin = -vmax;
                    hmin = 0.0;
                    hmax = hdist;
                    break;
                }
                case 4: {
                    double hsign = hdy > 0.0 ? 1.0 : -1.0;
                    hmax = hsign * hdist / 2.0;
                    hmin = -hmax;
                    vmin = 0.0;
                    vmax = vdist;
                    break;
                }
                default: {
                    vmin = 0.0;
                    vmax = 0.0;
                    hmin = 0.0;
                    hmax = 0.0;
                }
            }
            this.setLimits(hmin, hmax, vmin, vmax);
        }
        catch (NoninvertibleTransformException e) {
            this.setLimits(0.0, 0.0, 0.0, 0.0);
        }
    }

    protected static int classifyTransform(AffineTransform xform) {
        int category = 6;
        double sx = xform.getScaleX();
        double sy = xform.getScaleY();
        double kx = xform.getShearX();
        double ky = xform.getShearY();
        if (kx == 0.0 && ky == 0.0) {
            category = 0;
        } else if (sx == 0.0 && sy == 0.0) {
            category = 1;
        } else if (kx == 0.0) {
            category = 3;
        } else if (ky == 0.0) {
            category = 2;
        } else if (sx == 0.0) {
            category = 5;
        } else if (sy == 0.0) {
            category = 4;
        }
        return category;
    }

    protected AffineTransform makeTransform(Point2D.Double[] corners) {
        double x0 = corners[0].x;
        double y0 = corners[0].y;
        double x1 = corners[1].x;
        double y1 = corners[1].y;
        double x2 = corners[2].x;
        double y2 = corners[2].y;
        double sx = 0.0;
        double kx = 0.0;
        double tx = 0.0;
        double sy = 0.0;
        double ky = 0.0;
        double ty = 0.0;
        double delta = x2 * (y1 - y0) - x1 * (y2 - y0) + x0 * (y2 - y1);
        if (delta == 0.0) {
            System.err.println("Fatal Error: AffineTransform creating failed.");
            System.err.println("Possible cause: wrong user corner values are set.");
            System.exit(1);
            return null;
        }
        delta = 1.0 / delta;
        double w = this.aWindow.getWidth();
        double h = this.aWindow.getHeight();
        sx = -(delta * w) * (y2 - y1);
        kx = delta * w * (x2 - x1);
        tx = -(x0 * sx + y0 * kx);
        ky = delta * h * (y1 - y0);
        sy = -(delta * h) * (x1 - x0);
        ty = -(x0 * ky + y0 * sy);
        return new AffineTransform(sx, ky, kx, sy, tx, ty);
    }

    public void drawString(Graphics2D g, String str, double x, double y, int horizontal, int vertical, int maxSize) {
        this.drawString(g, str, x, y, horizontal, vertical, false, null, 0.0, false, null, maxSize);
    }

    private void drawString(Graphics2D g, String str, double x, double y, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor, int maxSize) {
        Font sf = g.getFont();
        int width = sf.getSize();
        int descent = 0;
        int height = sf.getSize();
        int adjustment = 0;
        double xx = Math.min(x, (double)(maxSize - width / 2));
        Rectangle textSize = new Rectangle(0, descent - height, width, height);
        Point2D textUL = this.drawFrameAndBanner(xx, y, textSize, adjustment, framed, frameColor, frameWidth, banner, bannerColor, horizontal, vertical);
        if (g instanceof AAbstractGraphics2D) {
            g.drawString(str, (int)textUL.getX(), (int)textUL.getY());
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawString(str, (int)textUL.getX(), (int)textUL.getY());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    private Point2D drawFrameAndBanner(double x, double y, Rectangle textSize, int adjustment, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor, int horizontal, int vertical) {
        double descent = textSize.y + textSize.height;
        x = AScaleBorder.getXalignment(x, textSize.width, horizontal);
        y = AScaleBorder.getYalignment(y, textSize.height, (int)descent, vertical);
        return new Point2D.Double(x, y);
    }

    private static double getYalignment(double y, int ascent, int descent, int alignment) {
        switch (alignment) {
            case 1: {
                y = y + (double)ascent - (double)descent;
                break;
            }
            case 2: {
                y = y + (double)((ascent + descent) / 2) - (double)descent;
                break;
            }
            case 3: {
                y -= (double)descent;
                break;
            }
        }
        return y;
    }

    private static double getXalignment(double x, int width, int alignment) {
        switch (alignment) {
            case 2: {
                x -= (double)(width / 2);
                break;
            }
            case 3: {
                x -= (double)width;
                break;
            }
        }
        return x;
    }

    private String trim(double v, double ratio) {
        double r = 2.0;
        double f = 1.0;
        while (r > ratio) {
            r /= 10.0;
            f *= 10.0;
        }
        if (f == 1.0) {
            return "" + Math.round(v);
        }
        return "" + (double)Math.round(v * f) / f;
    }
}

