/*
 * Decompiled with CFR 0.152.
 */
package atlantis.canvas;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.event.AEvent;
import atlantis.graphics.AGraphics;
import atlantis.parameters.APar;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JMenuBar;

public class ATitleMenuBar
extends JMenuBar {
    public ATitleMenuBar() {
        JLabel atlas = new JLabel(" HYPATIA ");
        atlas.setFont(new Font("Courier", 0, 25));
        this.add(atlas);
    }

    public void paint(Graphics g) {
        Font titleFont = new Font("Dialog", 1, 15);
        AEvent event = Atlantis.getEventManager().getCurrentEvent();
        int availableSpace = (int)Math.floor(this.getWidth() - 10);
        FontMetrics fm = ACanvas.getCanvas().getFontMetrics(titleFont);
        AGraphics ag = AGraphics.makeAGraphics(g);
        ag.setColor(AWindow.BORDER_BACKGROUND_COLOR);
        ag.fillRect(0, 0, this.getWidth(), this.getHeight());
        ag.setColor(AWindow.BORDER_FOREGROUND_COLOR);
        ag.updateColor();
        ag.setFont(titleFont);
        availableSpace -= fm.stringWidth("ATLAS  HYPATIA");
        ag.drawString("ATLAS ", 5.0, this.getHeight() - 10);
        ag.drawString(" HYPATIA", this.getWidth() - fm.stringWidth(" HYPATIA") - 5, this.getHeight() - 10);
        String[] titleSections = new String[6];
        if (event != null) {
            titleSections[0] = !event.getDateTime().equals("n/a") ? event.getDateTime() : "";
            titleSections[1] = " source:" + event.getSourceName();
            int extension_dot = titleSections[1].toLowerCase().lastIndexOf(".");
            if (extension_dot > 0) {
                titleSections[1] = titleSections[1].substring(0, extension_dot);
            }
            titleSections[2] = " run:" + event.getRunNumber();
            titleSections[3] = " ev:" + event.getEventNumber();
            titleSections[4] = " lumiBlock:" + event.getLumiBlock();
            titleSections[5] = " eventProperties: " + event.getEventProperties();
        } else {
            titleSections[0] = "";
            titleSections[1] = " event:n/a";
            titleSections[2] = " run:n/a";
            titleSections[3] = " ev:n/a";
            titleSections[4] = "";
            titleSections[5] = "";
        }
        if (APar.get("Minerva", "hiderun").getStatus()) {
            titleSections[2] = "";
        }
        if (APar.get("Minerva", "hideev").getStatus()) {
            titleSections[3] = "";
        }
        String outputString = "";
        int titleSectionSize = 0;
        for (int i = 0; i < 6; ++i) {
            if (titleSectionSize + fm.stringWidth(titleSections[i]) >= availableSpace || titleSections[i].endsWith("default")) continue;
            titleSectionSize += fm.stringWidth(titleSections[i]);
            outputString = outputString + titleSections[i];
        }
        ag.drawString(outputString, (this.getWidth() - titleSectionSize) / 2, this.getHeight() - 10);
    }
}

