/*
 * Decompiled with CFR 0.152.
 */
package atlantis.canvas;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.canvas.ALayout;
import atlantis.canvas.AScaleBorder;
import atlantis.canvas.AWindowSwingView;
import atlantis.graphics.ACoord;
import atlantis.gui.ACallBack;
import atlantis.gui.AColorHelpDialog;
import atlantis.gui.ADnDLabel;
import atlantis.gui.AInteractionToolBar;
import atlantis.gui.AObjectTransferable;
import atlantis.gui.APreferencesControl;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AInteractionsManager;
import atlantis.interactions.ASelection;
import atlantis.interactions.AZMRInteraction;
import atlantis.parameters.APar;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionNPhysics;
import atlantis.projection.AProjectionTrackResidual;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.ALogger;
import atlantis.utils.AOutput;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AWindow
extends JPanel
implements DropTargetListener,
DragSourceListener,
DragGestureListener,
ACallBack {
    private static ALogger logger = ALogger.getLogger(AWindow.class);
    public static Color BORDER_BACKGROUND_COLOR = new Color(224, 224, 224);
    public static final Color BORDER_FOREGROUND_COLOR = new Color(48, 48, 48);
    public static final Color BORDER_SELECTED_FOREGROUND_COLOR = new Color(48, 48, 48);
    public static final Color BORDER_SELECTED_FRAME_COLOR = new Color(99, 130, 191);
    public static final Color BORDER_SELECTED_FRAMELIGHT_COLOR = new Color(255, 255, 255);
    public static Color BORDER_SELECTED_BACKGROUND_COLOR = new Color(200, 221, 242);
    public static final Color FILL_BACKGROUND_COLOR = new Color(48, 48, 48);
    private dragActionType dragAction;
    private boolean canCopyScales = false;
    private DragSource dragSource = null;
    private Graphics2D backingGraphics = null;
    private BufferedImage backingImage = null;
    private Dimension backingDimension = new Dimension();
    private AScaleBorder scaleBorder;
    private boolean bufferValid = false;
    private boolean borderValid = false;
    private Insets insets = new Insets(0, 0, 0, 0);
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;
    private double n00;
    private double n01;
    private double n02;
    private double n10;
    private double n11;
    private double n12;
    private AInteractionsManager interactionsManager;
    private Hashtable corners;
    private Point2D.Double[] userCorners;
    private Point2D.Double[] defaultCorners;
    private AProjection projection;
    private String group;
    private String defaultGroup;
    private String defaultProjectionName;
    private int index;
    private NamedNodeMap attributes;
    public boolean finalized;
    private Stack cornersHistory = new Stack();
    private AProjection projectionHistory = null;
    private Stack zoomSummed = new Stack();
    private Stack zoomLayers = new Stack();
    private Stack zoomCalo = new Stack();
    private Stack zoomCaloLAr = new Stack();
    private Stack modeHistory = new Stack();
    private Stack cutHistoryLAr = new Stack();
    private Stack cutHistoryHEC = new Stack();
    private Stack layoutHistory = new Stack();
    private boolean locked;
    private static JPopupMenu popupMenu = new JPopupMenu();
    private static final String LOCK = "Freeze";
    private static final String UNLOCK = "Unfreeze";
    private static final String HORIZONTAL_FLIP = "Horizontal Flip";
    private static final String VERTICAL_FLIP = "Vertical Flip";
    private static final String ROTATE_BY_90_CLOCKWISE = "Rotate by 90";
    private static final String ROTATE_BY_90_ANTICLOCKWISE = "Rotate by -90";
    private static final String TOGGLE_SCALE = "Toggle Scale";
    private static final String RESTORE_DEFAULTS = "Restore Initial Size";
    private JComponent m_view = null;
    private Vector projectionChangeListeners = new Vector();
    private Vector groupChangeListeners = new Vector();

    public AWindow(Node node, int index) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.m_view = new AWindowSwingView(this);
        this.index = index;
        this.attributes = node.getAttributes();
        this.setName(this.attributes.getNamedItem("name").getNodeValue());
        this.scaleBorder = new AScaleBorder(this);
        this.scaleBorder.setLabelFont(new Font("Dialog", 0, 12));
        this.m_view.setBorder(this.scaleBorder);
        this.add((Component)this.m_view, "Center");
        this.setInteractionManager(new AInteractionsManager(this));
        this.finalized = false;
        if (!Atlantis.isAtlantisHeadless()) {
            this.dragSource = new DragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            this.setDropTarget(new DropTarget(this, this));
        }
    }

    public void finalizeConstruction() {
        this.corners = new Hashtable();
        String[] pName = AProjectionsManager.getKnownProjectionNames();
        ALayout l = ACanvas.getCanvas().getCurrentLayout();
        Dimension size = l.getWindowConstraints(this.getName()).getSize();
        for (int i = 0; i < pName.length; ++i) {
            AProjection proj = AProjectionsManager.getProjection(pName[i]);
            if (!(proj instanceof AProjection2D)) continue;
            Point2D.Double[] pCorners = ((AProjection2D)proj).calculateNoZoomCorners(size);
            this.corners.put(pName[i], pCorners);
        }
        this.defaultProjectionName = this.attributes.getNamedItem("projection").getNodeValue();
        AProjection defaultProjection = AProjectionsManager.getProjection(this.defaultProjectionName);
        this.defaultGroup = this.attributes.getNamedItem("group").getNodeValue();
        this.setGroup(this.defaultGroup);
        this.setProjection(defaultProjection);
        if (!this.defaultProjectionName.matches("EventInfo") && !Atlantis.isAtlantisHeadless()) {
            this.interactionsManager.setContext(this.getInteractionToolBar().getSelectedGroup());
        }
        this.finalized = true;
    }

    public void restoreDefaults() {
        if (this.finalized) {
            this.corners = new Hashtable();
            String[] pName = AProjectionsManager.getKnownProjectionNames();
            ALayout l = ACanvas.getCanvas().getCurrentLayout();
            Rectangle r = l.getWindowConstraints(this.getName());
            Dimension size = new Dimension(1, 1);
            if (r != null) {
                size = r.getSize();
            }
            for (int i = 0; i < pName.length; ++i) {
                AProjection proj = AProjectionsManager.getProjection(pName[i]);
                if (!(proj instanceof AProjection2D)) continue;
                Point2D.Double[] pCorners = pName[i].equals(this.defaultProjectionName) && this.defaultCorners != null ? this.getDefaultCorners() : ((AProjection2D)proj).calculateNoZoomCorners(size);
                this.corners.put(pName[i], pCorners);
            }
            AProjection defaultProjection = AProjectionsManager.getProjection(this.defaultProjectionName);
            this.setGroup(this.defaultGroup);
            this.projection = null;
            this.setProjection(defaultProjection);
            this.getInteractionManager().forgetContext();
            AInteractionToolBar itb = this.getInteractionToolBar();
            if (itb != null) {
                itb.setDefaultGroup();
                this.interactionsManager.setContext(itb.getSelectedGroup());
            }
            this.setScaleStatus(true);
        }
    }

    public boolean isCurrent() {
        return ACanvas.getCanvas().getCurrentWindowName().equals(this.getName());
    }

    public static JPopupMenu getPopupMenu() {
        return popupMenu;
    }

    public int getIndex() {
        return this.index;
    }

    public String getGroupName() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
        this.fireGroupChange();
    }

    public synchronized AProjection getProjection() {
        return this.projection;
    }

    public AInteractionToolBar getInteractionToolBar() {
        return AProjectionsManager.getInteractionToolBar(this.getName(), this.projection.getName());
    }

    public synchronized void setProjection(AProjection newProjection) {
        if (this.projection == null || !newProjection.equals(this.projection) || newProjection instanceof AProjectionTrackResidual || newProjection instanceof AProjectionNPhysics) {
            if (this.projection != null && this.projection instanceof AProjection2D) {
                this.corners.put(this.projection.getName(), this.userCorners);
            }
            this.projection = newProjection;
            if (this.projection instanceof AProjection2D) {
                this.userCorners = (Point2D.Double[])this.corners.get(this.projection.getName());
            }
            this.scaleBorder.hideScale();
            this.repaintFromScratch();
            this.fireProjectionChange();
        }
    }

    private Point2D.Double[] clonedCopy(Point2D.Double[] corners) {
        if (corners == null) {
            return null;
        }
        Point2D.Double[] newCorners = new Point2D.Double[corners.length];
        for (int i = 0; i < corners.length; ++i) {
            newCorners[i] = new Point2D.Double(corners[i].x, corners[i].y);
        }
        return newCorners;
    }

    public synchronized void setUserCorners(Point2D.Double[] corners) {
        if (this.projection != null) {
            Point2D.Double[] validCorners = null;
            try {
                validCorners = ((AProjection2D)this.projection).validateCorners(this.clonedCopy(corners));
            }
            catch (ClassCastException e) {
                logger.error("Not a 2D projection...");
                validCorners = corners;
            }
            if (validCorners != null) {
                this.userCorners = validCorners;
                if (ACanvas.getCanvas().customisedCorner) {
                    this.defaultCorners = validCorners;
                }
                this.repaintFromScratch();
            }
        }
    }

    public boolean getUnzoomPossible() {
        if (this.zoomSummed.size() > 0 && ((Integer)this.zoomSummed.peek()).intValue() == this.cornersHistory.size()) {
            return false;
        }
        if (this.zoomLayers.size() > 0 && ((Integer)this.zoomLayers.peek()).intValue() == this.cornersHistory.size()) {
            return false;
        }
        if (this.zoomCalo.size() > 0 && ((Integer)this.zoomCalo.peek()).intValue() == this.cornersHistory.size()) {
            return false;
        }
        if (this.zoomCaloLAr.size() > 0 && ((Integer)this.zoomCaloLAr.peek()).intValue() == this.cornersHistory.size()) {
            return false;
        }
        return this.projection == this.projectionHistory && this.cornersHistory.size() > 0;
    }

    public boolean getUnzoomFullPossible() {
        return this.projection == this.projectionHistory && this.cornersHistory.size() > 0;
    }

    public boolean getUnzoomAllPossible(String typeOfZoom) {
        if (this.cornersHistory.size() <= 0) {
            return false;
        }
        if ("Zoom LAr".equals(typeOfZoom) || "Zoom Calorimeters".equals(typeOfZoom)) {
            int indexOfZoomCalo = -1;
            if (this.zoomCalo.size() > 0) {
                indexOfZoomCalo = (Integer)this.zoomCalo.peek();
            }
            int indexOfZoomCaloLAr = -1;
            if (this.zoomCaloLAr.size() > 0) {
                indexOfZoomCaloLAr = (Integer)this.zoomCaloLAr.peek();
            }
            if ("Zoom Calorimeters".equals(typeOfZoom) && indexOfZoomCalo > indexOfZoomCaloLAr) {
                return true;
            }
            return typeOfZoom.equals("Zoom LAr") && indexOfZoomCaloLAr > indexOfZoomCalo;
        }
        int indexOfZoomSummed = -1;
        if (this.zoomSummed.size() > 0) {
            indexOfZoomSummed = (Integer)this.zoomSummed.peek();
        }
        int indexOfZoomLayers = -1;
        if (this.zoomLayers.size() > 0) {
            indexOfZoomLayers = (Integer)this.zoomLayers.peek();
        }
        if (typeOfZoom.equals("summed") && indexOfZoomSummed > indexOfZoomLayers) {
            return true;
        }
        return typeOfZoom.equals("layers") && indexOfZoomLayers > indexOfZoomSummed;
    }

    public void unzoom(String typeOfZoom) {
        int i;
        int numberOfWindows = 0;
        if (typeOfZoom.equals("Zoom LAr") || typeOfZoom.equals("summed")) {
            numberOfWindows = 4;
        } else if ("Zoom Calorimeters".equals(typeOfZoom) || typeOfZoom.equals("layers")) {
            numberOfWindows = 8;
        }
        int numberOfUnlayouts = 0;
        for (i = 0; i < numberOfWindows; ++i) {
            String wName = Integer.toString(i + 1);
            AWindow w = ACanvas.getCanvas().getWindow(wName);
            int indexOfZoom = this.findUnzoomIndex(typeOfZoom, w);
            if (indexOfZoom <= 0) continue;
            while (w.cornersHistory.size() >= indexOfZoom) {
                w.unzoom();
            }
            this.setParameters(typeOfZoom, w, wName);
            int count = 0;
            while (w.layoutHistory.size() > 0 && (Integer)w.layoutHistory.peek() >= indexOfZoom) {
                w.layoutHistory.pop();
                ++count;
            }
            if (count <= numberOfUnlayouts) continue;
            numberOfUnlayouts = count;
        }
        for (i = 0; i < numberOfUnlayouts; ++i) {
            ACanvas.getCanvas().unlayout();
        }
    }

    public int findUnzoomIndex(String typeOfZoom, AWindow w) {
        int indexOfZoom;
        block16: {
            block15: {
                indexOfZoom = 0;
                if ("Zoom Calorimeters".equals(typeOfZoom)) {
                    if (w.zoomCalo.size() == 0) {
                        indexOfZoom = 0;
                    } else {
                        indexOfZoom = (Integer)w.zoomCalo.pop();
                        while (w.zoomCaloLAr.size() > 0 && (Integer)w.zoomCaloLAr.peek() > indexOfZoom) {
                            w.zoomCaloLAr.pop();
                            w.modeHistory.pop();
                        }
                    }
                } else if (typeOfZoom.equals("Zoom LAr")) {
                    if (w.zoomCaloLAr.size() == 0) {
                        indexOfZoom = 0;
                    } else {
                        indexOfZoom = (Integer)w.zoomCaloLAr.pop();
                        while (w.zoomCalo.size() > 0 && (Integer)w.zoomCalo.peek() > indexOfZoom) {
                            w.zoomCalo.pop();
                            w.modeHistory.pop();
                        }
                    }
                }
                if (!typeOfZoom.equals("summed")) break block15;
                if (w.zoomSummed.size() == 0) {
                    indexOfZoom = 0;
                } else {
                    indexOfZoom = (Integer)w.zoomSummed.pop();
                    while (w.zoomLayers.size() > 0 && (Integer)w.zoomLayers.peek() > indexOfZoom) {
                        w.zoomLayers.pop();
                        w.modeHistory.pop();
                        w.cutHistoryHEC.pop();
                        w.cutHistoryLAr.pop();
                    }
                }
                break block16;
            }
            if (!typeOfZoom.equals("layers")) break block16;
            if (w.zoomLayers.size() == 0) {
                indexOfZoom = 0;
            } else {
                indexOfZoom = (Integer)w.zoomLayers.pop();
                while (w.zoomSummed.size() > 0 && (Integer)w.zoomSummed.peek() > indexOfZoom) {
                    w.zoomSummed.pop();
                    w.modeHistory.pop();
                    w.cutHistoryHEC.pop();
                    w.cutHistoryLAr.pop();
                }
            }
        }
        return indexOfZoom;
    }

    public void setParameters(String typeOfZoom, AWindow w, String wName) {
        APar.selectWindowParameters(wName);
        if ("Zoom LAr".equals(typeOfZoom) || "Zoom Calorimeters".equals(typeOfZoom)) {
            APar.get("VP", "Mode").setI((Integer)w.modeHistory.pop());
        } else {
            APar.get("YX", "Mode").setI((Integer)w.modeHistory.pop());
            APar.get("CutsCalo", "HEC").setI((Integer)w.cutHistoryHEC.pop());
            APar.get("CutsCalo", "LAr").setI((Integer)w.cutHistoryLAr.pop());
        }
        APar.restoreWindowParameters();
    }

    public void saveParameters(String typeOfZoom) {
        if (typeOfZoom.equals("summed") || typeOfZoom.equals("layers")) {
            APar.selectWindowParameters(this.getName());
            this.modeHistory.push(new Integer(APar.get("YX", "Mode").getI()));
            this.cutHistoryHEC.push(new Integer(APar.get("CutsCalo", "HEC").getI()));
            this.cutHistoryLAr.push(new Integer(APar.get("CutsCalo", "LAr").getI()));
            APar.restoreWindowParameters();
        } else if ("Zoom Calorimeters".equals(typeOfZoom) || "Zoom LAr".equals(typeOfZoom)) {
            APar.selectWindowParameters(this.getName());
            this.modeHistory.push(new Integer(APar.get("VP", "Mode").getI()));
            APar.restoreWindowParameters();
        }
    }

    public void unzoomFull() {
        this.setUserCorners(((AProjection2D)this.getProjection()).calculateNoZoomCorners(this.getSize()));
        this.cornersHistory.clear();
        this.zoomSummed.clear();
        this.zoomLayers.clear();
        this.zoomCaloLAr.clear();
        this.zoomCalo.clear();
        this.layoutHistory.clear();
        this.modeHistory.clear();
        this.cutHistoryHEC.clear();
        this.cutHistoryLAr.clear();
    }

    public void unzoom() {
        if (this.projection == this.projectionHistory && this.cornersHistory.size() > 0) {
            this.setUserCorners((Point2D.Double[])this.cornersHistory.pop());
        }
    }

    public void saveLayout() {
        if (this.userCorners != null) {
            ACanvas.getCanvas().saveLayout();
        }
    }

    public void saveCorners() {
        if (this.projection != this.projectionHistory) {
            this.cornersHistory.clear();
            String wName = this.getName();
            if (wName.equals("1") || wName.equals("2") || wName.equals("3") || wName.equals("4") || wName.equals("5") || wName.equals("6") || wName.equals("7") || wName.equals("8")) {
                int temp;
                this.zoomSummed.clear();
                this.zoomLayers.clear();
                this.zoomCaloLAr.clear();
                this.zoomCalo.clear();
                this.layoutHistory.clear();
                if (this.modeHistory.size() > 0) {
                    temp = (Integer)this.modeHistory.pop();
                    this.modeHistory.clear();
                    this.modeHistory.push(new Integer(temp));
                }
                if (this.cutHistoryHEC.size() > 0) {
                    temp = (Integer)this.cutHistoryHEC.pop();
                    this.cutHistoryHEC.clear();
                    this.cutHistoryHEC.push(new Integer(temp));
                }
                if (this.cutHistoryLAr.size() > 0) {
                    temp = (Integer)this.cutHistoryLAr.pop();
                    this.cutHistoryLAr.clear();
                    this.cutHistoryLAr.push(new Integer(temp));
                }
            }
        }
        this.projectionHistory = this.projection;
        if (this.userCorners != null) {
            this.cornersHistory.push(this.clonedCopy(this.userCorners));
        }
    }

    public void saveCorners(String typeOfZoom) {
        this.saveCorners();
        if (this.userCorners != null) {
            if (typeOfZoom.equals("summed")) {
                this.zoomSummed.push(new Integer(this.cornersHistory.size()));
            } else if (typeOfZoom.equals("layers")) {
                this.zoomLayers.push(new Integer(this.cornersHistory.size()));
            } else if ("Zoom Calorimeters".equals(typeOfZoom)) {
                this.zoomCalo.push(new Integer(this.cornersHistory.size()));
            } else if ("Zoom LAr".equals(typeOfZoom)) {
                this.zoomCaloLAr.push(new Integer(this.cornersHistory.size()));
            }
            this.layoutHistory.push(new Integer(this.cornersHistory.size()));
        }
    }

    public void setUserCornersNoRepaint(Point2D.Double[] corners) {
        Point2D.Double[] validCorners = ((AProjection2D)this.projection).validateCorners(this.clonedCopy(corners));
        if (validCorners != null) {
            this.userCorners = validCorners;
        }
    }

    public void setUserCorners(double x0, double x1, double y0, double y1) {
        Point2D.Double[] corners = new Point2D.Double[]{new Point2D.Double(x0, y1), new Point2D.Double(x1, y1), new Point2D.Double(x1, y0)};
        if (this.projection instanceof AProjection2D) {
            corners = ((AProjection2D)this.projection).validateCorners(corners);
        }
        if (corners != null) {
            this.userCorners = corners;
        }
    }

    public Point2D.Double[] getDefaultCorners() {
        return this.clonedCopy(this.defaultCorners);
    }

    public Point2D.Double[] getUserCorners() {
        return this.clonedCopy(this.userCorners);
    }

    public void setInteractionManager(AInteractionsManager interactionsManager) {
        this.interactionsManager = interactionsManager;
        ACanvas.getCanvas().addParentWindowFocusListener(interactionsManager);
    }

    public void setScaleStatus(boolean statusWanted) {
        if (this.getScaleStatus() != statusWanted) {
            this.toggleScale();
        }
    }

    public boolean getScaleStatus() {
        return this.scaleBorder.getScaleStatus();
    }

    public void toggleScale() {
        this.scaleBorder.toggleScale();
        this.repaintFromScratch();
    }

    public AInteractionsManager getInteractionManager() {
        return this.interactionsManager;
    }

    public void paintComponent(Graphics g) {
    }

    public void paintWindow(Graphics g, boolean doubleBuffer) {
        int i;
        LinkedList interactions;
        if (!ACanvas.getCanvas().isReallyOnScreen(this)) {
            return;
        }
        if (this.projection instanceof AProjectionTrackResidual) {
            if (((AProjectionTrackResidual)this.projection).getResidual() != null) {
                this.userCorners = ((AProjectionTrackResidual)this.projection).calculateNoZoomCorners();
            } else {
                AOutput.append("\nTrackResidual Projection is not available, using YX instead in window " + this.getName() + ".\n", "WARNING");
                this.projection = AProjectionsManager.getProjection("YX");
                this.userCorners = (Point2D.Double[])this.corners.get(this.projection.getName());
            }
        }
        Graphics paint = g;
        if (doubleBuffer) {
            this.createOffScreenBuffer();
            paint = this.backingGraphics;
        }
        if (paint != null) {
            if (!this.bufferValid) {
                this.setLocked(false);
                this.paintWindowFromScratch(paint);
                interactions = this.interactionsManager.getInteractions();
                for (i = 0; i < interactions.size(); ++i) {
                    if (!(interactions.get(i) instanceof ASelection)) continue;
                    ((ASelection)interactions.get(i)).invalidate();
                }
                this.bufferValid = true;
            }
            if (!this.isLocked() && !this.borderValid) {
                this.borderValid = true;
            }
        }
        if (g != paint) {
            this.imageComponent(g);
        }
        interactions = this.interactionsManager.getInteractions();
        for (i = 0; i < interactions.size(); ++i) {
            ((AInteraction)interactions.get(i)).paint((Graphics2D)g);
        }
    }

    public void printComponent(Graphics g) {
        this.setLocked(false);
        if (!ACanvas.getCanvas().isReallyOnScreen(this)) {
            return;
        }
        ((AScaleBorder)this.getView().getBorder()).forceDraw();
        ((AScaleBorder)this.getView().getBorder()).printBorder(this, g, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.paintWindowFromScratch(g);
        ((AScaleBorder)this.getView().getBorder()).printBorder(this, g, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.borderValid = true;
        LinkedList interactions = this.interactionsManager.getInteractions();
        for (int i = 0; i < interactions.size(); ++i) {
            AInteraction inter = (AInteraction)interactions.get(i);
            if (!inter.isPrintable()) continue;
            inter.paint((Graphics2D)g);
        }
    }

    public void printBorder(Graphics g) {
    }

    public void paintBorder(Graphics g) {
    }

    public void repaintFromScratch() {
        if (this.locked) {
            return;
        }
        this.bufferValid = false;
        this.borderValid = false;
        this.scaleBorder.hideScale();
        this.repaint();
        this.m_view.repaint();
    }

    public ACoord calculateUser(ACoord user) {
        if (this.validTransform()) {
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] h = user.hv[0][j];
                double[] v = user.hv[1][j];
                for (int i = 0; i < h.length; ++i) {
                    double hTemp = h[i];
                    double vTemp = v[i];
                    h[i] = this.m00 * hTemp + this.m01 * vTemp + this.m02;
                    v[i] = this.m10 * hTemp + this.m11 * vTemp + this.m12;
                }
            }
        } else {
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] h = user.hv[0][j];
                double[] v = user.hv[1][j];
                for (int i = 0; i < h.length; ++i) {
                    h[i] = 0.0;
                    v[i] = 0.0;
                }
            }
        }
        return user;
    }

    public Point2D.Double calculateUser(double x, double y) {
        double[][][] hv = new double[2][1][1];
        hv[0][0][0] = x;
        hv[1][0][0] = y;
        ACoord p = this.calculateUser(new ACoord(hv));
        return new Point2D.Double(p.hv[0][0][0], p.hv[1][0][0]);
    }

    public Point2D.Double calculateUser(Point2D.Double p) {
        return this.calculateUser(p.x, p.y);
    }

    public Point2D.Double calculateUser(Point p) {
        return this.calculateUser(p.x, p.y);
    }

    public ACoord calculateDisplay(ACoord user) {
        if (user == null) {
            return null;
        }
        if (this.validTransform()) {
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] h = user.hv[0][j];
                double[] v = user.hv[1][j];
                for (int i = 0; i < h.length; ++i) {
                    double hTemp = h[i];
                    double vTemp = v[i];
                    h[i] = this.n00 * hTemp + this.n01 * vTemp + this.n02;
                    v[i] = this.n10 * hTemp + this.n11 * vTemp + this.n12;
                }
            }
        } else {
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] h = user.hv[0][j];
                double[] v = user.hv[1][j];
                for (int i = 0; i < h.length; ++i) {
                    h[i] = 0.0;
                    v[i] = 0.0;
                }
            }
        }
        return user;
    }

    public Point2D.Double calculateDisplay(double x, double y) {
        double[][][] hv = new double[2][1][1];
        hv[0][0][0] = x;
        hv[1][0][0] = y;
        ACoord p = this.calculateDisplay(new ACoord(hv));
        return new Point2D.Double(p.hv[0][0][0], p.hv[1][0][0]);
    }

    public Point2D.Double calculateDisplay(Point2D.Double p) {
        return this.calculateDisplay(p.x, p.y);
    }

    public void select() {
        this.scaleBorder.setSelected();
        this.borderValid = false;
        this.repaint();
    }

    public void deselect() {
        this.scaleBorder.setDeselected();
        this.borderValid = false;
        this.repaint();
    }

    private void imageComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (g2d != null) {
            Rectangle clipRect = g2d.getClipBounds();
            if (!(clipRect == null || System.getProperty("os.name").equals("Mac OS X") && System.getProperty("os.version").startsWith("10.4."))) {
                int x = clipRect.x;
                int y = clipRect.y;
                int w = clipRect.width;
                int h = clipRect.height;
                BufferedImage subImage = this.backingImage.getSubimage(x, y, w, h);
                g2d.drawImage((Image)subImage, x, y, this);
            } else {
                g2d.drawImage((Image)this.backingImage, 0, 0, this);
            }
        }
    }

    public Rectangle getCurrDisp() {
        int width = this.m_view.getWidth();
        int height = this.m_view.getHeight();
        this.insets = this.m_view.getInsets(this.insets);
        int x = this.insets.left;
        int y = this.insets.top;
        int w = width - this.insets.left - this.insets.right;
        int h = height - this.insets.top - this.insets.bottom;
        return new Rectangle(x, y, w, h);
    }

    public void paintWindowFromScratch(Graphics g) {
        ACanvas.getCanvas().setPaintingWindow(this);
        APar.selectWindowParameters(this.getName());
        Rectangle currDisp = this.getCurrDisp();
        int x = (int)Math.rint(currDisp.getX());
        int y = (int)Math.rint(currDisp.getY());
        int width = (int)Math.rint(currDisp.getWidth());
        int height = (int)Math.rint(currDisp.getHeight());
        g.setClip(x, y, width, height);
        Graphics2D g2 = (Graphics2D)g;
        if (APreferencesControl.getAliasMenuItem()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.projection.paint(this, g);
        g.setClip(0, 0, this.m_view.getWidth(), this.m_view.getHeight());
        APar.restoreWindowParameters();
        ACanvas.getCanvas().setPaintingWindow(null);
        if (AColorHelpDialog.getInstance() != null && AColorHelpDialog.getInstance().isVisible()) {
            AColorHelpDialog.getInstance().update();
        }
    }

    private void createOffScreenBuffer() {
        int w = this.m_view.getWidth();
        int h = this.m_view.getHeight();
        Dimension dim = new Dimension(w, h);
        if (w > 0 && h > 0) {
            if (!this.backingDimension.equals(dim)) {
                this.backingImage = System.getProperty("os.name").equals("Mac OS X") && System.getProperty("os.version").startsWith("10.4.") ? this.getGraphicsConfiguration().createCompatibleImage(w, h) : (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel().getTransferType() == 1 ? new BufferedImage(w, h, 8) : (System.getProperty("os.name").equals("Mac OS X") ? new BufferedImage(w, h, 3) : new BufferedImage(w, h, 1)));
                this.backingGraphics = this.backingImage.createGraphics();
                this.backingDimension.setSize(dim);
                this.bufferValid = false;
                this.borderValid = false;
            }
        } else {
            this.backingImage = null;
            this.backingGraphics = null;
        }
    }

    public Point2D.Double[] getDisplayCorners() {
        Point2D.Double[] corners = new Point2D.Double[3];
        this.insets = this.m_view.getInsets(this.insets);
        int x = this.insets.left;
        int y = this.insets.top;
        int w = this.m_view.getWidth() - this.insets.left - this.insets.right;
        int h = this.m_view.getHeight() - this.insets.top - this.insets.bottom;
        Point2D.Double upperLeft = new Point2D.Double(x, y);
        Point2D.Double lowerRight = new Point2D.Double(x + w, y + h);
        Point2D.Double upperRight = new Point2D.Double(x + w, y);
        corners[0] = upperLeft;
        corners[1] = upperRight;
        corners[2] = lowerRight;
        return corners;
    }

    private boolean validTransform() {
        double x1 = this.userCorners[0].x;
        double y1 = this.userCorners[0].y;
        double x2 = this.userCorners[1].x;
        double y2 = this.userCorners[1].y;
        double x3 = this.userCorners[2].x;
        double y3 = this.userCorners[2].y;
        Point2D.Double[] displayCorners = this.getDisplayCorners();
        double v1 = displayCorners[0].y;
        double u3 = displayCorners[2].x;
        double u2 = displayCorners[1].x;
        double v2 = displayCorners[1].y;
        double u1 = displayCorners[0].x;
        double v3 = displayCorners[2].y;
        if (v1 * (u3 - u2) + v2 * (u1 - u3) + v3 * (u2 - u1) == 0.0) {
            return false;
        }
        if (u1 - u2 == 0.0) {
            return false;
        }
        this.m01 = (u1 * (x2 - x3) + u2 * (x3 - x1) + u3 * (x1 - x2)) / (v1 * (u3 - u2) + v2 * (u1 - u3) + v3 * (u2 - u1));
        this.m00 = (x1 - x2 - this.m01 * (v1 - v2)) / (u1 - u2);
        this.m02 = x1 - this.m00 * u1 - this.m01 * v1;
        this.m11 = (u1 * (y2 - y3) + u2 * (y3 - y1) + u3 * (y1 - y2)) / (v1 * (u3 - u2) + v2 * (u1 - u3) + v3 * (u2 - u1));
        this.m10 = (y1 - y2 - this.m11 * (v1 - v2)) / (u1 - u2);
        this.m12 = y1 - this.m10 * u1 - this.m11 * v1;
        if (x1 - x2 == 0.0) {
            this.n01 = (u2 - u1) / (y2 - y1);
            this.n11 = (v2 - v1) / (y2 - y1);
            this.n00 = (u3 - u2 - this.n01 * (y3 - y2)) / (x3 - x1);
            this.n10 = (v3 - v2 - this.n11 * (y3 - y2)) / (x3 - x1);
            this.n02 = u1 - this.n00 * x1 - this.n01 * y1;
            this.n12 = v1 - this.n10 * x1 - this.n11 * y1;
            return true;
        }
        if (y1 * (x3 - x2) + y2 * (x1 - x3) + y3 * (x2 - x1) == 0.0) {
            return false;
        }
        this.n01 = (x1 * (u2 - u3) + x2 * (u3 - u1) + x3 * (u1 - u2)) / (y1 * (x3 - x2) + y2 * (x1 - x3) + y3 * (x2 - x1));
        this.n00 = (u1 - u2 - this.n01 * (y1 - y2)) / (x1 - x2);
        this.n02 = u1 - this.n00 * x1 - this.n01 * y1;
        this.n11 = (x1 * (v2 - v3) + x2 * (v3 - v1) + x3 * (v1 - v2)) / (y1 * (x3 - x2) + y2 * (x1 - x3) + y3 * (x2 - x1));
        this.n10 = (v1 - v2 - this.n11 * (y1 - y2)) / (x1 - x2);
        this.n12 = v1 - this.n10 * x1 - this.n11 * y1;
        return true;
    }

    public JToolTip createToolTip() {
        JToolTip tip = new JToolTip();
        tip.setFont(new Font(null, 0, 20));
        return tip;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(2);
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable transferable = dtde.getTransferable();
            DataFlavor javaObjectDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
            if (transferable.isDataFlavorSupported(javaObjectDataFlavor)) {
                dtde.acceptDrop(2);
                Object object = transferable.getTransferData(javaObjectDataFlavor);
                if (object instanceof ACallBack) {
                    ((ACallBack)object).callBack(this);
                } else {
                    ACanvas.getCanvas().copyWindowSettings(((ADnDLabel)object).getText(), this.getName());
                }
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                AOutput.append("Cannot accept drop\n", "BAD_COMMAND");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void addProjectionChangeListener(ChangeListener listener) {
        this.projectionChangeListeners.addElement(listener);
        listener.stateChanged(new ChangeEvent(this));
    }

    private void fireProjectionChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.projectionChangeListeners.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)this.projectionChangeListeners.elementAt(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    public void addGroupChangeListener(ChangeListener listener) {
        this.groupChangeListeners.addElement(listener);
        listener.stateChanged(new ChangeEvent(this));
    }

    private void fireGroupChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.groupChangeListeners.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)this.groupChangeListeners.elementAt(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(ADnDLabel.DROP_INVALID);
    }

    public void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(ADnDLabel.DROP_INVALID);
    }

    public void dragOver(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(ADnDLabel.DROP_VALID);
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        if (!this.canCopyScales) {
            return;
        }
        Point p = dge.getDragOrigin();
        Insets i = this.m_view.getInsets();
        int w = this.m_view.getWidth();
        int h = this.m_view.getHeight();
        Rectangle vScale = new Rectangle(0, 0, i.left, h - i.bottom);
        Rectangle hScale = new Rectangle(i.left, h - i.bottom, w - i.left, i.bottom);
        if (vScale.contains(p)) {
            this.dragAction = dragActionType.COPY_VERTICAL_SCALE;
        } else if (hScale.contains(p)) {
            this.dragAction = dragActionType.COPY_HORIZONTAL_SCALE;
        } else {
            return;
        }
        this.dragSource.startDrag(dge, ADnDLabel.DROP_INVALID, new AObjectTransferable(this), this);
    }

    public void setScaleCopyStatus(boolean canCopyScales) {
        this.canCopyScales = canCopyScales;
    }

    public void callBack(Object to) {
        String labelTarget;
        String labelSource;
        AWindow targetWindow;
        if (to instanceof ADnDLabel) {
            targetWindow = ACanvas.getCanvas().getWindow(((ADnDLabel)to).getText());
        } else if (to instanceof AWindow) {
            targetWindow = (AWindow)to;
        } else {
            return;
        }
        if (this.dragAction == dragActionType.COPY_VERTICAL_SCALE) {
            String labelTarget2;
            String labelSource2 = ((AScaleBorder)this.getBorder()).getVerticalAxisLabel();
            if (labelSource2.equals(labelTarget2 = ((AScaleBorder)targetWindow.getBorder()).getVerticalAxisLabel()) && labelSource2.equals("\u03a6")) {
                Point2D.Double[] sourceCorners = this.getUserCorners();
                Point2D.Double[] targetCorners = targetWindow.getUserCorners();
                for (int i = 0; i < sourceCorners.length; ++i) {
                    targetCorners[i].setLocation(targetCorners[i].getX(), sourceCorners[i].getY());
                }
                targetWindow.setUserCorners(targetCorners);
                AOutput.append("Copy \u03a6 Scale from " + this.getName() + " to " + targetWindow.getName() + "\n", "NORMAL");
            }
        } else if (this.dragAction == dragActionType.COPY_HORIZONTAL_SCALE && (labelSource = ((AScaleBorder)this.getBorder()).getHorizontalAxisLabel()).equals(labelTarget = ((AScaleBorder)targetWindow.getBorder()).getHorizontalAxisLabel()) && labelSource.equals("Z")) {
            Point2D.Double[] sourceCorners = this.getUserCorners();
            Point2D.Double[] targetCorners = targetWindow.getUserCorners();
            for (int i = 0; i < sourceCorners.length; ++i) {
                targetCorners[i].setLocation(sourceCorners[i].getX(), targetCorners[i].getY());
            }
            targetWindow.setUserCorners(targetCorners);
            AOutput.append("Copy Z Scale from " + this.getName() + " to " + targetWindow.getName() + "\n", "NORMAL");
        }
    }

    private void setLocked(boolean locked) {
        if (locked == this.locked) {
            return;
        }
        boolean wasLocked = this.locked;
        this.locked = locked;
        ACanvas.getCanvas().fireLockChange();
        if (wasLocked && !locked) {
            this.repaintFromScratch();
        }
        ACanvas.getCanvas().fireLockChange();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public JComponent getView() {
        return this.m_view;
    }

    public void invalidateQuietly() {
        this.bufferValid = false;
        this.borderValid = false;
    }

    static {
        PopupMenuActionListener actionListener = new PopupMenuActionListener();
        popupMenu.add(HORIZONTAL_FLIP).addActionListener(actionListener);
        popupMenu.add(VERTICAL_FLIP).addActionListener(actionListener);
        popupMenu.add(new JSeparator());
        popupMenu.add(ROTATE_BY_90_CLOCKWISE).addActionListener(actionListener);
        popupMenu.add(ROTATE_BY_90_ANTICLOCKWISE).addActionListener(actionListener);
        popupMenu.add(new JSeparator());
        popupMenu.add(TOGGLE_SCALE).addActionListener(actionListener);
        popupMenu.add(RESTORE_DEFAULTS).addActionListener(actionListener);
        popupMenu.add(LOCK).addActionListener(actionListener);
        popupMenu.add(UNLOCK).addActionListener(actionListener);
    }

    static class PopupMenuActionListener
    implements ActionListener {
        PopupMenuActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            AWindow window = ACanvas.getCanvas().getCurrentWindow();
            if (action.equals(AWindow.LOCK)) {
                window.setLocked(true);
            } else if (action.equals(AWindow.UNLOCK)) {
                window.setLocked(false);
            } else if (action.equals(AWindow.TOGGLE_SCALE)) {
                window.toggleScale();
            }
            if (window.getProjection() instanceof AProjection2D) {
                if (action.equals(AWindow.RESTORE_DEFAULTS)) {
                    window.unzoomFull();
                } else if (action.equals(AWindow.HORIZONTAL_FLIP)) {
                    AZMRInteraction.performFlip(AZMRInteraction.getMiddleVerticalLine(window), window);
                } else if (action.equals(AWindow.VERTICAL_FLIP)) {
                    AZMRInteraction.performFlip(AZMRInteraction.getMiddleHorizontalLine(window), window);
                } else if (action.equals(AWindow.ROTATE_BY_90_CLOCKWISE)) {
                    AZMRInteraction.performPlus90Rotation(window);
                } else if (action.equals(AWindow.ROTATE_BY_90_ANTICLOCKWISE)) {
                    AZMRInteraction.performMinus90Rotation(window);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum dragActionType {
        COPY_VERTICAL_SCALE,
        COPY_HORIZONTAL_SCALE;

    }
}

