/*
 * Decompiled with CFR 0.152.
 */
package atlantis.canvas;

import atlantis.canvas.AGLGraphics;
import atlantis.canvas.AWindow;
import atlantis.interactions.AInteractionsManager;
import atlantis.utils.ALogger;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JPanel;

public class AWindowGLView
extends JPanel
implements GLEventListener {
    private static ALogger logger = ALogger.getLogger(AWindowGLView.class);
    private GLCanvas m_panel;
    private long m_start = 0L;
    private int m_count = 0;
    private AWindow m_parent;
    private Graphics m_g = null;
    private static GLContext m_ocontext;
    private static ArrayList<WeakReference> m_all;
    private static int m_maxFSAA;
    private static int m_FSAA;

    public static int getCurrentFSAA() {
        return m_FSAA;
    }

    public static void setCurrentFSAA(int FSAA) {
        logger.info("Changing anti-aliasing to " + FSAA + "x");
        m_FSAA = FSAA;
        for (int i = 0; i < m_all.size(); ++i) {
            AWindowGLView v = (AWindowGLView)m_all.get(i).get();
            if (v == null) continue;
            v.restartDisplay();
        }
    }

    public static int getMaxFSAA() {
        return m_maxFSAA;
    }

    public void restartDisplay() {
        System.out.println("RESTART DISPLAY!");
        this.remove((Component)this.m_panel);
        this.m_panel = null;
        this.startDisplay();
        this.validate();
        this.m_panel.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    private void startDisplay() {
        GLCapabilities cap = new GLCapabilities();
        if (m_FSAA > 0) {
            cap.setSampleBuffers(true);
            cap.setNumSamples(m_FSAA);
            logger.info("Requesting " + m_FSAA + "x");
        }
        cap.setDoubleBuffered(true);
        this.m_panel = m_ocontext != null ? new GLCanvas(cap, null, m_ocontext, null) : new GLCanvas(cap);
        m_ocontext = this.m_panel.getContext();
        this.m_panel.addGLEventListener((GLEventListener)this);
        this.add((Component)this.m_panel, "Center");
    }

    public AWindowGLView(AWindow parent) {
        this.m_parent = parent;
        this.setLayout(null);
        this.startDisplay();
        m_all.add(new WeakReference<AWindowGLView>(this));
    }

    private void checkListeners() {
        AInteractionsManager lt = this.m_parent.getInteractionManager();
        MouseListener[] lr = this.m_panel.getMouseListeners();
        boolean found = false;
        for (int i = 0; i < lr.length; ++i) {
            if (lr[i] != lt) continue;
            found = true;
        }
        if (!found) {
            this.m_panel.addMouseListener((MouseListener)lt);
            this.m_panel.addMouseMotionListener((MouseMotionListener)lt);
        }
    }

    public void init(GLAutoDrawable drawable) {
        System.out.println("INIT CALLED!");
        System.out.println(this.getWidth() + ":" + this.getHeight());
        this.checkListeners();
        GL gl = drawable.getGL();
        logger.debug("INIT GL IS: " + gl.getClass().getName());
        int[] buffer = new int[2];
        gl.glGetIntegerv(36183, buffer, 0);
        m_maxFSAA = buffer[0];
        logger.debug("Graphics card supports max anti-alias of: " + buffer[0] + "x");
        BufferCapabilities bc = this.m_panel.getGraphicsConfiguration().getBufferCapabilities();
        boolean frontacc = bc.getFrontBufferCapabilities().isAccelerated();
        boolean backacc = bc.getBackBufferCapabilities().isAccelerated();
        logger.info("OpenGL Acceleration Status: Front - " + frontacc + " and Back - " + backacc);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glShadeModel(7424);
        gl.glDisable(2929);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
    }

    private static int countContexts() {
        int count = 0;
        for (int i = 0; i < m_all.size(); ++i) {
            if (m_all.get(i).get() == null) continue;
            ++count;
        }
        return count;
    }

    public void display(GLAutoDrawable d) {
        this.m_parent.invalidateQuietly();
        GL gl = d.getGL();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glColor4f(1.0f, 1.0f, 1.0f, 0.5f);
        gl.glClear(16384);
        if (this.m_parent != null) {
            AGLGraphics glg = new AGLGraphics(d);
            this.m_parent.paintWindow(glg, false);
            super.paintBorder(glg);
        }
        gl.glFlush();
        ++this.m_count;
        long tnow = System.currentTimeMillis();
        if (tnow - 1000L > this.m_start) {
            logger.info("OpenGL FPS: " + this.m_count);
            this.m_count = 0;
            this.m_start = tnow;
        }
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL gl = drawable.getGL();
        GLU glu = new GLU();
        if (height <= 0) {
            height = 1;
        }
        float h = (float)width / (float)height;
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho((double)x, (double)(x + width), (double)(y + height), (double)y, -100.0, 100.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.m_count = 0;
        this.m_start = System.currentTimeMillis();
    }

    public void displayChanged(GLAutoDrawable arg0, boolean arg1, boolean arg2) {
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.m_panel.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    public void paintBorder(Graphics g) {
    }

    public void repaint() {
        super.repaint();
        if (this.m_panel != null) {
            this.m_panel.repaint();
        }
    }

    public Component getRealPanel() {
        return this.m_panel;
    }

    static {
        m_all = new ArrayList();
        m_maxFSAA = -1;
        m_FSAA = 0;
    }
}

