/*
 * Decompiled with CFR 0.152.
 */
package atlantis.config;

import atlantis.Atlantis;
import atlantis.config.AConfigNode;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import atlantis.utils.xml.AXMLErrorHandler;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AConfig {
    private static ALogger logger = ALogger.getLogger(AConfig.class);
    static Hashtable keyMap;
    public static String[] CANVAS_ATT;
    public static String[] WINDOW_ATT;
    public static String[] LAYOUT_ATT;
    public static String[] PAR_ATT;
    public static String[] GROUP_ATT;
    static String[] GREEK_LETTER;
    static String[] GREEK_ENTITY;
    private String filename;
    private boolean isCustomised;
    private String dtdSection = null;
    private AConfigNode rootNode;
    private ArrayList nodeList;
    private ArrayList userExclusiveNodeList;

    public AConfig(String configFilename, boolean isCustomised) throws Exception {
        if (keyMap == null) {
            AConfig.createKeyMap();
        }
        this.filename = configFilename;
        this.isCustomised = isCustomised;
        this.parseXML();
    }

    public String getDtdSection() throws Exception {
        if (this.dtdSection == null) {
            this.createDTDSection(this.filename);
        }
        return this.dtdSection;
    }

    public Iterator getIterator() {
        return this.nodeList.iterator();
    }

    void addNode(AConfigNode node) {
        this.nodeList.add(node);
    }

    void addUserExclusiveNode(AConfigNode node) {
        this.userExclusiveNodeList.add(node);
    }

    private static void createKeyMap() {
        keyMap = new Hashtable();
        keyMap.put("Canvas", "startupLayout");
        keyMap.put("UsedWindow", "name");
        keyMap.put("Layout", "name");
        keyMap.put("ENUM", "fn");
        keyMap.put("SENUM", "fn");
        keyMap.put("ICUT", "fn");
        keyMap.put("SICUT", "fn");
        keyMap.put("FCUT", "fn");
        keyMap.put("SFCUT", "fn");
        keyMap.put("INT", "fn");
        keyMap.put("SINT", "fn");
        keyMap.put("FLOAT", "fn");
        keyMap.put("SFLOAT", "fn");
        keyMap.put("LINT", "fn");
        keyMap.put("SLINT", "fn");
        keyMap.put("COLOR", "fn");
        keyMap.put("SCOLOR", "fn");
        keyMap.put("STATUS", "fn");
    }

    private void createDTDSection(String configFilename) throws Exception {
        String dtdStart = "<?xml version=\"1.0\"?>";
        String dtdEnd = "]>";
        this.dtdSection = "";
        try {
            InputStream is = AUtilities.getFileAsStream(configFilename);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            boolean isInsideDTD = false;
            while (true) {
                String currentLine;
                if ((currentLine = br.readLine()) == null) {
                    return;
                }
                if (dtdStart.equals(currentLine.trim())) {
                    isInsideDTD = true;
                    this.dtdSection = this.dtdSection + currentLine + Atlantis.LINE_SEPAR;
                    continue;
                }
                if (dtdEnd.equals(currentLine.trim())) {
                    isInsideDTD = false;
                    this.dtdSection = this.dtdSection + currentLine + Atlantis.LINE_SEPAR;
                    continue;
                }
                if (!isInsideDTD) continue;
                this.dtdSection = this.dtdSection + currentLine + Atlantis.LINE_SEPAR;
            }
        }
        catch (FileNotFoundException e) {
            String m = "File " + configFilename + " not found, fatal.";
            throw new Exception(m);
        }
        catch (IOException e) {
            String m = "I/O exception while reading file " + configFilename;
            throw new Exception(m);
        }
    }

    public void createConfigTree(Element rootElement) {
        this.nodeList = new ArrayList();
        if (this.isCustomised) {
            this.userExclusiveNodeList = new ArrayList();
        }
        this.rootNode = new AConfigNode(null, rootElement, 0, this);
    }

    public void parseXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder parser = factory.newDocumentBuilder();
        parser.setErrorHandler(new AXMLErrorHandler());
        InputStream isConfig = AUtilities.getFileAsStream(this.filename);
        Document xmlConfigDoc = parser.parse(isConfig);
        this.createConfigTree(xmlConfigDoc.getDocumentElement());
    }

    public AConfigNode find(AConfigNode sampleNode) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            AConfigNode testNode = (AConfigNode)this.nodeList.get(i);
            if ("Canvas".equals(sampleNode.getNodeName()) && testNode.getFullNodeName().equals(sampleNode.getFullNodeName())) {
                return testNode;
            }
            if (!testNode.getFullNodeName().equals(sampleNode.getFullNodeName()) || !testNode.getKeyValue().equals(sampleNode.getKeyValue())) continue;
            return testNode;
        }
        return null;
    }

    public AConfigNode find(String name, String attName, String attValue) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            AConfigNode testNode = (AConfigNode)this.nodeList.get(i);
            if (!name.equals(testNode.getNodeName()) || !attValue.equals(testNode.getAttValue(attName))) continue;
            return testNode;
        }
        return null;
    }

    public AConfigNode find(String name, String attName, String attValue, String parName, String parAttName, String parAttValue) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            AConfigNode parNode;
            AConfigNode testNode = (AConfigNode)this.nodeList.get(i);
            if (!name.equals(testNode.getNodeName()) || !attValue.equals(testNode.getAttValue(attName)) || !parName.equals((parNode = testNode.getParent()).getNodeName()) || !parAttValue.equals(parNode.getAttValue(parAttName))) continue;
            return testNode;
        }
        return null;
    }

    public AConfigNode findPar(String attName, String attValue, String parAttValue) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            AConfigNode testNode = (AConfigNode)this.nodeList.get(i);
            if (!attValue.equals(testNode.getAttValue(attName))) continue;
            AConfigNode parNode = testNode.getParent();
            while ("StatusRoot".equals(parNode.getNodeName()) || "StatusGroup".equals(parNode.getNodeName())) {
                parNode = parNode.getParent();
            }
            if (!"Group".equals(parNode.getNodeName()) || !parAttValue.equals(parNode.getAttValue("name"))) continue;
            return testNode;
        }
        return null;
    }

    public boolean validate(AConfigNode node, String attName, String attValue) {
        if ("Canvas".equals(node.getNodeName()) && "startupLayout".equals(attName)) {
            if (this.find("Layout", "name", attValue) == null) {
                return false;
            }
        } else if ("UsedWindow".equals(node.getNodeName()) && "projection".equals(attName)) {
            if (this.find("Group", "name", attValue, "SuperGroup", "name", "Projection") == null) {
                return false;
            }
        } else if ("UsedWindow".equals(node.getNodeName()) && "group".equals(attName)) {
            if (this.find("Group", "name", attValue) == null) {
                return false;
            }
        } else if ("Layout".equals(node.getNodeName())) {
            int numWindows = attValue.length();
            for (int i = 0; i < numWindows; ++i) {
                String windowName = attValue.substring(i, i + 1);
                if (this.find("Window", "name", windowName, "Layout", "name", node.getKeyValue()) != null) continue;
                return false;
            }
        }
        return true;
    }

    public void validateUserExclusiveNode(AConfigNode node) {
        block5: {
            block4: {
                if (!"ParameterDifferences".equals(node.getNodeName())) break block4;
                Iterator it = node.getChildren().iterator();
                while (it.hasNext()) {
                    AConfigNode childNode = (AConfigNode)it.next();
                    String group = childNode.getAttValue("group");
                    String window = childNode.getAttValue("windowName");
                    String parameter = childNode.getAttValue("name");
                    if (this.find("UsedWindow", "name", window) == null) {
                        it.remove();
                        continue;
                    }
                    if (this.find("Group", "name", group) == null) {
                        it.remove();
                        continue;
                    }
                    if (this.findPar("fn", parameter, group) != null) continue;
                    it.remove();
                }
                break block5;
            }
            if (!"WindowCorners".equals(node.getNodeName())) break block5;
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                AConfigNode childNode = (AConfigNode)it.next();
                String window = childNode.getAttValue("windowName");
                if (this.find("UsedWindow", "name", window) != null) continue;
                it.remove();
            }
        }
    }

    static String replaceGreekLetter(String testStr) {
        for (int i = 0; i < GREEK_LETTER.length; ++i) {
            if (testStr.indexOf(GREEK_LETTER[i]) < 0) continue;
            testStr = testStr.replaceAll(GREEK_LETTER[i], GREEK_ENTITY[i]);
        }
        return testStr;
    }

    public String convertToString() throws Exception {
        return this.getDtdSection() + "\n\n" + this.rootNode.toString();
    }

    public String convertToString(AConfig userConfig) throws Exception {
        if (!this.isCustomised && userConfig.isCustomised) {
            StringBuffer str = new StringBuffer("\n");
            for (int i = 0; i < userConfig.userExclusiveNodeList.size(); ++i) {
                AConfigNode userExclusiveNode = (AConfigNode)userConfig.userExclusiveNodeList.get(i);
                this.validateUserExclusiveNode(userExclusiveNode);
                str.append(userExclusiveNode.toString());
                str.append("\n");
            }
            return this.getDtdSection() + "\n\n" + this.rootNode.toString(str.toString());
        }
        return this.toString();
    }

    static {
        CANVAS_ATT = new String[]{"startupLayout", "aspectRatio"};
        WINDOW_ATT = new String[]{"projection", "group"};
        LAYOUT_ATT = new String[]{"startup", "startupWindow"};
        PAR_ATT = new String[]{"va", "st", "dop", "scope", "ul"};
        GROUP_ATT = new String[]{"userLevel"};
        GREEK_LETTER = new String[]{"\u03b7", "\u03c1", "\u03a6", "\u0394", "\u03bb", "\u03c3"};
        GREEK_ENTITY = new String[]{"&eta;", "&rho;", "&phi;", "&delta;", "&lambda;", "&sigma;"};
    }
}

