/*
 * Decompiled with CFR 0.152.
 */
package atlantis.config;

import atlantis.config.AConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AConfigNode {
    private String nodeName;
    private String fullNodeName;
    private String keyValue = null;
    private int layer;
    private Attributes attributes = null;
    private ArrayList children = null;
    private AConfigNode parent = null;

    AConfigNode(AConfigNode parent, Node elementNode, int layer, AConfig configObject) {
        String keyAttr;
        configObject.addNode(this);
        this.layer = layer;
        this.parent = parent;
        String parentName = this.parent != null ? this.parent.getFullNodeName() + "-" : "";
        this.nodeName = elementNode.getNodeName();
        if ("ParameterDifferences".equals(this.nodeName) || "WindowCorners".equals(this.nodeName)) {
            configObject.addUserExclusiveNode(this);
        }
        this.fullNodeName = parentName + this.nodeName;
        if (elementNode.hasAttributes()) {
            NamedNodeMap attMap = elementNode.getAttributes();
            int numAttributes = attMap.getLength();
            this.attributes = new Attributes(numAttributes);
            for (int i = 0; i < numAttributes; ++i) {
                String name = attMap.item(i).getNodeName();
                String value = attMap.item(i).getNodeValue();
                if ("=".equals(value)) {
                    value = "&intEqual;";
                } else if (">".equals(value)) {
                    value = "&gt;";
                } else if ("<".equals(value)) {
                    value = "&lt;";
                } else if ("<,>".equals(value)) {
                    value = "&real;";
                } else if ("<=".equals(value)) {
                    value = "&le;";
                } else if (">=".equals(value)) {
                    value = "&ge;";
                } else if ("=,!=,<,<=,>,>=".equals(value)) {
                    value = "&int;";
                }
                value = AConfig.replaceGreekLetter(value);
                this.attributes.putValue(name, value);
            }
        }
        if ((keyAttr = (String)AConfig.keyMap.get(this.nodeName)) != null) {
            String groupName = this.parent.getAttValue("name");
            this.keyValue = (groupName == null ? "" : groupName + "-") + this.attributes.getValue(keyAttr);
        }
        if (elementNode.hasChildNodes()) {
            NodeList childList = elementNode.getChildNodes();
            int numChildren = childList.getLength() / 2;
            this.children = new ArrayList(numChildren);
            int idx = 0;
            for (int i = 0; i < childList.getLength(); ++i) {
                Node childNode = childList.item(i);
                if (childNode.getNodeType() != 1) continue;
                this.children.add(idx++, new AConfigNode(this, childNode, this.layer + 1, configObject));
            }
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getFullNodeName() {
        return this.fullNodeName;
    }

    public AConfigNode getParent() {
        return this.parent;
    }

    public List getChildren() {
        return this.children;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public String getAttValue(String name) {
        if (this.attributes != null) {
            return this.attributes.getValue(name);
        }
        return null;
    }

    public String setAttValue(String name, String value) {
        return this.attributes.putValue(name, value);
    }

    private String selfStartString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.layer; ++i) {
            str.append("\t");
        }
        str.append("<");
        str.append(this.nodeName);
        if (this.attributes != null) {
            Set<Object> attSet = this.attributes.keySet();
            Iterator<Object> it = attSet.iterator();
            while (it.hasNext()) {
                String attName = it.next().toString();
                String attValue = this.attributes.getValue(attName);
                str.append(" ");
                str.append(attName);
                str.append("=\"");
                str.append(attValue);
                str.append("\"");
            }
        }
        if (this.children == null) {
            str.append("/>");
        }
        return str.toString();
    }

    private String selfEndString() {
        StringBuffer str = new StringBuffer();
        if (this.children == null) {
            return "";
        }
        for (int i = 0; i < this.layer; ++i) {
            str.append("\t");
        }
        str.append("</");
        str.append(this.nodeName);
        str.append(">");
        return str.toString();
    }

    private String childrenString() {
        StringBuffer str = new StringBuffer();
        if (this.children == null) {
            return "";
        }
        str.append(">\n");
        for (int i = 0; i < this.children.size(); ++i) {
            AConfigNode child = (AConfigNode)this.children.get(i);
            str.append(child.toString());
            str.append("\n");
        }
        return str.toString();
    }

    public String toString() {
        return this.selfStartString() + this.childrenString() + this.selfEndString();
    }

    public String toString(String userExclusiveSection) {
        if (this.layer == 0) {
            return this.selfStartString() + this.childrenString() + userExclusiveSection + this.selfEndString();
        }
        return this.toString();
    }
}

