/*
 * Decompiled with CFR 0.152.
 */
package atlantis.config;

import atlantis.config.AConfig;
import atlantis.config.AConfigNode;
import atlantis.utils.AAtlantisException;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;

public final class AConfigUpdater {
    private static ALogger logger = ALogger.getLogger(AConfigUpdater.class);

    public static void createChecksumFile(String fileName, String fileNameChk) throws AAtlantisException {
        try {
            logger.debug("Creating checksum file " + fileNameChk + " of a file " + fileName);
            byte[] chk = AConfigUpdater.calculateChecksum(fileName);
            File fileChk = new File(fileNameChk);
            FileOutputStream os = new FileOutputStream(fileChk);
            ((OutputStream)os).write(chk);
            ((OutputStream)os).close();
        }
        catch (AAtlantisException ae) {
            String m = "Error while creating MD5 checksum file, reason: " + ae.getMessage();
            throw new AAtlantisException(m);
        }
        catch (FileNotFoundException fnfe) {
            String m = "File not found exception: " + fnfe.getMessage();
            throw new AAtlantisException(m);
        }
        catch (IOException ioe) {
            String m = "I/O error while creating file " + fileNameChk;
            throw new AAtlantisException(m);
        }
    }

    private static byte[] calculateChecksum(String fileName) throws AAtlantisException {
        InputStream fis = null;
        logger.debug("Calculating checksum of file: " + fileName);
        fis = AUtilities.getFileAsStream(fileName);
        MessageDigest complete = null;
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = fis.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            fis.close();
        }
        catch (IOException ioe) {
            throw new AAtlantisException("Error while reading data from file " + fileName);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AAtlantisException(nsae.getMessage());
        }
        logger.debug("Checksum calculated.");
        return complete.digest();
    }

    public static boolean compareChecksums(String fileName, String fileNameChk) throws AAtlantisException {
        boolean result = false;
        try {
            byte[] inputFileChecksum = AConfigUpdater.calculateChecksum(fileName);
            byte[] storedChecksum = new byte[inputFileChecksum.length];
            File fileChk = new File(fileNameChk);
            FileInputStream is = new FileInputStream(fileChk);
            ((InputStream)is).read(storedChecksum);
            result = new String(storedChecksum).equals(new String(inputFileChecksum));
            ((InputStream)is).close();
        }
        catch (Exception e) {
            String m = "Error while checking MD5 checksum file, reason: " + e.getMessage();
            throw new AAtlantisException(m);
        }
        return result;
    }

    private static void updateConfiguration(AConfig distConfig, AConfig userConfig) {
        logger.debug("Updating customised configuration ...");
        Iterator distIt = distConfig.getIterator();
        while (distIt.hasNext()) {
            AConfigNode matchUserNode;
            AConfigNode testDistNode = (AConfigNode)distIt.next();
            if (testDistNode.getKeyValue() == null || (matchUserNode = userConfig.find(testDistNode)) == null) continue;
            AConfigUpdater.updateNode(distConfig, testDistNode, matchUserNode);
        }
        logger.debug("Update finished.");
    }

    private static void updateNode(AConfig distConfig, AConfigNode distNode, AConfigNode userNode) {
        String userValue;
        String distValue;
        String att;
        int i;
        String[] attStrArray = null;
        if ("Canvas".equals(distNode.getNodeName())) {
            attStrArray = AConfig.CANVAS_ATT;
        } else if ("UsedWindow".equals(distNode.getNodeName())) {
            attStrArray = AConfig.WINDOW_ATT;
        } else if ("Layout".equals(distNode.getNodeName())) {
            attStrArray = AConfig.LAYOUT_ATT;
        } else {
            if (distNode.getParent().getNodeName().equals("Group")) {
                attStrArray = AConfig.GROUP_ATT;
                for (i = 0; i < attStrArray.length; ++i) {
                    att = attStrArray[i];
                    distValue = distNode.getParent().getAttValue(att);
                    userValue = userNode.getParent().getAttValue(att);
                    if (distValue == null || userValue == null || distValue.equals(userValue) || !distConfig.validate(distNode.getParent(), att, userValue)) continue;
                    distNode.getParent().setAttValue(att, userValue);
                }
            }
            attStrArray = AConfig.PAR_ATT;
        }
        for (i = 0; i < attStrArray.length; ++i) {
            att = attStrArray[i];
            distValue = distNode.getAttValue(att);
            userValue = userNode.getAttValue(att);
            if (distValue == null || userValue == null || distValue.equals(userValue) || !distConfig.validate(distNode, att, userValue)) continue;
            distNode.setAttValue(att, userValue);
        }
    }

    private static void writeUpdatedConfigurationFile(AConfig distConfig, AConfig userConfig, String filename) throws Exception {
        FileOutputStream fo = null;
        fo = new FileOutputStream(filename);
        String updatedConfiguration = distConfig.convertToString(userConfig);
        fo.write(updatedConfiguration.getBytes());
        fo.close();
    }

    public static void updateConfigurationFile(String fileNameDist, String fileNameCustom) throws AAtlantisException {
        logger.info("Updating configuration - master configuration: " + fileNameDist);
        logger.info("Updating configuration - customised (being updated) configuration: " + fileNameCustom);
        AConfig distConfig = null;
        AConfig customConfig = null;
        try {
            distConfig = new AConfig(fileNameDist, false);
        }
        catch (Exception e) {
            String m = "Could not read/parse distribution configuration " + fileNameDist + " reason: " + e.getMessage();
            throw new AAtlantisException(m);
        }
        try {
            customConfig = new AConfig(fileNameCustom, true);
        }
        catch (Exception e) {
            String m = "Could not read/parse customised configuration " + fileNameCustom + " reason: " + e.getMessage();
            throw new AAtlantisException(m);
        }
        try {
            AConfigUpdater.updateConfiguration(distConfig, customConfig);
        }
        catch (Throwable t) {
            String m = "Updating customised configuration failed, reason: " + t.getMessage();
            logger.debug(m, t);
            throw new AAtlantisException(m);
        }
        logger.info("Creating backup of the customised configuration file ...");
        String fileNameUserBackup = fileNameCustom + "-backup_on_" + AUtilities.getDateTimeString();
        File fileCustom = new File(fileNameCustom);
        File fileBackup = new File(fileNameUserBackup);
        boolean renameResult = fileCustom.renameTo(fileBackup);
        if (!renameResult) {
            String m = "Could not backup customised configuration file, updating configuration failed.";
            if (fileNameDist.startsWith("//")) {
                m = m + " Running via webstart, update can't be perfomed in this mode.";
            }
            throw new AAtlantisException(m);
        }
        logger.info(fileNameCustom + " backup created: " + fileNameUserBackup);
        try {
            AConfigUpdater.writeUpdatedConfigurationFile(distConfig, customConfig, fileNameCustom);
        }
        catch (Throwable t) {
            String m = "Saving updated customised configuration into file failed, reason: " + t.getMessage();
            logger.debug(m, t);
            throw new AAtlantisException(m);
        }
        logger.info(fileNameCustom + " configuration was successfully updated.");
    }
}

