/*
 * Decompiled with CFR 0.152.
 */
package atlantis.config;

import atlantis.Atlantis;
import atlantis.utils.ALogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ADefaultValues {
    public static final String CONFIGFILE = Atlantis.USER_HOME_DIR + Atlantis.FILE_SEPAR + ".Atlantis-runtime_values.txt";
    private static Hashtable v = new Hashtable();
    private static ALogger logger = ALogger.getLogger(ADefaultValues.class);

    private ADefaultValues() {
    }

    private static void setDefaultValues() {
        v.put("LastEventFilesSourceDir", Atlantis.getHomeDirectory() + "events" + Atlantis.FILE_SEPAR);
        v.put("LastEventFilesSaveDir", Atlantis.getHomeDirectory());
        v.put("LastCanvasPlotSaveDir", Atlantis.getHomeDirectory());
        v.put("JiveXMLServerName", "");
        v.put("JiveXMLServerPort", "48965");
        v.put("GeometryName", "");
    }

    private static Hashtable readRuntimeConfigFile() {
        Hashtable<String, String> helpTable = null;
        String line = null;
        String[] l = null;
        String patternLine = ".*=.*";
        Pattern pattern = Pattern.compile(patternLine);
        try {
            BufferedReader in = new BufferedReader(new FileReader(CONFIGFILE));
            helpTable = new Hashtable<String, String>();
            logger.info("Atlantis runtime configuration file: " + CONFIGFILE);
            while ((line = in.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.matches()) continue;
                l = line.split("=");
                if (l != null && l.length == 2) {
                    logger.debug("Configuration value: " + l[0] + " : " + l[1] + " read in");
                    l[1] = l[1].replaceAll("\"", "");
                    helpTable.put(l[0].trim(), l[1].trim());
                    continue;
                }
                logger.warn("Line: " + line + " from runtime " + "configuration file: " + CONFIGFILE + " does not match, line is ignored");
            }
            in.close();
            return helpTable;
        }
        catch (FileNotFoundException ex) {
            logger.warn("Runtime configuration file: " + CONFIGFILE + " not found, using default runtime values");
        }
        catch (IOException ex) {
            logger.error("I/O error while reading " + CONFIGFILE + " file, using default runtime values");
        }
        return null;
    }

    public static void readRuntimeValues() {
        ADefaultValues.setDefaultValues();
        Hashtable help = ADefaultValues.readRuntimeConfigFile();
        if (help != null) {
            Enumeration e = v.keys();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (!help.containsKey(s)) continue;
                v.remove(s);
                v.put(s, help.get(s));
            }
        }
    }

    public static void saveRuntimeValues() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(CONFIGFILE));
            Enumeration e = v.keys();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                out.write(s + " = \"" + v.get(s) + "\"\n");
            }
            out.close();
        }
        catch (IOException ex) {
            logger.error("Can't open " + CONFIGFILE + " for writing, runtime " + "configuration values not saved");
        }
    }

    public static String get(String key) {
        if (v.containsKey(key)) {
            return (String)v.get(key);
        }
        logger.warn("Runtime configuration value: " + key + " does not exist", new Exception());
        return null;
    }

    public static void set(String key, String value) {
        if (v.containsKey(key)) {
            v.remove(key);
            v.put(key, value);
        } else {
            logger.warn("Runtime configuration value: " + key + " does not exist", new Exception());
        }
    }
}

