/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.data.AHitData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.projection.AProjection3D;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionXZ;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public abstract class A3DPointData
extends AHitData {
    protected float[] rho;
    protected float[] phi;
    protected float[] z;
    protected float[] x;
    protected float[] y;

    A3DPointData(AHashMap p, AEvent e) {
        super(p, e);
        if (p.get("x") != null) {
            this.x = p.getFloatArray("x");
            this.y = p.getFloatArray("y");
            this.z = p.getFloatArray("z");
            this.rho = new float[this.numData];
            this.phi = new float[this.numData];
            for (int i = 0; i < this.rho.length; ++i) {
                double dx = this.x[i];
                double dy = this.y[i];
                this.rho[i] = (float)Math.sqrt(dx * dx + dy * dy);
                this.phi[i] = (float)Math.atan2(dy, dx);
                if (!((double)this.phi[i] < 0.0)) continue;
                int n = i;
                this.phi[n] = (float)((double)this.phi[n] + Math.PI * 2);
            }
        } else {
            this.rho = p.getFloatArray("rho");
            this.phi = p.getFloatArray("phi");
            this.z = p.getFloatArray("z");
            this.x = new float[this.numData];
            this.y = new float[this.numData];
            this.calculateXY(this.rho, this.phi, this.x, this.y);
        }
    }

    public float[] getRho() {
        return this.rho;
    }

    public float[] getPhi() {
        return this.phi;
    }

    public float[] getX() {
        return this.x;
    }

    public float[] getY() {
        return this.y;
    }

    public float[] getZ() {
        return this.z;
    }

    protected void calculateRhoPhi() {
        this.calculateRhoPhi(this.x, this.y, this.rho, this.phi);
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.x[list];
            v[i] = this.y[list];
            index[i] = list;
        }
        return new ACoord(h, v, index, this);
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        if (phiMid > Math.PI * 2) {
            phiMid -= Math.PI * 2;
        }
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.z[list];
            double phiDiff = Math.abs((double)this.phi[list] - phiMid);
            v[i] = phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469 ? (double)this.rho[list] : (double)(-this.rho[list]);
            index[i] = list;
        }
        return new ACoord(h, v, index, this);
    }

    protected ACoord getXZUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        double phi0 = Math.toRadians(AProjectionXZ.getPhi());
        double cosPhi0 = Math.cos(phi0);
        double sinPhi0 = Math.sin(phi0);
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.z[list];
            v[i] = (double)this.x[list] * cosPhi0 + (double)this.y[list] * sinPhi0;
            index[i] = list;
        }
        return new ACoord(h, v, index, this);
    }

    protected ACoord getYZUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        double phi0 = Math.toRadians(AProjectionXZ.getPhi());
        double cosPhi0 = Math.cos(phi0);
        double sinPhi0 = Math.sin(phi0);
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.z[list];
            v[i] = (double)this.y[list] * cosPhi0 - (double)this.x[list] * sinPhi0;
            index[i] = list;
        }
        return new ACoord(h, v, index, this);
    }

    protected ACoord get3DUser() {
        this.makeDrawList();
        double[][] hvo = AProjection3D.getRotated(this.numDraw, this.listdl, this.x, this.y, this.z);
        double[] h = hvo[0];
        double[] v = hvo[1];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list;
            index[i] = list = this.listdl[i];
        }
        return new ACoord(h, v, index, this);
    }

    public double[][] get3DPoints() {
        this.makeDrawList();
        double[][] xyz = new double[this.numDraw][3];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            xyz[i][0] = this.x[list];
            xyz[i][1] = this.y[list];
            xyz[i][2] = this.z[list];
        }
        return xyz;
    }

    public int[] get3DPointsIndex() {
        this.makeDrawList();
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            index[i] = this.listdl[i];
        }
        return index;
    }

    protected ACoord getFZUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.z[list];
            v[i] = Math.toDegrees(this.phi[list]);
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("FZ");
    }

    protected ACoord getFRUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.rho[list];
            v[i] = Math.toDegrees(this.phi[list]);
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("FR");
    }

    protected ACoord getVPUser() {
        this.makeDrawList();
        int numTotal = 2 * this.numDraw;
        double[] h = new double[numTotal];
        double[] v = new double[numTotal];
        int[] index = new int[numTotal];
        double[] sign = new double[]{-1.0, 1.0};
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double eta = AMath.eta(this.z[list], this.rho[list]);
            double delEta = AProjectionVP.getDeltaEta(this.rho[list], this.z[list]);
            for (int j = 0; j < 2; ++j) {
                h[num] = eta + sign[j] * delEta;
                v[num] = AMath.phi(this.x[list], this.y[list]);
                index[num] = list;
                ++num;
            }
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("VP");
    }
}

