/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.canvas.AWindow;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.event.AObjectsAssociation;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.graphics.AGraphics;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionVP;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;
import java.util.Vector;

public abstract class AAODData
extends AData {
    protected float[] eta;
    protected float[] phi;
    protected float[] pT;

    AAODData(AHashMap p, AEvent e) {
        super(p, e);
        this.eta = p.getFloatArray("eta");
        this.phi = p.getFloatArray("phi");
        this.pT = p.getFloatArray("pt");
        int[] pdgId = p.getUnsureIntArray("pdgId");
        if (pdgId != null) {
            for (int i = 0; i < this.pT.length; ++i) {
                int n = i;
                this.pT[n] = this.pT[n] * (float)(-AMath.getSign(pdgId[i]));
            }
        }
        if (p.get("clusterKey") != null) {
            int[] clusterLinkCount = p.getUnsureIntArray("clusterLinkCount");
            if (clusterLinkCount == null) {
                this.event.getAssociationManager().add(new AObjectsAssociation(this.getName() + this.getStoreGateKey(), "Cluster", p.getStringArray("clusterKey"), p.getIntArray("clusterIndex"), this.event));
            } else {
                this.event.getAssociationManager().add(new AObjectsAssociation(this.getName() + this.getStoreGateKey(), "Cluster", p.getStringArray("clusterKey"), p.getIntArray("clusterIndex"), p.getIntArray("clusterLinkCount"), this.event));
            }
        }
        if (p.get("trackKey") != null) {
            int[] trackLinkCount = p.getUnsureIntArray("trackLinkCount");
            if (trackLinkCount == null) {
                this.event.getAssociationManager().add(new AObjectsAssociation(this.getName() + this.getStoreGateKey(), "Track", p.getStringArray("trackKey"), p.getIntArray("trackIndex"), this.event));
            } else {
                this.event.getAssociationManager().add(new AObjectsAssociation(this.getName() + this.getStoreGateKey(), "Track", p.getStringArray("trackKey"), p.getIntArray("trackIndex"), p.getIntArray("trackLinkCount"), this.event));
            }
        }
    }

    public float getEta(int index) {
        return this.eta[index];
    }

    public float getPhi(int index) {
        return this.phi[index];
    }

    public float getPT(int index) {
        return this.pT[index];
    }

    public float[] getEta() {
        return this.eta;
    }

    public float[] getPhi() {
        return this.phi;
    }

    public float[] getPT() {
        return this.pT;
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == 0) {
            this.colorByConstant();
        } else if (colorFunction == 1) {
            this.colorByIndex();
        }
        return 1;
    }

    public String getNameScreenName() {
        return this.getParameterGroup();
    }

    protected int getDrawOrFill() {
        return 1;
    }

    protected void applyCuts() {
        AData.printCut(this.getParameterGroup(), this.numDraw);
        this.cutIndex();
        this.cutPhi(this.phi);
        this.cutEta(this.eta);
    }

    public String getVPHitInfo() {
        this.makeDrawList();
        if (this.numDraw == 0) {
            return "";
        }
        double sumP = 0.0;
        double sumPt = 0.0;
        for (int i = 0; i < this.numDraw; ++i) {
            sumPt += (double)Math.abs(this.pT[this.listdl[i]]);
            sumP += Math.abs((double)this.pT[this.listdl[i]] / Math.cos(AMath.lambda(this.eta[this.listdl[i]])));
        }
        StringBuffer msg = new StringBuffer("");
        msg.append(this.numDraw);
        msg.append(" ");
        msg.append(this.getFullName());
        msg.append("  sum(PT) = ");
        msg.append(AMath.d2s(sumPt, 1));
        msg.append("  sum(P) = ");
        msg.append(AMath.d2s(sumP, 1));
        return msg.toString();
    }

    public void draw(AWindow window, AGraphics ag, AProjection2D projection) {
        if (projection instanceof AProjectionVP) {
            this.drawVP(window, ag, projection);
        } else {
            super.draw(window, ag, projection);
        }
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        double dphi = Math.toRadians(0.5);
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiPlus = (double)this.phi[list] + dphi;
            double phiMinus = (double)this.phi[list] - dphi;
            double cosPlus = Math.cos(phiPlus);
            double sinPlus = Math.sin(phiPlus);
            double cosMinus = Math.cos(phiMinus);
            double sinMinus = Math.sin(phiMinus);
            double rhoMax = 1450.0;
            double rhoMinus = 1150.0;
            Vector keys = (Vector)this.event.getCollections().get("CompositeParticle");
            if (keys == null || !APar.get("Data", "CompositeParticle").getStatus()) {
                rhoMax = 1800.0;
            } else if (this.PARAMETER_GROUP.equals("CompositeParticle")) {
                rhoMax = 1800.0;
                rhoMinus = 1500.0;
            }
            double maxEnergy = APar.get("Projection", "EnergyMax").getD();
            double rhoPlus = rhoMax;
            if ((double)Math.abs(this.pT[list]) < maxEnergy) {
                rhoPlus = rhoMinus + (rhoMax - rhoMinus) * (double)Math.abs(this.pT[list]) / maxEnergy;
            }
            hv[0][i][0] = rhoMinus * cosPlus;
            hv[1][i][0] = rhoMinus * sinPlus;
            hv[0][i][1] = rhoPlus * cosPlus;
            hv[1][i][1] = rhoPlus * sinPlus;
            hv[0][i][2] = rhoPlus * cosMinus;
            hv[1][i][2] = rhoPlus * sinMinus;
            hv[0][i][3] = rhoMinus * cosMinus;
            hv[1][i][3] = rhoMinus * sinMinus;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 4);
    }

    protected ACoord getFRUser() {
        ACoord coordFR = this.getYXUser().convertYXToFR().includePhiWrapAround("FR");
        return coordFR;
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        double dtheta = Math.toRadians(0.5);
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
            double phiDiff = Math.abs((double)this.phi[list] - phiMid);
            double rSign = phiDiff > 1.5707963267948966 && phiDiff <= 4.71238898038469 ? -1.0 : 1.0;
            double theta = Math.atan(Math.exp(-Math.abs(this.eta[list]))) * 2.0;
            if ((double)this.eta[list] > 0.0 && rSign == -1.0) {
                theta = Math.PI * 2 - theta;
            } else if ((double)this.eta[list] < 0.0 && rSign == -1.0) {
                theta += Math.PI;
            } else if ((double)this.eta[list] < 0.0 && rSign == 1.0) {
                theta = Math.PI - theta;
            }
            double thetaPlus = theta + dtheta;
            double thetaMinus = theta - dtheta;
            double cosPlus = Math.cos(thetaPlus);
            double sinPlus = Math.sin(thetaPlus);
            double cosMinus = Math.cos(thetaMinus);
            double sinMinus = Math.sin(thetaMinus);
            boolean TOP_BOTTOM = false;
            boolean LEFT_RIGHT = true;
            int region = 0;
            if (Math.abs(Math.tan(theta)) < 0.8) {
                region = 1;
            }
            double radiusMinus = 0.0;
            switch (region) {
                case 0: {
                    if (this.PARAMETER_GROUP.equals("CompositeParticle")) {
                        radiusMinus = 1550.0 / Math.abs(Math.sin(theta));
                        break;
                    }
                    radiusMinus = 1350.0 / Math.abs(Math.sin(theta));
                    break;
                }
                case 1: {
                    radiusMinus = this.PARAMETER_GROUP.equals("CompositeParticle") ? 1850.0 / Math.abs(Math.cos(theta)) : 1650.0 / Math.abs(Math.cos(theta));
                }
            }
            double radiusMax = radiusMinus + 150.0;
            Vector keys = (Vector)this.event.getCollections().get("CompositeParticle");
            if (keys == null || !APar.get("Data", "CompositeParticle").getStatus()) {
                radiusMax += 200.0;
            }
            double maxEnergy = APar.get("Projection", "EnergyMax").getD();
            double radiusPlus = radiusMax;
            if ((double)Math.abs(this.pT[list]) < maxEnergy) {
                radiusPlus = radiusMinus + (radiusMax - radiusMinus) * (double)Math.abs(this.pT[list]) / maxEnergy;
            }
            hv[0][i][0] = radiusMinus * cosPlus;
            hv[1][i][0] = radiusMinus * sinPlus;
            hv[0][i][1] = radiusPlus * cosPlus;
            hv[1][i][1] = radiusPlus * sinPlus;
            hv[0][i][2] = radiusPlus * cosMinus;
            hv[1][i][2] = radiusPlus * sinMinus;
            hv[0][i][3] = radiusMinus * cosMinus;
            hv[1][i][3] = radiusMinus * sinMinus;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 4);
    }

    protected ACoord getVPUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.eta[list];
            v[i] = Math.toDegrees(this.phi[list]);
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("VP");
    }

    private void drawVP(AWindow window, AGraphics ag, AProjection2D projection) {
        ACoord centers = window.calculateDisplay(this.getUser(projection));
        int[] drawlist = centers.index;
        double eLimit = 0.025;
        int numPoints = 25;
        if (this.PARAMETER_GROUP.equals("CompositeParticle")) {
            numPoints = 5;
        }
        double[][][] hv = new double[2][drawlist.length][numPoints];
        double[][][] hv_cross1 = new double[2][drawlist.length][2];
        double[][][] hv_cross2 = new double[2][drawlist.length][2];
        int crossLength = 6;
        for (int i = 0; i < drawlist.length; ++i) {
            int j;
            int list = drawlist[i];
            double e = Math.abs(this.pT[list]);
            int d = (int)Math.sqrt(e / eLimit / Math.PI);
            if (d == 0) {
                d = 1;
            }
            for (j = 0; j < numPoints; ++j) {
                hv[0][i][j] = centers.hv[0][0][i] + (double)d * Math.cos(Math.PI * 2 * (double)j / (double)(numPoints - 1));
                hv[1][i][j] = centers.hv[1][0][i] + (double)d * Math.sin(Math.PI * 2 * (double)j / (double)(numPoints - 1));
            }
            for (j = 0; j < 2; ++j) {
                hv_cross1[0][i][j] = centers.hv[0][0][i] + (double)(crossLength / 2) * Math.cos(Math.PI * (double)(1 + 4 * j) / 4.0);
                hv_cross1[1][i][j] = centers.hv[1][0][i] + (double)(crossLength / 2) * Math.sin(Math.PI * (double)(1 + 4 * j) / 4.0);
                hv_cross2[0][i][j] = centers.hv[0][0][i] + (double)(crossLength / 2) * Math.cos(Math.PI * (double)(3 + 4 * j) / 4.0);
                hv_cross2[1][i][j] = centers.hv[1][0][i] + (double)(crossLength / 2) * Math.sin(Math.PI * (double)(3 + 4 * j) / 4.0);
            }
        }
        ag.draw(new ACoord(hv, drawlist, (ADrawable)this, 3));
        ag.draw(new ACoord(hv_cross1, drawlist, (ADrawable)this, 3));
        ag.draw(new ACoord(hv_cross2, drawlist, (ADrawable)this, 3));
    }
}

