/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.AAODData;
import atlantis.event.AEvent;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public class ABJetData
extends AAODData {
    private float[] lhSig;
    private float[] weight;

    ABJetData(AHashMap p, AEvent e) {
        super(p, e);
        this.lhSig = p.getFloatArray("lhSig");
        this.weight = p.getFloatArray("weight");
    }

    public String getParameterGroup() {
        return "BJet";
    }

    public float getweight(int index) {
        return this.weight[index];
    }

    public float getlhSig(int index) {
        return this.lhSig[index];
    }

    protected void applyCuts() {
        super.applyCuts();
        this.cut("CutsObjects", "BJetPt", " |ET|", this.pT);
        this.cut("CutsObjects", "BJetlhSig", " |lhSig|", this.lhSig);
        this.cut("CutsObjects", "BJetweight", " |weight|", this.weight);
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n PT=" + AMath.d2s(this.pT[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Px=" + AMath.d2s((double)this.pT[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Py=" + AMath.d2s((double)this.pT[index] * Math.sin(this.phi[index]), 3) + " GeV " + "\n Pz=" + AMath.d2s((double)this.pT[index] * Math.sinh(this.eta[index]), 3) + " GeV ";
            }
            return output;
        }
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" (id: " + this.id[index] + " index: " + index + ")");
        msg.append("\n PT = ");
        msg.append(AMath.d2s(this.pT[index], 3));
        msg.append(" GeV\n P = ");
        msg.append(AMath.d2s(Math.abs((double)this.pT[index] / Math.cos(AMath.lambda(this.eta[index]))), 3));
        msg.append(" GeV\n ");
        msg.append("\u03b7");
        msg.append(" = ");
        msg.append(AMath.d2s(this.eta[index], 3));
        msg.append("\n ");
        msg.append("\u03a6");
        msg.append(" = ");
        msg.append(AMath.d2s(Math.toDegrees(this.phi[index]), 3));
        msg.append("\u00b0");
        msg.append("  (" + AMath.d2s(this.phi[index], 3) + " rad)");
        msg.append("\n lhSig = ");
        msg.append(this.lhSig[index]);
        msg.append("\n weight = ");
        msg.append(this.weight[index]);
        return msg.toString();
    }
}

