/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.data.AMuonHitData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AIdHelper;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;

public class ACSCDData
extends AMuonHitData {
    private static final double CSC_TILT_ANGLE = Math.toRadians(-11.59);
    float[] charge;
    float[] length;
    int[] gasGap;
    private static ALogger logger = ALogger.getLogger(ACSCDData.class);

    public String getParameterGroup() {
        return "CSC";
    }

    public String getName() {
        return "CSCD";
    }

    public String getNameScreenName() {
        return "CSC Digits";
    }

    ACSCDData(AHashMap p, AEvent e) {
        super(p, e);
        int i;
        if (p.get("length") != null) {
            this.length = p.getFloatArray("length");
        } else {
            this.length = new float[this.numData];
            for (i = 0; i < this.numData; ++i) {
                this.length[i] = 10.0f;
            }
        }
        this.charge = p.getFloatArray("charge");
        this.gasGap = new int[this.numData];
        for (i = 0; i < this.numData; ++i) {
            try {
                this.gasGap[i] = AIdHelper.cscWireLayer(this.id[i]);
                continue;
            }
            catch (AAtlantisException aex) {
                this.gasGap[i] = 0;
            }
        }
    }

    protected int getStation(int index) {
        return 0;
    }

    protected int getSub(int index) {
        try {
            if (AIdHelper.stationEta(this.id[index]) < 0) {
                return 0;
            }
            return 1;
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding TGC identifier", e);
            return 0;
        }
    }

    public int getSector(int index) {
        try {
            String stationName = AIdHelper.stationName(this.id[index]);
            if (stationName.charAt(2) == 'L') {
                return 2 * (AIdHelper.stationPhi(this.id[index]) - 1);
            }
            return 2 * (AIdHelper.stationPhi(this.id[index]) - 1) + 1;
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding CSCD identifier", e);
            return 0;
        }
    }

    protected boolean getMeasuresPhi(int index) {
        try {
            if (AIdHelper.cscMeasuresPhi(this.id[index]) == 1) {
                return true;
            }
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding CSCD identifier", e);
        }
        return false;
    }

    protected void applyCuts() {
        super.applyCuts();
        this.cut("CutsMuon", "Charge", " Charge", this.charge);
        this.cutPhi(this.phi);
        this.cutEta(this.rho, this.z);
    }

    protected int getDrawOrFill() {
        return 1;
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        if (APar.get("YX", "Mode").getI() != 5) {
            return ACoord.NO_DATA;
        }
        AParameter cscGasGap = APar.get("YX", "CSCGasGap");
        if (cscGasGap.getStatus()) {
            this.cutArray(this.gasGap, cscGasGap.getI(), "CSC Gas Gap");
        }
        double[][][] hv = new double[2][this.numDraw][2];
        int[] index = new int[this.numDraw];
        try {
            for (int i = 0; i < this.numDraw; ++i) {
                double rho;
                double phi;
                int j;
                index[i] = j = this.listdl[i];
                if (AIdHelper.cscMeasuresPhi(this.id[j]) == 1) {
                    phi = Math.atan2(this.y[j], this.x[j]);
                    rho = Math.sqrt(this.x[j] * this.x[j] + this.y[j] * this.y[j]);
                    double drho = (double)this.length[j] / 2.0;
                    hv[0][i][0] = (rho - Math.cos(CSC_TILT_ANGLE) * drho) * Math.cos(phi);
                    hv[1][i][0] = (rho - Math.cos(CSC_TILT_ANGLE) * drho) * Math.sin(phi);
                    hv[0][i][1] = (rho + Math.cos(CSC_TILT_ANGLE) * drho) * Math.cos(phi);
                    hv[1][i][1] = (rho + Math.cos(CSC_TILT_ANGLE) * drho) * Math.sin(phi);
                    continue;
                }
                phi = Math.atan2(this.y[j], this.x[j]);
                rho = Math.sqrt((double)(this.x[j] * this.x[j] + this.y[j] * this.y[j]) + (double)(this.length[j] * this.length[j]) / 4.0);
                double dphi = Math.asin((double)this.length[j] / 2.0 / rho);
                hv[0][i][0] = rho * Math.cos(phi - dphi);
                hv[1][i][0] = rho * Math.sin(phi - dphi);
                hv[0][i][1] = rho * Math.cos(phi + dphi);
                hv[1][i][1] = rho * Math.sin(phi + dphi);
            }
            return new ACoord(hv, index, (ADrawable)this);
        }
        catch (AAtlantisException e) {
            AOutput.append("Error decoding CSC identifier: " + e.getMessage(), "BAD_COMMAND");
            return ACoord.NO_DATA;
        }
    }

    protected ACoord getFRUser() {
        return this.getYXUser().convertYXToFR().includePhiWrapAround("FR");
    }

    protected ACoord getXZRZUser(int[] sign) {
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        try {
            for (int i = 0; i < this.numDraw; ++i) {
                int j;
                index[i] = j = this.listdl[i];
                double rho = Math.sqrt(this.x[j] * this.x[j] + this.y[j] * this.y[j]);
                if (AIdHelper.cscMeasuresPhi(this.id[j]) == 1) {
                    double drho = (double)this.length[j] / 2.0;
                    if (this.z[j] < 0.0f) {
                        hv[0][i] = new double[]{(double)this.z[j] - (double)sign[i] * Math.sin(CSC_TILT_ANGLE) * drho, (double)this.z[j] + (double)sign[i] * Math.sin(CSC_TILT_ANGLE) * drho};
                        hv[1][i] = new double[]{(double)sign[i] * (rho + (double)sign[i] * Math.cos(CSC_TILT_ANGLE) * drho), (double)sign[i] * (rho - (double)sign[i] * Math.cos(CSC_TILT_ANGLE) * drho)};
                        continue;
                    }
                    hv[0][i] = new double[]{(double)this.z[j] - Math.sin(CSC_TILT_ANGLE) * drho, (double)this.z[j] + Math.sin(CSC_TILT_ANGLE) * drho};
                    hv[1][i] = new double[]{(double)sign[i] * (rho - Math.cos(CSC_TILT_ANGLE) * drho), (double)sign[i] * (rho + Math.cos(CSC_TILT_ANGLE) * drho)};
                    continue;
                }
                hv[0][i] = new double[]{this.z[j]};
                hv[1][i] = new double[]{(double)sign[i] * rho};
            }
            return new ACoord(hv, index, (ADrawable)this);
        }
        catch (AAtlantisException e) {
            AOutput.append("Error decoding CSC identifier: " + e.getMessage(), "BAD_COMMAND");
            return ACoord.NO_DATA;
        }
    }

    protected ACoord getXZUser() {
        this.makeDrawList();
        this.cutMuonSector(this.sector);
        int[] sign = new int[this.numDraw];
        int sect = (int)Math.round(APar.get("XZ", "Phi").getD() / 22.5);
        for (int i = 0; i < this.numDraw; ++i) {
            sign[i] = this.sector[this.listdl[i]] == sect ? 1 : -1;
        }
        return this.getXZRZUser(sign);
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        int[] sign = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            sign[i] = AMath.getRhoSign(this.x[j], this.y[j]);
        }
        return this.getXZRZUser(sign);
    }

    protected ACoord getFZUser() {
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        try {
            for (int i = 0; i < this.numDraw; ++i) {
                int j;
                index[i] = j = this.listdl[i];
                double rho = Math.sqrt(this.x[j] * this.x[j] + this.y[j] * this.y[j]);
                double phi = Math.toDegrees(Math.atan2(this.y[j], this.x[j]));
                if (AIdHelper.cscMeasuresPhi(this.id[j]) == 1) {
                    double drho = (double)this.length[j] / 2.0;
                    hv[0][i] = new double[]{(double)this.z[j] - Math.sin(CSC_TILT_ANGLE) * drho, (double)this.z[j] + Math.sin(CSC_TILT_ANGLE) * drho};
                    hv[1][i] = new double[]{phi, phi};
                    continue;
                }
                double dphi = Math.toDegrees(Math.atan2((double)this.length[j] / 2.0, rho));
                hv[0][i] = new double[]{this.z[j], this.z[j]};
                hv[1][i] = new double[]{phi - dphi, phi + dphi};
            }
            return new ACoord(hv, index, (ADrawable)this);
        }
        catch (AAtlantisException e) {
            AOutput.append("Error decoding CSCD identifier: " + e.getMessage(), "BAD_COMMAND");
            return ACoord.NO_DATA;
        }
    }

    protected int internalColor() {
        int constantColor = APar.get(this.PARAMETER_GROUP, "Strip").getI();
        for (int i = 0; i < this.numData; ++i) {
            this.color[i] = (byte)constantColor;
        }
        return 0;
    }
}

