/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.data.AMuonHitData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AIdHelper;
import atlantis.utils.ALogger;

public class ACSCData
extends AMuonHitData {
    float[] sigma;
    private static ALogger logger = ALogger.getLogger(ACSCData.class);

    public String getParameterGroup() {
        return "CSC";
    }

    public String getName() {
        return "CSC";
    }

    public String getNameScreenName() {
        return "CSC";
    }

    ACSCData(AHashMap p, AEvent e) {
        super(p, e);
        this.sigma = p.getFloatArray("sigma");
    }

    protected int getStation(int index) {
        return 0;
    }

    protected int getSub(int index) {
        try {
            if (AIdHelper.stationEta(this.id[index]) < 0) {
                return 0;
            }
            return 1;
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding TGC identifier", e);
            return 0;
        }
    }

    public int getSector(int index) {
        try {
            String stationName = AIdHelper.stationName(this.id[index]);
            if (stationName.charAt(2) == 'L') {
                return 2 * (AIdHelper.stationPhi(this.id[index]) - 1);
            }
            return 2 * (AIdHelper.stationPhi(this.id[index]) - 1) + 1;
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding CSC identifier", e);
            return 0;
        }
    }

    protected boolean getMeasuresPhi(int index) {
        try {
            if (AIdHelper.cscMeasuresPhi(this.id[index]) == 1) {
                return true;
            }
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding CSC identifier", e);
        }
        return false;
    }

    protected void applyCuts() {
        super.applyCuts();
        this.cutPhi(this.phi);
        this.cutEta(this.rho, this.z);
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        int mode = APar.get("YX", "Mode").getI();
        if (mode != 5) {
            this.numDraw = 0;
        }
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.x[list];
            v[i] = this.y[list];
            index[i] = list;
        }
        return new ACoord(h, v, index, this);
    }

    protected ACoord getXZRZUser(int[] sign) {
        int numPoints = 2;
        double[][][] hv = new double[2][this.numDraw][numPoints];
        int[] index = new int[this.numDraw];
        double alpha = -11.59;
        double sinAlphaCopy = Math.sin(Math.toRadians(alpha));
        double cosAlphaCopy = Math.cos(Math.toRadians(alpha));
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double rMid = (double)sign[i] * ACSCData.getSectorRho(this.sector[list], this.rho[list], this.phi[list]);
            double zMid = this.z[list];
            double dRho = this.sigma[list];
            double sinAlpha = sinAlphaCopy;
            double cosAlpha = cosAlphaCopy;
            if (zMid > 0.0) {
                cosAlpha *= -1.0;
            }
            if (rMid < 0.0) {
                sinAlpha *= -1.0;
            }
            hv[0][i][0] = zMid - sinAlpha * dRho;
            hv[0][i][1] = zMid + sinAlpha * dRho;
            hv[1][i][0] = rMid + cosAlpha * dRho;
            hv[1][i][1] = rMid - cosAlpha * dRho;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    protected int getDrawOrFill() {
        return 0;
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        int[] sign = new int[this.numDraw];
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        for (int i = 0; i < this.numDraw; ++i) {
            double phiDiff = Math.abs((double)this.phi[this.listdl[i]] - phiMid);
            sign[i] = -1;
            if (!(phiDiff < 1.5707963267948966) && !(phiDiff > 4.71238898038469)) continue;
            sign[i] = 1;
        }
        return this.getXZRZUser(sign);
    }

    protected ACoord getXZUser() {
        this.makeDrawList();
        this.cutMuonSector(this.sector);
        int[] sign = new int[this.numDraw];
        int sect = (int)Math.round(APar.get("XZ", "Phi").getD() / 22.5);
        for (int i = 0; i < this.numDraw; ++i) {
            sign[i] = 1;
            if (this.sector[this.listdl[i]] == sect) continue;
            sign[i] = -1;
        }
        return this.getXZRZUser(sign);
    }
}

