/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.data.AHistogram;
import atlantis.data.AHistogramData;
import atlantis.data.AHitData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.geometry.ABarrelCalorimeterDetector;
import atlantis.geometry.ACalorimeterDetector;
import atlantis.geometry.AEndcapCalorimeterDetector;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawCalorimeterSummedEndcaps;
import atlantis.graphics.ADrawParameters;
import atlantis.graphics.ADrawable;
import atlantis.graphics.ADrawnGraphics2D;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.gui.ALegendWindow;
import atlantis.gui.APreferencesControl;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionYX;
import atlantis.utils.A4Vector;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AIdHelper;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import atlantis.utils.APolygon;
import atlantis.utils.APulseShapePlot;
import java.awt.Color;
import java.util.Vector;

public abstract class ACalorimeterData
extends AHitData
implements AHistogramData {
    private static ALogger logger = ALogger.getLogger(ACalorimeterData.class);
    public static final int ENERGY_MODE_SUM_LIN = 0;
    public static final int ENERGY_MODE_MAX_LIN = 1;
    public static final int ENERGY_MODE_SUM_LOG = 2;
    public static final int ENERGY_MODE_MAX_LOG = 3;
    public static final int ENERGY_MODE_SUM_SQRT = 4;
    public static final int ENERGY_MODE_MAX_SQRT = 5;
    public static final int ENERGY_CALIB_UNKNOWN = -1;
    public static final int ENERGY_CALIB_OVERALL = 0;
    public static final int ENERGY_CALIB_BY_TYPE = 1;
    public static final int ENERGY_CALIB_BY_CALO = 2;
    public static final int COLOR_FUNC_CONSTANT = 0;
    public static final int COLOR_FUNC_SUBDET = 1;
    public static final int COLOR_FUNC_CLUSTER = 2;
    public static final int COLOR_FUNC_SAMPLING = 3;
    public static final int COLOR_FUNC_ENERGY = 4;
    public static final int COLOR_FUNC_JET = 5;
    public static final int COLOR_FUNC_TYPE = 6;
    public static final int COLOR_FUNC_TIME = 7;
    private static final float SCALE_FACTOR_VPLOT = 20.0f;
    public String CALORIMETER_NAME;
    protected double innerR;
    protected double outerR;
    protected double innerZ;
    protected double outerZ;
    protected double outerEta;
    protected double phiGranularity = 0.0;
    protected double etaGranularity = 0.0;
    protected AParameter histoScale;
    protected short MAX_HIT_INDEX = (short)512;
    protected static final double NON_SCALING_FACTOR = 0.85;
    protected float[] phi;
    protected float[] eta;
    protected float[] dphi;
    protected float[] deta;
    protected float[] energy;
    protected float[] et;
    protected float[] etSum;
    protected byte[] side;
    protected short[] etaIndex;
    protected short[] phiIndex;
    protected int[] sampling;
    protected short[] detector;
    private int[][] cellTable;
    protected double minDensityECAL;
    protected double maxDensityECAL;
    protected double minDensityHCAL;
    protected double maxDensityHCAL;
    protected int[] feedThrough = null;
    protected int[] channel = null;
    protected int[] slot = null;

    ACalorimeterData(AHashMap p, AEvent e) {
        super(p, e);
        this.CALORIMETER_NAME = this.getName();
        this.energy = p.getFloatArray("energy");
        this.et = new float[this.numData];
        this.phi = new float[this.numData];
        this.eta = new float[this.numData];
        this.deta = new float[this.numData];
        this.dphi = new float[this.numData];
        this.etSum = new float[this.numData];
        this.side = new byte[this.numData];
        this.etaIndex = new short[this.numData];
        this.phiIndex = new short[this.numData];
        this.sampling = new int[this.numData];
        this.detector = new short[this.numData];
        this.histoScale = APar.get(this.CALORIMETER_NAME, "HistoScale");
        this.feedThrough = p.getUnsureIntArray("feedThrough");
        this.channel = p.getUnsureIntArray("channel");
        this.slot = p.getUnsureIntArray("slot");
    }

    protected int[][] getADCCountsData(AHashMap p) {
        int[] adc;
        int[][] adcCounts = null;
        int[] nArray = adc = p.get("adcCounts") != null ? p.getIntArray("adcCounts") : null;
        if (adc != null) {
            adcCounts = new int[this.numData][0];
            int multiple = adc.length / this.numData;
            int num = 0;
            for (int i = 0; i < this.numData; ++i) {
                adcCounts[i] = new int[multiple];
                for (int j = 0; j < multiple; ++j) {
                    adcCounts[i][j] = adc[num];
                    ++num;
                }
            }
        }
        return adcCounts;
    }

    public void makeHitToGeometryMapping() {
        int numNotFound = 0;
        for (int i = 0; i < this.numData; ++i) {
            this.detector[i] = (short)ACalorimeterDetector.getDetectorIndex(this.id[i]);
            if (this.detector[i] >= 0) {
                this.eta[i] = (float)ACalorimeterDetector.get(this.detector[i]).getEta(this.etaIndex[i], this.side[i]);
                this.deta[i] = (float)ACalorimeterDetector.get(this.detector[i]).getDeltaEta();
                this.phi[i] = (float)ACalorimeterDetector.get(this.detector[i]).getPhi(this.phiIndex[i]);
                this.dphi[i] = (float)ACalorimeterDetector.get(this.detector[i]).getDeltaPhi();
                continue;
            }
            if (this.CALORIMETER_NAME.equals("FCAL")) continue;
            this.eta[i] = 0.0f;
            this.deta[i] = 0.0f;
            this.phi[i] = 0.0f;
            this.dphi[i] = 0.0f;
            ++numNotFound;
        }
        if (numNotFound > 0) {
            System.err.println(numNotFound + "/" + this.numData + " cells in " + this.CALORIMETER_NAME + " not mapped to a geometry object. These will not be drawn.");
        }
        this.cellTable = new int[2 * ACalorimeterDetector.count()][2 * this.MAX_HIT_INDEX];
    }

    public String getCalorimeterName() {
        return this.CALORIMETER_NAME;
    }

    public void plotPulseShapes(int index, boolean withcurve) {
        int[][] adc = this.getADCCounts(index);
        if (adc == null) {
            logger.warn("Pulse shape plot requested but no adc data available");
            return;
        }
        if (!withcurve) {
            APulseShapePlot.plotADCCounts(adc, this.getPulseTitleString(index), null);
        } else {
            double[][] ps = this.getPulseShape(index);
            if (ps == null) {
                logger.warn("No pulse shape information available, just plotting adc instead");
                APulseShapePlot.plotADCCounts(adc, this.getPulseTitleString(index), null);
            } else {
                APulseShapePlot.plotRealPulseShapes(adc, ps, this.getPulseStep(index), this.getPulseSubtitle(index), this.getPulseTitleString(index));
            }
        }
    }

    protected int[][] getADCCounts(int index) {
        return null;
    }

    protected double[][] getPulseShape(int index) {
        return null;
    }

    protected double getPulseStep(int index) {
        return 1.0;
    }

    protected String[] getPulseSubtitle(int index) {
        return null;
    }

    public abstract String getCalorimeterType(int var1);

    public ACalorimeterDetector getDetector(int index) {
        return ACalorimeterDetector.get(this.detector[index]);
    }

    public double getEta(int index) {
        double z;
        double r;
        if (!APar.get("VP", "EtaVertex").getStatus() || this.detector[index] < 0) {
            return this.eta[index];
        }
        if (ACalorimeterDetector.get(this.detector[index]) instanceof ABarrelCalorimeterDetector) {
            r = ACalorimeterDetector.get(this.detector[index]).getR();
            z = r * AMath.tanLambda(this.eta[index]);
        } else {
            z = ACalorimeterDetector.get(this.detector[index]).getZ();
            r = z / AMath.tanLambda(this.eta[index]);
        }
        return AMath.eta(z, r);
    }

    public int getSampling(int index) {
        return this.sampling[index];
    }

    public int getSide(int index) {
        return this.side[index];
    }

    public double getdEta(int index) {
        return this.deta[index];
    }

    public double getdPhi(int index) {
        return this.dphi[index];
    }

    public double getPhi(int index) {
        return this.phi[index];
    }

    public float getET(int index) {
        return this.et[index];
    }

    public float[] getET(int[] index) {
        float[] temp = new float[index.length];
        for (int i = 0; i < index.length; ++i) {
            temp[i] = this.et[index[i]];
        }
        return temp;
    }

    public int[] getSampling(int[] index) {
        int[] temp = new int[index.length];
        for (int i = 0; i < index.length; ++i) {
            temp[i] = this.sampling[index[i]];
        }
        return temp;
    }

    public float getEnergy(int index) {
        return this.energy[index];
    }

    public float[] getEnergy(int[] index) {
        float[] temp = new float[index.length];
        for (int i = 0; i < index.length; ++i) {
            temp[i] = this.energy[index[i]];
        }
        return temp;
    }

    public static double getNonScalingFactor() {
        return 0.85;
    }

    protected double getMinDensity(int index) {
        return this.getMinDensity(this.getCalorimeterType(index));
    }

    protected double getMinDensity(String type) {
        if (type.equals("ECAL")) {
            return this.minDensityECAL;
        }
        if (type.equals("HCAL")) {
            return this.minDensityHCAL;
        }
        if (type.equals("ALL")) {
            if (this.minDensityECAL == 0.0 || this.minDensityHCAL == 0.0) {
                return Math.max(this.minDensityECAL, this.minDensityHCAL);
            }
            return Math.min(this.minDensityECAL, this.minDensityHCAL);
        }
        return 0.0;
    }

    protected double getMaxDensity(int index) {
        return this.getMaxDensity(this.getCalorimeterType(index));
    }

    protected double getMaxDensity(String type) {
        if (type.equals("ECAL")) {
            return this.maxDensityECAL;
        }
        if (type.equals("HCAL")) {
            return this.maxDensityHCAL;
        }
        if (type.equals("ALL")) {
            return Math.max(this.maxDensityECAL, this.maxDensityHCAL);
        }
        return 0.0;
    }

    protected void setMinDensity(String type, double density) {
        if (type.equals("ECAL")) {
            this.minDensityECAL = density;
        } else if (type.equals("HCAL")) {
            this.minDensityHCAL = density;
        } else if (type.equals("ALL")) {
            this.minDensityECAL = density;
            this.minDensityHCAL = density;
        }
    }

    protected void setMaxDensity(String type, double density) {
        if (type.equals("ECAL")) {
            this.maxDensityECAL = density;
        } else if (type.equals("HCAL")) {
            this.maxDensityHCAL = density;
        } else if (type.equals("ALL")) {
            this.maxDensityECAL = density;
            this.maxDensityHCAL = density;
        }
        APar.get(this.CALORIMETER_NAME, "Area/Energy").setD(1.0 / Math.max(this.maxDensityECAL, this.maxDensityHCAL));
    }

    protected ACoord getUserNoTransform(AProjection projection) {
        if (this.CALORIMETER_NAME.equals("FCAL") || this.CALORIMETER_NAME.equals("MBTS")) {
            return super.getUserNoTransform(projection);
        }
        this.makeDrawList();
        this.filterDrawList(projection);
        double[][][] hv = new double[2][this.numDraw][0];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            if (this.detector[j] >= 0) {
                ACoord coord = ACalorimeterDetector.get(this.detector[j]).getCell(projection, this.etaIndex[j], this.phiIndex[j], this.side[j]);
                if (coord.hv[0].length > 0) {
                    hv[0][i] = coord.hv[0][0];
                    hv[1][i] = coord.hv[1][0];
                }
            }
            index[i] = j;
        }
        if (projection instanceof AProjectionVP) {
            return new ACoord(hv, index, (ADrawable)this).includePhiWrapAround("VP");
        }
        if (projection instanceof AProjectionFR) {
            return new ACoord(hv, index, (ADrawable)this).includePhiWrapAround("FR");
        }
        if (projection instanceof AProjectionFZ) {
            return new ACoord(hv, index, (ADrawable)this).includePhiWrapAround("FZ");
        }
        return new ACoord(hv, index, (ADrawable)this);
    }

    public ACoord getVPPoints() {
        this.makeDrawList();
        double[][] hv = new double[2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            hv[0][i] = this.getEta(j);
            hv[1][i] = Math.toDegrees(this.phi[j]);
            index[i] = j;
        }
        return new ACoord(hv, index, (ADrawable)this, 1).includePhiWrapAround("VP");
    }

    protected void filterDrawList(AProjection projection) {
        int j;
        int i;
        if (projection instanceof AProjectionVP) {
            switch (APar.get("VP", "Mode").getI()) {
                case 0: {
                    return;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    if (!this.CALORIMETER_NAME.equals("LAr")) {
                        this.numDraw = 0;
                    }
                    return;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    if (!this.CALORIMETER_NAME.equals("TILE") && !this.CALORIMETER_NAME.equals("HEC")) {
                        this.numDraw = 0;
                    }
                    return;
                }
            }
            this.numDraw = 0;
            return;
        }
        if (projection instanceof AProjectionFZ && APar.get(projection.getName(), "Mode").getI() != 0) {
            this.numDraw = 0;
            return;
        }
        int mode = APar.get("YX", "Mode").getI();
        if (projection instanceof AProjectionYX || projection instanceof AProjectionFR) {
            if (mode != 0 && (mode < 12 || mode > 21)) {
                this.numDraw = 0;
                return;
            }
            if (mode >= 12 && mode <= 21) {
                if (mode >= 16 && mode <= 19 && !this.CALORIMETER_NAME.equals("HEC") || mode < 16 && !this.CALORIMETER_NAME.equals("LAr") || mode == 21 && !this.CALORIMETER_NAME.equals("HEC") || mode == 20 && !this.CALORIMETER_NAME.equals("LAr")) {
                    this.numDraw = 0;
                    return;
                }
            } else if (mode == 22 && !this.CALORIMETER_NAME.equals("MBTS")) {
                this.numDraw = 0;
                return;
            }
        }
        float[][] etTable = new float[2 * ACalorimeterDetector.count()][2 * this.MAX_HIT_INDEX];
        for (i = 0; i < 2 * ACalorimeterDetector.count(); ++i) {
            for (j = 0; j < 2 * this.MAX_HIT_INDEX; ++j) {
                this.cellTable[i][j] = -1;
                etTable[i][j] = 0.0f;
            }
        }
        for (i = 0; i < this.numDraw; ++i) {
            int detIndex = this.getDetectorIndex(this.listdl[i]);
            int hitIndex = this.getHitIndex(this.listdl[i], projection);
            if (detIndex < 0 || hitIndex < 0) continue;
            float[] fArray = etTable[detIndex];
            int n = hitIndex;
            fArray[n] = fArray[n] + this.et[this.listdl[i]];
            if (this.cellTable[detIndex][hitIndex] >= 0 && !(this.et[this.cellTable[detIndex][hitIndex]] < this.et[this.listdl[i]])) continue;
            this.cellTable[detIndex][hitIndex] = this.listdl[i];
        }
        this.numDraw = 0;
        for (i = 0; i < 2 * ACalorimeterDetector.count(); ++i) {
            for (j = 0; j < 2 * this.MAX_HIT_INDEX; ++j) {
                if (this.cellTable[i][j] <= 0) continue;
                this.listdl[this.numDraw] = this.cellTable[i][j];
                this.etSum[this.listdl[this.numDraw]] = etTable[i][j];
                ++this.numDraw;
            }
        }
    }

    protected int getDetectorIndex(int index) {
        if (this.detector[index] >= 0) {
            if (this.side[index] > 0) {
                return ACalorimeterDetector.count() + this.detector[index];
            }
            return this.detector[index];
        }
        return -1;
    }

    protected int getHitIndex(int index, AProjection projection) {
        if (this.detector[index] >= 0) {
            if (projection instanceof AProjectionYX) {
                return this.phiIndex[index];
            }
            if (projection instanceof AProjectionRZ) {
                if (ACalorimeterDetector.get(this.detector[index]).getRSign(this.phiIndex[index]) > 0) {
                    return this.MAX_HIT_INDEX + this.etaIndex[index];
                }
                return this.etaIndex[index];
            }
            if (projection instanceof AProjectionFR) {
                return this.phiIndex[index];
            }
            if (projection instanceof AProjectionFZ) {
                return this.phiIndex[index];
            }
        }
        return -1;
    }

    protected ACoord[] getUserHistograms(AProjection2D projection) {
        return ACoord.NO_HISTOGRAMS;
    }

    public ACoord[] getYXHistograms() {
        AHistogram hist = new AHistogram(0.0, Math.PI * 2, this.phiGranularity, this.histoScale.getD(), this);
        int mode = APar.get("YX", "Mode").getI();
        double newInnerR = this.innerR;
        boolean hasAddedToHistogram = false;
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            if (this.detector[j] < 0 || (mode != 0 || !(ACalorimeterDetector.get(this.detector[j]) instanceof ABarrelCalorimeterDetector)) && (mode == 0 || !(ACalorimeterDetector.get(this.detector[j]) instanceof AEndcapCalorimeterDetector))) continue;
            String name = ACalorimeterDetector.get(this.detector[j]).getName();
            if (!(mode == 0 || mode == 12 && (name.equals("LAr Endcap Presampler") || name.equals("LAr_EC_Presampler")) || name.equals("LAr Outer Endcap") && this.getSampling(j) == mode - 12 || name.equals("LAr Inner Endcap") && this.getSampling(j) == mode - 12 - 1 || name.equals("HEC") && this.getSampling(j) == mode - 16 || mode == 20 && name.indexOf("LAr") >= 0) && (mode != 21 || !name.equals("HEC"))) continue;
            hasAddedToHistogram = true;
            double phiMin = ACalorimeterDetector.get(this.detector[j]).getPhiMin(this.phiIndex[j]);
            double phiMax = ACalorimeterDetector.get(this.detector[j]).getPhiMax(this.phiIndex[j]);
            if (phiMin < -1.0E-9 && phiMax > 1.0E-9) {
                hist.fill(phiMin + Math.PI * 2, Math.PI * 2, (double)this.etSum[j] / 2.0);
                hist.fill(0.0, phiMax, (double)this.etSum[j] / 2.0);
            } else {
                hist.fill(phiMin, phiMax, this.etSum[j]);
            }
            if (mode == 0) continue;
            if (name.equals("HEC")) {
                if (mode != 21) {
                    newInnerR = ACalorimeterDetector.get(this.detector[j]).getRMin();
                    continue;
                }
                if (!(ACalorimeterDetector.get(this.detector[j]).getRMin() < newInnerR)) continue;
                newInnerR = ACalorimeterDetector.get(this.detector[j]).getRMin();
                continue;
            }
            double etaMax = ACalorimeterDetector.get(this.detector[j]).getEtaMax();
            double zMin = ACalorimeterDetector.get(this.detector[j]).getZMin();
            double temp = zMin / Math.sinh(etaMax);
            if (!(temp < newInnerR)) continue;
            newInnerR = temp;
        }
        if (hasAddedToHistogram) {
            return new ACoord[]{hist.getYXUser(newInnerR)};
        }
        return ACoord.NO_HISTOGRAMS;
    }

    public ACoord[] getFRHistograms() {
        AHistogram hist = new AHistogram(0.0, Math.PI * 2, this.phiGranularity, this.histoScale.getD(), this);
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            if (this.detector[j] < 0 || !(ACalorimeterDetector.get(this.detector[j]) instanceof ABarrelCalorimeterDetector)) continue;
            double phiMin = ACalorimeterDetector.get(this.detector[j]).getPhiMin(this.phiIndex[j]);
            double phiMax = ACalorimeterDetector.get(this.detector[j]).getPhiMax(this.phiIndex[j]);
            if (phiMin < -1.0E-9 && phiMax > 1.0E-9) {
                hist.fill(phiMin + Math.PI * 2, Math.PI * 2, (double)this.etSum[j] / 2.0);
                hist.fill(0.0, phiMax, (double)this.etSum[j] / 2.0);
                continue;
            }
            hist.fill(phiMin, phiMax, this.etSum[j]);
        }
        return new ACoord[]{hist.getFRUser(this.innerR).includePhiWrapAround("FR")};
    }

    public ACoord[] getRZHistograms() {
        AHistogram histUp = new AHistogram(-this.outerEta, this.outerEta, this.etaGranularity, this.histoScale.getD(), this);
        AHistogram histDown = new AHistogram(-this.outerEta, this.outerEta, this.etaGranularity, this.histoScale.getD(), this);
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            if (this.detector[j] < 0) continue;
            int sign = ACalorimeterDetector.get(this.detector[j]).getRSign(this.phiIndex[j]);
            double etaMin = ACalorimeterDetector.get(this.detector[j]).getEtaMin(this.etaIndex[j], this.side[j]);
            double etaMax = ACalorimeterDetector.get(this.detector[j]).getEtaMax(this.etaIndex[j], this.side[j]);
            if (sign > 0) {
                histUp.fill(etaMin, etaMax, this.etSum[j]);
                continue;
            }
            histDown.fill(etaMin, etaMax, this.etSum[j]);
        }
        ACoordArray c = new ACoordArray();
        c.add(histUp.getRZUser(this.outerZ, this.outerR, 0));
        c.add(histDown.getRZUser(this.outerZ, this.outerR, 1));
        return c.getArray();
    }

    public ACoord[] getFZHistograms() {
        AHistogram histLeft = new AHistogram(0.0, Math.PI * 2, this.phiGranularity, this.histoScale.getD(), this);
        AHistogram histRight = new AHistogram(0.0, Math.PI * 2, this.phiGranularity, this.histoScale.getD(), this);
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            if (this.detector[j] < 0 || !(ACalorimeterDetector.get(this.detector[j]) instanceof AEndcapCalorimeterDetector)) continue;
            double phiMin = ACalorimeterDetector.get(this.detector[j]).getPhiMin(this.phiIndex[j]);
            double phiMax = ACalorimeterDetector.get(this.detector[j]).getPhiMax(this.phiIndex[j]);
            AHistogram hist = this.side[j] > 0 ? histRight : histLeft;
            if (phiMin < -1.0E-9 && phiMax > 1.0E-9) {
                hist.fill(phiMin + Math.PI * 2, Math.PI * 2, (double)this.etSum[j] / 2.0);
                hist.fill(0.0, phiMax, (double)this.etSum[j] / 2.0);
                continue;
            }
            hist.fill(phiMin, phiMax, this.etSum[j]);
        }
        return new ACoord[]{histLeft.getFZUser(this.innerZ, 1).includePhiWrapAround("FZ"), histRight.getFZUser(this.innerZ, 0).includePhiWrapAround("FZ")};
    }

    public ACoord[] getXZHistograms() {
        return ACoord.NO_HISTOGRAMS;
    }

    public ACoord[] getYZHistograms() {
        return ACoord.NO_HISTOGRAMS;
    }

    public ACoord[] getVPHistograms() {
        return ACoord.NO_HISTOGRAMS;
    }

    protected void setType() {
        int[][] cluster = this.event.getAssociationManager().get(this.getName(), "Cluster");
        for (int i = 0; i < this.numData; ++i) {
            this.type[i] = cluster != null && cluster[i] != null ? (byte)1 : 0;
        }
    }

    protected boolean energyScaling() {
        return APar.get(this.PARAMETER_GROUP, "ColorFunction").getI() != 4;
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        switch (colorFunction) {
            case 0: {
                this.colorByConstant();
                break;
            }
            case 1: {
                this.colorBy(this.sub);
                break;
            }
            case 2: {
                this.colorBy(this.getClusters());
                break;
            }
            case 3: {
                this.colorBy(this.sampling);
                break;
            }
            case 4: {
                this.colorByEnergy();
                break;
            }
            case 5: {
                if (APar.get("Jet", "ColorFunction").getI() != 1) {
                    APar.get("Jet", "ColorFunction").setI(1);
                    String msg = "Coloring Calo by jet so ";
                    msg = msg + "ATLAS->Jet->Color Function changed to color by index";
                    AOutput.append("\n" + msg + "\n", "WARNING");
                }
                this.colorBy(this.getJets());
                break;
            }
            case 6: {
                this.colorByType();
                break;
            }
            case 7: {
                this.colorByTime();
            }
        }
        return colorFunction + 8;
    }

    protected void colorByEnergy() {
        int j;
        int i;
        double min = 0.0;
        double max = 0.0;
        boolean first = true;
        int numColors = 17;
        float[] en = null;
        switch (APar.get(this.CALORIMETER_NAME, "EnergyMode").getI()) {
            case 0: 
            case 2: 
            case 4: {
                en = this.etSum;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                en = this.et;
            }
        }
        for (i = 0; i < this.numDraw; ++i) {
            j = this.listdl[i];
            if (first) {
                min = en[j];
                max = en[j];
                first = false;
            }
            if ((double)en[j] > max) {
                max = en[j];
            }
            if (!((double)en[j] < min)) continue;
            min = en[j];
        }
        for (i = 0; i < this.numDraw; ++i) {
            j = this.listdl[i];
            if (AColorMap.getColorMap() == 6) {
                this.color[j] = 26;
                continue;
            }
            int colorIndex = 0;
            switch (APar.get(this.CALORIMETER_NAME, "EnergyMode").getI()) {
                case 0: 
                case 1: {
                    colorIndex = (int)((double)numColors * ((double)en[j] - min) / (max - min));
                    break;
                }
                case 2: 
                case 3: {
                    colorIndex = (int)((double)numColors * (Math.log(en[j]) - Math.log(min)) / (Math.log(max) - Math.log(min)));
                    break;
                }
                case 4: 
                case 5: {
                    colorIndex = (int)((double)numColors * Math.sqrt(((double)en[j] - min) / (max - min)));
                }
            }
            if (colorIndex >= numColors) {
                colorIndex = (byte)(numColors - 1);
            }
            this.color[j] = (byte)colorIndex;
        }
    }

    protected void colorByType() {
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            String cellType = this.getCalorimeterType(j);
            this.color[j] = (byte)(APar.get("Det", cellType + "Fill").getI() + 12);
        }
    }

    protected double getTime(int hit) {
        return 0.0;
    }

    protected void colorByTime() {
        double min = 0.0;
        double max = 0.0;
        boolean first = true;
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            double t = this.getTime(j);
            if (t == 0.0) continue;
            if (first) {
                min = t;
                max = t;
                first = false;
            }
            if (t > max) {
                max = t;
            }
            if (!(t < min)) continue;
            min = t;
        }
        int numColors = 127;
        double scale = max - min;
        if (scale < 5.0) {
            scale = 5.0;
        }
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            double t = this.getTime(j);
            int colorIndex = (int)((double)numColors * (t - min) / scale);
            if (colorIndex >= numColors) {
                colorIndex = numColors;
            }
            if (colorIndex < 1) {
                colorIndex = 1;
            }
            if (t == 0.0) {
                colorIndex = 0;
            }
            this.color[j] = (byte)colorIndex;
        }
    }

    protected void applyCuts() {
        AData.printCut(this.CALORIMETER_NAME, this.numDraw);
        this.cutIndex();
        this.cut("CutsCalo", "Layer", "Layer", this.sampling);
        this.cutPhi(this.phi, this.dphi);
        this.cutEtaDEta(this.eta, this.deta);
    }

    public void calibrateLocalDensity(int[] index, double[] area) {
        float[] en = null;
        boolean firstECAL = true;
        boolean firstHCAL = true;
        AParameter par = APar.get(this.CALORIMETER_NAME, "Area/Energy");
        if (par.getStatus() && par.getD() > 0.0) {
            this.minDensityECAL = 0.0;
            this.minDensityHCAL = 0.0;
            this.maxDensityECAL = 1.0 / par.getD();
            this.maxDensityHCAL = 1.0 / par.getD();
        } else {
            switch (APar.get(this.CALORIMETER_NAME, "EnergyMode").getI()) {
                case 0: 
                case 2: 
                case 4: {
                    en = this.etSum;
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    en = this.et;
                }
            }
            this.minDensityECAL = 0.0;
            this.maxDensityECAL = 0.0;
            this.minDensityHCAL = 0.0;
            this.maxDensityHCAL = 0.0;
            for (int i = 0; i < index.length; ++i) {
                double density;
                if (!(area[i] > 0.0) || !((density = (double)en[index[i]] / area[i]) > 0.0)) continue;
                if (this.getCalorimeterType(index[i]).equals("ECAL")) {
                    if (firstECAL) {
                        this.minDensityECAL = density;
                        this.maxDensityECAL = density;
                        firstECAL = false;
                    }
                    if (density < this.minDensityECAL) {
                        this.minDensityECAL = density;
                    }
                    if (!(density > this.maxDensityECAL)) continue;
                    this.maxDensityECAL = density;
                    continue;
                }
                if (!this.getCalorimeterType(index[i]).equals("HCAL")) continue;
                if (firstHCAL) {
                    this.minDensityHCAL = density;
                    this.maxDensityHCAL = density;
                    firstHCAL = false;
                }
                if (density < this.minDensityHCAL) {
                    this.minDensityHCAL = density;
                }
                if (!(density > this.maxDensityHCAL)) continue;
                this.maxDensityHCAL = density;
            }
        }
    }

    public double[] getScaleFactors(int[] dl, double[] area) {
        double[] factors = new double[area.length];
        float[] en = null;
        int energyMode = APar.get(this.CALORIMETER_NAME, "EnergyMode").getI();
        switch (energyMode) {
            case 0: 
            case 2: 
            case 4: {
                en = this.etSum;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                en = this.et;
            }
        }
        for (int i = 0; i < area.length; ++i) {
            factors[i] = 1.0;
            if (area[i] == 0.0) continue;
            if (this.energyScaling()) {
                double density = (double)en[dl[i]] / area[i];
                double minDensity = this.getMinDensity(dl[i]);
                double maxDensity = this.getMaxDensity(dl[i]);
                switch (energyMode) {
                    case 0: 
                    case 1: {
                        factors[i] = Math.sqrt(density / maxDensity);
                        break;
                    }
                    case 2: 
                    case 3: {
                        double magnitude = Math.floor(Math.log10(Math.sqrt(maxDensity / minDensity)) + 1.0);
                        factors[i] = (Math.log10(Math.sqrt(density / maxDensity)) + magnitude) / magnitude;
                        break;
                    }
                    case 4: 
                    case 5: {
                        factors[i] = Math.sqrt(Math.sqrt(density / maxDensity));
                        break;
                    }
                    default: {
                        factors[i] = 0.85;
                        break;
                    }
                }
            } else {
                factors[i] = 0.85;
            }
            if (!(factors[i] > 1.0)) continue;
            factors[i] = 1.0;
        }
        return factors;
    }

    protected ACoord scalePolygons(ACoord coord, double[] area) {
        double[] factors = this.getScaleFactors(coord.index, area);
        for (int i = 0; i < area.length; ++i) {
            if (area[i] == 0.0) continue;
            APolygon.scale(coord.hv[0][i], coord.hv[1][i], factors[i]);
        }
        return coord;
    }

    private String getCellString(int index, String idstr) {
        StringBuffer msg = new StringBuffer();
        msg.append(this.CALORIMETER_NAME + " cell");
        msg.append(" (id: " + idstr + " index: " + index + ")");
        return msg.toString();
    }

    private String getHitString(int index) {
        StringBuffer msg = new StringBuffer();
        msg.append("\n E Max = ");
        msg.append(AMath.d2s(this.energy[index], 2));
        msg.append(" GeV\n ET Max = ");
        msg.append(AMath.d2s(this.et[index], 2));
        msg.append(" GeV\n ET Sum = ");
        msg.append(AMath.d2s(this.etSum[index], 2));
        msg.append(" GeV\n ");
        msg.append("\u03b7");
        msg.append(" = ");
        msg.append(AMath.d2s(this.eta[index], 4));
        msg.append(" ");
        msg.append("\u00b1");
        msg.append(" ");
        msg.append(AMath.d2s((double)this.deta[index] / 2.0, 4));
        msg.append("\n ");
        msg.append("\u03a6");
        msg.append(" = ");
        msg.append(AMath.d2s(Math.toDegrees(this.phi[index]), 1));
        msg.append(" \u00b1 ");
        msg.append(AMath.d2s(Math.toDegrees((double)this.dphi[index] / 2.0), 1));
        msg.append("\u00b0");
        msg.append("  (" + AMath.d2s(this.phi[index], 1) + "  ");
        msg.append("\u00b1 " + AMath.d2s((double)this.dphi[index] / 2.0, 1) + " rad)");
        if (this.feedThrough != null && this.slot != null && this.channel != null) {
            String s = "\n feed through/slot/channel = " + this.feedThrough[index] + "/" + this.slot[index] + "/" + this.channel[index];
            msg.append(s);
        }
        return msg.toString();
    }

    protected String getPulseTitleString(int index) {
        String[] decodedId = AIdHelper.getFullIdentifier(this.id[index]);
        String title = null;
        if (this.feedThrough == null || this.slot == null || this.channel == null) {
            logger.warn("Calo FT/slot/channel info not available, using old style title");
            title = decodedId[1] + " cell: " + decodedId[0];
        } else {
            title = decodedId[1] + " cell: " + this.feedThrough[index] + "/" + this.slot[index] + "/" + this.channel[index];
        }
        return title;
    }

    public String getHitInfoNoDecode(int index) {
        String[] decodedId = AIdHelper.getFullIdentifier(this.id[index]);
        return this.getCellString(index, decodedId[0]) + this.getHitString(index);
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n ET=" + AMath.d2s(this.et[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Ex=" + AMath.d2s((double)this.et[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Ey=" + AMath.d2s((double)this.et[index] * Math.sin(this.phi[index]), 3) + " GeV " + "\n Ez=" + AMath.d2s((double)this.et[index] * Math.sinh(this.eta[index]), 3) + " GeV ";
            }
            return output;
        }
        String[] decodedId = AIdHelper.getFullIdentifier(this.id[index]);
        StringBuffer msg = new StringBuffer();
        msg.append(this.getCellString(index, decodedId[0]));
        for (int i = 1; i < decodedId.length; ++i) {
            msg.append("\n " + decodedId[i]);
        }
        msg.append(this.getHitString(index));
        return msg.toString();
    }

    public double getTotalTransverseEnergy() {
        double sumEt = 0.0;
        for (int i = 0; i < this.numData; ++i) {
            sumEt += (double)this.et[i];
        }
        return sumEt;
    }

    public String getVPHitInfo() {
        this.applyCuts();
        if (this.numDraw == 0) {
            return "";
        }
        double sumE = 0.0;
        double sumEt = 0.0;
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            sumEt += (double)this.et[j];
            sumE += (double)this.energy[j];
        }
        String msg = this.numDraw + " " + this.getNameScreenName();
        msg = msg + "  sum(ET) = " + AMath.d2s(sumEt, 1) + "  sum(E) = " + AMath.d2s(sumE, 1);
        return msg;
    }

    public A4Vector get4Vector(int num, int[] list) {
        A4Vector sum = new A4Vector();
        for (int i = 0; i < num; ++i) {
            int j = list[i];
            double lambda = AMath.lambda(this.eta[j]);
            double pt = (double)this.energy[j] * Math.cos(lambda);
            double pz = (double)this.energy[j] * Math.sin(lambda);
            double px = pt * Math.cos(this.phi[j]);
            double py = pt * Math.sin(this.phi[j]);
            sum.add(px, py, pz, 0.0);
        }
        return sum;
    }

    public boolean[] expandDrawn(boolean[] drawn) {
        this.makeDrawList();
        AProjection projection = ACanvas.getCanvas().getCurrentWindow().getProjection();
        for (int i = 0; i < this.numDraw; ++i) {
            int mappedTo;
            int j = this.listdl[i];
            if (drawn[j]) continue;
            int detIndex = this.getDetectorIndex(j);
            int hitIndex = this.getHitIndex(j, projection);
            if (detIndex < 0 || hitIndex < 0 || this.cellTable == null || detIndex >= this.cellTable.length || hitIndex >= this.cellTable[detIndex].length || (mappedTo = this.cellTable[detIndex][hitIndex]) < 0 || !drawn[mappedTo]) continue;
            drawn[j] = true;
        }
        return drawn;
    }

    public static void remakeHitToGeometryMapping() {
        AEvent event = Atlantis.getEventManager().getCurrentEvent();
        if (event != null) {
            ACalorimeterData[] calorimeters = new ACalorimeterData[event.getCalorimeters().size()];
            event.getCalorimeters().toArray(calorimeters);
            for (int i = 0; i < calorimeters.length; ++i) {
                calorimeters[i].makeHitToGeometryMapping();
            }
        }
    }

    public static void drawCalorimeters(AWindow window, AGraphics ag, AProjection2D projection, AEvent event) {
        int j;
        int i;
        int i2;
        int mode = APar.get(projection.getName(), "Mode").getI();
        if (projection instanceof AProjectionYX || projection instanceof AProjectionFR) {
            boolean changeGUI = false;
            if (window.equals(ACanvas.getCanvas().getCurrentWindow())) {
                changeGUI = true;
            }
            AParameter drawFCAL = APar.get("YX", "DrawFCAL");
            if (changeGUI) {
                if (!drawFCAL.isInitialized()) {
                    drawFCAL.initialize();
                }
                if (mode < 17 || mode > 19) {
                    drawFCAL.getNameComponent().setEnabled(false);
                } else {
                    drawFCAL.getNameComponent().setEnabled(true);
                }
            }
            AParameter splitEta = APar.get("YX", "SplitEta");
            AParameter LArBin = APar.get("YX", "LArBin");
            AParameter HECBin = APar.get("YX", "HECBin");
            if (changeGUI) {
                if (!HECBin.isInitialized()) {
                    HECBin.initialize();
                }
                if (!LArBin.isInitialized()) {
                    LArBin.initialize();
                }
                if (!splitEta.isInitialized()) {
                    splitEta.initialize();
                }
            }
            if (mode == 20 || mode == 21) {
                if (changeGUI) {
                    LArBin.getValueComponent().setEnabled(true);
                    HECBin.getValueComponent().setEnabled(true);
                    LArBin.getNameComponent().setEnabled(true);
                    HECBin.getNameComponent().setEnabled(true);
                    if (LArBin.getI() == 3 || HECBin.getI() == 3) {
                        splitEta.getValueComponent().setEnabled(true);
                        splitEta.getNameComponent().setEnabled(true);
                    } else {
                        splitEta.getValueComponent().setEnabled(false);
                        splitEta.getNameComponent().setEnabled(false);
                    }
                }
                ACalorimeterData[] calorimeters = new ACalorimeterData[event.getCalorimeters().size()];
                event.getCalorimeters().toArray(calorimeters);
                for (int i3 = 0; i3 < calorimeters.length; ++i3) {
                    if (mode == 20 && !calorimeters[i3].getName().equals("LAr") || mode == 21 && !calorimeters[i3].getName().equals("HEC")) continue;
                    ADrawCalorimeterSummedEndcaps.drawCalorimeterSummedEndcaps(window, ag, projection, calorimeters[i3], calorimeters[i3].etaIndex, calorimeters[i3].phiIndex, calorimeters[i3].side);
                }
                return;
            }
            if (changeGUI) {
                LArBin.getValueComponent().setEnabled(false);
                HECBin.getValueComponent().setEnabled(false);
                splitEta.getValueComponent().setEnabled(false);
                LArBin.getNameComponent().setEnabled(false);
                HECBin.getNameComponent().setEnabled(false);
                splitEta.getNameComponent().setEnabled(false);
            }
            if (APreferencesControl.getLegMenuItem()) {
                ALegendWindow.getInstance().nothingToDisplay(window);
            }
        } else if (APreferencesControl.getLegMenuItem()) {
            ALegendWindow.getInstance().nothingToDisplay(window);
        }
        if (projection instanceof AProjectionVP && mode == 0) {
            ACalorimeterData.drawCalorimetersVPlot(window, ag, projection, event);
            return;
        }
        ACalorimeterData[] calorimeters = new ACalorimeterData[event.getCalorimeters().size()];
        event.getCalorimeters().toArray(calorimeters);
        ACoord[] data = new ACoord[calorimeters.length];
        double[][] area = new double[calorimeters.length][];
        for (i2 = 0; i2 < calorimeters.length; ++i2) {
            data[i2] = calorimeters[i2].getUserNoTransform(projection);
            area[i2] = new double[data[i2].index.length];
            for (int j2 = 0; j2 < data[i2].index.length; ++j2) {
                area[i2][j2] = APolygon.getArea(data[i2].hv[0][j2], data[i2].hv[1][j2]);
            }
            calorimeters[i2].calibrateLocalDensity(data[i2].index, area[i2]);
        }
        if (window.getProjection() instanceof AProjectionVP) {
            ACalorimeterData.calibrateDensity(calorimeters, 0);
        } else {
            ACalorimeterData.calibrateDensity(calorimeters, -1);
        }
        for (i2 = 0; i2 < calorimeters.length; ++i2) {
            data[i2] = window.calculateDisplay(projection.nonLinearTransform(data[i2]));
            if (!APar.get(calorimeters[i2].getName(), "Cells").getStatus()) continue;
            ACalorimeterData.drawFrames(calorimeters[i2], data[i2], window, ag);
        }
        for (i2 = 0; i2 < calorimeters.length; ++i2) {
            if (!APar.get(calorimeters[i2].getName(), "Cells").getStatus()) continue;
            ACalorimeterData.drawGeometry(calorimeters[i2], data[i2], window, ag);
        }
        String[] histograms = new String[]{"TILE", "HEC", "LAr", "FCAL", "MBTS"};
        for (i = 0; i < calorimeters.length; ++i) {
            for (j = 0; j < histograms.length; ++j) {
                if (!calorimeters[i].getCalorimeterName().equals(histograms[j])) continue;
                ACalorimeterData.drawHistogram(calorimeters[i], window, ag, projection);
            }
        }
        for (i = 0; i < calorimeters.length; ++i) {
            for (j = 0; j < histograms.length; ++j) {
                if (!calorimeters[i].getCalorimeterName().equals(histograms[j])) continue;
                ACalorimeterData.frameHistogram(calorimeters[i], window, ag, projection);
            }
        }
        for (i = 0; i < calorimeters.length; ++i) {
            if (!APar.get(calorimeters[i].getName(), "Cells").getStatus()) continue;
            data[i] = calorimeters[i].scalePolygons(data[i], area[i]);
            ACalorimeterData.drawHits(calorimeters[i], data[i], window, ag);
        }
    }

    private static void drawCalorimetersVPlot(AWindow window, AGraphics ag, AProjection2D projection, AEvent event) {
        int i;
        ACalorimeterData[] calorimeters = new ACalorimeterData[event.getCalorimeters().size()];
        event.getCalorimeters().toArray(calorimeters);
        float[][] energies = new float[calorimeters.length][];
        int[] sizes = new int[calorimeters.length];
        ACoord[] points = new ACoord[calorimeters.length];
        Color[] colorMap = AColorMap.getColors();
        for (i = 0; i < calorimeters.length; ++i) {
            if (calorimeters[i].CALORIMETER_NAME.equals("MBTS")) continue;
            if (APar.get(calorimeters[i].getParameterGroup(), "ColorFunction").getI() == 4) {
                switch (AColorMap.getColorMap()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        colorMap = AColorMap.getColors(7);
                        break;
                    }
                    case 5: 
                    case 6: {
                        colorMap = AColorMap.getColors(8);
                    }
                }
            } else if (APar.get(calorimeters[i].getParameterGroup(), "ColorFunction").getI() == 7) {
                colorMap = AColorMap.getShades(128);
            }
            points[i] = window.calculateDisplay(calorimeters[i].getVPPoints());
            energies[i] = calorimeters[i].getET(points[i].index);
            sizes[i] = energies[i].length;
            calorimeters[i].color();
        }
        for (i = 0; i < calorimeters.length; ++i) {
            for (int j = 0; j < sizes[i]; ++j) {
                int size = (int)Math.sqrt(energies[i][j] * 20.0f);
                if (size == 0) {
                    ++size;
                }
                byte cellColor = calorimeters[i].color[points[i].index[j]];
                ag.setColor(colorMap[cellColor]);
                ag.drawPoint(calorimeters[i], points[i].index[j], points[i].hv[0][0][j], points[i].hv[1][0][j], size, size);
            }
        }
    }

    protected static void calibrateDensity(ACalorimeterData[] calorimeters, int mode) {
        String[] types;
        if (mode == -1) {
            mode = APar.get("LAr", "EnergyCalibration").getI();
        }
        switch (mode) {
            case 0: {
                types = new String[]{"ALL"};
                break;
            }
            case 1: {
                types = new String[]{"ECAL", "HCAL"};
                break;
            }
            default: {
                types = new String[]{};
            }
        }
        for (int i = 0; i < types.length; ++i) {
            int j;
            boolean first = true;
            double min = 0.0;
            double max = 0.0;
            for (j = 0; j < calorimeters.length; ++j) {
                if (!(calorimeters[j].getMaxDensity(types[i]) > 0.0)) continue;
                if (first) {
                    min = calorimeters[j].getMinDensity(types[i]);
                    max = calorimeters[j].getMaxDensity(types[i]);
                    first = false;
                }
                if (calorimeters[j].getMinDensity(types[i]) < min) {
                    min = calorimeters[j].getMinDensity(types[i]);
                }
                if (!(calorimeters[j].getMaxDensity(types[i]) > max)) continue;
                max = calorimeters[j].getMaxDensity(types[i]);
            }
            for (j = 0; j < calorimeters.length; ++j) {
                calorimeters[j].setMinDensity(types[i], min);
                calorimeters[j].setMaxDensity(types[i], max);
            }
        }
    }

    protected static void drawFrames(ACalorimeterData calorimeter, ACoord display, AWindow window, AGraphics ag) {
        String name = calorimeter.getCalorimeterName();
        Color[] colorMap = AColorMap.getColors();
        int[] index = display.index;
        int[] type = calorimeter.getType(index);
        boolean drawCellGeometry = APar.get(name, "CellGeometry").getStatus();
        boolean drawFrame = APar.get(name, "Frame").getStatus();
        int frameColor = APar.get(name, "Frame").getI();
        drawFrame = drawFrame && AColorMap.drawFrames();
        if (window.getProjection() instanceof AProjectionVP) {
            drawCellGeometry = APar.get("VP", "VPlotIsland").getStatus();
            drawFrame = true;
            frameColor = 0;
        }
        if (drawFrame && drawCellGeometry) {
            for (int i = 0; i < index.length; ++i) {
                ag.updateDrawParameters(calorimeter.getDrawParameters(0, type[i]));
                ag.setColor(colorMap[frameColor]);
                ag.drawPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
            }
        }
    }

    protected static void drawGeometry(ACalorimeterData calorimeter, ACoord display, AWindow window, AGraphics ag) {
        int i;
        String name = calorimeter.getCalorimeterName();
        Color[] colorMap = AColorMap.getColors();
        int[] index = display.index;
        int[] type = calorimeter.getType(index);
        boolean drawCellGeometry = APar.get(name, "CellGeometry").getStatus();
        boolean drawCellOutline = APar.get(name, "CellOutline").getStatus();
        boolean cutByLayer = false;
        int cellGeometryColor = APar.get(name, "CellGeometry").getI();
        int cellOutlineColor = APar.get(name, "CellOutline").getI();
        int cutLayer = 0;
        if (window.getProjection() instanceof AProjectionVP) {
            drawCellGeometry = APar.get("VP", "VPlotIsland").getStatus();
            cellGeometryColor = APar.get("VP", "VPlotIsland").getI();
            int mode = APar.get("VP", "Mode").getI();
            if (mode >= 7) {
                cutByLayer = true;
                cutLayer = mode - 7;
            } else if (mode >= 3) {
                cutByLayer = true;
                cutLayer = mode - 3;
            }
        }
        if (drawCellGeometry) {
            for (i = 0; i < index.length; ++i) {
                ag.updateDrawParameters(calorimeter.getDrawParameters(1, type[i]));
                ag.setColor(colorMap[cellGeometryColor]);
                ag.fillPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
            }
        }
        if (drawCellOutline) {
            ag.updateDrawParameters(new ADrawParameters(true, cellOutlineColor, 0, 1, 0, 0, false, 1, 0));
            for (i = 0; i < index.length; ++i) {
                if (cutByLayer && calorimeter.getSampling(index[i]) != cutLayer) continue;
                ag.drawPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
            }
        }
    }

    protected static void drawHits(ACalorimeterData calorimeter, ACoord display, AWindow window, AGraphics ag) {
        int i;
        String name = calorimeter.getCalorimeterName();
        int[] index = display.index;
        int[] color = calorimeter.getColor(index);
        int[] type = calorimeter.getType(index);
        int[] sampling = calorimeter.getSampling(index);
        boolean cutByLayer = false;
        int cutLayer = 0;
        if (window.getProjection() instanceof AProjectionVP) {
            int mode = APar.get("VP", "Mode").getI();
            if (mode >= 7) {
                cutByLayer = true;
                cutLayer = mode - 7;
            } else if (mode >= 3) {
                cutByLayer = true;
                cutLayer = mode - 3;
            }
        }
        AParameter cellGeometry = APar.get(name, "CellGeometry");
        AParameter colorFunction = APar.get(name, "ColorFunction");
        boolean drawFrame = APar.get(name, "Frame").getStatus();
        int frameColor = APar.get(name, "Frame").getI();
        drawFrame = drawFrame && AColorMap.drawFrames();
        Color[] colorMap = AColorMap.getColors();
        if (colorFunction.getI() == 4) {
            switch (AColorMap.getColorMap()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    colorMap = AColorMap.getColors(7);
                    break;
                }
                case 5: 
                case 6: {
                    colorMap = AColorMap.getColors(8);
                }
            }
        } else if (colorFunction.getI() == 7) {
            colorMap = AColorMap.getShades(128);
        }
        if (drawFrame && !cellGeometry.getStatus()) {
            for (i = 0; i < index.length; ++i) {
                if (cutByLayer && sampling[i] != cutLayer) continue;
                ag.updateDrawParameters(calorimeter.getDrawParameters(0, type[i]));
                ag.setColor(colorMap[frameColor]);
                ag.drawPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
            }
        }
        for (i = 0; i < index.length; ++i) {
            if (cutByLayer && sampling[i] != cutLayer) continue;
            ag.updateDrawParameters(calorimeter.getDrawParameters(1, type[i]));
            ag.setColor(colorMap[color[i]]);
            ag.fillPolygon(calorimeter, index[i], display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
        }
    }

    protected static void drawHistogram(ACalorimeterData calorimeter, AWindow window, AGraphics ag, AProjection2D projection) {
        String name = calorimeter.getCalorimeterName();
        if (!APar.get(name, "Histogram").getStatus()) {
            return;
        }
        ACoord[] histograms = calorimeter.getUserHistograms(projection);
        for (int i = 0; i < histograms.length; ++i) {
            int j;
            ACoord display = window.calculateDisplay(histograms[i]);
            AHistogram hist = (AHistogram)histograms[i].source;
            hist.completeTowers(display);
            if (ag.getGraphics2D() instanceof ADrawnGraphics2D) {
                ((ADrawnGraphics2D)ag.getGraphics2D()).addHistogramData(hist);
            }
            boolean onTop = APar.getUnknown(name, "OnTopHistoFrame") != null ? APar.get(name, "OnTopHistoFrame").getStatus() : false;
            if (APar.get(name, "HistoFrame").getStatus() && !onTop) {
                int frameColor = APar.get(name, "HistoFrame").getI();
                ag.updateDrawParameters(new ADrawParameters(true, frameColor, 0, 0, 1, 0));
                for (j = 0; j < display.hv[0].length; ++j) {
                    ag.drawPolygon(display.hv[0][j], display.hv[1][j], display.hv[0][j].length);
                }
            }
            int fillColor = APar.get(name, "Histogram").getI();
            ag.updateDrawParameters(new ADrawParameters(true, fillColor, 0, 1, 0, 0));
            for (j = 0; j < display.hv[0].length; ++j) {
                ag.fillPolygon(hist, display.index[j], display.hv[0][j], display.hv[1][j], display.hv[0][j].length);
            }
        }
    }

    protected static void frameHistogram(ACalorimeterData calorimeter, AWindow window, AGraphics ag, AProjection2D projection) {
        String name = calorimeter.getCalorimeterName();
        if (!APar.get(name, "Histogram").getStatus()) {
            return;
        }
        ACoord[] histograms = calorimeter.getUserHistograms(projection);
        for (int i = 0; i < histograms.length; ++i) {
            ACoord display = window.calculateDisplay(histograms[i]);
            AHistogram hist = (AHistogram)display.source;
            hist.completeTowers(display);
            boolean onTop = false;
            if (APar.getUnknown(name, "OnTopHistoFrame") != null) {
                onTop = APar.get(name, "OnTopHistoFrame").getStatus();
            }
            if (!APar.get(name, "HistoFrame").getStatus() || !onTop) continue;
            int frameColor = APar.get(name, "HistoFrame").getI();
            ag.updateDrawParameters(new ADrawParameters(true, frameColor, 0, 1, 0, 0));
            for (int j = 0; j < display.hv[0].length; ++j) {
                ag.drawPolygon(display.hv[0][j], display.hv[1][j], display.hv[0][j].length);
            }
        }
    }

    public static void drawEndcapHistogram(ACalorimeterData calorimeter, AWindow window, AGraphics ag, AProjection2D projection) {
        calorimeter.filterDrawList(projection);
        ACalorimeterData.drawHistogram(calorimeter, window, ag, projection);
        ACalorimeterData.frameHistogram(calorimeter, window, ag, projection);
    }

    protected static float[] getLookupTableArray(String[][] s, int numLookupTableValues) throws AAtlantisException {
        float[] r = new float[numLookupTableValues];
        int i = 0;
        for (int k = 0; k < s.length; ++k) {
            for (int l = 0; l < s[k].length; ++l) {
                if ("".equals(s[k][l])) continue;
                try {
                    if (i >= numLookupTableValues) {
                        String m = "more lookup values than NUMBER_OF_LOOKUP_VALUES: " + i + " >= " + numLookupTableValues;
                        throw new AAtlantisException(m);
                    }
                    r[i] = Float.valueOf(s[k][l]).floatValue();
                    ++i;
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new AAtlantisException("number format exception: " + s[k][l]);
                }
            }
        }
        if (i != numLookupTableValues) {
            throw new AAtlantisException("incorrect number to items (" + i + ") " + "in the lookup table, should be " + numLookupTableValues);
        }
        return r;
    }

    protected double getPhysicsPulseShape(double localTime, double cellPedestal, double energy, float[] amplitude, float[] time, int numerOfLookupValues) throws AAtlantisException {
        double tdiv = 0.0;
        int lookup = 0;
        double xpulse = 0.0;
        tdiv = time[1] - time[0];
        lookup = (int)((localTime - (double)time[0]) / tdiv);
        if (lookup < 0) {
            lookup = 0;
        }
        if (lookup >= numerOfLookupValues - 1) {
            lookup = numerOfLookupValues - 2;
        }
        try {
            xpulse = lookup == 0 || lookup == numerOfLookupValues - 2 ? (double)amplitude[lookup] : (double)amplitude[lookup] + (double)(amplitude[lookup + 1] - amplitude[lookup]) / tdiv * (localTime - (double)time[lookup]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            String m = this.CALORIMETER_NAME + " getPhysicsPulseShape():\n" + "  lookup index out of bound: lookup = " + lookup;
            throw new AAtlantisException(m);
        }
        return xpulse * energy + cellPedestal;
    }

    protected static boolean checkADCCountsAvailability(int[][] adcCountsLocal) {
        boolean adcCountsAvailable = false;
        for (int x = 0; x < adcCountsLocal.length; ++x) {
            for (int y = 0; y < adcCountsLocal[0].length; ++y) {
                if (adcCountsLocal[x][y] == 0) continue;
                adcCountsAvailable = true;
                break;
            }
            if (adcCountsAvailable) break;
        }
        return adcCountsAvailable;
    }

    public static class ACoordArray {
        private Vector v = new Vector();

        public void add(ACoord[] c) {
            for (int i = 0; i < c.length; ++i) {
                this.v.addElement(c[i]);
            }
        }

        public ACoord[] getArray() {
            ACoord[] c = new ACoord[this.v.size()];
            for (int i = 0; i < this.v.size(); ++i) {
                c[i] = (ACoord)this.v.elementAt(i);
            }
            return c;
        }
    }
}

