/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.utils.AAtlantisException;
import atlantis.utils.ALogger;
import java.util.HashMap;

public final class ACalorimeterRPSPLT {
    private static ALogger logger = ALogger.getLogger(ACalorimeterRPSPLT.class);
    protected static float[] TILE_TIME = null;
    protected static float[] TILE_AMPLITUDE = null;
    protected static float[] FCAL_TIME = null;
    protected static float[] FCAL_LAYER0_AMPLITUDE = null;
    protected static float[] FCAL_LAYER1_AMPLITUDE = null;
    protected static float[] FCAL_LAYER2_AMPLITUDE = null;
    protected static float[] HEC_TIME = null;
    protected static float[] HEC_AMPLITUDE = null;
    private static HashMap<String, float[]> larTables = null;

    public static boolean areFCALLookupTablesInitialized() {
        return FCAL_LAYER0_AMPLITUDE != null && FCAL_LAYER1_AMPLITUDE != null && FCAL_LAYER2_AMPLITUDE != null && FCAL_TIME != null;
    }

    public static boolean areHECLookupTablesInitialized() {
        return HEC_TIME != null && HEC_AMPLITUDE != null;
    }

    public static boolean areTileLookupTablesInitialized() {
        return TILE_TIME != null && TILE_AMPLITUDE != null;
    }

    public static boolean areLarLookupTablesInitialized() {
        for (String key : larTables.keySet()) {
            if (larTables.get(key) != null) continue;
            logger.error("LAr real pulse shapes plots lookup table \"" + key + "\" was not initialised.");
            return false;
        }
        return true;
    }

    public static void setLarTable(String key, float[] array) throws AAtlantisException {
        logger.debug("Setting LAr pulse shapes lookup table \"" + key + "\"");
        if (larTables.containsKey(key)) {
            if (larTables.get(key) != null) {
                throw new AAtlantisException("LAr pulse shapes lookup table \"" + key + "\" has already been defined.");
            }
        } else {
            throw new AAtlantisException("LAr pulse shapes lookup table - entry \"" + key + "\" has not been created.");
        }
        larTables.put(key, array);
    }

    public static float[] getLarTable(String key) throws AAtlantisException {
        logger.debug("Getting LAr pulse shapes lookup table \"" + key + "\"");
        if (larTables.containsKey(key)) {
            float[] r = larTables.get(key);
            if (r == null) {
                throw new AAtlantisException("LAr pulse shape lookup table key \"" + key + "\" is null.");
            }
            return r;
        }
        throw new AAtlantisException("LAr pulse shape lookup table entry \"" + key + "\" has not been created.");
    }

    static {
        larTables = new HashMap(70);
        larTables.put("LAR_TIME", null);
        larTables.put("LAR_BARREL_LAYER1_REGION0_AMPLITUDE", null);
        larTables.put("LAR_BARREL_LAYER1_REGION1_AMPLITUDE", null);
        larTables.put("LAR_BARREL_LAYER2_REGION0_AMPLITUDE", null);
        larTables.put("LAR_BARREL_LAYER2_REGION1_AMPLITUDE", null);
        larTables.put("LAR_BARREL_LAYER3_REGION0_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER0_REGION0_ETA0_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION0_ETA0_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION0_ETA1_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION0_ETA2_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION0_ETA3_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION0_ETA4_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION0_ETA5_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION0_ETA6_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION0_ETA7_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION1_ETA0_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION2_ETA0_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION2_ETA1_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION2_ETA2_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION2_ETA3_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION3_ETA0_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION3_ETA1_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION3_ETA2_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION4_ETA0_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION4_ETA1_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION4_ETA2_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION4_ETA3_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION4_ETA4_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER1_REGION5_ETA0_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION0_ETA0_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION0_ETA1_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION0_ETA2_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION0_ETA3_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION0_ETA4_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION0_ETA5_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION0_ETA6_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION0_ETA7_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION1_ETA0_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION1_ETA1_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION1_ETA2_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION1_ETA3_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION1_ETA4_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION1_ETA5_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION1_ETA6_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION1_ETA7_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION1_ETA8_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION1_ETA9_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER2_REGION1_ETA10_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER3_REGION0_ETA0_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER3_REGION0_ETA1_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER3_REGION0_ETA2_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER3_REGION0_ETA3_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER3_REGION0_ETA4_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER3_REGION0_ETA5_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER3_REGION0_ETA6_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER3_REGION0_ETA7_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER3_REGION0_ETA8_AMPLITUDE", null);
        larTables.put("LAR_ENDCAP_LAYER3_REGION0_ETA9_AMPLITUDE", null);
    }
}

