/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.canvas.AWindow;
import atlantis.event.AAssociation;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.graphics.AGraphics;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionVP;
import atlantis.utils.A3Vector;
import atlantis.utils.A4Vector;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public class AClusterData
extends AData {
    protected float[] eT;
    protected float[] eta;
    protected float[] phi;

    public String getParameterGroup() {
        return "Cluster";
    }

    public String getName() {
        return "Cluster";
    }

    public String getNameScreenName() {
        return "Cluster";
    }

    public float getET(int index) {
        return this.eT[index];
    }

    public float getEta(int index) {
        return this.eta[index];
    }

    public float getPhi(int index) {
        return this.phi[index];
    }

    AClusterData(AHashMap p, AEvent e) {
        super(p, e);
        this.eta = p.getFloatArray("eta");
        this.phi = p.getFloatArray("phi");
        if (p.get("et") != null) {
            this.eT = p.getFloatArray("et");
        } else {
            float[] energy = p.getFloatArray("energy");
            this.eT = new float[this.numData];
            for (int i = 0; i < this.numData; ++i) {
                this.eT[i] = (float)Math.abs((double)energy[i] * Math.cos(AMath.lambda(this.eta[i])));
            }
        }
        String assocKey = this.getName() + this.getStoreGateKey();
        if (p.get("numCells") != null) {
            this.event.getAssociationManager().add(new AAssociation(assocKey, "LAr", p.getIntArray("numCells"), p.getIntArray("cells"), this.event));
            this.event.getAssociationManager().add(new AAssociation(assocKey, "TILE", p.getIntArray("numCells"), p.getIntArray("cells"), this.event));
        }
    }

    protected int getDrawOrFill() {
        return 1;
    }

    protected void applyCuts() {
        AData.printCut(this.getName(), this.numDraw);
        this.cutIndex();
        this.cut("CutsCalo", "ClusterET", " |ET|", this.eT);
        this.cutPhi(this.phi);
        this.cutEta(this.eta);
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        switch (colorFunction) {
            case 0: {
                this.colorByConstant();
                break;
            }
            case 1: {
                this.colorByIndex();
                break;
            }
            case 2: {
                this.colorByObjects();
            }
        }
        return 3;
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n ET=" + AMath.d2s(this.eT[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Ex=" + AMath.d2s((double)this.eT[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Ey=" + AMath.d2s((double)this.eT[index] * Math.sin(this.phi[index]), 3) + " GeV " + "\n Ez=" + AMath.d2s((double)this.eT[index] * Math.sinh(this.eta[index]), 3) + " GeV ";
            }
            return output;
        }
        String k = this.getStoreGateKey();
        String sgKey = k != null ? k : "n/a";
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" (id: " + this.id[index] + " index: " + index + ")");
        msg.append("\n storegate key: ");
        msg.append(sgKey);
        msg.append("\n ET = ");
        msg.append(AMath.d2s(this.eT[index], 3));
        msg.append(" GeV\n E = ");
        msg.append(AMath.d2s(Math.abs((double)this.eT[index] / Math.cos(AMath.lambda(this.eta[index]))), 3));
        msg.append(" GeV\n ");
        msg.append("\u03b7");
        msg.append(" = ");
        msg.append(AMath.d2s(this.eta[index], 3));
        msg.append("\n ");
        msg.append("\u03a6");
        msg.append(" = ");
        msg.append(AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0");
        msg.append("  (" + AMath.d2s(this.phi[index], 3) + " rad)");
        return msg.toString();
    }

    public String getVPHitInfo() {
        this.makeDrawList();
        if (this.numDraw == 0) {
            return "";
        }
        double sumE = 0.0;
        double sumET = 0.0;
        for (int i = 0; i < this.numDraw; ++i) {
            sumET += (double)Math.abs(this.eT[this.listdl[i]]);
            sumE += Math.abs((double)this.eT[this.listdl[i]] / Math.cos(AMath.lambda(this.eta[this.listdl[i]])));
        }
        StringBuffer msg = new StringBuffer("");
        msg.append(this.numDraw);
        msg.append(" ");
        msg.append(this.getStoreGateKey() != null ? this.getStoreGateKey() : this.getNameScreenName());
        msg.append("  sum(ET) = ");
        msg.append(AMath.d2s(sumET, 1));
        msg.append("  sum(E) = ");
        msg.append(AMath.d2s(sumE, 1));
        return msg.toString();
    }

    public A4Vector get4Vector(int num, int[] list) {
        A4Vector sum = new A4Vector();
        for (int i = 0; i < num; ++i) {
            int k = list[i];
            A3Vector start = new A3Vector().setCylindrical(0.0, 0.0, 0.0);
            double tL = AMath.tanLambda(this.eta[k]);
            A3Vector stop = new A3Vector().setCylindrical(1.0, this.phi[k], tL);
            A3Vector v = stop.subtract(start).normalize();
            double p = (double)this.eT[k] / Math.sqrt(1.0 - v.z * v.z);
            sum.add(new A4Vector(v.scale(p), 0.0));
        }
        return sum;
    }

    public void draw(AWindow window, AGraphics ag, AProjection2D projection) {
        if (projection instanceof AProjectionVP) {
            this.drawVP(window, ag, projection);
        } else {
            super.draw(window, ag, projection);
        }
    }

    private void drawVP(AWindow window, AGraphics ag, AProjection2D projection) {
        ACoord centers = window.calculateDisplay(this.getUser(projection));
        int[] drawlist = centers.index;
        double eLimit = 0.025;
        int numPoints = 25;
        double[][][] hv = new double[2][drawlist.length][numPoints];
        for (int i = 0; i < drawlist.length; ++i) {
            int list = drawlist[i];
            double e = Math.abs(this.eT[list]);
            int d = (int)Math.sqrt(e / eLimit / Math.PI);
            if (d == 0) {
                d = 1;
            }
            for (int j = 0; j < numPoints; ++j) {
                hv[0][i][j] = centers.hv[0][0][i] + (double)d * Math.cos(Math.PI * 2 * (double)j / (double)(numPoints - 1));
                hv[1][i][j] = centers.hv[1][0][i] + (double)d * Math.sin(Math.PI * 2 * (double)j / (double)(numPoints - 1));
            }
        }
        ag.draw(new ACoord(hv, drawlist, (ADrawable)this, 3));
    }

    protected ACoord getVPUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.eta[list];
            v[i] = Math.toDegrees(this.phi[list]);
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("VP");
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        double dphi = Math.toRadians(0.5);
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiPlus = (double)this.phi[list] + dphi;
            double phiMinus = (double)this.phi[list] - dphi;
            double cosPlus = Math.cos(phiPlus);
            double sinPlus = Math.sin(phiPlus);
            double cosMinus = Math.cos(phiMinus);
            double sinMinus = Math.sin(phiMinus);
            double rhoMax = 380.0;
            double rhoMinus = 155.0;
            double maxEnergy = APar.get("Projection", "EnergyMax").getD();
            double rhoPlus = rhoMax;
            if ((double)Math.abs(this.eT[list]) < maxEnergy) {
                rhoPlus = rhoMinus + (rhoMax - rhoMinus) * (double)Math.abs(this.eT[list]) / maxEnergy;
            }
            hv[0][i][0] = rhoMinus * cosPlus;
            hv[1][i][0] = rhoMinus * sinPlus;
            hv[0][i][1] = rhoPlus * cosPlus;
            hv[1][i][1] = rhoPlus * sinPlus;
            hv[0][i][2] = rhoPlus * cosMinus;
            hv[1][i][2] = rhoPlus * sinMinus;
            hv[0][i][3] = rhoMinus * cosMinus;
            hv[1][i][3] = rhoMinus * sinMinus;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 4);
    }

    protected ACoord getFRUser() {
        return this.getYXUser().convertYXToFR().includePhiWrapAround("FR");
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        double dtheta = Math.toRadians(0.5);
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
            double phiDiff = Math.abs((double)this.phi[list] - phiMid);
            double rSign = phiDiff > 1.5707963267948966 && phiDiff <= 4.71238898038469 ? -1.0 : 1.0;
            double theta = Math.atan(Math.exp(-Math.abs(this.eta[list]))) * 2.0;
            if ((double)this.eta[list] > 0.0 && rSign == -1.0) {
                theta = Math.PI * 2 - theta;
            } else if ((double)this.eta[list] < 0.0 && rSign == -1.0) {
                theta += Math.PI;
            } else if ((double)this.eta[list] < 0.0 && rSign == 1.0) {
                theta = Math.PI - theta;
            }
            double thetaPlus = theta + dtheta;
            double thetaMinus = theta - dtheta;
            double cosPlus = Math.cos(thetaPlus);
            double sinPlus = Math.sin(thetaPlus);
            double cosMinus = Math.cos(thetaMinus);
            double sinMinus = Math.sin(thetaMinus);
            boolean LAR = false;
            boolean LAR_ENDCAP = true;
            int FCAL_EM = 2;
            int region = 0;
            if (Math.abs(Math.tan(theta)) >= 0.0778 && Math.abs(Math.tan(theta)) < 0.4828) {
                region = 1;
            } else if (Math.abs(Math.tan(theta)) < 0.0778) {
                region = 2;
            }
            double radiusMinus = 0.0;
            switch (region) {
                case 0: {
                    radiusMinus = 155.0 / Math.abs(Math.sin(theta));
                    break;
                }
                case 1: {
                    radiusMinus = 380.0 / Math.abs(Math.cos(theta));
                    break;
                }
                case 2: {
                    radiusMinus = 470.0 / Math.abs(Math.cos(theta));
                }
            }
            double radiusMax = radiusMinus + 200.0;
            double maxEnergy = APar.get("Projection", "EnergyMax").getD();
            double radiusPlus = radiusMax;
            if ((double)Math.abs(this.eT[list]) < maxEnergy) {
                radiusPlus = radiusMinus + (radiusMax - radiusMinus) * (double)Math.abs(this.eT[list]) / maxEnergy;
            }
            hv[0][i][0] = radiusMinus * cosPlus;
            hv[1][i][0] = radiusMinus * sinPlus;
            hv[0][i][1] = radiusPlus * cosPlus;
            hv[1][i][1] = radiusPlus * sinPlus;
            hv[0][i][2] = radiusPlus * cosMinus;
            hv[1][i][2] = radiusPlus * sinMinus;
            hv[0][i][3] = radiusMinus * cosMinus;
            hv[1][i][3] = radiusMinus * sinMinus;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 4);
    }
}

