/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.AAODData;
import atlantis.event.AEvent;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;
import atlantis.utils.APDGTable;

public class ACompositeParticleData
extends AAODData {
    private int[] pdgId;
    private float[] charge;
    private String[] label;
    private String[] typeEV;

    ACompositeParticleData(AHashMap p, AEvent e) {
        super(p, e);
        this.pdgId = p.getUnsureIntArray("pdgId");
        this.charge = p.getUnsureFloatArray("charge");
        this.label = p.getStringArray("label");
        this.typeEV = p.getStringArray("typeEV");
    }

    public String getParameterGroup() {
        return "CompositeParticle";
    }

    public String getName() {
        return "CompositeParticle";
    }

    public int getPdgId(int index) {
        return this.pdgId[index];
    }

    public float getCharge(int index) {
        return this.charge[index];
    }

    public String getLabel(int index) {
        return this.label[index];
    }

    public String getTypeEV(int index) {
        return this.typeEV[index];
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n PT=" + AMath.d2s(this.pT[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Px=" + AMath.d2s((double)this.pT[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Py=" + AMath.d2s((double)this.pT[index] * Math.sin(this.phi[index]), 3) + " GeV " + "\n Pz=" + AMath.d2s((double)this.pT[index] * Math.sinh(this.eta[index]), 3) + " GeV ";
            }
            return output;
        }
        String k = this.getStoreGateKey();
        String sgKey = k != null ? k : "n/a";
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" = ");
        msg.append(this.id[index]);
        msg.append("\n storegate key: ");
        msg.append(sgKey);
        msg.append("\n PT = ");
        msg.append(AMath.d2s(this.pT[index], 3));
        msg.append(" GeV\n P = ");
        msg.append(AMath.d2s(Math.abs((double)this.pT[index] / Math.cos(AMath.lambda(this.eta[index]))), 3));
        msg.append(" GeV\n ");
        msg.append("\u03b7");
        msg.append(" = ");
        msg.append(AMath.d2s(this.eta[index], 3));
        msg.append("\n ");
        msg.append("\u03a6");
        msg.append(" = ");
        msg.append(AMath.d2s(Math.toDegrees(this.phi[index]), 3));
        msg.append("\u00b0");
        msg.append("  (" + AMath.d2s(this.phi[index], 3) + " rad)");
        if (this.charge != null) {
            msg.append("\n Charge = ");
            msg.append(this.charge[index]);
        }
        if (this.pdgId != null) {
            if (this.pdgId[index] != 0) {
                msg.append("\n Type = " + APDGTable.getName(this.pdgId[index]) + " (type code " + this.pdgId[index] + ")");
            } else {
                msg.append("\n Type = unknown (type code " + this.pdgId[index] + ")");
            }
        }
        msg.append("\n TypeEV = " + this.typeEV[index]);
        if (this.label != null) {
            msg.append("\n Label = " + this.label[index]);
        }
        return msg.toString();
    }
}

