/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.canvas.AWindow;
import atlantis.data.AHelix;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjection3D;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionXZ;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Vector;

public class ADHelix {
    private static ALogger logger = ALogger.getLogger(ADHelix.class);
    protected final AEvent event;
    public final AHelix helix;
    double rC;
    double xC;
    double yC;
    double ch;
    double a0;
    double x0;
    double y0;
    double z0;
    double bz;
    double cosA0;
    double sinA0;
    double aStart;
    double aEnd;
    double aCurrent;
    double x;
    double y;
    double z;
    double rho;
    double phi;
    double startPhi;
    boolean startMark;
    static double phiUpper;
    static double phiLower;
    private static double[] point3D;
    private static int callDepthCut;
    static final AParameter zVertexPar;
    static final AParameter signConventionForD0Par;
    static final AParameter rToPar;
    static final AParameter lToPar;
    static final AParameter zToPar;
    static final double rhoMax = 55.0;

    ADHelix(AHelix h, AEvent e) {
        this.event = e;
        this.helix = h;
        this.rC = AMath.getCurvature() * Math.abs(h.pT);
        this.ch = AMath.getSign(h.pT);
        this.a0 = h.phi0 + this.ch * 90.0;
        double a0Rad = Math.toRadians(this.a0);
        this.cosA0 = Math.cos(a0Rad);
        this.sinA0 = Math.sin(a0Rad);
        this.z0 = h.z0;
        double d0 = h.d0;
        boolean kdeb = false;
        double signD0 = this.ch;
        if (kdeb) {
            int signConventionForD0 = signConventionForD0Par.getI();
            signD0 = signConventionForD0 == 0 || signConventionForD0 == 2 ? 1.0 : -1.0;
            if (signConventionForD0 <= 1) {
                signD0 = this.ch * signD0;
            }
        }
        this.x0 = (d0 *= signD0) * this.cosA0;
        this.y0 = d0 * this.sinA0;
        double SD0 = 1.0;
        double SRC = 1.0;
        double r0 = SD0 * d0 - SRC * this.rC;
        this.xC = r0 * this.cosA0;
        this.yC = r0 * this.sinA0;
        this.bz = this.rC * Math.toRadians(h.tL);
        double rTo = rToPar.getD();
        if (h.getRhoEndVertex() > 0.0) {
            rTo = Math.min(rTo, h.getRhoEndVertex());
        }
        double zTo = zToPar.getD();
        this.aStart = h.startPhi;
        this.aCurrent = -9.9999999E7;
        this.moveTo(this.aStart);
        this.setPhi(180.0);
        if (Math.abs(this.rho) > rTo || Math.abs(this.z) > zTo) {
            this.aEnd = this.aStart;
            return;
        }
        double aEndMax = Math.min(this.aStart + 180.0, 180.0);
        double aEndR = this.intersectWithRadialCylinder(rTo, this.aStart, aEndMax);
        double aEndZ = this.intersectWithZPlanes(zTo, this.aStart, aEndMax);
        this.aEnd = Math.min(aEndMax, aEndR);
        if (aEndZ > this.aStart) {
            this.aEnd = Math.min(this.aEnd, aEndZ);
        }
        if (this.aEnd - this.aStart > 180.0) {
            this.aEnd = this.aStart + 180.0;
        }
        this.aEnd = Math.min(this.aEnd, aEndMax);
    }

    public double intersectWithRadialCylinder(double rCyl, double aStart, double aEnd) {
        if (this.rC <= 0.0) {
            return aStart;
        }
        double r0 = Math.sqrt(this.xC * this.xC + this.yC * this.yC);
        double bb = (rCyl * rCyl - this.rC * this.rC - r0 * r0) / (2.0 * this.rC * r0);
        double rhoStart = this.getRho(aStart);
        double rhoEnd = this.getRho(aEnd);
        if (rCyl >= rhoStart && rCyl >= rhoEnd) {
            return aEnd;
        }
        if (rCyl <= rhoStart && rCyl <= rhoEnd) {
            return aStart;
        }
        if (Math.abs(bb) > 1.0) {
            logger.warn("Bug in ADHelix " + rCyl + " " + rhoStart + " " + rhoEnd);
            return aEnd;
        }
        double cc = Math.toDegrees(Math.acos(bb));
        if (Math.abs(cc) > 360.0) {
            throw new Error("error in cc in dhelix");
        }
        double gA = Math.toDegrees(Math.atan2(this.yC, this.xC));
        double a1 = this.ch * (this.a0 - gA + cc);
        double a2 = this.ch * (this.a0 - gA - cc);
        if (a1 < 0.0) {
            a1 += 360.0;
        }
        if (a2 < 0.0) {
            a2 += 360.0;
        }
        if (a1 >= 360.0) {
            a1 -= 360.0;
        }
        if (a2 >= 360.0) {
            a2 -= 360.0;
        }
        return Math.min(a1, a2);
    }

    public double intersectWithZPlanes(double zCyl, double aStart, double aEnd) {
        double zMin = 20.0;
        double aZ = aEnd;
        if (zCyl >= zMin && this.bz != 0.0) {
            double aZPlus = (zCyl - this.z0) / this.bz;
            double aZMinus = (-zCyl - this.z0) / this.bz;
            if (aZPlus < aZ && aZPlus > aStart) {
                aZ = aZPlus;
            }
            if (aZMinus < aZ && aZMinus > aStart) {
                aZ = aZMinus;
            }
        }
        return aZ;
    }

    public double intersectWithCylinder(boolean useR, double rCyl, boolean useZ, double zCyl) {
        double aStart = 0.0;
        double aEndMax = 180.0;
        double zMin = 20.0;
        double aEndR = 0.0;
        if (useR) {
            aEndR = this.intersectWithRadialCylinder(rCyl, aStart, aEndMax);
        }
        double aEndZ = 0.0;
        if (useZ && zCyl >= zMin && this.bz != 0.0) {
            aEndZ = this.intersectWithZPlanes(zCyl, aStart, aEndMax);
            return Math.min(aEndR, aEndZ);
        }
        return aEndR;
    }

    private void moveTo(double a) {
        if (a != this.aCurrent) {
            double aRad = Math.toRadians(this.a0 - this.ch * a);
            this.x = this.x0 + this.rC * (Math.cos(aRad) - this.cosA0);
            this.y = this.y0 + this.rC * (Math.sin(aRad) - this.sinA0);
            this.z = this.z0 + this.bz * a;
            double[] primaryVtx = this.event.getPrimaryVertex();
            double dx = this.x - primaryVtx[0];
            double dy = this.y - primaryVtx[1];
            this.rho = Math.sqrt(dx * dx + dy * dy);
            this.phi = Math.toDegrees(Math.atan2(dy, dx));
            while (this.phi < 0.0 || this.phi > 360.0) {
                if (this.phi < 0.0) {
                    this.phi += 360.0;
                    continue;
                }
                this.phi -= 360.0;
            }
            if (this.phi < phiLower) {
                this.phi += 360.0;
            } else if (this.phi > phiUpper) {
                this.phi -= 360.0;
            }
            this.aCurrent = a;
        }
    }

    public double setPhiStart(double s1, double s2) {
        this.setPhi(180.0);
        double phi1 = this.getPhi(s1);
        double phi2 = this.getPhi(s2);
        double phiM = this.getPhi((s1 + s2) / 2.0);
        if (Math.abs(phi1 - phi2) > 180.0 || Math.abs(phi1 - phiM) > 180.0 || Math.abs(phi2 - phiM) > 180.0) {
            if (phi1 - phiM > 180.0) {
                phi1 -= 360.0;
            }
            if (phi2 - phiM > 180.0) {
                phi2 -= 360.0;
            }
            if (phi1 - phiM < -180.0) {
                phi1 += 360.0;
            }
            if (phi2 - phiM < -180.0) {
                phi2 += 360.0;
            }
            phiM = phi1 < phiM && phiM < phi2 ? (phi1 + phi2) / 2.0 : (phi1 > phiM && phiM > phi2 ? (phi1 + phi2) / 2.0 : (phi1 + phi2) / 2.0);
        }
        if (phiM > 360.0) {
            phiM -= 360.0;
        }
        if (phiM < 0.0) {
            phiM += 360.0;
        }
        this.setPhi(phiM);
        return phiM;
    }

    public double getAStart() {
        return this.aStart;
    }

    public double getAEnd() {
        return this.aEnd;
    }

    public ACoord getYXPoint(double a) {
        this.moveTo(a);
        return new ACoord(this.x, this.y, -1);
    }

    public ACoord getRZPoint(double a) {
        this.moveTo(a);
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        double phiDiff = Math.abs(Math.toRadians(this.phi) - phiMid);
        if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
            return new ACoord(this.z, this.rho, -1);
        }
        return new ACoord(this.z, -this.rho, -1);
    }

    public ACoord get3DPoint(double a) {
        this.moveTo(a);
        ADHelix.point3D[0] = this.x;
        ADHelix.point3D[1] = this.y;
        ADHelix.point3D[2] = this.z;
        point3D = AProjection3D.getRotated(point3D);
        return new ACoord(point3D[0], point3D[1], -1);
    }

    public double[] get3DPointAsArray(double a) {
        this.moveTo(a);
        double[] point3D = new double[]{this.x, this.y, this.z};
        point3D = AProjection3D.getRotated(point3D);
        return point3D;
    }

    public ACoord getXZPoint(double a) {
        this.moveTo(a);
        double phiC = AProjectionXZ.getPhi();
        return new ACoord(this.z, this.rho * Math.cos(Math.toRadians(this.phi - phiC)), -1);
    }

    public ACoord getYZPoint(double a) {
        this.moveTo(a);
        double phiC = AProjectionXZ.getPhi();
        return new ACoord(this.z, this.rho * Math.sin(Math.toRadians(this.phi - phiC)), -1);
    }

    public ACoord getFZPoint(double a) {
        this.moveTo(a);
        double temp = Math.toDegrees(AMath.getPhiStereo(this.rho, Math.toRadians(this.phi), this.z));
        return new ACoord(this.z, temp, -1);
    }

    public ACoord getFRPoint(double a) {
        this.moveTo(a);
        double temp = Math.toDegrees(AMath.getPhiStereo(this.rho, Math.toRadians(this.phi), this.z));
        return new ACoord(this.rho, temp, -1);
    }

    public ACoord getVPPoint(double a, int sign) {
        this.moveTo(a);
        if (this.startMark) {
            this.startPhi = this.phi;
        } else if (this.phi - this.startPhi > 180.0) {
            this.phi -= 360.0;
        } else if (this.startPhi - this.phi > 180.0) {
            this.phi += 360.0;
        }
        return new ACoord(AMath.eta(this.z, this.rho) + (double)sign * AProjectionVP.getDeltaEta(this.rho, this.z), this.phi, -1);
    }

    public ACoord getLEGOPoint(double a) {
        this.moveTo(a);
        double temp = Math.toDegrees(AMath.getPhiStereo(this.rho, Math.toRadians(this.phi), this.z));
        return new ACoord(AMath.eta(this.z, this.rho), temp, -1);
    }

    public void setPhi(double phiMid) {
        phiLower = phiMid - 180.0;
        phiUpper = phiMid + 180.0;
    }

    public double getPhi(double a) {
        this.moveTo(a);
        return this.phi;
    }

    public double getEta(double a) {
        this.moveTo(a);
        return AMath.eta(this.z, this.rho);
    }

    private double getRho(double a) {
        this.moveTo(a);
        return this.rho;
    }

    public ACoord drawHelix(AWindow window, AProjection2D projection, double s1, double s2) {
        Vector<Point2D.Double> pointsOnHelix = new Vector<Point2D.Double>(30);
        double dPrevious = 999.0;
        int callDepth = 0;
        callDepthCut = APar.get("RTr", "CallDepth").getI();
        this.startMark = true;
        ACoord d1 = window.calculateDisplay(projection.getUserPoint(this, s1));
        double h1 = d1.hv[0][0][0];
        double v1 = d1.hv[1][0][0];
        this.startMark = false;
        ACoord d2 = window.calculateDisplay(projection.getUserPoint(this, s2));
        double h2 = d2.hv[0][0][0];
        double v2 = d2.hv[1][0][0];
        pointsOnHelix.add(new Point2D.Double(h1, v1));
        this.drawHelix(pointsOnHelix, window, projection, s1, h1, v1, s2, h2, v2, dPrevious, callDepth);
        int numPoints = projection instanceof AProjectionVP ? pointsOnHelix.size() : pointsOnHelix.size() + 1;
        double[][][] hv = new double[2][1][numPoints];
        int[] index = new int[1];
        if (projection instanceof AProjectionVP) {
            for (int k = 0; k < numPoints; ++k) {
                Point2D.Double p = (Point2D.Double)pointsOnHelix.elementAt(k);
                hv[0][0][k] = p.getX();
                hv[1][0][k] = p.getY();
            }
        } else {
            for (int k = 0; k < numPoints - 1; ++k) {
                Point2D.Double p = (Point2D.Double)pointsOnHelix.elementAt(k);
                hv[0][0][k] = p.getX();
                hv[1][0][k] = p.getY();
            }
            if (numPoints > 2) {
                double dx = hv[0][0][numPoints - 2] - hv[0][0][numPoints - 3];
                double dy = hv[1][0][numPoints - 2] - hv[1][0][numPoints - 3];
                double x0 = hv[0][0][numPoints - 2] - hv[0][0][0];
                double y0 = hv[1][0][numPoints - 2] - hv[1][0][0];
                double dtopar = (rToPar.getD() + lToPar.getD()) / rToPar.getD() * Math.sqrt(x0 * x0 + y0 * y0);
                double cophi = dx / Math.sqrt(dx * dx + dy * dy);
                double siphi = dy / Math.sqrt(dx * dx + dy * dy);
                double addl = Math.sqrt((y0 * siphi + x0 * cophi) * (y0 * siphi + x0 * cophi) - x0 * x0 - y0 * y0 + dtopar * dtopar);
                double addlen = Math.min(Math.abs(-(y0 * siphi + x0 * cophi) + addl), Math.abs(-(y0 * siphi + x0 * cophi) - addl));
                hv[0][0][numPoints - 1] = x0 + addlen * cophi + hv[0][0][0];
                hv[1][0][numPoints - 1] = y0 + addlen * siphi + hv[1][0][0];
            }
        }
        return new ACoord(hv, index);
    }

    private void drawHelix(Vector pointsOnHelix, AWindow window, AProjection2D projection, double s1, double h1, double v1, double s2, double h2, double v2, double dPrevious, int callDepth) {
        double D_MAX = 1.0;
        double h21 = h2 - h1;
        double v21 = v2 - v1;
        if (h21 == 0.0 && v21 == 0.0) {
            return;
        }
        double sM = 0.5 * (s1 + s2);
        ACoord dispM = window.calculateDisplay(projection.getUserPoint(this, sM));
        double hM = dispM.hv[0][0][0];
        double vM = dispM.hv[1][0][0];
        boolean isinview = true;
        if (callDepth > 2) {
            Rectangle bound;
            Rectangle wdim = window.getCurrDisp();
            int left = (int)h1;
            int top = (int)v1;
            int width = (int)(h2 - h1);
            int height = (int)(v2 - v1);
            if (width < 0) {
                left += width;
                width = -width;
            }
            if (height < 0) {
                top += height;
                height = -height;
            }
            if (width == 0) {
                width = 1;
            }
            if (height == 0) {
                height = 1;
            }
            if (!wdim.intersects(bound = new Rectangle(left, top, width, height))) {
                isinview = false;
            }
        }
        double hM1 = hM - h1;
        double vM1 = vM - v1;
        double temp = v21 * hM1 - h21 * vM1;
        double dM = temp * temp / (v21 * v21 + h21 * h21);
        if (dPrevious < D_MAX && dM < D_MAX) {
            pointsOnHelix.add(new Point2D.Double(h2, v2));
        } else if (callDepth < callDepthCut && isinview) {
            this.drawHelix(pointsOnHelix, window, projection, s1, h1, v1, sM, hM, vM, dM, callDepth + 1);
            this.drawHelix(pointsOnHelix, window, projection, sM, hM, vM, s2, h2, v2, dM, callDepth + 1);
        } else {
            pointsOnHelix.add(new Point2D.Double(hM, vM));
            pointsOnHelix.add(new Point2D.Double(h2, v2));
        }
    }

    static {
        point3D = new double[3];
        zVertexPar = APar.get("Event", "ZVtx");
        signConventionForD0Par = APar.get("RTr", "d0Sign");
        rToPar = APar.get("RTr", "RadiusTr");
        lToPar = APar.get("RTr", "LineTr");
        zToPar = APar.get("RTr", "ZTr");
    }
}

