/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.canvas.AWindow;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.graphics.AGraphics;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionYX;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class AETMisData
extends AData {
    protected float[] et;
    protected float[] etx;
    protected float[] ety;
    protected float[] sumet;
    protected float[] phi;
    protected final int YX_NUMPOINTS = 10;

    AETMisData(AHashMap p, AEvent e) throws AAtlantisException {
        super(p, e);
        this.sumet = p.getFloatArray("et");
        this.etx = p.getFloatArray("etx");
        this.ety = p.getFloatArray("ety");
        this.et = new float[this.numData];
        this.phi = new float[this.numData];
        for (int i = 0; i < this.numData; ++i) {
            if ((double)this.etx[i] == 0.0 && (double)this.ety[i] == 0.0) {
                throw new AAtlantisException("etx and ety are 0");
            }
            this.et[i] = (float)Math.sqrt(this.etx[i] * this.etx[i] + this.ety[i] * this.ety[i]);
            this.phi[i] = (float)Math.atan2(this.ety[i], this.etx[i]);
            if (!((double)this.phi[i] < 0.0)) continue;
            int n = i;
            this.phi[n] = (float)((double)this.phi[n] + Math.PI * 2);
        }
    }

    public float getET() {
        return this.et[0];
    }

    public float getETx() {
        return this.etx[0];
    }

    public float getETy() {
        return this.ety[0];
    }

    public float getPhi() {
        return this.phi[0];
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n ET=" + AMath.d2s(this.et[index], 3) + " GeV\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Ex=" + AMath.d2s((double)this.et[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Ey=" + AMath.d2s((double)this.et[index] * Math.sin(this.phi[index]), 3) + " GeV ";
            }
            return output;
        }
        String msg = this.getNameScreenName() + "\n";
        msg = msg + " storegate key: ";
        msg = msg + (this.storeGateKey == null ? "n/a" : this.storeGateKey) + "\n";
        msg = msg + " Sum-ET  = " + AMath.d2s(this.sumet[index], 3) + " GeV" + "\n" + " ET-Mis  = " + AMath.d2s(this.et[index], 3) + " GeV" + "\n" + " ETx-Mis = " + AMath.d2s(this.etx[index], 3) + " GeV" + "\n" + " ETy-Mis = " + AMath.d2s(this.ety[index], 3) + " GeV" + "\n" + " " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0" + "  (" + AMath.d2s(this.phi[index], 3) + " rad)";
        return msg;
    }

    public String getVPHitInfo() {
        this.makeDrawList();
        if (this.numDraw == 0) {
            return "";
        }
        double sumEt = 0.0;
        for (int i = 0; i < this.numDraw; ++i) {
            sumEt += (double)Math.abs(this.et[i]);
        }
        String key = this.getStoreGateKey();
        String msg = this.numDraw + " " + (key != null ? "" + key : this.getNameScreenName());
        msg = msg + "  ET = " + AMath.d2s(sumEt, 1);
        return msg;
    }

    public String getParameterGroup() {
        return "ETMis";
    }

    public String getName() {
        return "ETMis";
    }

    public String getNameScreenName() {
        return "ETMis";
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == 0) {
            this.colorByConstant();
        } else if (colorFunction == 1) {
            this.colorByIndex();
        } else if (colorFunction == 2) {
            this.colorByCollection();
        }
        return 3;
    }

    public void draw_new(AWindow window, AGraphics ag, AProjection2D projection) {
        Stroke origStroke = ag.getGraphics2D().getStroke();
        if (APar.getUnknown("ETMis", "LineWidth").getI() == 0) {
            float factor = 0.0f;
            factor = this.et[0] < 5.0f ? 1.0f : ((double)this.et[0] < 10.0 ? 1.5f : ((double)this.et[0] < 15.0 ? 2.0f : ((double)this.et[0] < 20.0 ? 2.5f : ((double)this.et[0] < 25.0 ? 3.0f : ((double)this.et[0] < 30.0 ? 3.5f : ((double)this.et[0] < 35.0 ? 4.0f : ((double)this.et[0] < 40.0 ? 4.5f : 5.0f)))))));
            ag.getGraphics2D().setStroke(new BasicStroke(factor));
        }
        if (projection instanceof AProjectionYX) {
            if (APar.get("ETMis", "Drawas").getI() == 0) {
                this.drawArrow(window, ag, projection);
            } else {
                this.drawDashed(window, ag, projection);
            }
        } else if (projection instanceof AProjectionVP) {
            ACoord centers = window.calculateDisplay(this.getUser(projection));
            int[] drawlist = centers.index;
            double eLimit = 0.05;
            int numPoints = 25;
            double[][][] hv = new double[2][drawlist.length][25];
            for (int i = 0; i < drawlist.length; ++i) {
                int list = drawlist[i];
                int d = (int)Math.sqrt((double)this.et[list] / eLimit / Math.PI);
                if (d == 0) {
                    d = 1;
                }
                for (int j = 0; j < 25; ++j) {
                    hv[0][i][j] = centers.hv[0][list][i] + (double)d * Math.cos(Math.PI * 2 * (double)j / 24.0);
                    hv[1][i][j] = centers.hv[1][list][i] + (double)d * Math.sin(Math.PI * 2 * (double)j / 24.0);
                }
            }
            ag.draw(new ACoord(hv, drawlist, (ADrawable)this, 5));
        } else {
            super.draw(window, ag, projection);
        }
        if (APar.getUnknown("ETMis", "LineWidth").getI() == 0) {
            ag.getGraphics2D().setStroke(origStroke);
        }
    }

    public void drawArrow(AWindow window, AGraphics ag, AProjection2D projection) {
        ACoord centers = window.calculateDisplay(this.getUser(projection));
        int[] drawlist = centers.index;
        double zoomScaling = 0.0;
        Point2D.Double[] corners = window.getUserCorners();
        double widthx = corners[1].x - corners[0].x;
        double widthy = corners[0].y - corners[2].y;
        double width = Math.sqrt(widthx * widthx + widthy * widthy);
        zoomScaling = 100.0 / width;
        double arrowheadScale = 10.0 + 10.0 * zoomScaling * Math.log(this.et[0] + 1.0f);
        double phiPrime = -1.0 * Math.atan2(this.ety[0], this.etx[0]);
        double[][][] arrowMain = new double[2][drawlist.length][2];
        double s = APar.get("ETMis", "Scale").getD();
        if (0.0 == s) {
            return;
        }
        double ET = this.et[0];
        double arrowScale = ET * s;
        if (arrowScale > 100.0) {
            arrowScale = 100.0;
        }
        for (int i = 0; i < drawlist.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                arrowMain[0][i][j] = centers.hv[0][i][3 + (int)(arrowScale * (double)j)];
                arrowMain[1][i][j] = centers.hv[1][i][3 + (int)(arrowScale * (double)j)];
            }
        }
        double[][][] arrowHead1 = new double[2][drawlist.length][2];
        double[][][] arrowHead2 = new double[2][drawlist.length][2];
        for (int i = 0; i < drawlist.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                arrowHead1[0][i][j] = arrowMain[0][0][1] + (double)j * (arrowheadScale * Math.cos(2.591 + phiPrime));
                arrowHead1[1][i][j] = arrowMain[1][0][1] + (double)j * (arrowheadScale * Math.sin(2.591 + phiPrime));
                arrowHead2[0][i][j] = arrowMain[0][0][1] + (double)j * (arrowheadScale * Math.cos(3.691 + phiPrime));
                arrowHead2[1][i][j] = arrowMain[1][0][1] + (double)j * (arrowheadScale * Math.sin(3.691 + phiPrime));
            }
        }
        ag.draw(new ACoord(arrowMain, drawlist, (ADrawable)this, 5));
        ag.draw(new ACoord(arrowHead1, drawlist, (ADrawable)this, 5));
        ag.draw(new ACoord(arrowHead2, drawlist, (ADrawable)this, 5));
    }

    public void drawDashed(AWindow window, AGraphics ag, AProjection2D projection) {
        boolean origStatus = APar.get(projection.getName(), "FishEye").getStatus();
        APar.get(projection.getName(), "FishEye").setStatus(false);
        ACoord centers = window.calculateDisplay(this.getUser(projection));
        if (origStatus) {
            APar.get(projection.getName(), "FishEye").setStatus(origStatus);
        }
        int[] drawlist = centers.index;
        double[][][] hv = new double[2][drawlist.length][10];
        for (int i = 0; i < drawlist.length; ++i) {
            for (int j = 0; j < 10; ++j) {
                hv[0][i][j] = centers.hv[0][i][j];
                hv[1][i][j] = centers.hv[1][i][j];
            }
        }
        ag.draw(new ACoord(hv, drawlist, (ADrawable)this, 5));
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        double rhoMinus = APar.get("ETMis", "Innerdrawradius").getD();
        double rhoMax = 1000.0;
        double inc = 0.1;
        double maxEnergy = APar.get("Projection", "EnergyMax").getD();
        double s = APar.get("ETMis", "Scale").getD();
        if (0.0 == s) {
            return ACoord.NO_DATA;
        }
        double[][][] hv = new double[2][this.numDraw][14];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double rhoPlus = rhoMax;
            if ((double)Math.abs(this.et[list]) < maxEnergy) {
                rhoPlus = (rhoMax - rhoMinus) * s * (double)Math.abs(this.et[list]) / maxEnergy;
            }
            double x = rhoPlus * Math.cos(this.phi[list]);
            double y = rhoPlus * Math.sin(this.phi[list]);
            for (int ii = 0; ii <= 10; ++ii) {
                hv[0][i][ii] = rhoMinus * Math.cos(this.phi[list]) + x * (inc * (double)ii);
                hv[1][i][ii] = rhoMinus * Math.sin(this.phi[list]) + y * (inc * (double)ii);
            }
            hv[0][i][11] = rhoMinus * Math.cos(this.phi[list]) + 0.8 * rhoPlus * Math.cos((double)this.phi[list] - 0.2);
            hv[1][i][11] = rhoMinus * Math.sin(this.phi[list]) + 0.8 * rhoPlus * Math.sin((double)this.phi[list] - 0.2);
            hv[0][i][12] = rhoMinus * Math.cos(this.phi[list]) + 0.8 * rhoPlus * Math.cos((double)this.phi[list] + 0.2);
            hv[1][i][12] = rhoMinus * Math.sin(this.phi[list]) + 0.8 * rhoPlus * Math.sin((double)this.phi[list] + 0.2);
            hv[0][i][13] = rhoMinus * Math.cos(this.phi[list]) + rhoPlus * Math.cos(this.phi[list]);
            hv[1][i][13] = rhoMinus * Math.sin(this.phi[list]) + rhoPlus * Math.sin(this.phi[list]);
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    protected ACoord getRZUser() {
        double s = APar.get("ETMis", "Scale").getD();
        if (0.0 == s) {
            return ACoord.NO_DATA;
        }
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][14];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            double phiDiff;
            int list = this.listdl[i];
            double rhoMinus = 500.0;
            double rhoMax = 1500.0;
            double inc = 0.1;
            double maxEnergy = APar.get("Projection", "EnergyMax").getD();
            double rhoPlus = rhoMax;
            if ((double)Math.abs(this.et[list]) < maxEnergy) {
                rhoPlus = (rhoMax - rhoMinus) * s * (double)Math.abs(this.et[list]) / maxEnergy;
            }
            double updown = 0.0;
            double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
            if (phiMid > Math.PI * 2) {
                phiMid -= Math.PI * 2;
            }
            updown = (phiDiff = Math.abs((double)this.phi[list] - phiMid)) < 1.5707963267948966 || phiDiff > 4.71238898038469 ? 1.0 : -1.0;
            double y = rhoPlus * updown;
            for (int ii = 0; ii <= 10; ++ii) {
                hv[0][i][ii] = 0.0;
                hv[1][i][ii] = rhoMinus * updown + y * (inc * (double)ii);
            }
            hv[0][i][11] = rhoMinus * 0.1;
            hv[1][i][11] = rhoMinus * updown + 0.8 * y;
            hv[0][i][12] = -rhoMinus * 0.1;
            hv[1][i][12] = rhoMinus * updown + 0.8 * y;
            hv[0][i][13] = 0.0;
            hv[1][i][13] = rhoMinus * updown + y;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    protected ACoord getVPUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[0] = 0.0;
            v[0] = Math.toDegrees(this.phi[list]);
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("VP");
    }

    protected void applyCuts() {
        AData.printCut(this.getParameterGroup(), this.numDraw);
        this.cutPhi(this.phi[0]);
        this.cutEta(0.0f);
        this.cut("CutsObjects", "ETMis", " |ETMis|", this.et);
    }

    protected void cutPhi(float phi) {
        AParameter par = APar.get("CutsATLAS", "CutPhi");
        boolean usePhiCut = par.getStatus();
        if (usePhiCut) {
            double phiCut = Math.toRadians(Math.abs(par.getD()));
            double phiMid = Math.toRadians(AMath.nearestPhiDegrees(APar.get("CutsATLAS", "PhiMiddle").getD()));
            double phiDiff = Math.abs(AMath.nearestPhiRadians(phi, phiMid) - phiMid);
            if (phiDiff - phiCut > 1.0E-6) {
                this.numDraw = 0;
            }
            AData.printCut(" Phi", this.numDraw);
        }
    }

    protected void cutEta(float eta) {
        AParameter par = APar.get("CutsATLAS", "CutEta");
        boolean useEtaCut = par.getStatus();
        if (useEtaCut) {
            double etaCut = Math.abs(par.getD());
            double etaMid = APar.get("CutsATLAS", "EtaMiddle").getD();
            double etaDiff = Math.abs((double)eta - etaMid);
            if (etaDiff - etaCut > 1.0E-6) {
                this.numDraw = 0;
            }
            AData.printCut(" Eta", this.numDraw);
        }
    }
}

