/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.ABJetData;
import atlantis.data.AClusterData;
import atlantis.data.ACompositeParticleData;
import atlantis.data.AETMisData;
import atlantis.data.AElectronData;
import atlantis.data.AInDetSegmentData;
import atlantis.data.AInDetTrackData;
import atlantis.data.AJetData;
import atlantis.data.ALVL1JetElementData;
import atlantis.data.ALVL1ResultData;
import atlantis.data.ALVL1TriggerTowerData;
import atlantis.data.AMuonData;
import atlantis.data.AMuonSegmentData;
import atlantis.data.AMuonTrackData;
import atlantis.data.APhotonData;
import atlantis.data.APixelClusterData;
import atlantis.data.ARPCData;
import atlantis.data.ASNPData;
import atlantis.data.ASTrData;
import atlantis.data.ASVxData;
import atlantis.data.ASiClusterData;
import atlantis.data.ASiClusterRDOData;
import atlantis.data.ATauJetData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.event.AEventSource;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.ALogger;
import atlantis.utils.AOutput;
import atlantis.utils.AUtilities;
import atlantis.utils.xml.AArrayParser;
import atlantis.utils.xml.AFloatArrayParser;
import atlantis.utils.xml.AIntArrayParser;
import atlantis.utils.xml.AStringArrayParser;
import atlantis.utils.xml.AXMLErrorHandler;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class AEventFromXML
extends DefaultHandler {
    private static final ALogger logger = ALogger.getLogger(AEventFromXML.class);
    private static final AEventFromXML instance = new AEventFromXML();
    private static final AXMLErrorHandler xmlErrorHandler = new AXMLErrorHandler();
    private static ParseState parseState;
    private static XMLReader xmlReader;
    private static AEvent event;
    private static String sourceName;
    private AHashMap parameters = null;
    private String currentDataName = null;
    private String currentArrayName = null;
    private String currentFullName = null;
    private int arrayLength = 0;
    private int currentArraySize = 0;
    private String storeGateKey = null;
    private AArrayParser arrayParser = null;
    private static boolean HLTIgnoredWarning;

    private AEventFromXML() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            xmlReader = factory.newSAXParser().getXMLReader();
            xmlReader.setErrorHandler(xmlErrorHandler);
            xmlReader.setEntityResolver(this);
            xmlReader.setContentHandler(this);
        }
        catch (ParserConfigurationException pce) {
            logger.error("Unable to initialize XML reader!", pce);
        }
        catch (SAXException sxe) {
            logger.error("Unable to initialize XML reader!", sxe);
        }
    }

    private boolean hasError() {
        return xmlErrorHandler.getErrorState() != AXMLErrorHandler.ErrorState.NO_ERROR;
    }

    public static AEvent read(InputStream eventInputStream, String sourceName) throws AEventSource.ReadEventException {
        logger.info("Parsing event from " + sourceName);
        xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.NO_ERROR, null);
        AEventFromXML.sourceName = sourceName;
        try {
            xmlReader.parse(new InputSource(eventInputStream));
        }
        catch (Exception e) {
            logger.error("Parsing exception " + e.getMessage(), e);
            throw new AEventSource.ReadEventException("XML parsing exception", e);
        }
        try {
            event.finalizeEvent();
        }
        catch (RuntimeException rte) {
            throw new AEventSource.ReadEventException("Inconsistent event data", rte);
        }
        return event;
    }

    public void startDocument() {
        if (this.hasError()) {
            return;
        }
        event = null;
        this.parameters = null;
        this.currentDataName = null;
        this.currentArrayName = null;
        this.currentFullName = null;
        this.arrayLength = 0;
        this.currentArraySize = 0;
        this.storeGateKey = null;
        this.arrayParser = null;
        parseState = ParseState.WAITING_EVENT;
        logger.debug("Start parsing document");
    }

    public void endDocument() {
        if (this.hasError()) {
            return;
        }
        logger.debug("Finished parsing document w/o error");
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.hasError()) {
            return;
        }
        try {
            switch (parseState) {
                case WAITING_EVENT: {
                    if (localName.equals("Event")) {
                        event = new AEvent(atts.getValue("eventNumber"), atts.getValue("runNumber"), atts.getValue("dateTime"), sourceName, atts.getValue("lumiBlock"), atts.getValue("eventProperty"));
                        this.parameters = new AHashMap(15);
                        parseState = ParseState.WAITING_DATA;
                        break;
                    }
                    logger.warn("Encountered tag " + localName + " while waiting for <event/>!");
                    break;
                }
                case WAITING_DATA: {
                    this.currentDataName = localName;
                    this.arrayLength = Integer.parseInt(atts.getValue("count"));
                    this.storeGateKey = atts.getValue("storeGateKey");
                    this.currentFullName = this.currentDataName + "-" + this.storeGateKey;
                    if (!Atlantis.showHLTAutoKeys && this.storeGateKey.indexOf("HLTAutoKey") >= 0) {
                        xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.IGNORED_DATA, new Exception("Ignored HLTAutoKey data " + this.currentFullName));
                        return;
                    }
                    this.parameters.clear();
                    this.parameters.put("numData", new Integer(this.arrayLength));
                    this.parameters.put("storeGateKey", this.storeGateKey);
                    parseState = ParseState.WAITING_ARRAY;
                    break;
                }
                case WAITING_ARRAY: {
                    this.currentArrayName = localName;
                    if (atts.getValue("type") == null || atts.getValue("multiple") == null) {
                        throw new SAXNotRecognizedException("No array type or multiplicity available for " + localName);
                    }
                    String type = atts.getValue("type");
                    float multiple = Float.parseFloat(atts.getValue("multiple"));
                    this.currentArraySize = Math.round((float)this.arrayLength * multiple);
                    if (type.equals("FLOAT")) {
                        this.arrayParser = new AFloatArrayParser(this.currentArraySize);
                        break;
                    }
                    if (type.equals("INT")) {
                        this.arrayParser = new AIntArrayParser(this.currentArraySize);
                        break;
                    }
                    if (type.equals("STRING")) {
                        this.arrayParser = new AStringArrayParser(this.currentArraySize);
                        break;
                    }
                    throw new SAXNotRecognizedException("Invalid array type: " + type);
                }
            }
        }
        catch (SAXNotRecognizedException sre) {
            xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.INVALID_DATA, sre);
            logger.debug("Encountered invalid subtag " + localName, sre);
        }
        catch (Exception e) {
            String msg = "Error reading file at " + this.currentFullName + ":" + this.currentArrayName;
            xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.FATAL_ERROR, e);
            logger.debug(msg, e);
            throw new SAXException(msg, e);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.hasError()) {
            String msg = null;
            switch (xmlErrorHandler.getErrorState()) {
                case UNKNOWN_TAG: {
                    msg = parseState == ParseState.WAITING_DATA ? "Unknown or obsolete data type <" + this.currentDataName + "> found" : (parseState == ParseState.WAITING_ARRAY ? xmlErrorHandler.getErrorCause().getMessage() : "Unknown tag <" + this.currentDataName + "> while waiting for event.");
                    xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.NO_ERROR, null);
                    break;
                }
                case INVALID_DATA: {
                    msg = "Invalid data encountered reading " + this.currentDataName;
                    xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.NO_ERROR, null);
                    break;
                }
                case IGNORED_DATA: {
                    if (!HLTIgnoredWarning) {
                        AOutput.append("\"HLTAutoKey\" data is hidden, option '-a' to see them.", "WARNING");
                        logger.warn(xmlErrorHandler.getErrorCause().getMessage());
                        HLTIgnoredWarning = true;
                    }
                    if (!localName.equals(this.currentDataName)) break;
                    xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.NO_ERROR, null);
                }
            }
            if (msg != null) {
                logger.warn(msg, xmlErrorHandler.getErrorCause());
            }
            return;
        }
        switch (parseState) {
            case WAITING_ARRAY: {
                if (localName.equals(this.currentArrayName)) {
                    if (this.arrayParser.getCount() != this.currentArraySize) {
                        xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.INVALID_DATA, new Exception("Invalid array size"));
                        String msg = "The number of data in <" + this.currentFullName + ">-<" + this.currentArrayName + "> is different than declared";
                        logger.error(msg);
                        AOutput.append("\n" + msg + "\n", "WARNING");
                        return;
                    }
                    this.parameters.put(this.currentArrayName, this.arrayParser.getArray());
                    return;
                }
                if (!localName.equals(this.currentDataName)) break;
                try {
                    if ("TILE".equals(this.currentDataName) || "LAr".equals(this.currentDataName) || "HEC".equals(this.currentDataName) || "FCAL".equals(this.currentDataName) || "MBTS".equals(this.currentDataName)) {
                        this.parameters.put("storeGateKey", null);
                    }
                    if ("PixelRDO".equals(this.currentDataName) || "SCTRDO".equals(this.currentDataName)) {
                        this.parameters.put("storeGateKey", null);
                    }
                    AEventFromXML.checkPhiRange(this.parameters, this.currentFullName);
                    if (this.currentDataName.equals("STr")) {
                        event.add(new ASVxData(ASVxData.createSVx(this.parameters), event));
                        event.add(new ASTrData(ASTrData.createSTr(this.parameters), event));
                        event.add(new ASNPData(ASNPData.createSNP(this.parameters), event));
                    } else if (this.currentDataName.equals("STC")) {
                        event.add(new ASiClusterData(this.parameters, event));
                    } else if (this.currentDataName.equals("SCTRDO")) {
                        event.add(new ASiClusterRDOData(this.parameters, event));
                    } else if (this.currentDataName.equals("PixCluster")) {
                        event.add(new APixelClusterData(this.parameters, event));
                    } else if (this.currentDataName.equals("ETMis") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "ETMis");
                        event.add(new AETMisData(this.parameters, event));
                    } else if (this.currentDataName.equals("CaloETMis")) {
                        this.parameters.put("storeGateKey", "CaloETMis");
                        event.add(new AETMisData(this.parameters, event));
                    } else if (this.currentDataName.equals("MuonETMis")) {
                        this.parameters.put("storeGateKey", "MuonETMis");
                        event.add(new AETMisData(this.parameters, event));
                    } else if (this.currentDataName.equals("Track")) {
                        String key = (String)this.parameters.get("storeGateKey");
                        if (key != null) {
                            if (key.toLowerCase().indexOf("mboy") >= 0 || key.toLowerCase().indexOf("mugirl") >= 0 || key.toLowerCase().indexOf("moore") >= 0 || key.toLowerCase().indexOf("momu") >= 0 || key.toLowerCase().indexOf("muon") >= 0 || key.toLowerCase().indexOf("staco") >= 0 || key.toLowerCase().indexOf("muid") >= 0 || key.toLowerCase().indexOf("mutag") >= 0) {
                                event.add(new AMuonTrackData(this.parameters, event));
                            } else {
                                event.add(new AInDetTrackData(this.parameters, event));
                            }
                        } else {
                            int[] trackAuthor = this.parameters.getUnsureIntArray("trackAuthor");
                            if (trackAuthor != null && trackAuthor.length > 0) {
                                if (trackAuthor[0] >= 7 && trackAuthor[0] <= 9 || trackAuthor[0] >= 13 && trackAuthor[0] <= 17) {
                                    event.add(new AMuonTrackData(this.parameters, event));
                                } else {
                                    event.add(new AInDetTrackData(this.parameters, event));
                                }
                            } else {
                                event.add(new AInDetTrackData(this.parameters, event));
                            }
                        }
                    } else if (this.currentDataName.equals("IDScan")) {
                        this.parameters.put("storeGateKey", "TrigInDetTrack");
                        event.add(new AInDetTrackData(this.parameters, event));
                    } else if (this.currentDataName.equals("iPat")) {
                        this.parameters.put("storeGateKey", "iPatTrack");
                        event.add(new AInDetTrackData(this.parameters, event));
                    } else if (this.currentDataName.equals("xKal")) {
                        this.parameters.put("storeGateKey", "xKalTrack");
                        event.add(new AInDetTrackData(this.parameters, event));
                    } else if (this.currentDataName.equals("RTr")) {
                        this.parameters.put("storeGateKey", "RTrTrack");
                        event.add(new AInDetTrackData(this.parameters, event));
                    } else if (this.currentDataName.equals("RMTr")) {
                        this.parameters.put("storeGateKey", "RMTrTrack");
                        event.add(new AMuonTrackData(this.parameters, event));
                    } else if (this.currentDataName.equals("ParticleJet") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "ParticleJet cone4");
                        event.add(new AJetData(this.parameters, event));
                    } else if (this.currentDataName.equals("Jet") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "JetRecJet");
                        event.add(new AJetData(this.parameters, event));
                    } else if (this.currentDataName.equals("MSeg")) {
                        this.parameters.put("storeGateKey", "MooreSegment");
                        float[] cotTheta = this.parameters.getFloatArray("cotTheta");
                        float[] theta = new float[cotTheta.length];
                        for (int i = 0; i < cotTheta.length; ++i) {
                            theta[i] = (float)Math.atan(1.0 / (double)cotTheta[i]);
                        }
                        this.parameters.put("theta", theta);
                        this.parameters.put("phi", this.parameters.getFloatArray("phi0"));
                        event.add(new AMuonSegmentData(this.parameters, event));
                    } else if (this.currentDataName.equals("Segment")) {
                        String key = (String)this.parameters.get("storeGateKey");
                        if (key != null) {
                            if (key.toLowerCase().indexOf("mboy") >= 0 || key.toLowerCase().indexOf("moore") >= 0 || key.toLowerCase().indexOf("momu") >= 0 || key.toLowerCase().indexOf("mdt") >= 0 || key.toLowerCase().indexOf("muon") >= 0) {
                                event.add(new AMuonSegmentData(this.parameters, event));
                            } else {
                                event.add(new AInDetSegmentData(this.parameters, event));
                            }
                        }
                    } else if (this.currentDataName.equals("Cluster") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "DefaultCluster");
                        event.add(new AClusterData(this.parameters, event));
                    } else if (this.currentDataName.equals("Electron") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "ElectronCollection");
                        event.add(new AElectronData(this.parameters, event));
                    } else if (this.currentDataName.equals("Muon") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "MuonCollection");
                        event.add(new AMuonData(this.parameters, event));
                    } else if (this.currentDataName.equals("Photon") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "PhotonCollection");
                        event.add(new APhotonData(this.parameters, event));
                    } else if (this.currentDataName.equals("BJet") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "BJetCollection");
                        event.add(new ABJetData(this.parameters, event));
                    } else if (this.currentDataName.equals("TauJet") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "TauJetCollection");
                        event.add(new ATauJetData(this.parameters, event));
                    } else if (this.currentDataName.equals("CompositeParticle") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "CompositeParticleCollection");
                        event.add(new ACompositeParticleData(this.parameters, event));
                    } else if (this.currentDataName.equals("LVL1Result") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "LVL1Result");
                        event.add(new ALVL1ResultData(this.parameters, event));
                    } else if (this.currentDataName.equals("LVL1TriggerTower") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "LVL1TriggerTower");
                        event.add(new ALVL1TriggerTowerData(this.parameters, event));
                    } else if (this.currentDataName.equals("LVL1JetElement") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "LVL1JetElement");
                        event.add(new ALVL1JetElementData(this.parameters, event));
                    } else if (this.currentDataName.equals("RPC") && "".equals(this.storeGateKey)) {
                        this.parameters.put("storeGateKey", "RPCCollection");
                        event.add(new ARPCData(this.parameters, event));
                    } else {
                        Constructor<?>[] cons = Class.forName("atlantis.data.A" + this.currentDataName + "Data").getDeclaredConstructors();
                        boolean foundConstructor = false;
                        for (Constructor<?> constructor : cons) {
                            Class<?>[] params = constructor.getParameterTypes();
                            if (params.length != 2 || !params[0].getName().endsWith("AHashMap") || !params[1].getName().endsWith("AEvent")) continue;
                            foundConstructor = true;
                            event.add((AData)constructor.newInstance(this.parameters, event));
                            break;
                        }
                        if (!foundConstructor) {
                            throw new ClassNotFoundException("Found no valid constructor for data type " + this.currentDataName);
                        }
                    }
                }
                catch (Throwable t) {
                    String msg = null;
                    if (t instanceof ClassNotFoundException) {
                        msg = "Class handling the type " + this.currentDataName + " not found";
                        xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.INVALID_DATA, t);
                    } else if (t instanceof OutOfMemoryError) {
                        msg = "Atlantis ran out of memory while\nreading in event data";
                        xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.FATAL_ERROR, t);
                    } else if (t instanceof AAtlantisException) {
                        msg = t.getMessage();
                        if (((AAtlantisException)t).isFatal()) {
                            xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.FATAL_ERROR, t);
                        } else {
                            xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.OTHER_ERROR, t);
                        }
                    } else if (t instanceof InvocationTargetException) {
                        msg = "Error when constructing " + this.currentFullName;
                        xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.OTHER_ERROR, t);
                    } else {
                        msg = "Caught exception " + t.toString() + " while constructing " + this.currentFullName;
                        xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.OTHER_ERROR, t);
                    }
                    AOutput.append("\n" + msg + "\n", "WARNING");
                    logger.error(msg, t);
                }
                if (xmlErrorHandler.getErrorState() == AXMLErrorHandler.ErrorState.FATAL_ERROR) {
                    throw new SAXException("Error parsing event at tag <" + this.currentDataName + ">", (Exception)xmlErrorHandler.getErrorCause());
                }
                xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.NO_ERROR, null);
                parseState = ParseState.WAITING_DATA;
                return;
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.hasError()) {
            return;
        }
        if (this.arrayParser == null) {
            xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.FATAL_ERROR, new NullPointerException("ArrayParser object not defined"));
            logger.error("arrayParser is NULL in SAX DefaultHandler:characters");
            return;
        }
        try {
            this.arrayParser.parse(ch, start, length);
        }
        catch (NumberFormatException nfe) {
            xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.INVALID_DATA, nfe);
            String msg = "Data in <" + this.currentFullName + ">-<" + this.currentArrayName + "> contains invalid character '" + nfe.getMessage() + "'";
            logger.error(msg);
        }
        catch (IndexOutOfBoundsException oob) {
            xmlErrorHandler.setError(AXMLErrorHandler.ErrorState.INVALID_DATA, oob);
            String msg = "The number of data in <" + this.currentFullName + ">-<" + this.currentArrayName + "> is more than declared";
            logger.error(msg);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource inputSource = null;
        if (systemId.endsWith("event.dtd")) {
            String dtdFile = Atlantis.getHomeDirectory() + "events" + Atlantis.FILE_SEPAR + "event.dtd";
            try {
                InputStream is = AUtilities.getFileAsStream(dtdFile);
                inputSource = new InputSource(is);
            }
            catch (AAtlantisException ae) {
                logger.error("reading " + dtdFile + " error: " + ae.getMessage(), ae);
            }
        }
        return inputSource;
    }

    private static void checkPhiRange(AHashMap p, String fullDataName) {
        for (String keyName : p.keySet()) {
            if (!keyName.startsWith("phi")) continue;
            float[] phi = null;
            try {
                phi = (float[])p.get(keyName);
            }
            catch (ClassCastException cce) {
                logger.warn("checkPhiRange(): Parameter array " + keyName + " in " + fullDataName + " is not a float array!");
                continue;
            }
            if (phi == null) continue;
            for (int i = 0; i < phi.length; ++i) {
                phi[i] = phi[i] % ((float)Math.PI * 2);
                if (!((double)phi[i] < 0.0)) continue;
                int n = i;
                phi[n] = (float)((double)phi[n] + Math.PI * 2);
            }
        }
    }

    static {
        event = null;
        sourceName = null;
        HLTIgnoredWarning = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParseState {
        WAITING_EVENT,
        WAITING_DATA,
        WAITING_ARRAY;

    }
}

