/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.data.ACalorimeterData;
import atlantis.data.ACalorimeterRPSPLT;
import atlantis.data.AHistogram;
import atlantis.event.AEvent;
import atlantis.geometry.ACalorimeterDetector;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionYX;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AIdHelper;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import atlantis.utils.AUtilities;
import com.Ostermiller.util.CSVParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class AFCALData
extends ACalorimeterData {
    private static ALogger logger = ALogger.getLogger(AFCALData.class);
    protected float[] x;
    protected float[] y;
    protected float[] z;
    protected float[] r;
    protected float[] dx;
    protected float[] dy;
    protected float[] dz;
    protected float[] dr;
    private int[][] cellTable;
    private int numSamplings = 0;
    private int[][] adcCounts = null;
    private float[] cellTime = null;
    private int[] cellGain = null;
    private float[] cellPedestal = null;
    private float[] adc2Mev = null;
    private static boolean pulseShapesDataAvailable = false;
    private static final String LOOKUP_TABLE_FILE = Atlantis.getHomeDirectory() + "configuration" + Atlantis.FILE_SEPAR + "rpsplt_fcal.csv";
    private static final short NUMBER_OF_LOOKUP_VALUES = 600;

    AFCALData(AHashMap p, AEvent e) {
        super(p, e);
        int i;
        int i2;
        this.x = p.getFloatArray("x");
        this.dx = p.getFloatArray("dx");
        this.y = p.getFloatArray("y");
        this.dy = p.getFloatArray("dy");
        this.r = new float[this.numData];
        this.dr = new float[this.numData];
        this.cellTable = new int[this.MAX_HIT_INDEX][this.MAX_HIT_INDEX];
        for (i2 = 0; i2 < this.numData; ++i2) {
            try {
                this.side[i2] = (byte)AIdHelper.larPosNeg(this.id[i2]);
                this.etaIndex[i2] = (short)AIdHelper.larEta(this.id[i2]);
                this.phiIndex[i2] = (short)AIdHelper.larPhi(this.id[i2]);
                this.sampling[i2] = AIdHelper.larSampling(this.id[i2]);
                continue;
            }
            catch (AAtlantisException ex) {
                logger.error("Problem decoding ID " + this.id[i2] + " in " + this.CALORIMETER_NAME + ": " + ex.getMessage());
                this.side[i2] = 0;
                this.etaIndex[i2] = -1;
                this.phiIndex[i2] = -1;
                this.sampling[i2] = -1;
            }
        }
        if (p.get("z") == null || p.get("dz") == null) {
            this.z = new float[this.numData];
            this.dz = new float[this.numData];
            block8: for (i2 = 0; i2 < this.numData; ++i2) {
                switch (this.sampling[i2]) {
                    case 0: {
                        this.z[i2] = (float)(this.side[i2] / Math.abs(this.side[i2])) * 489.4f;
                        this.dz[i2] = 45.2f;
                        continue block8;
                    }
                    case 1: {
                        this.z[i2] = (float)(this.side[i2] / Math.abs(this.side[i2])) * 534.8f;
                        this.dz[i2] = 45.0f;
                        continue block8;
                    }
                    case 2: {
                        this.z[i2] = (float)(this.side[i2] / Math.abs(this.side[i2])) * 582.2f;
                        this.dz[i2] = 45.0f;
                    }
                }
            }
        } else {
            this.z = p.getFloatArray("z");
            this.dz = p.getFloatArray("dz");
        }
        float drMin = 0.0f;
        float zMin = 0.0f;
        float zMax = 0.0f;
        float rMin = 0.0f;
        float rMax = 0.0f;
        for (i = 0; i < this.numData; ++i) {
            this.sub[i] = this.side[i] < 0 ? 0 : 1;
            float etaMin = (float)AMath.etaAbs(this.z[i], Math.sqrt(Math.pow(Math.abs(this.x[i]) - this.dx[i], 2.0) + Math.pow(Math.abs(this.y[i]) - this.dy[i], 2.0)));
            float etaMax = (float)AMath.etaAbs(this.z[i], Math.sqrt(Math.pow(Math.abs(this.x[i]) + this.dx[i], 2.0) + Math.pow(Math.abs(this.y[i]) + this.dy[i], 2.0)));
            this.eta[i] = (etaMin + etaMax) / 2.0f;
            this.deta[i] = Math.abs(etaMax - etaMin);
            this.phi[i] = (float)Math.atan2(this.y[i], this.x[i]);
            this.dphi[i] = (float)Math.abs(Math.atan2(this.y[i] + this.dy[i], this.x[i] - this.dx[i]) - Math.atan2(this.y[i] - this.dy[i], this.x[i] + this.dx[i]));
            if (this.phi[i] < 0.0f) {
                int n = i;
                this.phi[n] = (float)((double)this.phi[n] + Math.PI * 2);
            }
            this.r[i] = (float)Math.sqrt(this.x[i] * this.x[i] + this.y[i] * this.y[i]);
            this.dr[i] = (float)Math.sqrt(this.dx[i] * this.dx[i] + this.dy[i] * this.dy[i]);
            if ((double)rMin == 0.0 || (double)Math.abs(this.r[i]) - (double)this.dr[i] / 2.0 < (double)rMin) {
                rMin = Math.abs(this.r[i]) - this.dr[i] / 2.0f;
            }
            if ((double)rMax == 0.0 || (double)Math.abs(this.r[i]) + (double)this.dr[i] / 2.0 > (double)rMax) {
                rMax = Math.abs(this.r[i]) + this.dr[i] / 2.0f;
            }
            if ((double)zMax == 0.0 || (double)Math.abs(this.z[i]) + (double)this.dz[i] / 2.0 > (double)zMax) {
                zMax = Math.abs(this.z[i]) + this.dz[i] / 2.0f;
            }
            if ((double)zMin == 0.0 || (double)Math.abs(this.z[i]) - (double)this.dz[i] / 2.0 < (double)zMin) {
                zMin = Math.abs(this.z[i]) - this.dz[i] / 2.0f;
            }
            if ((double)drMin != 0.0 && !(this.dr[i] < drMin)) continue;
            drMin = this.dr[i];
        }
        this.etaGranularity = AMath.eta(zMin, rMax - drMin) - AMath.eta(zMin, rMax);
        this.outerEta = AMath.eta(zMax, rMin);
        for (i = 0; i < ACalorimeterDetector.count(); ++i) {
            if (this.outerR == 0.0 || ACalorimeterDetector.get(i).getRMax() > this.outerR) {
                this.outerR = ACalorimeterDetector.get(i).getRMax();
            }
            if (this.outerZ != 0.0 && !(ACalorimeterDetector.get(i).getZMax() > this.outerZ)) continue;
            this.outerZ = ACalorimeterDetector.get(i).getZMax();
        }
        for (i = 0; i < this.et.length; ++i) {
            this.et[i] = Math.abs(this.energy[i] / (float)Math.cosh(this.eta[i]));
        }
        this.readPulseShapePlotData(p);
    }

    private void readLookupTableFile() throws AAtlantisException {
        try {
            InputStream is = AUtilities.getFileAsStream(LOOKUP_TABLE_FILE);
            CSVParser parser = new CSVParser(is);
            parser.setCommentStart("#");
            String arrayName = null;
            while ((arrayName = parser.nextValue()) != null) {
                String valueArray = parser.nextValue();
                CSVParser parserArray = new CSVParser((Reader)new StringReader(valueArray));
                String[][] s = parserArray.getAllValues();
                if ("FCAL_LAYER0_AMPLITUDE".equals(arrayName)) {
                    ACalorimeterRPSPLT.FCAL_LAYER0_AMPLITUDE = AFCALData.getLookupTableArray(s, 600);
                    continue;
                }
                if ("FCAL_LAYER1_AMPLITUDE".equals(arrayName)) {
                    ACalorimeterRPSPLT.FCAL_LAYER1_AMPLITUDE = AFCALData.getLookupTableArray(s, 600);
                    continue;
                }
                if ("FCAL_LAYER2_AMPLITUDE".equals(arrayName)) {
                    ACalorimeterRPSPLT.FCAL_LAYER2_AMPLITUDE = AFCALData.getLookupTableArray(s, 600);
                    continue;
                }
                if (!"FCAL_TIME".equals(arrayName)) continue;
                ACalorimeterRPSPLT.FCAL_TIME = AFCALData.getLookupTableArray(s, 600);
            }
        }
        catch (FileNotFoundException e) {
            throw new AAtlantisException("could not find file: " + LOOKUP_TABLE_FILE);
        }
        catch (IOException e) {
            throw new AAtlantisException("exception while reading file: " + LOOKUP_TABLE_FILE);
        }
        catch (AAtlantisException e) {
            throw e;
        }
    }

    private void readPulseShapePlotData(AHashMap p) {
        this.adcCounts = super.getADCCountsData(p);
        this.cellTime = p.get("cellTime") != null ? p.getFloatArray("cellTime") : null;
        this.cellGain = p.get("cellGain") != null ? p.getIntArray("cellGain") : null;
        this.cellPedestal = p.get("cellPedestal") != null ? p.getFloatArray("cellPedestal") : null;
        this.adc2Mev = p.get("adc2Mev") != null ? p.getFloatArray("adc2Mev") : null;
        pulseShapesDataAvailable = false;
        if (this.adcCounts != null && this.cellTime != null && this.cellGain != null && this.cellPedestal != null && this.adc2Mev != null) {
            pulseShapesDataAvailable = true;
            this.numSamplings = this.adcCounts[0].length;
            logger.debug(this.CALORIMETER_NAME + ": data for real pulse shape plots available");
            if (ACalorimeterRPSPLT.areFCALLookupTablesInitialized()) {
                logger.debug(this.CALORIMETER_NAME + ": lookup tables have already been read in");
            } else {
                logger.debug(this.CALORIMETER_NAME + ": lookup table values have not been read in yet\n" + "  trying to read file: " + LOOKUP_TABLE_FILE);
                try {
                    this.readLookupTableFile();
                    logger.debug(this.CALORIMETER_NAME + ": values from " + LOOKUP_TABLE_FILE + " successfully read in");
                }
                catch (AAtlantisException ex) {
                    logger.debug(this.CALORIMETER_NAME + ": reading " + LOOKUP_TABLE_FILE + " failed, real pulse shapes plots will not " + "be available, reason: " + ex.getMessage(), ex);
                    pulseShapesDataAvailable = false;
                }
            }
        }
    }

    public String getParameterGroup() {
        return "FCAL";
    }

    public String getName() {
        return "FCAL";
    }

    public String getNameScreenName() {
        return "FCAL";
    }

    public String getCalorimeterType(int index) {
        if (this.sampling[index] == 0) {
            return "ECAL";
        }
        return "HCAL";
    }

    public boolean[] expandDrawn(boolean[] drawn) {
        AProjection projection = ACanvas.getCanvas().getCurrentWindow().getProjection();
        if (projection instanceof AProjectionYX) {
            return this.expandDrawnYX(drawn);
        }
        if (projection instanceof AProjectionRZ) {
            return this.expandDrawnRZ(drawn);
        }
        return drawn;
    }

    protected void filterDrawListYX() {
        int j;
        int i;
        float[][] etTable = new float[this.MAX_HIT_INDEX][this.MAX_HIT_INDEX];
        for (i = 0; i < this.MAX_HIT_INDEX; ++i) {
            for (j = 0; j < this.MAX_HIT_INDEX; ++j) {
                this.cellTable[i][j] = -1;
                etTable[i][j] = 0.0f;
            }
        }
        for (i = 0; i < this.numDraw; ++i) {
            j = this.listdl[i];
            short eta = this.etaIndex[j];
            short phi = this.phiIndex[j];
            float[] fArray = etTable[eta];
            short s = phi;
            fArray[s] = fArray[s] + this.et[j];
            if (this.cellTable[eta][phi] >= 0 && !(this.et[this.cellTable[eta][phi]] < this.et[j])) continue;
            this.cellTable[eta][phi] = j;
        }
        this.numDraw = 0;
        for (i = 0; i < this.MAX_HIT_INDEX; ++i) {
            for (j = 0; j < this.MAX_HIT_INDEX; ++j) {
                if (this.cellTable[i][j] <= 0) continue;
                this.listdl[this.numDraw] = this.cellTable[i][j];
                this.etSum[this.listdl[this.numDraw]] = etTable[i][j];
                ++this.numDraw;
            }
        }
    }

    private boolean[] expandDrawnYX(boolean[] drawn) {
        this.makeDrawList();
        int mode = APar.get("YX", "Mode").getI();
        if (APar.get("YX", "DrawFCAL").getStatus() && mode >= 17 && mode <= 19) {
            this.cutArray(this.sampling, mode - 17, "Layer");
        } else if (mode >= 9 || mode <= 11) {
            this.cutArray(this.sampling, mode - 9, "Layer");
        } else {
            return drawn;
        }
        for (int i = 0; i < this.numDraw; ++i) {
            int mappedTo;
            int j = this.listdl[i];
            if (drawn[j]) continue;
            short eta = this.etaIndex[j];
            short phi = this.phiIndex[j];
            if (eta < 0 || phi < 0 || (mappedTo = this.cellTable[eta][phi]) < 0 || !drawn[mappedTo]) continue;
            drawn[j] = true;
        }
        return drawn;
    }

    protected void filterDrawListRZ() {
        int i;
        boolean[] available = new boolean[this.numDraw];
        int numCells = this.numDraw;
        int newNumDraw = 0;
        for (i = 0; i < this.numDraw; ++i) {
            available[i] = true;
        }
        for (i = 0; i < this.numData; ++i) {
            this.etSum[i] = 0.0f;
        }
        while (numCells > 0) {
            int i2;
            int max = -1;
            for (i2 = 0; i2 < this.numDraw; ++i2) {
                if (!available[i2] || max >= 0 && !(this.et[this.listdl[i2]] > this.et[this.listdl[max]])) continue;
                max = i2;
            }
            available[max] = false;
            --numCells;
            this.listdl[newNumDraw++] = this.listdl[max];
            for (i2 = 0; i2 < this.numDraw; ++i2) {
                double rDist;
                int j;
                double zDist;
                if (!available[i2] || (zDist = (double)Math.abs(this.z[j = this.listdl[i2]] - this.z[this.listdl[max]])) >= (double)(this.dz[j] + this.dz[this.listdl[max]]) / 2.0 || (rDist = (double)Math.abs(this.r[j] - this.r[this.listdl[max]])) >= (double)(this.dr[j] + this.dr[this.listdl[max]]) / 2.0 || AMath.getRhoSign(this.x[j], this.y[j]) != AMath.getRhoSign(this.x[this.listdl[max]], this.y[this.listdl[max]])) continue;
                available[i2] = false;
                int n = this.listdl[max];
                this.etSum[n] = this.etSum[n] + this.et[j];
                --numCells;
            }
        }
        this.numDraw = newNumDraw;
    }

    private boolean[] expandDrawnRZ(boolean[] drawn) {
        this.makeDrawList();
        boolean[] available = new boolean[this.numDraw];
        int numCells = this.numDraw;
        for (int i = 0; i < this.numDraw; ++i) {
            available[i] = true;
        }
        while (numCells > 0) {
            int i;
            int max = -1;
            for (i = 0; i < this.numDraw; ++i) {
                if (!available[i] || max >= 0 && !(this.et[this.listdl[i]] > this.et[this.listdl[max]])) continue;
                max = i;
            }
            available[max] = false;
            --numCells;
            for (i = 0; i < this.numDraw; ++i) {
                double rDist;
                int j;
                double zDist;
                if (!available[i] || (zDist = (double)Math.abs(this.z[j = this.listdl[i]] - this.z[this.listdl[max]])) >= (double)(this.dz[j] + this.dz[this.listdl[max]]) / 2.0 || (rDist = (double)Math.abs(this.r[j] - this.r[this.listdl[max]])) >= (double)(this.dr[j] + this.dr[this.listdl[max]]) / 2.0 || AMath.getRhoSign(this.x[j], this.y[j]) != AMath.getRhoSign(this.x[this.listdl[max]], this.y[this.listdl[max]])) continue;
                available[i] = false;
                if (drawn[this.listdl[max]]) {
                    drawn[j] = true;
                }
                --numCells;
            }
        }
        return drawn;
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        int mode = APar.get("YX", "Mode").getI();
        if (APar.get("YX", "DrawFCAL").getStatus() && mode >= 17 && mode <= 19) {
            this.cutArray(this.sampling, mode - 17, "Layer");
        } else if (mode >= 9 || mode <= 11) {
            this.cutArray(this.sampling, mode - 9, "Layer");
        } else {
            return ACoord.NO_DATA;
        }
        this.filterDrawListYX();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            double xMin = (double)this.x[j] - (double)this.dx[j] / 2.0;
            double xMax = (double)this.x[j] + (double)this.dx[j] / 2.0;
            double yMin = (double)this.y[j] - (double)this.dy[j] / 2.0;
            double yMax = (double)this.y[j] + (double)this.dy[j] / 2.0;
            hv[0][i] = new double[]{xMax, xMin, xMin, xMax};
            hv[1][i] = new double[]{yMax, yMax, yMin, yMin};
            index[i] = j;
        }
        return new ACoord(hv, index, (ADrawable)this);
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        this.filterDrawListRZ();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            double zMin = (double)this.z[j] - (double)this.dz[j] / 2.0;
            double zMax = (double)this.z[j] + (double)this.dz[j] / 2.0;
            double rMin = Math.sqrt(Math.pow((double)Math.abs(this.x[j]) - Math.abs((double)this.dx[j] / 2.0), 2.0) + Math.pow((double)Math.abs(this.y[j]) - Math.abs((double)this.dy[j] / 2.0), 2.0));
            double rMax = Math.sqrt(Math.pow((double)Math.abs(this.x[j]) + Math.abs((double)this.dx[j] / 2.0), 2.0) + Math.pow((double)Math.abs(this.y[j]) + Math.abs((double)this.dy[j] / 2.0), 2.0));
            double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
            double phiDiff = Math.abs((double)this.phi[j] - phiMid);
            if (phiDiff > 1.5707963267948966 && phiDiff <= 4.71238898038469) {
                rMin *= -1.0;
                rMax *= -1.0;
            }
            hv[0][i] = new double[]{zMax, zMin, zMin, zMax};
            hv[1][i] = new double[]{rMax, rMax, rMin, rMin};
            index[i] = j;
        }
        return new ACoord(hv, index, (ADrawable)this);
    }

    protected void applyCuts() {
        super.applyCuts();
        this.cut("CutsCalo", "FCALET", "FCALET", this.et);
        this.cut("CutsCalo", "FCALEnergy", "FCALEnergy", this.energy);
        int cutSub = APar.get("CutsCalo", "FCAL").getI();
        if (cutSub != -1) {
            this.cutArray(this.sub, cutSub, "Endcap");
        }
    }

    public ACoord getFRUser() {
        return this.getYXUser().convertYXToFR().includePhiWrapAround("FR");
    }

    protected ACoord getVPUser() {
        this.makeDrawList();
        switch (APar.get("VP", "Mode").getI()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.cutArray(this.sampling, 0, "EM");
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.cutArrayOR(this.sampling, 1, 2, "Hadronic");
                break;
            }
            default: {
                return ACoord.NO_DATA;
            }
        }
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            this.etSum[j] = this.et[j];
            double eta0 = AMath.etaAbs(this.z[j], (float)Math.sqrt(Math.pow((double)this.x[j] + (double)this.dx[j] / 2.0, 2.0) + Math.pow((double)this.y[j] + (double)this.dy[j] / 2.0, 2.0)));
            double eta1 = AMath.etaAbs(this.z[j], (float)Math.sqrt(Math.pow((double)this.x[j] - (double)this.dx[j] / 2.0, 2.0) + Math.pow((double)this.y[j] + (double)this.dy[j] / 2.0, 2.0)));
            double eta2 = AMath.etaAbs(this.z[j], (float)Math.sqrt(Math.pow((double)this.x[j] - (double)this.dx[j] / 2.0, 2.0) + Math.pow((double)this.y[j] - (double)this.dy[j] / 2.0, 2.0)));
            double eta3 = AMath.etaAbs(this.z[j], (float)Math.sqrt(Math.pow((double)this.x[j] + (double)this.dx[j] / 2.0, 2.0) + Math.pow((double)this.y[j] - (double)this.dy[j] / 2.0, 2.0)));
            double phi0 = Math.toDegrees(Math.atan2((double)this.y[j] + (double)this.dy[j] / 2.0, (double)this.x[j] + (double)this.dx[j] / 2.0) + 360.0) % 360.0;
            double phi1 = Math.toDegrees(Math.atan2((double)this.y[j] + (double)this.dy[j] / 2.0, (double)this.x[j] - (double)this.dx[j] / 2.0) + 360.0) % 360.0;
            double phi2 = Math.toDegrees(Math.atan2((double)this.y[j] - (double)this.dy[j] / 2.0, (double)this.x[j] - (double)this.dx[j] / 2.0) + 360.0) % 360.0;
            double phi3 = Math.toDegrees(Math.atan2((double)this.y[j] - (double)this.dy[j] / 2.0, (double)this.x[j] + (double)this.dx[j] / 2.0) + 360.0) % 360.0;
            if (phi1 - phi0 > 180.0) {
                phi1 -= 360.0;
            } else if (phi0 - phi1 > 180.0) {
                phi1 += 360.0;
            }
            if (phi2 - phi1 > 180.0) {
                phi2 -= 360.0;
            } else if (phi1 - phi2 > 180.0) {
                phi2 += 360.0;
            }
            if (phi3 - phi2 > 180.0) {
                phi3 -= 360.0;
            } else if (phi2 - phi3 > 180.0) {
                phi3 += 360.0;
            }
            hv[0][i] = new double[]{eta0, eta1, eta2, eta3};
            hv[1][i] = new double[]{phi0, phi1, phi2, phi3};
            index[i] = j;
        }
        return new ACoord(hv, index, (ADrawable)this).includePhiWrapAround("VP");
    }

    public ACoord[] getRZHistograms() {
        AHistogram histUp = new AHistogram(-this.outerEta, this.outerEta, this.etaGranularity, this.histoScale.getD(), this);
        AHistogram histDown = new AHistogram(-this.outerEta, this.outerEta, this.etaGranularity, this.histoScale.getD(), this);
        for (int i = 0; i < this.numDraw; ++i) {
            double etaMax;
            double etaMin;
            int j = this.listdl[i];
            int sign = AMath.getRhoSign(this.x[j], this.y[j]);
            if (this.side[j] < 0) {
                etaMin = AMath.eta(this.z[j] + this.dz[j] / 2.0f, this.r[j] - this.dr[j] / 2.0f);
                etaMax = AMath.eta(this.z[j] - this.dz[j] / 2.0f, this.r[j] + this.dr[j] / 2.0f);
            } else {
                etaMin = AMath.eta(this.z[j] - this.dz[j] / 2.0f, this.r[j] + this.dr[j] / 2.0f);
                etaMax = AMath.eta(this.z[j] + this.dz[j] / 2.0f, this.r[j] - this.dr[j] / 2.0f);
            }
            if (sign > 0) {
                histUp.fill(etaMin, etaMax, this.etSum[j]);
                continue;
            }
            histDown.fill(etaMin, etaMax, this.etSum[j]);
        }
        ACalorimeterData.ACoordArray c = new ACalorimeterData.ACoordArray();
        c.add(histUp.getRZUser(this.outerZ, this.outerR, 0));
        c.add(histDown.getRZUser(this.outerZ, this.outerR, 1));
        return c.getArray();
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n ET=" + AMath.d2s(this.et[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Ex=" + AMath.d2s((double)this.et[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Ey=" + AMath.d2s((double)this.et[index] * Math.sin(this.phi[index]), 3) + " GeV " + "\n Ez=" + AMath.d2s((double)this.et[index] * Math.sinh(this.eta[index]), 3) + " GeV ";
            }
            return output;
        }
        String t = "";
        String cellInfo = "";
        t = super.getHitInfo(index);
        cellInfo = cellInfo + "\n x  = " + this.x[index] + " cm";
        cellInfo = cellInfo + "\n y  = " + this.y[index] + " cm";
        cellInfo = cellInfo + "\n cell time = ";
        cellInfo = cellInfo + (this.cellTime != null ? Float.toString(this.cellTime[index]) + " ns" : "n/a");
        cellInfo = cellInfo + "\n cell gain = ";
        cellInfo = cellInfo + (this.cellGain != null ? Integer.toString(this.cellGain[index]) : "n/a");
        cellInfo = cellInfo + "\n cell pedestal = ";
        cellInfo = cellInfo + (this.cellPedestal != null ? Float.toString(this.cellPedestal[index]) + " ADC counts" : "n/a");
        cellInfo = cellInfo + "\n ADC 2 MeV = ";
        cellInfo = this.adc2Mev == null ? cellInfo + "n/a" : (this.adc2Mev[index] != -1.0f ? cellInfo + Float.toString(this.adc2Mev[index]) + " (from database)" : cellInfo + "-1 (n/a in database)");
        cellInfo = cellInfo + (pulseShapesDataAvailable ? "" : "\n data for real pulse shapes plot n/a");
        return t + cellInfo;
    }

    protected double getTime(int hit) {
        if (this.cellTime == null) {
            return 0.0;
        }
        return this.cellTime[hit];
    }

    public double getEta(int index) {
        if (!APar.get("VP", "EtaVertex").getStatus()) {
            return this.eta[index];
        }
        return AMath.eta(this.z[index], Math.sqrt(this.x[index] * this.x[index] + this.y[index] * this.y[index]));
    }

    protected ACoord[] getUserHistograms(AProjection2D projection) {
        ACoord[] data = ACoord.NO_HISTOGRAMS;
        if (projection instanceof AProjectionRZ) {
            data = this.getRZHistograms();
        }
        return projection.nonLinearTransform(data);
    }

    protected int[][] getADCCounts(int index) {
        if (pulseShapesDataAvailable) {
            return new int[][]{this.adcCounts[index]};
        }
        return null;
    }

    protected double getLocalTime(double xTime, double cellTime, int numSamplings) {
        int nominalPeakSample = (int)((double)numSamplings / 2.0);
        return (xTime - (double)nominalPeakSample + 3.0) * 25.0 - cellTime;
    }

    protected double[][] getPulseShape(int index) {
        float[] time = ACalorimeterRPSPLT.FCAL_TIME;
        float[] amplitude = null;
        switch (this.sampling[index]) {
            case 0: {
                amplitude = ACalorimeterRPSPLT.FCAL_LAYER0_AMPLITUDE;
                break;
            }
            case 1: {
                amplitude = ACalorimeterRPSPLT.FCAL_LAYER1_AMPLITUDE;
                break;
            }
            case 2: {
                amplitude = ACalorimeterRPSPLT.FCAL_LAYER2_AMPLITUDE;
                break;
            }
            default: {
                AOutput.append("\nADC counts plot only, pulse shape plot not implemented for " + this.CALORIMETER_NAME + " layer " + this.sampling[index] + "\n", "WARNING");
                return null;
            }
        }
        double step = this.getPulseStep(index);
        double[][] realPulse = new double[1][600];
        double d = 1.0;
        float factor = this.adc2Mev[index];
        double energyLocal = (double)this.energy[index] * 1000.0 / (double)factor;
        try {
            if (factor != -1.0f) {
                for (int i = 0; i < 600; ++i) {
                    double localTime = this.getLocalTime(d += step, this.cellTime[index], this.numSamplings);
                    realPulse[0][i] = super.getPhysicsPulseShape(localTime, this.cellPedestal[index], energyLocal, amplitude, time, 600);
                }
            }
        }
        catch (AAtlantisException aaex) {
            AOutput.append(aaex.getMessage(), "WARNING");
            return null;
        }
        if (factor != -1.0f) {
            logger.debug("adc2Mev factor available, plotting full plot.");
            return realPulse;
        }
        logger.debug("adc2Mev factor not available, plotting just adc counts.");
        return null;
    }

    protected double getPulseStep(int index) {
        return (float)(this.adcCounts[0].length - 1) / 600.0f;
    }
}

