/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.ACalorimeterData;
import atlantis.data.ACalorimeterRPSPLT;
import atlantis.event.AEvent;
import atlantis.geometry.ACalorimeterDetector;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionYX;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AIdHelper;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import atlantis.utils.AUtilities;
import com.Ostermiller.util.CSVParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class AHECData
extends ACalorimeterData {
    private static ALogger logger = ALogger.getLogger(AHECData.class);
    private int numSamplings = 0;
    private int[][] adcCounts = null;
    private float[] cellTime = null;
    private int[] cellGain = null;
    private float[] cellPedestal = null;
    private float[] adc2Mev = null;
    private static boolean pulseShapesDataAvailable = false;
    private static final String LOOKUP_TABLE_FILE = Atlantis.getHomeDirectory() + "configuration" + Atlantis.FILE_SEPAR + "rpsplt_hec.csv";
    private static final short NUMBER_OF_LOOKUP_VALUES = 800;

    AHECData(AHashMap p, AEvent e) {
        super(p, e);
        int i;
        for (i = 0; i < this.numData; ++i) {
            try {
                this.side[i] = (byte)AIdHelper.larPosNeg(this.id[i]);
                this.etaIndex[i] = (short)AIdHelper.larEta(this.id[i]);
                this.phiIndex[i] = (short)AIdHelper.larPhi(this.id[i]);
                this.sampling[i] = AIdHelper.larSampling(this.id[i]);
                continue;
            }
            catch (AAtlantisException ex) {
                logger.error("Problem decoding ID " + this.id[i] + " in " + this.CALORIMETER_NAME + ": " + ex.getMessage());
                this.side[i] = 0;
                this.etaIndex[i] = -1;
                this.phiIndex[i] = -1;
                this.sampling[i] = -1;
            }
        }
        this.makeHitToGeometryMapping();
        for (i = 0; i < this.et.length; ++i) {
            this.et[i] = Math.abs(this.energy[i] / (float)Math.cosh(this.eta[i]));
        }
        for (i = 0; i < ACalorimeterDetector.count(); ++i) {
            if (ACalorimeterDetector.get(i).getName().indexOf(this.CALORIMETER_NAME) >= 0) {
                if (this.innerR == 0.0 || ACalorimeterDetector.get(i).getRMin() < this.innerR) {
                    this.innerR = ACalorimeterDetector.get(i).getRMin();
                }
                if (this.innerZ == 0.0 || ACalorimeterDetector.get(i).getZMin() < this.innerZ) {
                    this.innerZ = ACalorimeterDetector.get(i).getZMin();
                }
                if (this.phiGranularity == 0.0 || ACalorimeterDetector.get(i).getDeltaPhi() < this.phiGranularity) {
                    this.phiGranularity = ACalorimeterDetector.get(i).getDeltaPhi();
                }
                if (this.etaGranularity == 0.0 || ACalorimeterDetector.get(i).getDeltaEta() < this.etaGranularity) {
                    this.etaGranularity = ACalorimeterDetector.get(i).getDeltaEta();
                }
                if (this.outerEta == 0.0 || ACalorimeterDetector.get(i).getEtaMax() > this.outerEta) {
                    this.outerEta = ACalorimeterDetector.get(i).getEtaMax();
                }
            }
            if (this.outerR == 0.0 || ACalorimeterDetector.get(i).getRMax() > this.outerR) {
                this.outerR = ACalorimeterDetector.get(i).getRMax();
            }
            if (this.outerZ != 0.0 && !(ACalorimeterDetector.get(i).getZMax() > this.outerZ)) continue;
            this.outerZ = ACalorimeterDetector.get(i).getZMax();
        }
        this.outerEta += this.etaGranularity;
        this.readPulseShapePlotData(p);
    }

    private void readPulseShapePlotData(AHashMap p) {
        this.adcCounts = super.getADCCountsData(p);
        this.cellTime = p.get("cellTime") != null ? p.getFloatArray("cellTime") : null;
        this.cellGain = p.get("cellGain") != null ? p.getIntArray("cellGain") : null;
        this.cellPedestal = p.get("cellPedestal") != null ? p.getFloatArray("cellPedestal") : null;
        this.adc2Mev = p.get("adc2Mev") != null ? p.getFloatArray("adc2Mev") : null;
        pulseShapesDataAvailable = false;
        if (this.adcCounts != null && this.cellTime != null && this.cellGain != null && this.cellPedestal != null && this.adc2Mev != null) {
            pulseShapesDataAvailable = true;
            this.numSamplings = this.adcCounts[0].length;
            logger.debug(this.CALORIMETER_NAME + ": data for real pulse shape plots available");
            if (ACalorimeterRPSPLT.areHECLookupTablesInitialized()) {
                logger.debug(this.CALORIMETER_NAME + ": lookup tables have already been read in");
            } else {
                logger.debug(this.CALORIMETER_NAME + ": lookup table values have not been read in yet\n" + "  trying to read file: " + LOOKUP_TABLE_FILE);
                try {
                    this.readLookupTableFile();
                    logger.debug(this.CALORIMETER_NAME + ": values from " + LOOKUP_TABLE_FILE + " successfully read in");
                }
                catch (AAtlantisException ex) {
                    logger.debug(this.CALORIMETER_NAME + ": reading " + LOOKUP_TABLE_FILE + " failed, real pulse shapes plots will not " + "be available, reason: " + ex.getMessage(), ex);
                    pulseShapesDataAvailable = false;
                }
            }
        }
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n ET=" + AMath.d2s(this.et[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Ex=" + AMath.d2s((double)this.et[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Ey=" + AMath.d2s((double)this.et[index] * Math.sin(this.phi[index]), 3) + " GeV " + "\n Ez=" + AMath.d2s((double)this.et[index] * Math.sinh(this.eta[index]), 3) + " GeV ";
            }
            return output;
        }
        String t = "";
        String cellInfo = "";
        t = super.getHitInfo(index);
        cellInfo = cellInfo + "\n cell time = ";
        cellInfo = cellInfo + (this.cellTime != null ? Float.toString(this.cellTime[index]) + " ns" : "n/a");
        cellInfo = cellInfo + "\n cell gain = ";
        cellInfo = cellInfo + (this.cellGain != null ? Integer.toString(this.cellGain[index]) : "n/a");
        cellInfo = cellInfo + "\n cell pedestal = ";
        cellInfo = cellInfo + (this.cellPedestal != null ? Float.toString(this.cellPedestal[index]) + " ADC counts" : "n/a");
        cellInfo = cellInfo + "\n ADC 2 MeV = ";
        cellInfo = this.adc2Mev == null ? cellInfo + "n/a" : (this.adc2Mev[index] != -1.0f ? cellInfo + Float.toString(this.adc2Mev[index]) + " (from database)" : cellInfo + "-1 (n/a in database)");
        cellInfo = cellInfo + (pulseShapesDataAvailable ? "" : "\n data for real pulse shapes plot n/a");
        return t + cellInfo;
    }

    protected double getTime(int hit) {
        if (this.cellTime == null) {
            return 0.0;
        }
        return this.cellTime[hit];
    }

    private void readLookupTableFile() throws AAtlantisException {
        try {
            InputStream is = AUtilities.getFileAsStream(LOOKUP_TABLE_FILE);
            CSVParser parser = new CSVParser(is);
            parser.setCommentStart("#");
            String arrayName = null;
            while ((arrayName = parser.nextValue()) != null) {
                String valueArray = parser.nextValue();
                CSVParser parserArray = new CSVParser((Reader)new StringReader(valueArray));
                String[][] s = parserArray.getAllValues();
                if ("HEC_AMPLITUDE".equals(arrayName)) {
                    ACalorimeterRPSPLT.HEC_AMPLITUDE = AHECData.getLookupTableArray(s, 800);
                    continue;
                }
                if (!"HEC_TIME".equals(arrayName)) continue;
                ACalorimeterRPSPLT.HEC_TIME = AHECData.getLookupTableArray(s, 800);
            }
        }
        catch (FileNotFoundException e) {
            throw new AAtlantisException("could not find file: " + LOOKUP_TABLE_FILE);
        }
        catch (IOException e) {
            throw new AAtlantisException("exception while reading file: " + LOOKUP_TABLE_FILE);
        }
        catch (AAtlantisException e) {
            throw e;
        }
    }

    protected void applyCuts() {
        super.applyCuts();
        this.cut("CutsCalo", "HECET", "HECET", this.et);
        this.cut("CutsCalo", "HECEnergy", "HECEnergy", this.energy);
        int cutSub = APar.get("CutsCalo", "HEC").getI();
        if (cutSub != -1) {
            this.cutArray(this.side, cutSub, "Endcap");
        }
    }

    public String getParameterGroup() {
        return "HEC";
    }

    public String getName() {
        return "HEC";
    }

    public String getNameScreenName() {
        return "HEC";
    }

    public String getCalorimeterType(int index) {
        return "HCAL";
    }

    protected ACoord[] getUserHistograms(AProjection2D projection) {
        ACoord[] data = ACoord.NO_HISTOGRAMS;
        int mode = APar.get("YX", "Mode").getI();
        if (projection instanceof AProjectionRZ) {
            data = this.getRZHistograms();
        } else if (projection instanceof AProjectionFZ) {
            data = this.getFZHistograms();
        } else if (projection instanceof AProjectionYX && (mode == 16 || mode == 17 || mode == 18 || mode == 19 || mode == 21)) {
            data = this.getYXHistograms();
        }
        return projection.nonLinearTransform(data);
    }

    protected int[][] getADCCounts(int index) {
        if (pulseShapesDataAvailable) {
            return new int[][]{this.adcCounts[index]};
        }
        return null;
    }

    protected double getLocalTime(double xTime, double cellTime, int numSamplings) {
        int nominalPeakSample = (int)((double)numSamplings / 2.0);
        return (xTime - (double)nominalPeakSample + 3.0) * 25.0 - cellTime;
    }

    protected double[][] getPulseShape(int index) {
        float[] time = ACalorimeterRPSPLT.HEC_TIME;
        float[] amplitude = ACalorimeterRPSPLT.HEC_AMPLITUDE;
        double step = this.getPulseStep(index);
        double[][] realPulse = new double[1][800];
        double d = 1.0;
        float factor = this.adc2Mev[index];
        double energyLocal = (double)this.energy[index] * 1000.0 / (double)factor;
        try {
            if (factor != -1.0f) {
                for (int i = 0; i < 800; ++i) {
                    double localTime = this.getLocalTime(d += step, this.cellTime[index], this.numSamplings);
                    realPulse[0][i] = super.getPhysicsPulseShape(localTime, this.cellPedestal[index], energyLocal, amplitude, time, 800);
                }
            }
        }
        catch (AAtlantisException aaex) {
            AOutput.append(aaex.getMessage(), "WARNING");
            return null;
        }
        if (factor != -1.0f) {
            logger.debug("adc2Mev factor available, plotting full plot.");
            return realPulse;
        }
        logger.debug("adc2Mev factor not available, plotting just adc counts.");
        return null;
    }

    protected double getPulseStep(int index) {
        return (float)(this.adcCounts[0].length - 1) / 800.0f;
    }
}

