/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import atlantis.Atlantis;
import atlantis.data.ADHelix;
import atlantis.parameters.APar;
import atlantis.utils.A3Vector;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import java.util.Random;

public class AHelix {
    private static ALogger logger = ALogger.getLogger(AHelix.class);
    public double phiTrack = 0.0;
    public double d0;
    public double z0;
    public double phi0;
    public double tL;
    public double pT;
    public double startPhi;
    public double eta;
    public double zVertex = 0.0;
    public double phiVertex = 0.0;
    public double rhoVertex = 0.0;
    private double rhoEndVertex = -1.0;
    public int numHits;
    private static final int SIZE = 5;
    public static final double C = 166.6666667;
    private static Random random = new Random();
    private static final boolean DEBUG = false;
    double[][] cov = null;

    AHelix(float rhoVertex, float phiVertex, float zVertex, float pTTrack, float phiTrack, float etaTrack, int charge) {
        this.createHelix(rhoVertex, phiVertex, zVertex, pTTrack, phiTrack, etaTrack, charge, -1.0f);
    }

    AHelix(float rhoVertex, float phiVertex, float zVertex, float pTTrack, float phiTrack, float etaTrack, int charge, float rhoEndVertex) {
        this.createHelix(rhoVertex, phiVertex, zVertex, pTTrack, phiTrack, etaTrack, charge, rhoEndVertex);
    }

    public void createHelix(float rhoVertex, float phiVertex, float zVertex, float pTTrack, float phiTrack, float etaTrack, int charge, float rhoEndVertex) {
        this.phiTrack = Math.toDegrees(phiTrack);
        double PI2 = 1.5707963267948966;
        double PI = Math.PI;
        double TPI = Math.PI * 2;
        if (charge > 0) {
            double rC = 166.6666667 * (double)pTTrack;
            double xC = (double)rhoVertex * Math.cos(phiVertex) + rC * Math.sin(phiTrack);
            double yC = (double)rhoVertex * Math.sin(phiVertex) - rC * Math.cos(phiTrack);
            double e = Math.exp(etaTrack);
            this.tL = 0.5 * (e - 1.0 / e);
            this.eta = etaTrack;
            this.d0 = rC - Math.sqrt(xC * xC + yC * yC);
            if ((double)phiTrack < 0.0) {
                phiTrack = (float)((double)phiTrack + TPI);
            }
            this.startPhi = PI2 - (double)phiTrack + Math.atan2(yC, xC);
            if (this.startPhi <= -PI) {
                this.startPhi += TPI;
            } else if (this.startPhi > PI) {
                this.startPhi -= TPI;
            }
            this.z0 = (double)zVertex - (double)rhoVertex * this.tL;
            this.phi0 = Math.toDegrees((double)phiTrack + this.startPhi);
            this.startPhi = Math.toDegrees(this.startPhi);
            this.pT = (float)charge * pTTrack;
        } else {
            double temp;
            double rC = 166.6666667 * (double)pTTrack * (double)charge;
            double xC = (double)rhoVertex * Math.cos(phiVertex) + rC * Math.sin(phiTrack);
            double yC = (double)rhoVertex * Math.sin(phiVertex) - rC * Math.cos(phiTrack);
            double e = Math.exp(etaTrack);
            this.tL = 0.5 * (e - 1.0 / e);
            this.eta = etaTrack;
            this.d0 = rC - (double)charge * Math.sqrt(xC * xC + yC * yC);
            if ((double)phiTrack < 0.0) {
                phiTrack = (float)((double)phiTrack + TPI);
            }
            if ((temp = Math.atan2(yC, xC)) < 0.0) {
                temp += TPI;
            }
            this.startPhi = -PI2 - (double)phiTrack + temp;
            if (this.startPhi <= -PI) {
                this.startPhi += TPI;
            } else if (this.startPhi > PI) {
                this.startPhi -= TPI;
            }
            this.z0 = (double)zVertex - rC * this.startPhi * this.tL;
            this.phi0 = Math.toDegrees((double)phiTrack + this.startPhi);
            this.startPhi = (double)charge * Math.toDegrees(this.startPhi);
            this.pT = (float)charge * pTTrack;
        }
        this.zVertex = zVertex;
        this.phiVertex = phiVertex;
        this.rhoVertex = rhoVertex;
        this.rhoEndVertex = rhoEndVertex;
    }

    public AHelix(float d0, float z0, float phi0, float tL, float pT) {
        this.d0 = d0;
        this.z0 = z0;
        this.phi0 = phi0;
        this.tL = tL;
        this.eta = this.calculateEta(this.tL);
        this.pT = pT;
        this.startPhi = 0.0;
    }

    public AHelix(float d0, float z0, float phi0, float tL, float pT, int numHits) {
        this(d0, z0, phi0, tL, pT);
        this.numHits = numHits;
    }

    public AHelix(float d0, float z0, float phi0, float tL, float pT, float[][] c) {
        int i;
        this.d0 = d0;
        this.z0 = z0;
        this.phi0 = phi0;
        this.tL = tL;
        this.eta = this.calculateEta(this.tL);
        this.pT = pT;
        this.startPhi = 0.0;
        this.cov = new double[c.length][];
        if (c.length != 5) {
            logger.error("Helix error " + c.length);
        }
        for (i = 0; i < c.length; ++i) {
            if (c[i].length != 5) {
                logger.error("Helix error " + c.length);
            }
            this.cov[i] = new double[c[i].length];
        }
        for (i = 0; i < c.length; ++i) {
            for (int j = 0; j < c[i].length; ++j) {
                this.cov[i][j] = c[i][j];
            }
        }
    }

    public AHelix(float d0, float z0, float phi0, float tL, float pT, int numHits, float[][] c) {
        this(d0, z0, phi0, tL, pT, c);
        this.numHits = numHits;
    }

    public AHelix(float d0, float z0, float phi0, float tL, float pT, float startPhi) {
        this.d0 = d0;
        this.z0 = z0;
        this.phi0 = phi0;
        this.tL = tL;
        this.eta = this.calculateEta(this.tL);
        this.pT = pT;
        this.startPhi = startPhi;
    }

    public double[] getPar() {
        return new double[]{this.d0, this.z0, Math.toRadians(this.phi0), this.tL, 1.0 / this.pT};
    }

    public double[][] getCov() {
        return this.cov;
    }

    public double getRhoEndVertex() {
        return this.rhoEndVertex;
    }

    public AHelix smear() {
        Matrix c = new Matrix(this.cov);
        EigenvalueDecomposition eVD = new EigenvalueDecomposition(c);
        double[] eigenvalues = eVD.getRealEigenvalues();
        Matrix eigenvectors = eVD.getV();
        double[] sigma = new double[5];
        for (int i = 0; i < 5; ++i) {
            sigma[i] = Math.sqrt(Math.abs(eigenvalues[i])) * random.nextGaussian();
        }
        double[] h = this.getPar();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                int n = i;
                h[n] = h[n] + sigma[j] * eigenvectors.get(i, j);
            }
        }
        this.d0 = h[0];
        this.z0 = h[1];
        this.phi0 = Math.toDegrees(h[2]);
        this.tL = h[3];
        this.pT = 1.0 / h[4];
        this.startPhi = 0.0;
        return this;
    }

    public void setPhiStartByXYPoint(double Vx, double Vy) {
        double sPhi;
        ADHelix Dh = new ADHelix(this, Atlantis.getEventManager().getCurrentEvent());
        double Xc = Dh.xC;
        double Yc = Dh.yC;
        double a = -1.0 * (Vx - Xc);
        double b = -1.0 * (Vy - Yc);
        double PI2 = 1.5707963267948966;
        double PI = Math.PI;
        double TPI = Math.PI * 2;
        double charge = 1.0;
        double pTTrack = this.pT;
        double phiTrack = Math.toRadians(this.phi0);
        if (pTTrack < 0.0) {
            charge = -1.0;
        }
        if (charge > 0.0) {
            double temp = Math.atan2(b, a);
            if (temp < 0.0) {
                temp += TPI;
            }
            if ((sPhi = PI2 - phiTrack + temp) <= -PI) {
                sPhi += TPI;
            } else if (sPhi > PI) {
                sPhi -= TPI;
            }
            sPhi = Math.toDegrees(sPhi);
        } else {
            double temp = Math.atan2(b, a);
            if (temp < 0.0) {
                temp += TPI;
            }
            if ((sPhi = -PI2 - phiTrack + temp) <= -PI) {
                sPhi += TPI;
            } else if (sPhi > PI) {
                sPhi -= TPI;
            }
            sPhi = charge * Math.toDegrees(sPhi);
        }
        this.startPhi = Math.abs(sPhi);
    }

    public String toString() {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = "";
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n PT=" + AMath.d2s(Math.abs(this.pT), 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta, 3) + "\n " + "\u03a6" + " = " + AMath.d2s(this.phi0, 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Px=" + AMath.d2s(Math.abs(this.pT) * Math.cos(Math.toRadians(this.phi0)), 3) + " GeV " + "\n Py=" + AMath.d2s(Math.abs(this.pT) * Math.sin(Math.toRadians(this.phi0)), 3) + " GeV " + "\n Pz=" + AMath.d2s(Math.abs(this.pT) * Math.sinh(this.eta), 3) + " GeV ";
            }
            return output;
        }
        String s = "";
        double f = 1.0;
        if (this.numHits > 0) {
            s = s + "\n numHits = " + this.numHits;
        }
        s = s + "\n d0 = " + AMath.d2s(f * this.d0, 3);
        if (this.cov != null) {
            s = s + " \u00b1 " + AMath.d2s(f * Math.sqrt(this.cov[0][0]), 3);
        }
        s = f > 100.0 ? s + " um" : s + " cm";
        f = 1.0;
        s = s + "\n z0 = " + AMath.d2s(f * this.z0, 3);
        if (this.cov != null) {
            s = s + " \u00b1 " + AMath.d2s(Math.sqrt(f * this.cov[1][1]), 3);
        }
        s = f > 100.0 ? s + " um" : s + " cm";
        double zVtx = APar.get("Event", "ZVtx").getD();
        s = s + "\n |z0-zVtx| = " + AMath.d2s(f * Math.abs(this.z0 - zVtx), 3);
        s = f > 100.0 ? s + " um" : s + " cm";
        s = s + "\n phi0 = " + AMath.d2s(this.phi0, 3);
        s = this.cov != null ? s + " \u00b1 " + AMath.d2s(Math.toDegrees(Math.sqrt(this.cov[2][2])), 3) + "\u00b0" : s + "\u00b0";
        s = s + "  (" + AMath.d2s(Math.toRadians(this.phi0), 3);
        s = this.cov != null ? s + " \u00b1 " + AMath.d2s(Math.toRadians(Math.sqrt(this.cov[2][2])), 3) + " rad)" : s + " rad)";
        s = s + "\n \u03b7 = " + AMath.d2s(this.eta, 3);
        if (this.cov != null) {
            double etaError = Math.sqrt(this.cov[3][3] / (this.tL * this.tL + 1.0));
            s = s + " \u00b1 " + AMath.d2s(etaError, 3);
        }
        s = s + "\n tL = " + AMath.d2s(this.tL, 3);
        if (this.cov != null) {
            s = s + " \u00b1 " + AMath.d2s(Math.sqrt(this.cov[3][3]), 3);
        }
        s = s + "\n pT = " + AMath.d2s(this.pT, 2) + " GeV";
        if (this.cov != null) {
            double sigmaPt = Math.abs(1.0 / (Math.abs(1.0 / this.pT) + Math.sqrt(this.cov[4][4])) - Math.abs(this.pT));
            s = s + " \u00b1 " + AMath.d2s(sigmaPt, 3) + " GeV";
        }
        s = this.pT < 0.0 ? s + "\n p  = " + AMath.d2s(-AMath.getPFromPttL(this.pT, this.tL), 2) : s + "\n p  = " + AMath.d2s(AMath.getPFromPttL(this.pT, this.tL), 2);
        s = s + " GeV";
        return s;
    }

    public A3Vector getP() {
        double pTrans = Math.abs(this.pT);
        double phi = Math.toRadians(this.phi0);
        return new A3Vector(pTrans * Math.cos(phi), pTrans * Math.sin(phi), pTrans * this.tL);
    }

    public double calculateEta(double ctgTheta) {
        double eta = -Math.log(Math.sqrt(ctgTheta * ctgTheta + 1.0) - ctgTheta);
        return eta;
    }
}

