/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.canvas.AWindow;
import atlantis.data.AAODData;
import atlantis.data.ADHelix;
import atlantis.data.AHelix;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.graphics.AGraphics;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionVP;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public abstract class AHelixAODData
extends AAODData {
    protected AHelix[] h = new AHelix[this.numData];

    AHelixAODData(AHashMap p, AEvent e) {
        super(p, e);
        float[] d0 = new float[this.numData];
        float[] z0 = new float[this.numData];
        float[] tl = new float[this.numData];
        for (int i = 0; i < this.numData; ++i) {
            d0[i] = 0.0f;
            z0[i] = 0.0f;
            tl[i] = (float)AMath.tanLambda(this.eta[i]);
            this.h[i] = new AHelix(d0[i], z0[i], (float)AMath.radiansToDegrees(this.phi[i]), tl[i], this.pT[i]);
        }
    }

    private void drawHelix(AWindow window, AGraphics ag, AProjection2D projection) {
        ag.draw(window.calculateDisplay(window.calculateUser(this.getVPDisplayHelices(window, projection)).includePhiWrapAround(projection.getName())));
    }

    private ADHelix[] getHelices() {
        this.makeDrawList();
        ADHelix[] tempList = new ADHelix[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            if (this.h != null && this.h[this.listdl[i]] != null) {
                tempList[i] = new ADHelix(this.h[this.listdl[i]], this.event);
                if (tempList[i].getAStart() != tempList[i].getAEnd()) continue;
                tempList[i] = null;
                continue;
            }
            tempList[i] = null;
        }
        return tempList;
    }

    private ACoord getVPDisplayHelices(AWindow window, AProjection2D projection) {
        boolean drawApex = APar.get("VP", "DrawApex").getStatus();
        ADHelix[] dhelix = this.getHelices();
        int size = 2 * dhelix.length;
        if (drawApex) {
            size = 3 * dhelix.length;
        }
        double[][][] hv = new double[2][size][0];
        int[] index = new int[size];
        int[] indexIn = this.getDrawList();
        int num = 0;
        for (int j = 0; j < dhelix.length; ++j) {
            if (dhelix[j] == null) continue;
            double s1 = dhelix[j].getAStart();
            double s2 = 179.0;
            s1 = dhelix[j].intersectWithRadialCylinder(projection.getMinRho(), s1, s2);
            double sEnd = dhelix[j].intersectWithCylinder(true, AProjectionVP.getRhoVPlot(), true, AProjectionVP.getZVPlot());
            s2 = Math.max(Math.min(s2, sEnd), s1);
            if (s1 == 0.0 && s2 == 180.0) {
                s2 = 179.0;
            }
            if (APar.get("VP", "ShortV").getStatus() && !APar.get("Data", "S3D").getStatus()) {
                s1 = s2 - APar.get("VP", "ShortV").getD() * (s2 - s1);
            }
            if (!(s2 > s1)) continue;
            int signMin = -1;
            int signMax = 1;
            double h = 0.0;
            double v = 0.0;
            for (int sign = signMin; sign <= signMax; sign += 2) {
                AProjectionVP.sign = sign;
                ACoord pointsOnHelix = dhelix[j].drawHelix(window, projection, s1, s2);
                hv[0][num] = pointsOnHelix.hv[0][0];
                hv[1][num] = pointsOnHelix.hv[1][0];
                index[num] = indexIn[j];
                h = hv[0][num][hv[0][num].length - 1];
                v = hv[1][num][hv[0][num].length - 1];
                ++num;
            }
            if (!drawApex) continue;
            int a = 3;
            int b = 7;
            hv[0][num] = new double[]{h - (double)a, h + (double)a, h, h, h - (double)a, h + (double)a};
            hv[1][num] = new double[]{v - (double)b, v - (double)b, v - (double)b, v + (double)b, v + (double)b, v + (double)b};
            index[num] = indexIn[j];
            ++num;
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    public void draw(AWindow window, AGraphics ag, AProjection2D projection) {
        if (projection instanceof AProjectionVP) {
            double[] primaryVtx = this.event.getPrimaryVertex();
            APar.get("Event", "XVtx").setD(0.0);
            APar.get("Event", "YVtx").setD(0.0);
            APar.get("Event", "ZVtx").setD(0.0);
            this.drawHelix(window, ag, projection);
            APar.get("Event", "XVtx").setD(primaryVtx[0]);
            APar.get("Event", "YVtx").setD(primaryVtx[1]);
            APar.get("Event", "ZVtx").setD(primaryVtx[2]);
        } else {
            super.draw(window, ag, projection);
        }
    }
}

