/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.event.AData;
import atlantis.graphics.ACoord;
import atlantis.utils.AHashMap;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AVector;

public class AHistogram
extends AData {
    private static ALogger logger = ALogger.getLogger(AHistogram.class);
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    private float leftLimit;
    private float rightLimit;
    private float gran;
    private float granSafety;
    private float[] towers;
    private double eta0;
    private double z;
    private double r;
    private double factor;
    private AData detector;

    AHistogram(double leftLimit, double rightLimit, double gran, double factor, AData detector) {
        super(new AHashMap(1).put("numData", 0), detector.getEvent());
        this.leftLimit = (float)leftLimit;
        this.rightLimit = (float)rightLimit;
        this.gran = (float)gran;
        this.factor = factor;
        this.detector = detector;
        this.granSafety = (float)((double)this.gran * 0.1);
        this.towers = new float[(int)Math.abs(Math.round((rightLimit - leftLimit) / gran))];
        this.numData = this.towers.length;
    }

    public float getGranularity() {
        return this.gran;
    }

    public int getTowersCount() {
        return this.towers.length;
    }

    public float[] getTowers() {
        return this.towers;
    }

    public void fill(double v1, double v2, double q) {
        int t1 = (int)((v1 + (double)this.granSafety - (double)this.leftLimit) / (double)this.gran);
        int t2 = (int)((v2 - (double)this.granSafety - (double)this.leftLimit) / (double)this.gran);
        int i = -999;
        if (Math.min(t1, t2) < 0 || Math.max(t1, t2) >= this.towers.length) {
            logger.error("Histogram binning problem " + t1 + " " + t2 + " " + this.towers.length + " " + v1 + " " + v2);
            return;
        }
        if (t1 == t2) {
            int n = t1;
            this.towers[n] = (float)((double)this.towers[n] + q);
        } else {
            i = t1;
            while (i <= t2) {
                int n = i++;
                this.towers[n] = (float)((double)this.towers[n] + q / (double)(t2 - t1 + 1));
            }
        }
    }

    public void setGranularity(double newGran) {
        AHistogram newHist = new AHistogram(this.leftLimit, this.rightLimit, newGran, this.factor, this.detector);
        for (int i = 0; i < this.towers.length; ++i) {
            newHist.fill(this.leftLimit + (float)i * this.gran, this.leftLimit + (float)(i + 1) * this.gran, this.towers[i]);
        }
        this.gran = (float)newGran;
        this.towers = newHist.towers;
    }

    public void add(AHistogram h) {
        int i;
        float min = Math.min(this.leftLimit, h.leftLimit);
        float max = Math.max(this.rightLimit, h.rightLimit);
        AHistogram sum = new AHistogram(min, max, this.gran, this.factor, this.detector);
        for (i = 0; i < this.towers.length; ++i) {
            sum.fill(this.leftLimit + (float)i * this.gran, this.leftLimit + (float)(i + 1) * this.gran, this.towers[i]);
        }
        for (i = 0; i < h.towers.length; ++i) {
            sum.fill(h.leftLimit + (float)i * h.gran, h.leftLimit + (float)(i + 1) * h.gran, h.towers[i]);
        }
        this.towers = sum.towers;
        this.leftLimit = min;
        this.rightLimit = max;
    }

    public AHistogram getRegion(double v1, double v2) {
        AHistogram hRegion = new AHistogram(v1, v2, this.gran, this.factor, this.detector);
        int n1 = (int)Math.round((v1 - (double)this.leftLimit) / (double)this.gran);
        int n2 = (int)Math.round((v2 - (double)this.leftLimit) / (double)this.gran);
        for (int i = n1; i < n2; ++i) {
            hRegion.fill(v1 + (double)((float)(i - n1) * this.gran), v1 + (double)((float)(i - n1 + 1) * this.gran), this.towers[i]);
        }
        return hRegion;
    }

    private int getCode() {
        int c1 = (double)this.leftLimit < -this.eta0 ? 1 : ((double)this.leftLimit > this.eta0 ? 3 : 2);
        int c2 = (double)this.rightLimit < -this.eta0 ? 1 : ((double)this.rightLimit > this.eta0 ? 3 : 2);
        return c1 * c2;
    }

    public ACoord[] getRZUser(double z1, double r1, int upORdown) {
        this.z = z1;
        this.r = r1;
        double k = this.z / this.r;
        this.eta0 = Math.abs(Math.log(k + Math.sqrt(k * k + 1.0)));
        switch (this.getCode()) {
            case 1: {
                return new ACoord[]{this.getRZVerticalUser(this.z, upORdown)};
            }
            case 4: {
                return new ACoord[]{this.getRZHorizontalUser(this.r, upORdown)};
            }
            case 9: {
                return new ACoord[]{this.getRZVerticalUser(this.z, upORdown)};
            }
            case 2: {
                int N = (int)Math.abs(Math.round((this.eta0 - (double)this.leftLimit) / (double)this.gran));
                this.eta0 = this.leftLimit + (float)N * this.gran;
                double expEta0 = Math.exp(this.eta0);
                this.r = 2.0 * this.z / (expEta0 - 1.0 / expEta0);
                return new ACoord[]{this.getRegion(this.leftLimit, -this.eta0).getRZVerticalUser(this.z, upORdown), this.getRegion(-this.eta0, this.rightLimit).getRZHorizontalUser(this.r, upORdown)};
            }
            case 6: {
                int N = (int)Math.abs(Math.round((this.eta0 - (double)this.leftLimit) / (double)this.gran));
                this.eta0 = this.leftLimit + (float)N * this.gran;
                double expEta0 = Math.exp(this.eta0);
                this.r = 2.0 * this.z / (expEta0 - 1.0 / expEta0);
                return new ACoord[]{this.getRegion(this.leftLimit, this.eta0).getRZHorizontalUser(this.r, upORdown), this.getRegion(this.eta0, this.rightLimit).getRZVerticalUser(this.z, upORdown)};
            }
            case 3: {
                int N = (int)Math.abs(Math.floor((this.eta0 - (double)this.leftLimit) / (double)this.gran));
                this.eta0 = this.leftLimit + (float)N * this.gran;
                double expEta0 = Math.exp(this.eta0);
                this.r = 2.0 * this.z / (expEta0 - 1.0 / expEta0);
                return new ACoord[]{this.getRegion(this.leftLimit, -this.eta0).getRZVerticalUser(this.z, upORdown), this.getRegion(-this.eta0, this.eta0).getRZHorizontalUser(this.r, upORdown), this.getRegion(this.eta0, this.rightLimit).getRZVerticalUser(this.z, upORdown)};
            }
        }
        return null;
    }

    public ACoord getRZHorizontalUser(double r, int place) {
        double[][][] hv = new double[2][this.towers.length][4];
        int[] index = new int[this.towers.length];
        for (int i = 0; i < this.towers.length; ++i) {
            double exp1 = Math.exp(this.leftLimit + (float)i * this.gran);
            double exp2 = Math.exp(this.leftLimit + (float)(i + 1) * this.gran);
            double rSign = (int)Math.pow(-1.0, place);
            double eta = (double)this.leftLimit + ((double)i + 0.5) * (double)this.gran;
            double zSign = eta != 0.0 ? eta / Math.abs(eta) : 1.0;
            hv[0][i][0] = zSign * Math.abs(r * (exp1 - 1.0 / exp1) / 2.0);
            hv[1][i][0] = rSign * r;
            hv[0][i][1] = zSign * Math.abs(r * (exp2 - 1.0 / exp2) / 2.0);
            hv[1][i][1] = rSign * r;
            hv[0][i][2] = 0.0;
            hv[1][i][2] = 0.0;
            index[i] = i;
        }
        ACoord c = new ACoord(hv, index);
        c.source = this;
        return c;
    }

    public ACoord getRZVerticalUser(double z, int place) {
        double[][][] hv = new double[2][this.towers.length][4];
        int[] index = new int[this.towers.length];
        for (int i = 0; i < this.towers.length; ++i) {
            double exp1 = Math.exp(this.leftLimit + (float)i * this.gran);
            double exp2 = Math.exp(this.leftLimit + (float)(i + 1) * this.gran);
            double rSign = (int)Math.pow(-1.0, place);
            double zSign = this.leftLimit > 0.0f && this.rightLimit > 0.0f ? 1.0 : -1.0;
            hv[0][i][0] = zSign * z;
            hv[1][i][0] = rSign * Math.abs(2.0 * z / (exp2 - 1.0 / exp2));
            hv[0][i][1] = zSign * z;
            hv[1][i][1] = rSign * Math.abs(2.0 * z / (exp1 - 1.0 / exp1));
            hv[0][i][2] = 0.0;
            hv[1][i][2] = 0.0;
            index[i] = i;
        }
        ACoord c = new ACoord(hv, index);
        c.source = this;
        return c;
    }

    protected ACoord getYXUser(double r) {
        int n = this.towers.length;
        double[][][] hv = new double[2][n][4];
        int[] index = new int[n];
        for (int i = 0; i < n; ++i) {
            double phi1 = this.leftLimit + (float)i * this.gran;
            double phi2 = this.leftLimit + (float)(i + 1) * this.gran;
            hv[0][i][0] = r * Math.cos(phi1);
            hv[1][i][0] = r * Math.sin(phi1);
            hv[1][i][1] = r * Math.sin(phi2);
            hv[0][i][1] = r * Math.cos(phi2);
            hv[0][i][2] = 0.0;
            hv[1][i][2] = 0.0;
            index[i] = i;
        }
        ACoord c = new ACoord(hv, index);
        c.source = this;
        return c;
    }

    public ACoord completeTowers(ACoord c) {
        AVector u = new AVector(0.0, 0.0);
        for (int i = 0; i < c.hv[0].length; ++i) {
            double x0 = (c.hv[0][i][0] + c.hv[0][i][1]) / 2.0;
            double y0 = (c.hv[1][i][0] + c.hv[1][i][1]) / 2.0;
            double f = this.factor * (double)this.towers[c.index[i]];
            u.set(x0 - c.hv[0][i][2], y0 - c.hv[1][i][2]).makeUnitary().scale(f);
            c.hv[0][i][2] = c.hv[0][i][1] + u.dx;
            c.hv[1][i][2] = c.hv[1][i][1] + u.dy;
            c.hv[0][i][3] = c.hv[0][i][0] + u.dx;
            c.hv[1][i][3] = c.hv[1][i][0] + u.dy;
        }
        return c;
    }

    protected ACoord getFRUser(double r) {
        int n = this.towers.length;
        double[][][] hv = new double[2][n][4];
        int[] index = new int[n];
        for (int i = 0; i < n; ++i) {
            hv[0][i][0] = r;
            hv[1][i][0] = Math.toDegrees(this.leftLimit + (float)i * this.gran);
            hv[0][i][1] = r;
            hv[1][i][1] = Math.toDegrees(this.leftLimit + (float)(i + 1) * this.gran);
            hv[0][i][2] = 0.0;
            hv[1][i][2] = Math.toDegrees((double)this.leftLimit + ((double)i + 0.5) * (double)this.gran);
            index[i] = i;
        }
        ACoord c = new ACoord(hv, index);
        c.source = this;
        return c;
    }

    protected ACoord getFZUser(double z, int alignment) {
        int n = this.towers.length;
        double[][][] hv = new double[2][n][4];
        int[] index = new int[n];
        double zSign = Math.pow(-1.0, alignment);
        for (int i = 0; i < n; ++i) {
            hv[0][i][0] = zSign * z;
            hv[1][i][0] = Math.toDegrees(this.leftLimit + (float)i * this.gran);
            hv[0][i][1] = zSign * z;
            hv[1][i][1] = Math.toDegrees(this.leftLimit + (float)(i + 1) * this.gran);
            hv[0][i][2] = 0.0;
            hv[1][i][2] = Math.toDegrees((double)this.leftLimit + ((double)i + 0.5) * (double)this.gran);
            index[i] = i;
        }
        ACoord c = new ACoord(hv, index);
        c.source = this;
        return c;
    }

    public String getParameterGroup() {
        return null;
    }

    public String getName() {
        return null;
    }

    public String getNameScreenName() {
        return this.detector.getParameterGroup() + " Histogram Tower";
    }

    protected int internalColor() {
        return 0;
    }

    protected void applyCuts() {
    }

    public String getHitInfo(int index) {
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" (index: " + index + ")");
        msg.append("\n ET = ");
        msg.append(AMath.d2s(this.towers[index], 2));
        msg.append(" GeV");
        return msg.toString();
    }

    public int getIdFromIndex(int index) {
        return index;
    }
}

