/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.event.AAssociation;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.list.AListManager;
import atlantis.parameters.AEnumeratorParameter;
import atlantis.parameters.APar;
import atlantis.utils.AHashMap;
import atlantis.utils.ALogger;
import java.util.Vector;

public abstract class AHitData
extends AData {
    private static ALogger logger = ALogger.getLogger(AHitData.class);
    protected byte[] type;
    protected int[] sub;
    protected int[] ll;
    protected int[] llStart;
    protected int[] llNum;
    protected int[] barcode = null;
    protected int[] barcodes = null;
    protected int[] numBarcodes = null;
    private static final int NOISE = 0;
    private static final int GOOD = 1;

    public final int getNumTypes() {
        return 2;
    }

    AHitData(AHashMap p, AEvent e) {
        super(p, e);
        this.sub = p.getUnknownIntArray("sub");
        this.type = new byte[this.numData];
        this.ll = new int[this.numData];
        this.llStart = new int[this.getNumTypes()];
        this.llNum = new int[this.getNumTypes()];
        AAssociation assoc = null;
        if (p.get("barcode") != null) {
            this.barcode = p.getUnknownIntArray("barcode");
            assoc = new AAssociation(this.getName(), "STr", this.barcode, this.event);
            this.event.getAssociationManager().add(assoc);
        } else if (p.get("barcodes") != null && p.get("numBarcodes") != null) {
            this.barcodes = p.getUnknownIntArray("barcodes");
            this.numBarcodes = p.getUnknownIntArray("numBarcodes");
            assoc = new AAssociation(this.getName(), "STr", this.numBarcodes, this.barcodes, this.event);
            this.event.getAssociationManager().add(assoc);
        }
    }

    public String getHitInfo(int index) {
        String r = "";
        if (this.barcode != null) {
            r = r + "\n barcode = " + this.barcode[index];
        } else if (this.barcodes != null && this.numBarcodes != null) {
            int[][] barcodes = this.event.getAssociationManager().get(this.getName(), "STr");
            if (barcodes[index] != null) {
                r = r + "\n barcode(s) = ";
                for (int i = 0; i < barcodes[index].length; ++i) {
                    r = r + barcodes[index][i] + "  ";
                }
            } else {
                r = r + "\n no STr associated";
            }
        }
        return r;
    }

    private int[][] calculateAssociation(String to, String via) {
        String infoMsg = "   association from: " + this.getName() + "  to: " + to + "  via: " + via;
        logger.debug("AData.calculateAssociation()\n" + infoMsg);
        int[][] clusters = this.event.getAssociationManager().get(this.getName(), via);
        int[][] recon = this.event.getAssociationManager().get(via, to);
        AData source = this.event.get(via);
        if (clusters == null || recon == null || source == null) {
            return null;
        }
        int[][] ass = new int[this.numData][];
        for (int i = 0; i < this.numData; ++i) {
            if (clusters[i] != null && clusters[i].length == 2) {
                int index1 = source.getIndexFromId(clusters[i][0]);
                int index2 = source.getIndexFromId(clusters[i][1]);
                if (index1 == -1 || index2 == -1 || recon[index1] == null || recon[index2] == null) continue;
                int[] temp = new int[recon[index1].length];
                int matches = 0;
                for (int k = 0; k < recon[index1].length; ++k) {
                    for (int j = 0; j < recon[index2].length; ++j) {
                        if (recon[index1][k] != recon[index2][j]) continue;
                        if (matches < recon[index1].length) {
                            temp[matches] = recon[index1][k];
                            ++matches;
                            continue;
                        }
                        logger.warn("Association problem:\n" + infoMsg);
                    }
                }
                if (matches == 0) {
                    ass[i] = null;
                    continue;
                }
                if (matches == temp.length) {
                    ass[i] = temp;
                    continue;
                }
                int[] dest = new int[matches];
                System.arraycopy(temp, 0, dest, 0, matches);
                ass[i] = dest;
                continue;
            }
            if (clusters[i] == null || clusters[i].length != 1) continue;
            int[][] directRecon = this.event.getAssociationManager().getAssociation(to, via).getData();
            for (int x = 0; x < directRecon.length; ++x) {
                if (directRecon[x] == null) continue;
                for (int y = 0; y < directRecon[x].length; ++y) {
                    if (clusters[i][0] != directRecon[x][y]) continue;
                    if (ass[i] == null) {
                        ass[i] = new int[]{x};
                        continue;
                    }
                    int[] temp = new int[ass[i].length + 1];
                    System.arraycopy(ass[i], 0, temp, 0, ass[i].length);
                    temp[ass[i].length] = x;
                    ass[i] = new int[temp.length];
                    System.arraycopy(temp, 0, ass[i], 0, temp.length);
                }
            }
        }
        return ass;
    }

    protected void calculateAssociationViaClusters() {
        Vector keys = (Vector)this.event.getCollections().get("InDetTrack");
        int[][] recon = null;
        int[][] recon2 = null;
        AAssociation assoc = null;
        String[] trackCollec = null;
        if (keys != null) {
            trackCollec = keys.toArray(new String[keys.size()]);
            for (int j = 0; j < trackCollec.length; ++j) {
                String trackCollecFull = "InDetTrack" + trackCollec[j];
                recon = this.event.getAssociationManager().get(this.getName(), trackCollecFull);
                recon2 = this.calculateAssociation(trackCollecFull, "SiCluster");
                if (recon == null || recon2 == null) continue;
                for (int i = 0; i < this.numData; ++i) {
                    if (recon2[i] == null) continue;
                    recon[i] = recon2[i];
                }
                assoc = this.event.getAssociationManager().getAssociation(this.getName(), trackCollecFull);
                this.event.getAssociationManager().add(assoc.invert());
            }
        }
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == 0) {
            this.colorByConstant();
        } else if (colorFunction == 1) {
            this.colorBy("STr");
        } else if (colorFunction == 2) {
            this.colorBy(this.getReconstructedTracks());
        } else if (colorFunction == 3) {
            this.colorBy(this.sub);
        }
        return 3;
    }

    protected String getSegments() {
        AEnumeratorParameter key = (AEnumeratorParameter)APar.get("InDetSegment", "InDetSegmentCollections");
        return "InDetSegment" + key.getCurrentText();
    }

    public void constructDefaultDrawlist() {
        this.makeNoiseList(0, 0);
        if (!APar.get("CutsATLAS", "ByList").getStatus()) {
            this.makeDrawList(APar.get("CutsInDet", "HitType").getI());
            int[][] temp = AListManager.getInstance().getColorMapping(this);
            int[] index = temp[0];
            int[] ctemp = temp[1];
            if (index.length > 0) {
                int i;
                int[] c = new int[this.numData];
                int NONE = -999;
                for (i = 0; i < c.length; ++i) {
                    c[i] = -999;
                }
                for (i = 0; i < index.length; ++i) {
                    c[index[i]] = ctemp[i];
                }
                int[] newListdl = new int[this.numData];
                int num = 0;
                for (int t = 0; t < this.getNumTypes(); ++t) {
                    int i2;
                    for (i2 = 0; i2 < this.numDraw; ++i2) {
                        if (t != this.type[this.listdl[i2]] || c[this.listdl[i2]] != -999) continue;
                        newListdl[num++] = this.listdl[i2];
                    }
                    for (i2 = 0; i2 < this.numDraw; ++i2) {
                        if (t != this.type[this.listdl[i2]] || c[this.listdl[i2]] == -999 || c[this.listdl[i2]] == -2) continue;
                        newListdl[num++] = this.listdl[i2];
                    }
                }
                this.listdl = newListdl;
                this.numDraw = num;
            }
        } else {
            boolean[] selected = AListManager.getInstance().getSelection(this);
            this.numDraw = 0;
            for (int t = 0; t < this.getNumTypes(); ++t) {
                for (int i = 0; i < this.numData; ++i) {
                    if (t != this.type[i] || !selected[i]) continue;
                    this.listdl[this.numDraw++] = i;
                }
            }
        }
    }

    protected void setType() {
        int[][] assocSTr = this.event.getAssociationManager().get(this.getName(), "STr");
        int[][] assocRTr = this.event.getAssociationManager().get(this.getName(), this.getReconstructedTracks());
        for (int i = 0; i < this.numData; ++i) {
            this.type[i] = assocSTr != null && assocSTr[i] != null || assocRTr != null && assocRTr[i] != null ? (byte)1 : 0;
        }
    }

    protected void makeNoiseList(int a, int b) {
        int i;
        this.setType();
        for (i = 0; i < this.getNumTypes(); ++i) {
            this.llStart[i] = -1;
            this.llNum[i] = 0;
        }
        for (i = this.numData - 1; i >= 0; --i) {
            this.ll[i] = this.llStart[this.type[i]];
            this.llStart[this.type[i]] = i;
            byte by = this.type[i];
            this.llNum[by] = this.llNum[by] + 1;
        }
    }

    private void makeDrawList(int hitType) {
        int start;
        int end;
        this.numDraw = 0;
        if (hitType == 0) {
            end = 0;
            start = 0;
        } else if (hitType == 1) {
            end = 1;
            start = 1;
        } else {
            start = 0;
            end = 1;
        }
        for (int i = start; i <= end; ++i) {
            int n = this.llStart[i];
            for (int j = 0; j < this.llNum[i]; ++j) {
                this.listdl[this.numDraw++] = n;
                n = this.ll[n];
            }
        }
    }

    public int[] getType(int[] dl) {
        int[] temp = new int[dl.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.type[dl[i]];
        }
        return temp;
    }

    protected void cutSimulatedTracks() {
        int cutOption = APar.get("CutsInDet", "HitsBySTr").getI();
        if (TEST_CUTS.getStatus()) {
            TEST_CUTS.setStatus(false);
            this.cutByAssociationTo("STr", this.getName(), cutOption);
            TEST_CUTS.setStatus(true);
        } else {
            this.cutByAssociationTo("STr", this.getName(), cutOption);
        }
        AData.printCut(" STr", this.numDraw);
    }

    protected void cutReconstructedTracks() {
        int cutOption = APar.get("CutsInDet", "HitsByRTr").getI();
        if (TEST_CUTS.getStatus()) {
            TEST_CUTS.setStatus(false);
            this.cutByAssociationTo(this.getReconstructedTracks(), this.getName(), cutOption);
            TEST_CUTS.setStatus(true);
        } else {
            this.cutByAssociationTo(this.getReconstructedTracks(), this.getName(), cutOption);
        }
        AData.printCut(" RTr", this.numDraw);
    }

    protected void cutSegments() {
        int cutOption = APar.get("CutsInDet", "HitsBySegment").getI();
        if (TEST_CUTS.getStatus()) {
            TEST_CUTS.setStatus(false);
            this.cutByAssociationTo(this.getSegments(), this.getName(), cutOption);
            TEST_CUTS.setStatus(true);
        } else {
            this.cutByAssociationTo(this.getSegments(), this.getName(), cutOption);
        }
        AData.printCut(" Segment", this.numDraw);
    }
}

