/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.data.ATrackData;
import atlantis.event.AAssociation;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.parameters.APar;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AIdHelper;
import atlantis.utils.ALogger;

public class AInDetTrackData
extends ATrackData {
    private int[] author = null;
    protected int[] numPixelHits = null;
    protected int[] numSCTHits = null;
    protected int[] numTRTHits = null;
    private static ALogger logger = ALogger.getLogger(ATrackData.class);

    AInDetTrackData(AHashMap p, AEvent e) throws AAtlantisException {
        super(p, e);
        this.author = p.getUnsureIntArray("trackAuthor");
        this.numPixelHits = p.getUnsureIntArray("nPixHits");
        this.numSCTHits = p.getUnsureIntArray("nSCTHits");
        this.numTRTHits = p.getUnsureIntArray("nTRTHits");
        String assocKey = this.getName() + this.getStoreGateKey();
        if (p.get("numHits") != null) {
            int[] numHits = p.getIntArray("numHits");
            int[] hits = p.getIntArray("hits");
            if (this.numPixelHits == null && this.numSCTHits == null && this.numTRTHits == null) {
                this.numPixelHits = new int[this.numData];
                this.numSCTHits = new int[this.numData];
                this.numTRTHits = new int[this.numData];
                int num = 0;
                for (int i = 0; i < this.numData; ++i) {
                    this.numTRTHits[i] = 0;
                    this.numSCTHits[i] = 0;
                    this.numPixelHits[i] = 0;
                    int j = 0;
                    while (j < numHits[i]) {
                        try {
                            if (numHits[i] > 0 && (hits[num] < 0 || AIdHelper.subDetector(hits[num]) == 2)) {
                                switch (hits[num] < 0 ? 1 : AIdHelper.indetPart(hits[num])) {
                                    case 1: {
                                        int n = i;
                                        this.numPixelHits[n] = this.numPixelHits[n] + 1;
                                        break;
                                    }
                                    case 2: {
                                        int n = i;
                                        this.numSCTHits[n] = this.numSCTHits[n] + 1;
                                        break;
                                    }
                                    case 3: {
                                        int n = i;
                                        this.numTRTHits[n] = this.numTRTHits[n] + 1;
                                    }
                                }
                            }
                        }
                        catch (AAtlantisException ex) {
                            logger.warn("Problem decoding hit identifier: " + ex.getMessage());
                        }
                        ++j;
                        ++num;
                    }
                }
            }
            int[] driftSign = null;
            int[] isOutlier = null;
            if (p.get("driftSign") != null && p.get("isOutlier") != null) {
                driftSign = p.getIntArray("driftSign");
                isOutlier = p.getIntArray("isOutlier");
            }
            this.event.getAssociationManager().add(new AAssociation(assocKey, "TRT", numHits, hits, this.event));
            if (driftSign != null) {
                this.event.getAssociationManager().add(new AAssociation(assocKey + "Drift", "TRT", numHits, driftSign, this.event));
            }
            if (isOutlier != null) {
                this.event.getAssociationManager().add(new AAssociation(assocKey + "Outlier", "TRT", numHits, isOutlier, this.event));
            }
            this.event.getAssociationManager().add(new AAssociation(assocKey, "SiCluster", numHits, hits, this.event));
            this.event.getAssociationManager().add(new AAssociation(assocKey, "PixelCluster", numHits, hits, this.event));
            this.event.getAssociationManager().add(new AAssociation(assocKey, "S3D", numHits, hits, this.event));
            this.event.getAssociationManager().add(new AAssociation(assocKey, "TrigS3D", numHits, hits, this.event));
        }
    }

    public String getParameterGroup() {
        return "InDetTrack";
    }

    public String getName() {
        return "InDetTrack";
    }

    public String getNameScreenName() {
        return "InDetTrack";
    }

    public String getHitInfo(int index) {
        String msg = super.getHitInfo(index);
        if (this.numPixelHits != null) {
            msg = msg + "\n numPixelHits = " + this.numPixelHits[index];
        }
        if (this.numSCTHits != null) {
            msg = msg + "\n numSCTHits = " + this.numSCTHits[index];
        }
        if (this.numTRTHits != null) {
            msg = msg + "\n numTRTHits = " + this.numTRTHits[index];
        }
        return msg;
    }

    protected void applyCuts() {
        AData.printCut(this.getName(), this.numDraw);
        this.cut("CutsInDet", "RTrIndex", " RTr id", this.id);
        this.cut("CutsInDet", "trackAuthor", " Author", this.author);
        if (this.numPixelHits != null) {
            this.cut("CutsInDet", "NumPixel", "Num Pixel", this.numPixelHits);
        }
        if (this.numSCTHits != null) {
            this.cut("CutsInDet", "NumSCT", "Num SCT", this.numSCTHits);
        }
        if (this.numTRTHits != null) {
            this.cut("CutsInDet", "NumTRT", "Num TRT", this.numTRTHits);
        }
        super.applyCuts();
        if (this.polylinedTrack && APar.get(this.PARAMETER_GROUP, "DrawnAs").getI() == 0) {
            super.cutRhoVertexAfterInDetRadius();
        }
    }
}

