/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.canvas.AWindow;
import atlantis.event.AAssociation;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.event.AObjectsAssociation;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.graphics.AGraphics;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionVP;
import atlantis.utils.A3Vector;
import atlantis.utils.A4Vector;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public class AJetData
extends AData {
    protected float[] eT;
    protected float[] eta;
    protected float[] phi;

    AJetData(AHashMap p, AEvent e) {
        super(p, e);
        this.eT = p.get("et") != null ? p.getFloatArray("et") : p.getFloatArray("pt");
        this.eta = p.getFloatArray("eta");
        this.phi = p.getFloatArray("phi");
        String assocKey = this.getName() + this.getStoreGateKey();
        if (p.get("numCells") != null) {
            this.event.getAssociationManager().add(new AAssociation(assocKey, "LAr", p.getIntArray("numCells"), p.getIntArray("cells"), this.event));
            this.event.getAssociationManager().add(new AAssociation(assocKey, "TILE", p.getIntArray("numCells"), p.getIntArray("cells"), this.event));
            this.event.getAssociationManager().add(new AAssociation(assocKey, "HEC", p.getIntArray("numCells"), p.getIntArray("cells"), this.event));
            this.event.getAssociationManager().add(new AAssociation(assocKey, "FCAL", p.getIntArray("numCells"), p.getIntArray("cells"), this.event));
        }
        if (p.get("clusterKey") != null) {
            int[] clusterLinkCount = p.getUnsureIntArray("clusterLinkCount");
            if (clusterLinkCount == null) {
                this.event.getAssociationManager().add(new AObjectsAssociation(assocKey, "Cluster", p.getStringArray("clusterKey"), p.getIntArray("clusterIndex"), this.event));
            } else {
                this.event.getAssociationManager().add(new AObjectsAssociation(assocKey, "Cluster", p.getStringArray("clusterKey"), p.getIntArray("clusterIndex"), p.getIntArray("clusterLinkCount"), this.event));
            }
        }
        if (p.get("trackKey") != null) {
            int[] trackLinkCount = p.getUnsureIntArray("trackLinkCount");
            if (trackLinkCount == null) {
                this.event.getAssociationManager().add(new AObjectsAssociation(assocKey, "Track", p.getStringArray("trackKey"), p.getIntArray("trackIndex"), this.event));
            } else {
                this.event.getAssociationManager().add(new AObjectsAssociation(assocKey, "Track", p.getStringArray("trackKey"), p.getIntArray("trackIndex"), p.getIntArray("trackLinkCount"), this.event));
            }
        }
    }

    public String getParameterGroup() {
        return "Jet";
    }

    public String getName() {
        return "Jet";
    }

    public String getNameScreenName() {
        return "Jet";
    }

    public float getET(int index) {
        return this.eT[index];
    }

    public float getEta(int index) {
        return this.eta[index];
    }

    public float getPhi(int index) {
        return this.phi[index];
    }

    public float[] getET() {
        return this.eT;
    }

    public double getE(int index) {
        return Math.abs((double)this.eT[index] / Math.cos(AMath.lambda(this.eta[index])));
    }

    public float[] getEta() {
        return this.eta;
    }

    public float[] getPhi() {
        return this.phi;
    }

    protected void applyCuts() {
        AData.printCut("Jet", this.numDraw);
        this.cutIndex();
        this.cut("CutsObjects", "JetET", " |ET|", this.eT);
        this.cutPhi(this.phi);
        this.cutEta(this.eta);
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == 0) {
            this.colorByConstant();
        } else if (colorFunction == 1) {
            this.colorByIndex();
        } else if (colorFunction == 2) {
            this.colorByCollection();
        }
        return 3;
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n ET=" + AMath.d2s(this.eT[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Ex=" + AMath.d2s((double)this.eT[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Ey=" + AMath.d2s((double)this.eT[index] * Math.sin(this.phi[index]), 3) + " GeV " + "\n Ez=" + AMath.d2s((double)this.eT[index] * Math.sinh(this.eta[index]), 3) + " GeV ";
            }
            return output;
        }
        String k = this.getStoreGateKey();
        String sgKey = k != null ? k : "n/a";
        String msg = this.getNameScreenName() + " (id: " + this.id[index] + " index: " + index + ")\n" + " storegate key: " + sgKey + "\n ET  = " + AMath.d2s(this.eT[index], 3) + " GeV" + "\n E   = " + AMath.d2s(Math.abs((double)this.eT[index] / Math.cos(AMath.lambda(this.eta[index]))), 3) + " GeV" + "\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0" + "  (" + AMath.d2s(this.phi[index], 3) + " rad)";
        return msg;
    }

    public String getVPHitInfo() {
        this.makeDrawList();
        if (this.numDraw == 0) {
            return "";
        }
        double sumE = 0.0;
        double sumEt = 0.0;
        for (int i = 0; i < this.numDraw; ++i) {
            sumEt += (double)Math.abs(this.eT[this.listdl[i]]);
            sumE += Math.abs((double)this.eT[this.listdl[i]] / Math.cos(AMath.lambda(this.eta[this.listdl[i]])));
        }
        String key = this.getFullName();
        String msg = this.numDraw + " " + (key != null ? "" + key : this.getNameScreenName());
        msg = msg + "  sum(ET) = " + AMath.d2s(sumEt, 1) + "  sum(E) = " + AMath.d2s(sumE, 1);
        return msg;
    }

    public A4Vector get4Vector(int num, int[] list) {
        A4Vector sum = new A4Vector();
        for (int i = 0; i < num; ++i) {
            int k = list[i];
            A3Vector start = new A3Vector().setCylindrical(0.0, 0.0, 0.0);
            double tL = AMath.tanLambda(this.eta[k]);
            A3Vector stop = new A3Vector().setCylindrical(1.0, this.phi[k], tL);
            A3Vector v = stop.subtract(start).normalize();
            double p = (double)this.eT[k] / Math.sqrt(1.0 - v.z * v.z);
            sum.add(new A4Vector(v.scale(p), 0.0));
        }
        return sum;
    }

    public void draw(AWindow window, AGraphics ag, AProjection2D projection) {
        if (projection instanceof AProjectionVP) {
            ACoord centers = window.calculateDisplay(this.getUser(projection));
            int[] drawlist = centers.index;
            double eLimit = 0.05;
            int numPoints = 25;
            double[][][] hv = new double[2][drawlist.length][numPoints];
            for (int i = 0; i < drawlist.length; ++i) {
                int list = drawlist[i];
                int jetMode = APar.get("VP", "Jet").getI();
                double e = jetMode == 0 ? (double)Math.abs(this.eT[list]) : Math.abs((double)this.eT[list] / Math.cos(AMath.lambda(this.eta[list])));
                int d = (int)Math.sqrt(e / eLimit / Math.PI);
                if (d == 0) {
                    d = 1;
                }
                for (int j = 0; j < numPoints; ++j) {
                    hv[0][i][j] = centers.hv[0][0][i] + (double)d * Math.cos(Math.PI * 2 * (double)j / (double)(numPoints - 1));
                    hv[1][i][j] = centers.hv[1][0][i] + (double)d * Math.sin(Math.PI * 2 * (double)j / (double)(numPoints - 1));
                }
            }
            ag.draw(new ACoord(hv, drawlist, (ADrawable)this, 3));
        } else {
            super.draw(window, ag, projection);
        }
    }

    protected int getDrawOrFill() {
        return 1;
    }

    protected ACoord getVPUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.eta[list];
            v[i] = Math.toDegrees(this.phi[list]);
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("VP");
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        double dphi = 0.3;
        double rhoMax = 1000.0;
        double rhoMinus = APar.get("Jet", "Innerdrawradius").getD();
        double maxEnergy = APar.get("Projection", "EnergyMax").getD();
        double s = APar.get("Jet", "Scale").getD();
        if (0.0 == s) {
            return ACoord.NO_POLYLINES;
        }
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiPlus = (double)this.phi[list] + dphi;
            double phiMinus = (double)this.phi[list] - dphi;
            double cosPlus = Math.cos(phiPlus);
            double sinPlus = Math.sin(phiPlus);
            double cosMinus = Math.cos(phiMinus);
            double sinMinus = Math.sin(phiMinus);
            double rhoPlus = rhoMax;
            if ((double)Math.abs(this.eT[list]) < maxEnergy) {
                rhoPlus = rhoMinus + (rhoMax - rhoMinus) * s * (double)Math.abs(this.eT[list]) / maxEnergy;
            }
            hv[0][i][0] = rhoMinus * cosPlus;
            hv[1][i][0] = rhoMinus * sinPlus;
            hv[0][i][1] = rhoPlus * cosPlus;
            hv[1][i][1] = rhoPlus * sinPlus;
            hv[0][i][2] = rhoPlus * cosMinus;
            hv[1][i][2] = rhoPlus * sinMinus;
            hv[0][i][3] = rhoMinus * cosMinus;
            hv[1][i][3] = rhoMinus * sinMinus;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    protected ACoord getFRUser() {
        ACoord coordFR = this.getYXUser().convertYXToFR().includePhiWrapAround("FR");
        return coordFR;
    }

    protected double Theta(double eta, int rSign) {
        double theta = Math.atan(Math.exp(-Math.abs(eta))) * 2.0;
        if (eta > 0.0 && rSign == -1) {
            theta = Math.PI * 2 - theta;
        } else if (eta < 0.0 && rSign == -1) {
            theta += Math.PI;
        } else if (eta < 0.0 && rSign == 1) {
            theta = Math.PI - theta;
        }
        return theta;
    }

    protected ACoord getRZUser() {
        double s = APar.get("Jet", "Scale").getD();
        if (0.0 == s) {
            return ACoord.NO_POLYLINES;
        }
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        double deta = 0.3;
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
            double phiDiff = Math.abs((double)this.phi[list] - phiMid);
            int rSign = phiDiff > 1.5707963267948966 && phiDiff <= 4.71238898038469 ? -1 : 1;
            double theta = this.Theta(this.eta[list], rSign);
            double thetaPlus = this.Theta((double)this.eta[list] + deta, rSign);
            double thetaMinus = this.Theta((double)this.eta[list] - deta, rSign);
            double cosPlus = Math.cos(thetaPlus);
            double sinPlus = Math.sin(thetaPlus);
            double cosMinus = Math.cos(thetaMinus);
            double sinMinus = Math.sin(thetaMinus);
            boolean TOP_BOTTOM = false;
            boolean LEFT_RIGHT = true;
            int region = 0;
            if (Math.abs(Math.tan(theta)) < 0.8) {
                region = 1;
            }
            double radiusMinus = 0.0;
            switch (region) {
                case 0: {
                    radiusMinus = 500.0 / Math.abs(Math.sin(theta));
                    break;
                }
                case 1: {
                    radiusMinus = 500.0 / Math.abs(Math.cos(theta));
                }
            }
            double radiusMax = radiusMinus + 1000.0;
            double maxEnergy = APar.get("Projection", "EnergyMax").getD();
            double radiusPlus = radiusMax;
            if ((double)Math.abs(this.eT[list]) < maxEnergy) {
                radiusPlus = radiusMinus + (radiusMax - radiusMinus) * s * (double)Math.abs(this.eT[list]) / maxEnergy;
            }
            hv[0][i][0] = radiusMinus * cosPlus;
            hv[1][i][0] = radiusMinus * sinPlus;
            hv[0][i][1] = radiusPlus * cosPlus;
            hv[1][i][1] = radiusPlus * sinPlus;
            hv[0][i][2] = radiusPlus * cosMinus;
            hv[1][i][2] = radiusPlus * sinMinus;
            hv[0][i][3] = radiusMinus * cosMinus;
            hv[1][i][3] = radiusMinus * sinMinus;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }
}

