/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.ACalorimeterData;
import atlantis.data.ACalorimeterRPSPLT;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.geometry.ABarrelCalorimeterDetector;
import atlantis.geometry.ACalorimeterDetector;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionYX;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AIdHelper;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import atlantis.utils.APulseShapePlot;
import atlantis.utils.AUtilities;
import com.Ostermiller.util.CSVParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class ALArData
extends ACalorimeterData {
    private static ALogger logger = ALogger.getLogger(ALArData.class);
    private int numSamplings = 0;
    private int[][] adcCounts = null;
    private float[] cellTime = null;
    private int[] cellGain = null;
    private float[] cellPedestal = null;
    private float[] adc2Mev = null;
    private static boolean pulseShapesDataAvailable = false;
    private static final String LOOKUP_TABLE_FILE = Atlantis.getHomeDirectory() + "configuration" + Atlantis.FILE_SEPAR + "rpsplt_lar.csv";
    private static final short NUMBER_OF_LOOKUP_VALUES = 799;

    ALArData(AHashMap p, AEvent e) {
        super(p, e);
        int i;
        for (i = 0; i < this.numData; ++i) {
            try {
                this.side[i] = (byte)AIdHelper.larBarrelEndcap(this.id[i]);
                this.etaIndex[i] = (short)AIdHelper.larEta(this.id[i]);
                this.phiIndex[i] = (short)AIdHelper.larPhi(this.id[i]);
                this.sampling[i] = AIdHelper.larSampling(this.id[i]);
                continue;
            }
            catch (AAtlantisException aex) {
                logger.warn("Problem decoding ID " + this.id[i] + " in " + this.CALORIMETER_NAME + ": " + aex.getMessage(), aex);
                this.side[i] = 0;
                this.etaIndex[i] = -1;
                this.phiIndex[i] = -1;
                this.sampling[i] = -1;
            }
        }
        this.makeHitToGeometryMapping();
        for (i = 0; i < this.et.length; ++i) {
            this.et[i] = Math.abs(this.energy[i] / (float)Math.cosh(this.eta[i]));
        }
        for (i = 0; i < ACalorimeterDetector.count(); ++i) {
            if (ACalorimeterDetector.get(i).getName().indexOf(this.CALORIMETER_NAME) < 0) continue;
            if (ACalorimeterDetector.get(i) instanceof ABarrelCalorimeterDetector) {
                if (this.innerR == 0.0 || ACalorimeterDetector.get(i).getRMin() < this.innerR) {
                    this.innerR = ACalorimeterDetector.get(i).getRMin();
                }
            } else if (this.innerZ == 0.0 || ACalorimeterDetector.get(i).getZMin() < this.innerZ) {
                this.innerZ = ACalorimeterDetector.get(i).getZMin();
            }
            if (this.outerR == 0.0 || ACalorimeterDetector.get(i).getRMax() > this.outerR) {
                this.outerR = ACalorimeterDetector.get(i).getRMax();
            }
            if (this.outerZ == 0.0 || ACalorimeterDetector.get(i).getZMax() > this.outerZ) {
                this.outerZ = ACalorimeterDetector.get(i).getZMax();
            }
            if (this.outerEta == 0.0 || ACalorimeterDetector.get(i).getEtaMax() > this.outerEta) {
                this.outerEta = ACalorimeterDetector.get(i).getEtaMax();
            }
            if (this.phiGranularity == 0.0 || ACalorimeterDetector.get(i).getDeltaPhi() < this.phiGranularity) {
                this.phiGranularity = ACalorimeterDetector.get(i).getDeltaPhi();
            }
            if (this.etaGranularity != 0.0 && !(ACalorimeterDetector.get(i).getDeltaEta() < this.etaGranularity)) continue;
            this.etaGranularity = ACalorimeterDetector.get(i).getDeltaEta();
        }
        this.outerEta += this.etaGranularity;
        this.readPulseShapePlotData(p);
    }

    private void readPulseShapePlotData(AHashMap p) {
        this.adcCounts = super.getADCCountsData(p);
        this.cellTime = p.get("cellTime") != null ? p.getFloatArray("cellTime") : null;
        this.cellGain = p.get("cellGain") != null ? p.getIntArray("cellGain") : null;
        this.cellPedestal = p.get("cellPedestal") != null ? p.getFloatArray("cellPedestal") : null;
        this.adc2Mev = p.get("adc2Mev") != null ? p.getFloatArray("adc2Mev") : null;
        pulseShapesDataAvailable = false;
        if (this.adcCounts != null && this.cellTime != null && this.cellGain != null && this.cellPedestal != null && this.adc2Mev != null) {
            pulseShapesDataAvailable = true;
            this.numSamplings = this.adcCounts[0].length;
            logger.debug(this.CALORIMETER_NAME + ": data for real pulse shape plots available");
            if (ACalorimeterRPSPLT.areLarLookupTablesInitialized()) {
                logger.debug(this.CALORIMETER_NAME + ": lookup tables have already been read in");
            } else {
                logger.debug(this.CALORIMETER_NAME + ": lookup table values have not been read in yet\n" + "  trying to read file: " + LOOKUP_TABLE_FILE);
                try {
                    this.readLookupTableFile();
                    logger.debug(this.CALORIMETER_NAME + ": values from " + LOOKUP_TABLE_FILE + " successfully read in");
                }
                catch (AAtlantisException ex) {
                    logger.error(this.CALORIMETER_NAME + ": reading " + LOOKUP_TABLE_FILE + " failed, real pulse shapes plots will not " + "be available, reason: " + ex.getMessage(), ex);
                    pulseShapesDataAvailable = false;
                }
            }
        }
    }

    private void readLookupTableFile() throws AAtlantisException {
        try {
            InputStream is = AUtilities.getFileAsStream(LOOKUP_TABLE_FILE);
            CSVParser parser = new CSVParser(is);
            parser.setCommentStart("#");
            String arrayName = null;
            while ((arrayName = parser.nextValue()) != null) {
                String valueArray = parser.nextValue();
                CSVParser parserArray = new CSVParser((Reader)new StringReader(valueArray));
                String[][] s = parserArray.getAllValues();
                float[] array = ALArData.getLookupTableArray(s, 799);
                ACalorimeterRPSPLT.setLarTable(arrayName, array);
            }
        }
        catch (FileNotFoundException e) {
            throw new AAtlantisException("could not find file: " + LOOKUP_TABLE_FILE);
        }
        catch (IOException e) {
            throw new AAtlantisException("exception while reading file: " + LOOKUP_TABLE_FILE);
        }
        catch (AAtlantisException e) {
            throw e;
        }
    }

    private void pulseShapePlotsDebugInfo(int index, String lookupTableName) {
        String msg = null;
        try {
            msg = "\n    barrel/endcap value: " + AIdHelper.larBarrelEndcap(this.id[index]);
            msg = msg + " is ";
            msg = msg + (AIdHelper.larIsBarrel(this.id[index]) ? "barrel" : "endcap");
            msg = msg + "\n    sampling/layer: " + this.sampling[index];
            msg = msg + "\n    region: " + AIdHelper.larRegion(this.id[index]);
            msg = msg + "\n    lookup table used: " + lookupTableName;
            logger.debug(msg + "\n");
        }
        catch (AAtlantisException aaex) {
            logger.debug("\n  exception: " + aaex.getMessage(), aaex);
        }
    }

    private static String getEtaBinIndex(float etaFrom, float etaTo, float cellEta, int startIndex) {
        float step = 0.1f;
        float absEta = Math.abs(cellEta);
        int index = startIndex;
        float f = etaFrom;
        while (f < etaTo) {
            if (absEta > f && absEta < f + step) {
                logger.debug("eta range calculation: cell eta = " + cellEta + " " + "etaFrom = " + etaFrom + " etaTo = " + etaTo);
                logger.debug("eta range index result: " + index + " (index offset was: " + startIndex + ")");
                return "ETA" + index + "_";
            }
            f += step;
            ++index;
        }
        return "";
    }

    private float[] getLookupTableForPulseShapesPlots(int index) throws AAtlantisException {
        float[] amplitude = null;
        float absEta = Math.abs(this.eta[index]);
        String lookupTableKey = "LAR_";
        if (AIdHelper.larIsBarrel(this.id[index])) {
            lookupTableKey = lookupTableKey + "BARREL_";
            block0 : switch (this.sampling[index]) {
                case 0: {
                    String[] decodedId = AIdHelper.getFullIdentifier(this.id[index]);
                    String title = "LAr cell: " + decodedId[0];
                    int[][] data = new int[][]{this.adcCounts[index]};
                    APulseShapePlot.plotADCCounts(data, title, null);
                    throw new AAtlantisException("ADC counts plot only, pulse shape plot not implemented for LAr barrel, layer 0");
                }
                case 1: {
                    lookupTableKey = lookupTableKey + "LAYER1_";
                    switch (AIdHelper.larRegion(this.id[index])) {
                        case 0: {
                            lookupTableKey = lookupTableKey + "REGION0_";
                            break block0;
                        }
                        case 1: {
                            lookupTableKey = lookupTableKey + "REGION1_";
                            break block0;
                        }
                    }
                    AOutput.append("\npulse shape plots - LAr barrel, layer 1, region > 1. Using layer 1, region 1 lookup table\n", "WARNING");
                    lookupTableKey = lookupTableKey + "REGION1_";
                    break;
                }
                case 2: {
                    lookupTableKey = lookupTableKey + "LAYER2_";
                    switch (AIdHelper.larRegion(this.id[index])) {
                        case 0: {
                            lookupTableKey = lookupTableKey + "REGION0_";
                            break block0;
                        }
                        case 1: {
                            lookupTableKey = lookupTableKey + "REGION1_";
                            break block0;
                        }
                    }
                    AOutput.append("\npulse shape plots - LAr barrel, layer 2, region > 1. Using layer 2, region 1 lookup table\n", "WARNING");
                    lookupTableKey = lookupTableKey + "REGION1_";
                    break;
                }
                case 3: {
                    lookupTableKey = lookupTableKey + "LAYER3_REGION0_";
                }
            }
        } else {
            lookupTableKey = lookupTableKey + "ENDCAP_";
            block14 : switch (this.sampling[index]) {
                case 0: {
                    lookupTableKey = lookupTableKey + "LAYER0_REGION0_ETA0_";
                    break;
                }
                case 1: {
                    lookupTableKey = lookupTableKey + "LAYER1_";
                    switch (AIdHelper.larRegion(this.id[index])) {
                        case 0: {
                            lookupTableKey = lookupTableKey + "REGION0_";
                            if (absEta > 1.375f && absEta < 1.425f) {
                                lookupTableKey = lookupTableKey + "ETA0_";
                                break block14;
                            }
                            lookupTableKey = lookupTableKey + ALArData.getEtaBinIndex(2.5f, 3.2f, this.eta[index], 1);
                            break block14;
                        }
                        case 1: {
                            lookupTableKey = lookupTableKey + "REGION1_ETA0_";
                            break block14;
                        }
                        case 2: {
                            lookupTableKey = lookupTableKey + "REGION2_";
                            lookupTableKey = lookupTableKey + ALArData.getEtaBinIndex(1.5f, 1.8f, this.eta[index], 0);
                            break block14;
                        }
                        case 3: {
                            lookupTableKey = lookupTableKey + "REGION3_";
                            lookupTableKey = lookupTableKey + ALArData.getEtaBinIndex(1.8f, 2.0f, this.eta[index], 0);
                            break block14;
                        }
                        case 4: {
                            lookupTableKey = lookupTableKey + "REGION4_";
                            lookupTableKey = lookupTableKey + ALArData.getEtaBinIndex(2.0f, 2.4f, this.eta[index], 0);
                            break block14;
                        }
                        case 5: {
                            lookupTableKey = lookupTableKey + "REGION5_";
                            if (!(absEta > 2.4f) || !(absEta < 2.5f)) break block14;
                            lookupTableKey = lookupTableKey + "ETA0_";
                            break block14;
                        }
                    }
                    AOutput.append("\npulse shape plots - LAr endcap, layer 1, region > 5. Using layer 1, region 5, eta range 0 lookup table\n", "WARNING");
                    lookupTableKey = lookupTableKey + "REGION5_ETA0_";
                    break;
                }
                case 2: {
                    lookupTableKey = lookupTableKey + "LAYER2_";
                    switch (AIdHelper.larRegion(this.id[index])) {
                        case 0: {
                            lookupTableKey = lookupTableKey + "REGION0_";
                            if (absEta > 1.375f && absEta < 1.425f) {
                                lookupTableKey = lookupTableKey + "ETA0_";
                                break;
                            }
                            lookupTableKey = lookupTableKey + ALArData.getEtaBinIndex(2.5f, 3.2f, this.eta[index], 1);
                            break;
                        }
                        case 1: {
                            lookupTableKey = lookupTableKey + "REGION1_";
                            lookupTableKey = lookupTableKey + ALArData.getEtaBinIndex(1.425f, 2.5f, this.eta[index], 0);
                        }
                    }
                    break;
                }
                case 3: {
                    lookupTableKey = lookupTableKey + "LAYER3_";
                    lookupTableKey = lookupTableKey + "REGION0_";
                    lookupTableKey = lookupTableKey + ALArData.getEtaBinIndex(1.5f, 2.5f, this.eta[index], 0);
                }
            }
        }
        lookupTableKey = lookupTableKey + "AMPLITUDE";
        this.pulseShapePlotsDebugInfo(index, lookupTableKey);
        amplitude = ACalorimeterRPSPLT.getLarTable(lookupTableKey);
        return amplitude;
    }

    public void plotADCCounts(int index) {
        if (!pulseShapesDataAvailable) {
            return;
        }
        String title = this.getPulseTitleString(index);
        int[][] adcCountsLocal = new int[][]{this.adcCounts[index]};
        logger.debug("Plotting only ADC counts plot ... ");
        APulseShapePlot.plotADCCounts(adcCountsLocal, title, null);
    }

    protected int[][] getADCCounts(int index) {
        if (pulseShapesDataAvailable) {
            for (int adc : this.adcCounts[index]) {
                if (adc == 0) continue;
                return new int[][]{this.adcCounts[index]};
            }
        }
        return null;
    }

    protected double getLocalTime(double xTime, double cellTime, int numSamplings) {
        int nominalPeakSample = (int)((double)numSamplings / 2.0);
        return (xTime - (double)nominalPeakSample + 3.0) * 25.0 - cellTime;
    }

    protected double[][] getPulseShape(int index) {
        float[] amplitude = null;
        float[] time = null;
        try {
            time = ACalorimeterRPSPLT.getLarTable("LAR_TIME");
            amplitude = this.getLookupTableForPulseShapesPlots(index);
        }
        catch (AAtlantisException ex) {
            AOutput.append("\n" + ex.getMessage(), "WARNING");
            logger.error(ex.getMessage());
            return null;
        }
        double step = this.getPulseStep(index);
        double[][] realPulse = new double[1][799];
        double d = 1.0;
        float factor = this.adc2Mev[index];
        double energyLocal = (double)this.energy[index] * 1000.0 / (double)factor;
        try {
            if (factor != -1.0f) {
                for (int i = 0; i < 799; ++i) {
                    double localTime = this.getLocalTime(d += step, this.cellTime[index], this.numSamplings);
                    realPulse[0][i] = super.getPhysicsPulseShape(localTime, this.cellPedestal[index], energyLocal, amplitude, time, 799);
                }
            }
        }
        catch (AAtlantisException aaex) {
            AOutput.append(aaex.getMessage(), "WARNING");
            logger.error(aaex.getMessage());
            return null;
        }
        if (factor != -1.0f) {
            logger.debug("adc2Mev factor available, plotting full plot.");
            return realPulse;
        }
        return null;
    }

    protected double getPulseStep(int index) {
        return (float)(this.adcCounts[0].length - 1) / 799.0f;
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n ET=" + AMath.d2s(this.et[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Ex=" + AMath.d2s((double)this.et[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Ey=" + AMath.d2s((double)this.et[index] * Math.sin(this.phi[index]), 3) + " GeV " + "\n Ez=" + AMath.d2s((double)this.et[index] * Math.sinh(this.eta[index]), 3) + " GeV ";
            }
            return output;
        }
        String t = "";
        String cellInfo = "";
        t = super.getHitInfo(index);
        cellInfo = cellInfo + "\n cell time = ";
        cellInfo = cellInfo + (this.cellTime != null ? Float.toString(this.cellTime[index]) + " ns" : "n/a");
        cellInfo = cellInfo + "\n cell gain = ";
        cellInfo = cellInfo + (this.cellGain != null ? Integer.toString(this.cellGain[index]) : "n/a");
        cellInfo = cellInfo + "\n cell pedestal = ";
        cellInfo = cellInfo + (this.cellPedestal != null ? Float.toString(this.cellPedestal[index]) + " ADC counts" : "n/a");
        cellInfo = cellInfo + "\n ADC 2 MeV = ";
        cellInfo = this.adc2Mev == null ? cellInfo + "n/a" : (this.adc2Mev[index] != -1.0f ? cellInfo + Float.toString(this.adc2Mev[index]) + " (from database)" : cellInfo + "-1 (n/a in database)");
        cellInfo = cellInfo + (pulseShapesDataAvailable ? "" : "\n data for real pulse shapes plot n/a");
        return t + cellInfo;
    }

    protected double getTime(int hit) {
        if (this.cellTime == null) {
            return 0.0;
        }
        return this.cellTime[hit];
    }

    private void cutEnergyByLayer(String groupName, String parameterName, String text, float[] array, int[] sampling, int currSampling) {
        AParameter par = APar.get(groupName, parameterName);
        if (par.getStatus() && array != null) {
            double value = par.getD();
            String operator = par.getOperator();
            int num = 0;
            if (operator.equals("<")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (sampling[this.listdl[i]] == currSampling) {
                        if (!((double)Math.abs(array[this.listdl[i]]) < value)) continue;
                        this.listdl[num++] = this.listdl[i];
                        continue;
                    }
                    this.listdl[num++] = this.listdl[i];
                }
            } else if (operator.equals(">")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (sampling[this.listdl[i]] == currSampling) {
                        if (!((double)Math.abs(array[this.listdl[i]]) >= value)) continue;
                        this.listdl[num++] = this.listdl[i];
                        continue;
                    }
                    this.listdl[num++] = this.listdl[i];
                }
            } else {
                throw new Error(operator + " operator not sensible for floats");
            }
            this.numDraw = num;
            AData.printCut(text, this.numDraw);
        }
    }

    protected void applyCuts() {
        super.applyCuts();
        this.cut("CutsCalo", "LArET", "LArET", this.et);
        this.cut("CutsCalo", "LArEnergy", "LArEnergy", this.energy);
        this.cutEnergyByLayer("CutsCalo", "LArEnergyLayer0", "LArEnergyLayer0", this.energy, this.sampling, 0);
        this.cutEnergyByLayer("CutsCalo", "LArEnergyLayer1", "LArEnergyLayer1", this.energy, this.sampling, 1);
        this.cutEnergyByLayer("CutsCalo", "LArEnergyLayer2", "LArEnergyLayer2", this.energy, this.sampling, 2);
        this.cutEnergyByLayer("CutsCalo", "LArEnergyLayer3", "LArEnergyLayer3", this.energy, this.sampling, 3);
        int cutSub = APar.get("CutsCalo", "LAr").getI();
        if (cutSub != -1) {
            int num = 0;
            block6: for (int i = 0; i < this.numDraw; ++i) {
                switch (cutSub) {
                    case 0: {
                        if (this.side[this.listdl[i]] != -2 && this.side[this.listdl[i]] != -3) continue block6;
                        this.listdl[num++] = this.listdl[i];
                        continue block6;
                    }
                    case 1: {
                        if (this.side[this.listdl[i]] != 2 && this.side[this.listdl[i]] != 3) continue block6;
                        this.listdl[num++] = this.listdl[i];
                        continue block6;
                    }
                    case 2: {
                        if (Math.abs(this.side[this.listdl[i]]) == 1) continue block6;
                        this.listdl[num++] = this.listdl[i];
                        continue block6;
                    }
                    case 3: {
                        if (Math.abs(this.side[this.listdl[i]]) != 1) continue block6;
                        this.listdl[num++] = this.listdl[i];
                        continue block6;
                    }
                }
            }
            this.numDraw = num;
            AData.printCut(" Endcap", this.numDraw);
        }
    }

    public String getParameterGroup() {
        return "LAr";
    }

    public String getName() {
        return "LAr";
    }

    public String getNameScreenName() {
        return "LAr";
    }

    public String getCalorimeterType(int index) {
        return "ECAL";
    }

    protected ACoord[] getUserHistograms(AProjection2D projection) {
        ACoord[] data = ACoord.NO_HISTOGRAMS;
        int mode = APar.get("YX", "Mode").getI();
        if (projection instanceof AProjectionYX && (mode == 0 || mode == 12 || mode == 13 || mode == 14 || mode == 15 || mode == 20)) {
            data = this.getYXHistograms();
        } else if (projection instanceof AProjectionFR) {
            data = this.getFRHistograms();
        } else if (projection instanceof AProjectionRZ) {
            data = this.getRZHistograms();
        } else if (projection instanceof AProjectionFZ) {
            data = this.getFZHistograms();
        }
        return projection.nonLinearTransform(data);
    }
}

