/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.canvas.AWindow;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawParameters;
import atlantis.graphics.ADrawable;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionVP;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;
import atlantis.utils.APolygon;
import java.awt.Color;

public class ALVL1JetElementData
extends AData {
    private float[] energy;
    private float[] eta;
    private float[] deta;
    private float[] phi;
    private float[] dphi;

    ALVL1JetElementData(AHashMap p, AEvent e) {
        super(p, e);
        this.phi = p.getFloatArray("phi");
        this.eta = p.getFloatArray("eta");
        this.energy = p.getFloatArray("energy");
        this.deta = new float[this.numData];
        this.dphi = new float[this.numData];
        this.fillGranularity();
    }

    private void fillGranularity() {
        for (int i = 0; i < this.numData; ++i) {
            float positiveEta = Math.abs(this.eta[i]);
            if ((double)positiveEta <= 2.4) {
                this.deta[i] = 0.1f;
                this.dphi[i] = 0.09817477f;
                continue;
            }
            if ((double)positiveEta <= 2.7) {
                this.deta[i] = 0.15f;
                this.dphi[i] = 0.09817477f;
                continue;
            }
            if ((double)positiveEta <= 2.9) {
                this.deta[i] = 0.1f;
                this.dphi[i] = 0.09817477f;
                continue;
            }
            if ((double)positiveEta <= 3.2) {
                this.deta[i] = 0.15f;
                this.dphi[i] = 0.09817477f;
                continue;
            }
            this.deta[i] = 0.9f;
            this.dphi[i] = 0.19634955f;
        }
    }

    public double getEta(int index) {
        return this.eta[index];
    }

    public double getdEta(int index) {
        return this.deta[index];
    }

    public double getPhi(int index) {
        return this.phi[index];
    }

    public double getdPhi(int index) {
        return this.dphi[index];
    }

    public double getET(int index) {
        return this.energy[index];
    }

    public String getNameScreenName() {
        return "LVL1JetElement";
    }

    public String getParameterGroup() {
        return "LVL1JetElement";
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n E=" + AMath.d2s(this.energy[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
        }
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" (id: " + this.id[index] + " index: " + index + ")");
        msg.append("\n Energy = ");
        msg.append(AMath.d2s(this.energy[index], 3));
        msg.append(" GeV\n ");
        msg.append("\u03b7");
        msg.append(" = ");
        msg.append(AMath.d2s(this.eta[index], 3));
        msg.append("\n ");
        msg.append("\u03a6");
        msg.append(" = ");
        msg.append(AMath.d2s(Math.toDegrees(this.phi[index]), 3));
        msg.append("\u00b0");
        msg.append("  (" + AMath.d2s(this.phi[index], 3) + " rad)");
        return msg.toString();
    }

    protected void applyCuts() {
        AData.printCut(this.getParameterGroup(), this.numDraw);
        this.cutIndex();
        this.cut("CutsCalo", "LVL1TriggerET", " ET", this.energy);
        this.cutPhi(this.phi, this.dphi);
        this.cutEtaDEta(this.eta, this.deta);
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == 0) {
            this.colorByConstant();
        }
        return 1;
    }

    protected int getDrawOrFill() {
        return 1;
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiPlus = this.phi[list] + this.dphi[list];
            double phiMinus = this.phi[list] - this.dphi[list];
            double cosPlus = Math.cos(phiPlus);
            double sinPlus = Math.sin(phiPlus);
            double cosMinus = Math.cos(phiMinus);
            double sinMinus = Math.sin(phiMinus);
            double rhoMax = 380.0;
            double rhoMinus = 155.0;
            double maxEnergy = APar.get("Projection", "EnergyMax").getD();
            double rhoPlus = rhoMax;
            if ((double)Math.abs(this.energy[list]) < maxEnergy) {
                rhoPlus = rhoMinus + (rhoMax - rhoMinus) * (double)Math.abs(this.energy[list]) / maxEnergy;
            }
            hv[0][i][0] = rhoMinus * cosPlus;
            hv[1][i][0] = rhoMinus * sinPlus;
            hv[0][i][1] = rhoPlus * cosPlus;
            hv[1][i][1] = rhoPlus * sinPlus;
            hv[0][i][2] = rhoPlus * cosMinus;
            hv[1][i][2] = rhoPlus * sinMinus;
            hv[0][i][3] = rhoMinus * cosMinus;
            hv[1][i][3] = rhoMinus * sinMinus;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 4);
    }

    protected ACoord getFRUser() {
        ACoord coordFR = this.getYXUser().convertYXToFR().includePhiWrapAround("FR");
        return coordFR;
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
            double phiDiff = Math.abs((double)this.phi[list] - phiMid);
            double rSign = phiDiff > 1.5707963267948966 && phiDiff <= 4.71238898038469 ? -1.0 : 1.0;
            double theta = Math.atan(Math.exp(-Math.abs(this.eta[list]))) * 2.0;
            double thetaPlus = Math.atan(Math.exp(-(Math.abs(this.eta[list]) - this.deta[list]))) * 2.0;
            double thetaMinus = Math.atan(Math.exp(-(Math.abs(this.eta[list]) + this.deta[list]))) * 2.0;
            if ((double)this.eta[list] > 0.0 && rSign == -1.0) {
                theta = Math.PI * 2 - theta;
                thetaPlus = Math.PI * 2 - thetaPlus;
                thetaMinus = Math.PI * 2 - thetaMinus;
            } else if ((double)this.eta[list] < 0.0 && rSign == -1.0) {
                theta += Math.PI;
                thetaPlus += Math.PI;
                thetaMinus += Math.PI;
            } else if ((double)this.eta[list] < 0.0 && rSign == 1.0) {
                theta = Math.PI - theta;
                thetaPlus = Math.PI - thetaPlus;
                thetaMinus = Math.PI - thetaMinus;
            }
            double cosPlus = Math.cos(thetaPlus);
            double sinPlus = Math.sin(thetaPlus);
            double cosMinus = Math.cos(thetaMinus);
            double sinMinus = Math.sin(thetaMinus);
            boolean LAR = false;
            boolean LAR_ENDCAP = true;
            int FCAL_EM = 2;
            int region = 0;
            if (Math.abs(Math.tan(theta)) >= 0.0778 && Math.abs(Math.tan(theta)) < 0.4828) {
                region = 1;
            } else if (Math.abs(Math.tan(theta)) < 0.0778) {
                region = 2;
            }
            double radiusMinus = 0.0;
            switch (region) {
                case 0: {
                    radiusMinus = 155.0 / Math.abs(Math.sin(theta));
                    break;
                }
                case 1: {
                    radiusMinus = 380.0 / Math.abs(Math.cos(theta));
                    break;
                }
                case 2: {
                    radiusMinus = 470.0 / Math.abs(Math.cos(theta));
                }
            }
            double radiusMax = radiusMinus + 200.0;
            double maxEnergy = APar.get("Projection", "EnergyMax").getD();
            double radiusPlus = radiusMax;
            if ((double)Math.abs(this.energy[list]) < maxEnergy) {
                radiusPlus = radiusMinus + (radiusMax - radiusMinus) * (double)Math.abs(this.energy[list]) / maxEnergy;
            }
            hv[0][i][0] = radiusMinus * cosPlus;
            hv[1][i][0] = radiusMinus * sinPlus;
            hv[0][i][1] = radiusPlus * cosPlus;
            hv[1][i][1] = radiusPlus * sinPlus;
            hv[0][i][2] = radiusPlus * cosMinus;
            hv[1][i][2] = radiusPlus * sinMinus;
            hv[0][i][3] = radiusMinus * cosMinus;
            hv[1][i][3] = radiusMinus * sinMinus;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 4);
    }

    protected ACoord getVPUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.eta[list];
            v[i] = Math.toDegrees(this.phi[list]);
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("VP");
    }

    public void draw(AWindow window, AGraphics ag, AProjection2D projection) {
        if (projection instanceof AProjectionVP) {
            int i;
            ACoord centers = this.getUser(projection);
            int[] drawlist = centers.index;
            double[] density = new double[drawlist.length];
            double maxDensity = 0.0;
            double[][][] hv = new double[2][drawlist.length][4];
            int[] index = new int[drawlist.length];
            for (i = 0; i < drawlist.length; ++i) {
                int list = drawlist[i];
                hv[1][i][0] = centers.hv[1][0][i] + Math.toDegrees(this.getdPhi(list));
                hv[1][i][1] = centers.hv[1][0][i] - Math.toDegrees(this.getdPhi(list));
                hv[1][i][2] = centers.hv[1][0][i] - Math.toDegrees(this.getdPhi(list));
                hv[1][i][3] = centers.hv[1][0][i] + Math.toDegrees(this.getdPhi(list));
                hv[0][i][0] = centers.hv[0][0][i] - this.getdEta(list);
                hv[0][i][1] = centers.hv[0][0][i] - this.getdEta(list);
                hv[0][i][2] = centers.hv[0][0][i] + this.getdEta(list);
                hv[0][i][3] = centers.hv[0][0][i] + this.getdEta(list);
                index[i] = list;
                density[i] = (double)Math.abs(this.energy[list]) / (this.getdPhi(list) * this.getdEta(list));
                if (i == 0) {
                    maxDensity = density[i];
                    continue;
                }
                if (!(density[i] > maxDensity)) continue;
                maxDensity = density[i];
            }
            ACoord geoCell = window.calculateDisplay(new ACoord(hv, index, (ADrawable)this, 4));
            this.drawGeometry(geoCell, window, ag);
            for (i = 0; i < density.length; ++i) {
                double factor = Math.sqrt(density[i] / maxDensity);
                APolygon.scale(geoCell.hv[0][i], geoCell.hv[1][i], factor);
            }
            this.drawHits(geoCell, window, ag);
        } else {
            super.draw(window, ag, projection);
        }
    }

    private void drawGeometry(ACoord display, AWindow window, AGraphics ag) {
        Color[] colorMap = AColorMap.getColors();
        boolean drawCellGeometry = APar.get(this.getParameterGroup(), "CellGeometry").getStatus();
        boolean drawCellOutline = APar.get(this.getParameterGroup(), "CellOutline").getStatus();
        int cellGeometryColor = APar.get(this.getParameterGroup(), "CellGeometry").getI();
        int cellOutlineColor = APar.get(this.getParameterGroup(), "CellOutline").getI();
        boolean drawFrame = APar.get(this.getParameterGroup(), "Frame").getStatus();
        int frameColor = APar.get(this.getParameterGroup(), "Frame").getI();
        int frameWidth = APar.get(this.getParameterGroup(), "FrameWidth").getI();
        drawFrame = drawFrame && AColorMap.drawFrames();
        if (!drawCellGeometry && !drawCellOutline) {
            return;
        }
        for (int i = 0; i < display.hv[0].length; ++i) {
            if (drawCellGeometry) {
                if (drawFrame) {
                    ag.updateDrawParameters(new ADrawParameters(true, frameColor, 1, 0, frameWidth, 0));
                    ag.drawPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
                }
                ag.updateDrawParameters(new ADrawParameters(true, cellGeometryColor, 1, 0, 0, 0));
                ag.fillPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
            }
            if (!drawCellOutline) continue;
            ag.setColor(colorMap[cellOutlineColor]);
            ag.drawPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
        }
    }

    private void drawHits(ACoord display, AWindow window, AGraphics ag) {
        int i;
        int[] color = this.getColor(display.index);
        boolean drawCellGeometry = APar.get(this.getParameterGroup(), "CellGeometry").getStatus();
        boolean drawFrame = APar.get(this.getParameterGroup(), "Frame").getStatus();
        int frameColor = APar.get(this.getParameterGroup(), "Frame").getI();
        int frameWidth = APar.get(this.getParameterGroup(), "FrameWidth").getI();
        if (drawFrame && !drawCellGeometry) {
            for (i = 0; i < display.hv[0].length; ++i) {
                ag.updateDrawParameters(new ADrawParameters(true, frameColor, 1, 0, frameWidth, 0));
                ag.drawPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
            }
        }
        for (i = 0; i < display.hv[0].length; ++i) {
            int lineWidth = APar.get(this.getParameterGroup(), "LineWidth").getI();
            ag.updateDrawParameters(new ADrawParameters(true, color[i], 1, lineWidth, 0, 0));
            ag.fillPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
        }
    }
}

