/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.canvas.AWindow;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawParameters;
import atlantis.graphics.ADrawable;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.list.AListManager;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionYX;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;
import atlantis.utils.APolygon;
import atlantis.utils.APulseShapePlot;
import java.util.Arrays;

public class ALVL1TriggerTowerData
extends AData {
    public static final boolean ELECTROMAGNETIC = true;
    public static final boolean HADRONIC = false;
    private float[] emEnergy;
    private float[] hadEnergy;
    private float[] sumEnergy;
    private float[] eta;
    private float[] deta_em;
    private float[] deta_had;
    private float[] phi;
    private float[] dphi_em;
    private float[] dphi_had;
    private int[] numADC;
    private int[][] hadADC;
    private int[][] emADC;
    private int[] emBCID;
    private int[] hadBCID;
    private int[] isEMSaturated;
    private int[] isHadSaturated;

    ALVL1TriggerTowerData(AHashMap p, AEvent e) {
        super(p, e);
        this.phi = p.getFloatArray("phi");
        this.eta = p.getFloatArray("eta");
        this.emEnergy = p.getFloatArray("emEnergy");
        this.hadEnergy = p.getFloatArray("hadEnergy");
        this.sumEnergy = p.getFloatArray("sumEnergy");
        this.deta_em = new float[this.numData];
        this.deta_had = new float[this.numData];
        this.dphi_em = new float[this.numData];
        this.dphi_had = new float[this.numData];
        this.fillGranularity();
        this.numADC = p.getIntArray("numADC");
        this.emADC = this.fillADC(p.getIntArray("emADC"));
        this.hadADC = this.fillADC(p.getIntArray("hadADC"));
        this.emBCID = p.getIntArray("emBCID");
        this.hadBCID = p.getIntArray("hadBCID");
        this.isEMSaturated = p.getIntArray("isEMSaturated");
        this.isHadSaturated = p.getIntArray("isHadSaturated");
    }

    private void fillGranularity() {
        for (int i = 0; i < this.numData; ++i) {
            float positiveEta = Math.abs(this.eta[i]);
            if ((double)positiveEta <= 2.4) {
                this.deta_em[i] = 0.05f;
                this.dphi_em[i] = 0.049087387f;
                this.deta_had[i] = 0.05f;
                this.dphi_had[i] = 0.049087387f;
                continue;
            }
            if ((double)positiveEta <= 2.5) {
                this.deta_em[i] = 0.05f;
                this.dphi_em[i] = 0.049087387f;
                this.deta_had[i] = 0.1f;
                this.dphi_had[i] = 0.09817477f;
                continue;
            }
            if ((double)positiveEta <= 3.0) {
                this.deta_em[i] = 0.1f;
                this.dphi_em[i] = 0.09817477f;
                this.deta_had[i] = 0.1f;
                this.dphi_had[i] = 0.09817477f;
                continue;
            }
            if ((double)positiveEta <= 3.1) {
                this.deta_em[i] = 0.1f;
                this.dphi_em[i] = 0.09817477f;
                this.deta_had[i] = 0.05f;
                this.dphi_had[i] = 0.09817477f;
                continue;
            }
            if ((double)positiveEta <= 3.2) {
                this.deta_em[i] = 0.05f;
                this.dphi_em[i] = 0.09817477f;
                this.deta_had[i] = 0.2f;
                this.dphi_had[i] = 0.19634955f;
                continue;
            }
            if ((double)positiveEta <= 4.3) {
                this.deta_em[i] = 0.2f;
                this.dphi_em[i] = 0.19634955f;
                this.deta_had[i] = 0.2f;
                this.dphi_had[i] = 0.19634955f;
                continue;
            }
            if ((double)positiveEta <= 4.4) {
                this.deta_em[i] = 0.2f;
                this.dphi_em[i] = 0.19634955f;
                this.deta_had[i] = 0.35f;
                this.dphi_had[i] = 0.19634955f;
                continue;
            }
            this.deta_em[i] = 0.3f;
            this.dphi_em[i] = 0.19634955f;
            this.deta_had[i] = 0.35f;
            this.dphi_had[i] = 0.19634955f;
        }
    }

    public int[][] fillADC(int[] tempADC) {
        int[][] ADC = null;
        if (tempADC != null) {
            ADC = new int[this.numADC.length][0];
            int num = 0;
            for (int i = 0; i < this.numADC.length; ++i) {
                ADC[i] = new int[this.numADC[i]];
                for (int j = 0; j < this.numADC[i]; ++j) {
                    ADC[i][j] = tempADC[num];
                    ++num;
                }
            }
        }
        return ADC;
    }

    public void plotPulseShapes(int index) {
        if (this.emADC != null && this.hadADC != null) {
            String[] labels = new String[]{"EM trigger ADC counts", "HAD trigger ADC counts", "Sum trigger ADC counts"};
            int[] sumADC = new int[this.emADC[index].length];
            String[] axis = new String[3];
            String[] colors = new String[3];
            colors[0] = this.isEMSaturated[index] == 0 ? "blue" : "red";
            axis[0] = "index (BCID=" + this.emBCID[index] + ")";
            if (this.isHadSaturated[index] == 0) {
                colors[1] = "blue";
            } else {
                colors[0] = "red";
            }
            axis[1] = "index (BCID=" + this.hadBCID[index] + ")";
            colors[2] = "blue";
            axis[2] = "index";
            for (int i = 0; i < this.emADC[index].length; ++i) {
                sumADC[i] = this.emADC[index][i] + this.hadADC[index][i];
            }
            int[][] data = new int[][]{this.emADC[index], this.hadADC[index], sumADC};
            String title = "LVL1TriggerTower " + this.id[index] + " ADC counts";
            APulseShapePlot.plotADCCounts(data, title, axis, labels, colors);
        } else {
            String[] axis;
            int[][] data;
            if (this.emADC != null) {
                data = new int[][]{this.emADC[index]};
                axis = new String[]{"index"};
                APulseShapePlot.plotADCCounts(data, "EM trigger ADC counts", axis);
            }
            if (this.hadADC != null) {
                data = new int[][]{this.hadADC[index]};
                axis = new String[]{"index"};
                APulseShapePlot.plotADCCounts(data, "HAD trigger ADC counts", axis);
            }
        }
    }

    public double getEta(int index) {
        return this.eta[index];
    }

    public double getdEta(int index, boolean emOrHad) {
        if (emOrHad) {
            return this.deta_em[index];
        }
        return this.deta_had[index];
    }

    public double getPhi(int index) {
        return this.phi[index];
    }

    public double getdPhi(int index, boolean emOrHad) {
        if (emOrHad) {
            return this.dphi_em[index];
        }
        return this.dphi_had[index];
    }

    public double getET(int index, boolean emOrHad) {
        if (emOrHad) {
            return this.emEnergy[index];
        }
        return this.hadEnergy[index];
    }

    public double getSumET(int index) {
        return this.sumEnergy[index];
    }

    public String getNameScreenName() {
        return "LVL1TriggerTower";
    }

    public String getParameterGroup() {
        return "LVL1TriggerTower";
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n E=" + AMath.d2s(this.sumEnergy[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
        }
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" (id: " + this.id[index] + " index: " + index + ")");
        msg.append("\n EM Energy = ");
        msg.append(AMath.d2s(this.emEnergy[index], 3));
        msg.append(" GeV\n Had Energy = ");
        msg.append(AMath.d2s(this.hadEnergy[index], 3));
        msg.append(" GeV\n Sum Energy = ");
        msg.append(AMath.d2s(this.sumEnergy[index], 3));
        msg.append(" GeV\n ");
        msg.append("\u03b7");
        msg.append(" = ");
        msg.append(AMath.d2s(this.eta[index], 3));
        msg.append("\n ");
        msg.append("\u03a6");
        msg.append(" = ");
        msg.append(AMath.d2s(Math.toDegrees(this.phi[index]), 3));
        msg.append("\u00b0");
        msg.append("  (" + AMath.d2s(this.phi[index], 3) + " rad)");
        return msg.toString();
    }

    protected void applyCuts() {
        AData.printCut(this.getParameterGroup(), this.numDraw);
        this.cutIndex();
        this.cut("CutsCalo", "LVL1TriggerET", " ET", this.sumEnergy);
    }

    public void applyEMCuts() {
        this.cutPhi(this.phi, this.dphi_em);
        this.cutEtaDEta(this.eta, this.deta_em);
    }

    public void applyHadCuts() {
        this.cutPhi(this.phi, this.dphi_had);
        this.cutEtaDEta(this.eta, this.deta_had);
    }

    public byte[] getColor(boolean emOrHad) {
        this.internalColor(emOrHad);
        this.coloring();
        byte[] temp = new byte[this.id.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.color[this.getIndexFromId(this.id[i])];
        }
        return temp;
    }

    public int[] getColor(int[] dl) {
        this.coloring();
        int[] temp = new int[dl.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.color[dl[i]];
        }
        return temp;
    }

    public void coloring() {
        int[][] temp = AListManager.getInstance().getColorMapping(this);
        int[] index = temp[0];
        int[] c = temp[1];
        for (int i = 0; i < index.length; ++i) {
            if (c[i] < 0) continue;
            this.color[index[i]] = (byte)c[i];
        }
        int others = AListManager.getInstance().getColorOfOthers();
        if (others >= 0 && APar.get("Data", this.getName()).getStatus()) {
            int i;
            boolean[] inList = new boolean[this.numData];
            for (i = 0; i < index.length; ++i) {
                inList[index[i]] = true;
            }
            for (i = 0; i < this.numData; ++i) {
                if (inList[i]) continue;
                this.color[i] = (byte)others;
            }
        }
    }

    protected int internalColor() {
        this.colorByConstant();
        return 1;
    }

    protected int internalColor(boolean emOrHad) {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == 0) {
            this.colorByConstant();
        } else if (colorFunction == 1) {
            if (emOrHad) {
                Arrays.fill(this.color, (byte)(APar.get("Det", "ECALFill").getI() + 12));
            } else {
                Arrays.fill(this.color, (byte)(APar.get("Det", "HCALFill").getI() + 12));
            }
        }
        return 1;
    }

    protected int getDrawOrFill() {
        return 1;
    }

    private void drawVP(AWindow window, AGraphics ag, boolean emOrHad) {
        int i;
        ACoord centers = this.getVPUser(emOrHad);
        if (centers == null) {
            return;
        }
        int[] drawlist = centers.index;
        double[] density = new double[drawlist.length];
        double[] sumDensity = new double[drawlist.length];
        double maxDensity = 0.0;
        double[][][] hv = new double[2][drawlist.length][4];
        int[] index = new int[drawlist.length];
        for (i = 0; i < drawlist.length; ++i) {
            int list = drawlist[i];
            hv[1][i][0] = centers.hv[1][0][i] + Math.toDegrees(this.getdPhi(list, emOrHad));
            hv[1][i][1] = centers.hv[1][0][i] - Math.toDegrees(this.getdPhi(list, emOrHad));
            hv[1][i][2] = centers.hv[1][0][i] - Math.toDegrees(this.getdPhi(list, emOrHad));
            hv[1][i][3] = centers.hv[1][0][i] + Math.toDegrees(this.getdPhi(list, emOrHad));
            hv[0][i][0] = centers.hv[0][0][i] - this.getdEta(list, emOrHad);
            hv[0][i][1] = centers.hv[0][0][i] - this.getdEta(list, emOrHad);
            hv[0][i][2] = centers.hv[0][0][i] + this.getdEta(list, emOrHad);
            hv[0][i][3] = centers.hv[0][0][i] + this.getdEta(list, emOrHad);
            index[i] = list;
            density[i] = Math.abs(this.getET(list, emOrHad)) / (this.getdPhi(list, emOrHad) * this.getdEta(list, emOrHad));
            sumDensity[i] = Math.abs(this.getSumET(list)) / (this.getdPhi(list, emOrHad) * this.getdEta(list, emOrHad));
            if (i == 0) {
                maxDensity = sumDensity[i];
                continue;
            }
            if (!(sumDensity[i] > maxDensity)) continue;
            maxDensity = sumDensity[i];
        }
        ACoord geoCell = window.calculateDisplay(new ACoord(hv, index, (ADrawable)this, 4));
        this.drawGeometry(geoCell, window, ag, density);
        for (i = 0; i < density.length; ++i) {
            double factor = Math.sqrt(density[i] / maxDensity);
            APolygon.scale(geoCell.hv[0][i], geoCell.hv[1][i], factor);
        }
        this.drawHits(geoCell, window, ag, density);
    }

    public void draw(AWindow window, AGraphics ag, AProjection2D projection) {
        int energyType = APar.get(this.PARAMETER_GROUP, "EnergyType").getI();
        if (projection instanceof AProjectionYX) {
            if (energyType == 0 || energyType == 2) {
                this.internalColor(true);
                ag.draw(window.calculateDisplay(projection.nonLinearTransform(this.getYXUser(true))));
            }
            if (energyType == 1 || energyType == 2) {
                this.internalColor(false);
                ag.draw(window.calculateDisplay(projection.nonLinearTransform(this.getYXUser(false))));
            }
        } else if (projection instanceof AProjectionFR) {
            if (energyType == 0 || energyType == 2) {
                this.internalColor(true);
                ag.draw(window.calculateDisplay(projection.nonLinearTransform(this.getFRUser(true))));
            }
            if (energyType == 1 || energyType == 2) {
                this.internalColor(false);
                ag.draw(window.calculateDisplay(projection.nonLinearTransform(this.getFRUser(false))));
            }
        } else if (projection instanceof AProjectionRZ) {
            if (energyType == 0 || energyType == 2) {
                this.internalColor(true);
                ag.draw(window.calculateDisplay(projection.nonLinearTransform(this.getRZUser(true))));
            }
            if (energyType == 1 || energyType == 2) {
                this.internalColor(false);
                ag.draw(window.calculateDisplay(projection.nonLinearTransform(this.getRZUser(false))));
            }
        } else if (projection instanceof AProjectionVP) {
            if (energyType == 0 || energyType == 2) {
                this.internalColor(true);
                this.drawVP(window, ag, true);
            }
            if (energyType == 1 || energyType == 2) {
                this.internalColor(false);
                this.drawVP(window, ag, false);
            }
        } else {
            super.draw(window, ag, projection);
        }
    }

    private ACoord getYXUser(boolean emOrHad) {
        this.makeDrawList();
        if (emOrHad) {
            this.applyEMCuts();
        } else {
            this.applyHadCuts();
        }
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            double rhoMinus;
            double rhoMax;
            int list = this.listdl[i];
            double et = this.getET(list, emOrHad);
            if (et == 0.0) continue;
            double dphi = this.getdPhi(list, emOrHad);
            double phiPlus = (double)this.phi[list] + dphi;
            double phiMinus = (double)this.phi[list] - dphi;
            double cosPlus = Math.cos(phiPlus);
            double sinPlus = Math.sin(phiPlus);
            double cosMinus = Math.cos(phiMinus);
            double sinMinus = Math.sin(phiMinus);
            if (emOrHad) {
                rhoMax = 195.0;
                rhoMinus = 155.0;
            } else {
                rhoMax = 380.0;
                rhoMinus = 235.0;
            }
            double maxEnergy = APar.get("Projection", "EnergyMax").getD();
            double rhoPlus = rhoMax;
            if (Math.abs(et) < maxEnergy) {
                rhoPlus = rhoMinus + (rhoMax - rhoMinus) * Math.abs(et) / maxEnergy;
            }
            hv[0][i][0] = rhoMinus * cosPlus;
            hv[1][i][0] = rhoMinus * sinPlus;
            hv[0][i][1] = rhoPlus * cosPlus;
            hv[1][i][1] = rhoPlus * sinPlus;
            hv[0][i][2] = rhoPlus * cosMinus;
            hv[1][i][2] = rhoPlus * sinMinus;
            hv[0][i][3] = rhoMinus * cosMinus;
            hv[1][i][3] = rhoMinus * sinMinus;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 4);
    }

    protected ACoord getFRUser(boolean emOrHad) {
        ACoord coordFR = this.getYXUser(emOrHad).convertYXToFR().includePhiWrapAround("FR");
        return coordFR;
    }

    protected ACoord getRZUser(boolean emOrHad) {
        this.makeDrawList();
        if (emOrHad) {
            this.applyEMCuts();
        } else {
            this.applyHadCuts();
        }
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double et = this.getET(list, emOrHad);
            if (et == 0.0) continue;
            double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
            double phiDiff = Math.abs((double)this.phi[list] - phiMid);
            double rSign = phiDiff > 1.5707963267948966 && phiDiff <= 4.71238898038469 ? -1.0 : 1.0;
            double theta = Math.atan(Math.exp(-Math.abs(this.eta[list]))) * 2.0;
            double deta = this.getdEta(list, emOrHad);
            double thetaPlus = Math.atan(Math.exp(-((double)Math.abs(this.eta[list]) - deta))) * 2.0;
            double thetaMinus = Math.atan(Math.exp(-((double)Math.abs(this.eta[list]) + deta))) * 2.0;
            if ((double)this.eta[list] > 0.0 && rSign == -1.0) {
                theta = Math.PI * 2 - theta;
                thetaPlus = Math.PI * 2 - thetaPlus;
                thetaMinus = Math.PI * 2 - thetaMinus;
            } else if ((double)this.eta[list] < 0.0 && rSign == -1.0) {
                theta += Math.PI;
                thetaPlus += Math.PI;
                thetaMinus += Math.PI;
            } else if ((double)this.eta[list] < 0.0 && rSign == 1.0) {
                theta = Math.PI - theta;
                thetaPlus = Math.PI - thetaPlus;
                thetaMinus = Math.PI - thetaMinus;
            }
            double cosPlus = Math.cos(thetaPlus);
            double sinPlus = Math.sin(thetaPlus);
            double cosMinus = Math.cos(thetaMinus);
            double sinMinus = Math.sin(thetaMinus);
            boolean LAR = false;
            boolean LAR_ENDCAP = true;
            int FCAL_EM = 2;
            int region = 0;
            if (Math.abs(Math.tan(theta)) >= 0.0778 && Math.abs(Math.tan(theta)) < 0.4828) {
                region = 1;
            } else if (Math.abs(Math.tan(theta)) < 0.0778) {
                region = 2;
            }
            double radiusMinus = 0.0;
            double radiusMax = 0.0;
            switch (region) {
                case 0: {
                    if (emOrHad) {
                        radiusMax = 195.0 / Math.abs(Math.sin(theta));
                        radiusMinus = 155.0 / Math.abs(Math.sin(theta));
                        break;
                    }
                    radiusMax = 380.0 / Math.abs(Math.sin(theta));
                    radiusMinus = 235.0 / Math.abs(Math.sin(theta));
                    break;
                }
                case 1: {
                    if (emOrHad) {
                        radiusMax = 420.0 / Math.abs(Math.cos(theta));
                        radiusMinus = 380.0 / Math.abs(Math.cos(theta));
                        break;
                    }
                    radiusMax = 585.0 / Math.abs(Math.cos(theta));
                    radiusMinus = 440.0 / Math.abs(Math.cos(theta));
                    break;
                }
                case 2: {
                    if (emOrHad) {
                        radiusMax = 510.0 / Math.abs(Math.cos(theta));
                        radiusMinus = 470.0 / Math.abs(Math.cos(theta));
                        break;
                    }
                    radiusMax = 600.0 / Math.abs(Math.cos(theta));
                    radiusMinus = 520.0 / Math.abs(Math.cos(theta));
                }
            }
            double maxEnergy = APar.get("Projection", "EnergyMax").getD();
            double radiusPlus = radiusMax;
            if (Math.abs(et) < maxEnergy) {
                radiusPlus = radiusMinus + (radiusMax - radiusMinus) * Math.abs(et) / maxEnergy;
            }
            hv[0][i][0] = radiusMinus * cosPlus;
            hv[1][i][0] = radiusMinus * sinPlus;
            hv[0][i][1] = radiusPlus * cosPlus;
            hv[1][i][1] = radiusPlus * sinPlus;
            hv[0][i][2] = radiusPlus * cosMinus;
            hv[1][i][2] = radiusPlus * sinMinus;
            hv[0][i][3] = radiusMinus * cosMinus;
            hv[1][i][3] = radiusMinus * sinMinus;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 4);
    }

    protected ACoord getVPUser(boolean emOrHad) {
        this.makeDrawList();
        if (emOrHad) {
            this.applyEMCuts();
        } else {
            this.applyHadCuts();
        }
        if (this.numDraw == 0) {
            return null;
        }
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.eta[list];
            v[i] = Math.toDegrees(this.phi[list]);
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("VP");
    }

    private void drawGeometry(ACoord display, AWindow window, AGraphics ag, double[] density) {
        boolean drawCellGeometry = APar.get(this.getParameterGroup(), "CellGeometry").getStatus();
        boolean drawCellOutline = APar.get(this.getParameterGroup(), "CellOutline").getStatus();
        int cellGeometryColor = APar.get(this.getParameterGroup(), "CellGeometry").getI();
        int cellOutlineColor = APar.get(this.getParameterGroup(), "CellOutline").getI();
        boolean drawFrame = APar.get(this.getParameterGroup(), "Frame").getStatus();
        int frameColor = APar.get(this.getParameterGroup(), "Frame").getI();
        int frameWidth = APar.get(this.getParameterGroup(), "FrameWidth").getI();
        drawFrame = drawFrame && AColorMap.drawFrames();
        if (!drawCellGeometry && !drawCellOutline) {
            return;
        }
        for (int i = 0; i < display.hv[0].length; ++i) {
            if (density[i] == 0.0) continue;
            if (drawCellGeometry) {
                if (drawFrame) {
                    ag.updateDrawParameters(new ADrawParameters(true, frameColor, 1, 0, frameWidth, 0));
                    ag.drawPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
                }
                ag.updateDrawParameters(new ADrawParameters(true, cellGeometryColor, 1, 0, 0, 0));
                ag.fillPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
            }
            if (!drawCellOutline) continue;
            ag.updateDrawParameters(new ADrawParameters(true, cellOutlineColor, 0, 1, 0, 0, false, 1, 0));
            ag.drawPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
        }
    }

    private void drawHits(ACoord display, AWindow window, AGraphics ag, double[] density) {
        int[] color = this.getColor(display.index);
        boolean drawCellGeometry = APar.get(this.getParameterGroup(), "CellGeometry").getStatus();
        boolean drawFrame = APar.get(this.getParameterGroup(), "Frame").getStatus();
        int frameColor = APar.get(this.getParameterGroup(), "Frame").getI();
        int frameWidth = APar.get(this.getParameterGroup(), "FrameWidth").getI();
        int lineWidth = APar.get(this.getParameterGroup(), "LineWidth").getI();
        for (int i = 0; i < display.hv[0].length; ++i) {
            if (density[i] == 0.0) continue;
            if (drawFrame && !drawCellGeometry) {
                ag.updateDrawParameters(new ADrawParameters(true, frameColor, 1, 0, frameWidth, 0));
                ag.drawPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
            }
            ag.updateDrawParameters(new ADrawParameters(true, color[i], 1, lineWidth, 0, 0));
            AGraphics.setCurrentDataAndIndex(this, display.index[i]);
            ag.fillPolygon(display.hv[0][i], display.hv[1][i], display.hv[0][i].length);
            ag.clearCurrentDataAndIndex();
        }
    }
}

