/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.canvas.AWindow;
import atlantis.data.ABJetData;
import atlantis.data.ACalorimeterData;
import atlantis.data.AClusterData;
import atlantis.data.ACompositeParticleData;
import atlantis.data.AETMisData;
import atlantis.data.AElectronData;
import atlantis.data.AJetData;
import atlantis.data.ALVL1JetElementData;
import atlantis.data.ALVL1TriggerTowerData;
import atlantis.data.AMuonData;
import atlantis.data.APhotonData;
import atlantis.data.AROIData;
import atlantis.data.ATauJetData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.AGraphics;
import atlantis.graphics.ALegoDraw;
import atlantis.parameters.APar;
import atlantis.projection.AProjectionLegoPlot;
import atlantis.utils.ALogger;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ALegoData {
    private static ALogger logger = ALogger.getLogger(ALegoData.class);

    public static double findMaxEt(double[][][] lego) {
        double maxEt;
        block12: {
            int z;
            int y;
            int x;
            int lowestColourIndex;
            double[][] legosum;
            block13: {
                maxEt = 0.0;
                legosum = new double[lego.length][lego[0].length];
                int largestColourIndex = 0;
                lowestColourIndex = AProjectionLegoPlot.nLayers;
                Iterator colorIterator = AProjectionLegoPlot.colorset.iterator();
                while (colorIterator.hasNext()) {
                    int currentColor = (Integer)colorIterator.next();
                    if (currentColor > largestColourIndex) {
                        largestColourIndex = currentColor;
                    }
                    if (currentColor >= lowestColourIndex) continue;
                    lowestColourIndex = currentColor;
                }
                for (x = AProjectionLegoPlot.nPhiCells - 1; x >= 0; --x) {
                    for (y = 0; y < AProjectionLegoPlot.nEtaCells; ++y) {
                        for (z = largestColourIndex; z >= lowestColourIndex; --z) {
                            double[] dArray = legosum[x];
                            int n = y;
                            dArray[n] = dArray[n] + lego[x][y][z];
                        }
                        if (!(legosum[x][y] > maxEt)) continue;
                        maxEt = legosum[x][y];
                    }
                }
                if (!(maxEt > 0.0)) break block12;
                if (AProjectionLegoPlot.defaultScale != 1) break block13;
                for (x = AProjectionLegoPlot.nPhiCells - 1; x >= 0; --x) {
                    for (y = 0; y < AProjectionLegoPlot.nEtaCells; ++y) {
                        for (z = largestColourIndex; z >= lowestColourIndex; --z) {
                            if (Math.log10(legosum[x][y]) >= (double)AProjectionLegoPlot.minimumofLogScale) {
                                double fraction = lego[x][y][z] / legosum[x][y];
                                lego[x][y][z] = fraction * (Math.log10(legosum[x][y]) - (double)AProjectionLegoPlot.minimumofLogScale);
                                continue;
                            }
                            lego[x][y][z] = 0.0;
                        }
                    }
                }
                break block12;
            }
            if (AProjectionLegoPlot.defaultScale != 2) break block12;
            for (x = AProjectionLegoPlot.nPhiCells - 1; x >= 0; --x) {
                for (y = 0; y < AProjectionLegoPlot.nEtaCells; ++y) {
                    for (z = largestColourIndex; z >= lowestColourIndex; --z) {
                        double fraction = lego[x][y][z] / legosum[x][y];
                        lego[x][y][z] = fraction * Math.sqrt(legosum[x][y]);
                    }
                }
            }
        }
        return maxEt;
    }

    public static double findAODMaxEt(AEvent event) {
        double AODmaxEt = 0.0;
        String[] colCluster = event.getActiveCollectionNames("Cluster");
        for (int i = 0; i < colCluster.length; ++i) {
            AClusterData cluster = (AClusterData)event.get(colCluster[i]);
            if (!APar.get("Data", "Cluster").getStatus()) {
                cluster = null;
            }
            if (cluster == null) continue;
            cluster.makeDrawList();
            for (int m = 0; m < cluster.getNumDraw(); ++m) {
                int list = cluster.getDrawIndex(m);
                float et = Math.abs(cluster.getET(list));
                if (!((double)et > AODmaxEt)) continue;
                AODmaxEt = et;
            }
        }
        String[] colMuon = event.getActiveCollectionNames("Muon");
        for (int i = 0; i < colMuon.length; ++i) {
            AMuonData muons = (AMuonData)event.get(colMuon[i]);
            if (!APar.get("Data", "Muon").getStatus()) {
                muons = null;
            }
            if (muons == null) continue;
            muons.makeDrawList();
            for (int m = 0; m < muons.getNumDraw(); ++m) {
                int list = muons.getDrawIndex(m);
                float pt = Math.abs(muons.getPT(list));
                if (!((double)pt > AODmaxEt)) continue;
                AODmaxEt = pt;
            }
        }
        String[] colElectron = event.getActiveCollectionNames("Electron");
        for (int i = 0; i < colElectron.length; ++i) {
            AElectronData electrons = (AElectronData)event.get(colElectron[i]);
            if (!APar.get("Data", "Electron").getStatus()) {
                electrons = null;
            }
            if (electrons == null) continue;
            electrons.makeDrawList();
            for (int e = 0; e < electrons.getNumDraw(); ++e) {
                int list = electrons.getDrawIndex(e);
                float pt = Math.abs(electrons.getPT(list));
                if (!((double)pt > AODmaxEt)) continue;
                AODmaxEt = pt;
            }
        }
        String[] colPhoton = event.getActiveCollectionNames("Photon");
        for (int i = 0; i < colPhoton.length; ++i) {
            APhotonData photons = (APhotonData)event.get(colPhoton[i]);
            if (!APar.get("Data", "Photon").getStatus()) {
                photons = null;
            }
            if (photons == null) continue;
            photons.makeDrawList();
            for (int p = 0; p < photons.getNumDraw(); ++p) {
                int list = photons.getDrawIndex(p);
                float pt = Math.abs(photons.getPT(list));
                if (!((double)pt > AODmaxEt)) continue;
                AODmaxEt = pt;
            }
        }
        String[] colCompPart = event.getActiveCollectionNames("CompositeParticle");
        for (int i = 0; i < colCompPart.length; ++i) {
            ACompositeParticleData compositeParticles = (ACompositeParticleData)event.get(colCompPart[i]);
            if (!APar.get("Data", "CompositeParticle").getStatus()) {
                compositeParticles = null;
            }
            if (compositeParticles == null) continue;
            compositeParticles.makeDrawList();
            for (int e = 0; e < compositeParticles.getNumDraw(); ++e) {
                int list = compositeParticles.getDrawIndex(e);
                float pt = Math.abs(compositeParticles.getPT(list));
                if (!((double)pt > AODmaxEt)) continue;
                AODmaxEt = pt;
            }
        }
        return AODmaxEt;
    }

    public static double findMissingEt(AWindow window, double[][][] lego, AEvent event) {
        double met = 0.0;
        List hitsAndTracks = event.getHitsAndTracks(window.getProjection());
        for (int h = 0; h < hitsAndTracks.size(); ++h) {
            double temp;
            AData datatype = (AData)hitsAndTracks.get(h);
            if (!datatype.getName().equals("ETMis")) continue;
            AETMisData mis = (AETMisData)datatype;
            mis.makeDrawList();
            if (mis.getNumDraw() <= 0 || !((temp = Math.sqrt(mis.getETx() * mis.getETx() + mis.getETy() * mis.getETy())) > met)) continue;
            met = temp;
        }
        return met;
    }

    public static void fillHistograms(AEvent event, double[][][] lego) {
        AProjectionLegoPlot.colorset.clear();
        if (AProjectionLegoPlot.mode == 0) {
            ALegoData.fillCaloLego(event, lego);
        } else if (AProjectionLegoPlot.mode == 1) {
            ALegoData.fillTriggerTowerLego(event, lego);
        } else {
            ALegoData.fillJetElementLego(event, lego);
        }
    }

    private static void fillCaloLego(AEvent event, double[][][] lego) {
        List detectors = event.getCalorimeters();
        for (int det = 0; det < detectors.size(); ++det) {
            ACalorimeterData calorimeter = (ACalorimeterData)detectors.get(det);
            String calname = calorimeter.getName();
            if (!(calname.equals("TILE") || calname.equals("FCAL") || calname.equals("HEC") || calname.equals("LAr") || calname.equals("MBTS"))) {
                logger.warn("Unknown calorimeter name for LegoPlot: " + calorimeter.getName());
            }
            calorimeter.makeDrawList();
            byte[] c = calorimeter.getColor();
            for (int i = 0; i < calorimeter.getNumDraw(); ++i) {
                int list = calorimeter.getDrawIndex(i);
                double et = calorimeter.getET(list);
                if (calname.equals("MBTS")) {
                    et /= 1000.0;
                }
                double phi = calorimeter.getPhi(list);
                double eta = calorimeter.getEta(list);
                if (eta > 5.0 || eta < -5.0 || et == 0.0) continue;
                double dphi = calorimeter.getdPhi(list);
                double deta = calorimeter.getdEta(list);
                ALegoData.phietabinsLoop("calo", phi, dphi, eta, deta, c[list], et, lego);
            }
        }
    }

    private static void fillTriggerTowerLego(AEvent event, double[][][] lego) {
        String[] colTT = event.getCollectionNames("LVL1TriggerTower");
        for (int k = 0; k < colTT.length; ++k) {
            ALVL1TriggerTowerData lvl1TriggerTower = (ALVL1TriggerTowerData)event.get(colTT[k]);
            if (lvl1TriggerTower == null) continue;
            for (int j = 0; j < 2; ++j) {
                boolean emOrHad;
                int energyType = APar.get(lvl1TriggerTower.getParameterGroup(), "EnergyType").getI();
                if (j == 0 && energyType == 1 || j == 1 && energyType == 0) continue;
                lvl1TriggerTower.makeDrawList();
                if (j == 0) {
                    emOrHad = true;
                    lvl1TriggerTower.applyEMCuts();
                } else {
                    emOrHad = false;
                    lvl1TriggerTower.applyHadCuts();
                }
                byte[] ttColor = lvl1TriggerTower.getColor(emOrHad);
                for (int i = 0; i < lvl1TriggerTower.getNumDraw(); ++i) {
                    int list = lvl1TriggerTower.getDrawIndex(i);
                    double et = lvl1TriggerTower.getET(list, emOrHad);
                    double phi = lvl1TriggerTower.getPhi(list);
                    double eta = lvl1TriggerTower.getEta(list);
                    if (eta > 5.0 || eta < -5.0 || et == 0.0) continue;
                    double dphi = lvl1TriggerTower.getdPhi(list, emOrHad);
                    double deta = lvl1TriggerTower.getdEta(list, emOrHad);
                    ALegoData.phietabinsLoop("trigger", phi, dphi, eta, deta, ttColor[list], et, lego);
                }
            }
        }
    }

    private static void fillJetElementLego(AEvent event, double[][][] lego) {
        String[] colJE = event.getCollectionNames("LVL1JetElement");
        for (int k = 0; k < colJE.length; ++k) {
            ALVL1JetElementData lvl1JetElement = (ALVL1JetElementData)event.get(colJE[k]);
            if (lvl1JetElement == null) continue;
            byte[] jeColor = lvl1JetElement.getColor();
            lvl1JetElement.makeDrawList();
            for (int i = 0; i < lvl1JetElement.getNumDraw(); ++i) {
                int list = lvl1JetElement.getDrawIndex(i);
                double et = lvl1JetElement.getET(list);
                double phi = lvl1JetElement.getPhi(list);
                double eta = lvl1JetElement.getEta(list);
                if (eta > 5.0 || eta < -5.0 || et == 0.0) continue;
                double dphi = lvl1JetElement.getdPhi(list);
                double deta = lvl1JetElement.getdEta(list);
                ALegoData.phietabinsLoop("jetElement", phi, dphi, eta, deta, jeColor[list], et, lego);
            }
        }
    }

    private static void phietabinsLoop(String sender, double phi, double dphi, double eta, double deta, byte color, double et, double[][][] lego) {
        if (color >= AProjectionLegoPlot.nLayers) {
            color = (byte)(color % AProjectionLegoPlot.nLayers);
        }
        AProjectionLegoPlot.colorset.add(new Integer(color));
        int highphibin = 0;
        int lowphibin = 0;
        double phibinsize = Math.PI * 2 / (double)AProjectionLegoPlot.nPhiCells;
        highphibin = (int)((phi + dphi) / phibinsize);
        lowphibin = (int)((phi - dphi) / phibinsize);
        int highetabin = 0;
        int lowetabin = 0;
        double etabinsize = 10.0 / (double)AProjectionLegoPlot.nEtaCells;
        highetabin = (int)((eta + deta + 5.0) / etabinsize);
        lowetabin = (int)((eta - deta + 5.0) / etabinsize);
        if (lowetabin < 0) {
            lowetabin = 0;
            if (highetabin < 0) {
                highetabin = 0;
            }
        }
        if (highetabin >= AProjectionLegoPlot.nEtaCells) {
            highetabin = AProjectionLegoPlot.nEtaCells - 1;
            if (lowetabin >= AProjectionLegoPlot.nEtaCells) {
                lowetabin = AProjectionLegoPlot.nEtaCells - 1;
            }
        }
        for (int phibin = lowphibin; phibin <= highphibin; ++phibin) {
            double phiweight = 0.0;
            phiweight = lowphibin == highphibin ? 1.0 : (phibin == lowphibin ? ((double)(lowphibin + 1) - (phi - dphi) / phibinsize) * (phibinsize / (2.0 * dphi)) : (phibin == highphibin ? ((phi + dphi) / phibinsize - (double)highphibin) * (phibinsize / (2.0 * dphi)) : phibinsize / (2.0 * dphi)));
            if (phiweight > 1.0 || phiweight < 0.0) {
                logger.error("huh(" + sender + ")? how is phiweight...? " + phiweight);
            }
            for (int etabin = lowetabin; etabin <= highetabin; ++etabin) {
                int wphibin;
                double etaweight = 0.0;
                etaweight = lowetabin == highetabin ? 1.0 : (etabin == lowetabin ? ((double)(lowetabin + 1) - (eta - deta + 5.0) / etabinsize) * (etabinsize / (2.0 * deta)) : (etabin == highetabin ? ((eta + deta + 5.0) / etabinsize - (double)highetabin) * (etabinsize / (2.0 * deta)) : etabinsize / (2.0 * deta)));
                if (etaweight > 1.0 || etaweight < 0.0) {
                    logger.error("huh(" + sender + ")? how is etaweight...? " + etaweight);
                }
                for (wphibin = phibin; wphibin >= AProjectionLegoPlot.nPhiCells; wphibin -= AProjectionLegoPlot.nPhiCells) {
                }
                while (wphibin < 0) {
                    wphibin += AProjectionLegoPlot.nPhiCells;
                }
                int retabin = etabin;
                if (AProjectionLegoPlot.reverse) {
                    retabin = AProjectionLegoPlot.nEtaCells - etabin - 1;
                }
                double[] dArray = lego[wphibin][retabin];
                byte by = color;
                dArray[by] = dArray[by] + et * phiweight * etaweight;
            }
        }
    }

    public static double scaleValue(double value) {
        if (value == 0.0) {
            return 0.0;
        }
        if (AProjectionLegoPlot.defaultScale == 2) {
            value = Math.sqrt(value);
        } else if (AProjectionLegoPlot.defaultScale == 1) {
            value = Math.log10(value) - (double)AProjectionLegoPlot.minimumofLogScale;
        }
        return value;
    }

    public static void drawHistograms(AWindow window, AGraphics ag, AEvent event, double[][][] lego, double maxEt, double met, double AODmaxEt) {
        double _jetcircleradius = APar.get("LegoPlot", "JetCircleRadius").getD();
        double _legocut = APar.get("LegoPlot", "LegoCut").getD();
        _legocut = ALegoData.scaleValue(_legocut);
        boolean doAOD = false;
        if (AODmaxEt != 0.0) {
            doAOD = true;
        }
        Stack<Integer> jetROI = new Stack<Integer>();
        Stack<Integer> emTauROI = new Stack<Integer>();
        Stack<Integer> muonROI = new Stack<Integer>();
        List hitsAndTracks = event.getHitsAndTracks(window.getProjection());
        for (int h = 0; h < hitsAndTracks.size(); ++h) {
            byte[] colors;
            AData datatype = (AData)hitsAndTracks.get(h);
            if (datatype.getName().equals("Jet")) {
                AJetData jet = (AJetData)datatype;
                jet.makeDrawList();
                colors = jet.getColor();
                for (int j = 0; j < jet.getNumDraw(); ++j) {
                    int list = jet.getDrawIndex(j);
                    double et = jet.getET(list);
                    Color _colorJet = AProjectionLegoPlot.defaultColorMap[colors[list]];
                    ALegoDraw.drawJet(et, jet.getEta(list), jet.getPhi(list), _colorJet, window, ag, _jetcircleradius);
                }
                continue;
            }
            if (datatype.getName().equals("ETMis")) {
                AETMisData mis = (AETMisData)datatype;
                mis.makeDrawList();
                if (mis.getNumDraw() <= 0) continue;
                colors = mis.getColor();
                int phib = (int)((double)(mis.getPhi() * (float)AProjectionLegoPlot.nPhiCells) / (Math.PI * 2));
                if (phib < 0) {
                    phib += AProjectionLegoPlot.nPhiCells;
                }
                if (phib >= AProjectionLegoPlot.nPhiCells) {
                    phib -= AProjectionLegoPlot.nPhiCells;
                }
                Color _colorMis = AProjectionLegoPlot.defaultColorMap[colors[0]];
                ALegoDraw.drawMissEt(window, ag, phib, mis.getET(), _colorMis, maxEt);
                continue;
            }
            if (datatype.getName().equals("JetROI")) {
                jetROI.push(h);
                continue;
            }
            if (datatype.getName().equals("EmTauROI")) {
                emTauROI.push(h);
                continue;
            }
            if (!datatype.getName().equals("MuonROI")) continue;
            muonROI.push(h);
        }
        ALegoData.drawROIs(jetROI, window, ag, event);
        ALegoData.drawROIs(emTauROI, window, ag, event);
        ALegoData.drawROIs(muonROI, window, ag, event);
        int largestColourIndex = 0;
        int lowestColourIndex = AProjectionLegoPlot.nLayers;
        Iterator colorIterator = AProjectionLegoPlot.colorset.iterator();
        while (colorIterator.hasNext()) {
            int currentColor = (Integer)colorIterator.next();
            if (currentColor > largestColourIndex) {
                largestColourIndex = currentColor;
            }
            if (currentColor >= lowestColourIndex) continue;
            lowestColourIndex = currentColor;
        }
        for (int y = 0; y < AProjectionLegoPlot.nEtaCells; ++y) {
            for (int x = AProjectionLegoPlot.nPhiCells - 1; x >= 0; --x) {
                int z;
                double binheight = 0.0;
                if (AProjectionLegoPlot.getDrawEMHAD() && AProjectionLegoPlot.colorset.size() == 2) {
                    z = AProjectionLegoPlot.colorEM;
                    binheight = lego[x][y][z];
                    if (binheight > _legocut) {
                        ALegoDraw.drawBox(window, ag, x, y, z, 0.0, binheight, maxEt);
                        if (!(lego[x][y][AProjectionLegoPlot.colorHad] > _legocut)) continue;
                        z = AProjectionLegoPlot.colorHad;
                        ALegoDraw.drawBox(window, ag, x, y, z, binheight, lego[x][y][z], maxEt);
                        continue;
                    }
                    if (!(lego[x][y][AProjectionLegoPlot.colorHad] > _legocut)) continue;
                    z = AProjectionLegoPlot.colorHad;
                    ALegoDraw.drawBox(window, ag, x, y, z, 0.0, lego[x][y][z], maxEt);
                    continue;
                }
                for (z = largestColourIndex; z >= lowestColourIndex; --z) {
                    if (!(lego[x][y][z] > _legocut)) continue;
                    ALegoDraw.drawBox(window, ag, x, y, z, binheight, lego[x][y][z], maxEt);
                    binheight += lego[x][y][z];
                }
            }
        }
        for (int h = 0; h < hitsAndTracks.size(); ++h) {
            AData datatype = (AData)hitsAndTracks.get(h);
            if (!datatype.getName().equals("Jet")) continue;
            AJetData jet = (AJetData)datatype;
            jet.makeDrawList();
            byte[] colors = jet.getColor();
            for (int j = 0; j < jet.getNumDraw(); ++j) {
                int list = jet.getDrawIndex(j);
                double et = jet.getET(list);
                Color _colorJet = AProjectionLegoPlot.defaultColorMap[colors[list]];
                if (!APar.get("LegoPlot", "JetText").getStatus()) continue;
                ALegoDraw.drawJetText(et, jet.getEta(list), jet.getPhi(list), _colorJet, window, ag, _jetcircleradius);
            }
        }
        if (doAOD) {
            double et;
            String[] colCluster = event.getActiveCollectionNames("Cluster");
            for (int i = 0; i < colCluster.length; ++i) {
                AClusterData cluster = (AClusterData)event.get(colCluster[i]);
                if (!APar.get("Data", "Cluster").getStatus()) {
                    cluster = null;
                }
                if (cluster == null) continue;
                cluster.makeDrawList();
                for (int m = 0; m < cluster.getNumDraw(); ++m) {
                    int list = cluster.getDrawIndex(m);
                    int etabin = (int)(((double)cluster.getEta(list) + 5.0) * (double)AProjectionLegoPlot.nEtaCells / 10.0);
                    if (AProjectionLegoPlot.reverse) {
                        etabin = AProjectionLegoPlot.nEtaCells - etabin;
                    }
                    int phibin = (int)((double)(cluster.getPhi(list) * (float)AProjectionLegoPlot.nPhiCells) / (Math.PI * 2));
                    et = Math.abs(cluster.getET(list));
                    et = ALegoData.scaleValue(et);
                    ALegoDraw.drawBox(window, ag, phibin, etabin, -5, 0.0, et, maxEt);
                }
            }
            String[] colBjets = event.getActiveCollectionNames("BJet");
            for (int i = 0; i < colBjets.length; ++i) {
                ABJetData bjets = (ABJetData)event.get(colBjets[i]);
                if (!APar.get("Data", "BJet").getStatus()) {
                    bjets = null;
                }
                if (bjets == null) continue;
                bjets.makeDrawList();
                for (int bj = 0; bj < bjets.getNumDraw(); ++bj) {
                    int list = bjets.getDrawIndex(bj);
                    double et2 = bjets.getPT(list);
                    ALegoDraw.drawJet(et2, bjets.getEta(list), bjets.getPhi(list), AProjectionLegoPlot.defaultColorMap[APar.get("BJet", "Constant").getI()], window, ag, _jetcircleradius + _jetcircleradius / 5.0);
                }
            }
            String[] colTau = event.getActiveCollectionNames("TauJet");
            for (int i = 0; i < colTau.length; ++i) {
                ATauJetData tjets = (ATauJetData)event.get(colTau[i]);
                if (!APar.get("Data", "TauJet").getStatus()) {
                    tjets = null;
                }
                if (tjets == null) continue;
                tjets.makeDrawList();
                for (int tj = 0; tj < tjets.getNumDraw(); ++tj) {
                    int list = tjets.getDrawIndex(tj);
                    et = tjets.getPT(list);
                    ALegoDraw.drawJet(et, tjets.getEta(list), tjets.getPhi(list), AProjectionLegoPlot.defaultColorMap[APar.get("TauJet", "Constant").getI()], window, ag, _jetcircleradius / 2.0);
                }
            }
            String[] colMuon = event.getActiveCollectionNames("Muon");
            for (int i = 0; i < colMuon.length; ++i) {
                AMuonData muons = (AMuonData)event.get(colMuon[i]);
                if (!APar.get("Data", "Muon").getStatus()) {
                    muons = null;
                }
                if (muons == null) continue;
                muons.makeDrawList();
                for (int m = 0; m < muons.getNumDraw(); ++m) {
                    int list = muons.getDrawIndex(m);
                    int etabin = (int)(((double)muons.getEta(list) + 5.0) * (double)AProjectionLegoPlot.nEtaCells / 10.0);
                    if (AProjectionLegoPlot.reverse) {
                        etabin = AProjectionLegoPlot.nEtaCells - etabin;
                    }
                    int phibin = (int)((double)(muons.getPhi(list) * (float)AProjectionLegoPlot.nPhiCells) / (Math.PI * 2));
                    double pt = Math.abs(muons.getPT(list));
                    pt = ALegoData.scaleValue(pt);
                    ALegoDraw.drawBox(window, ag, phibin, etabin, -2, 0.0, pt, maxEt);
                }
            }
            String[] colElectron = event.getActiveCollectionNames("Electron");
            for (int i = 0; i < colElectron.length; ++i) {
                AElectronData electrons = (AElectronData)event.get(colElectron[i]);
                if (!APar.get("Data", "Electron").getStatus()) {
                    electrons = null;
                }
                if (electrons == null) continue;
                electrons.makeDrawList();
                for (int e = 0; e < electrons.getNumDraw(); ++e) {
                    int list = electrons.getDrawIndex(e);
                    int etabin = (int)(((double)electrons.getEta(list) + 5.0) * (double)AProjectionLegoPlot.nEtaCells / 10.0);
                    if (AProjectionLegoPlot.reverse) {
                        etabin = AProjectionLegoPlot.nEtaCells - etabin;
                    }
                    int phibin = (int)((double)(electrons.getPhi(list) * (float)AProjectionLegoPlot.nPhiCells) / (Math.PI * 2));
                    double pt = Math.abs(electrons.getPT(list));
                    pt = ALegoData.scaleValue(pt);
                    ALegoDraw.drawBox(window, ag, phibin, etabin, -3, 0.0, pt, maxEt);
                }
            }
            String[] colPhoton = event.getActiveCollectionNames("Photon");
            for (int i = 0; i < colPhoton.length; ++i) {
                APhotonData photons = (APhotonData)event.get(colPhoton[i]);
                if (!APar.get("Data", "Photon").getStatus()) {
                    photons = null;
                }
                if (photons == null) continue;
                photons.makeDrawList();
                for (int p = 0; p < photons.getNumDraw(); ++p) {
                    int list = photons.getDrawIndex(p);
                    int etabin = (int)(((double)photons.getEta(list) + 5.0) * (double)AProjectionLegoPlot.nEtaCells / 10.0);
                    if (AProjectionLegoPlot.reverse) {
                        etabin = AProjectionLegoPlot.nEtaCells - etabin;
                    }
                    int phibin = (int)((double)(photons.getPhi(list) * (float)AProjectionLegoPlot.nPhiCells) / (Math.PI * 2));
                    double pt = Math.abs(photons.getPT(list));
                    pt = ALegoData.scaleValue(pt);
                    ALegoDraw.drawBox(window, ag, phibin, etabin, -4, 0.0, pt, maxEt);
                }
            }
            String[] colCompPart = event.getActiveCollectionNames("CompositeParticle");
            for (int i = 0; i < colCompPart.length; ++i) {
                ACompositeParticleData compositeParticles = (ACompositeParticleData)event.get(colCompPart[i]);
                if (!APar.get("Data", "CompositeParticle").getStatus()) {
                    compositeParticles = null;
                }
                if (compositeParticles == null) continue;
                compositeParticles.makeDrawList();
                for (int e = 0; e < compositeParticles.getNumDraw(); ++e) {
                    int list = compositeParticles.getDrawIndex(e);
                    int etabin = (int)(((double)compositeParticles.getEta(list) + 5.0) * (double)AProjectionLegoPlot.nEtaCells / 10.0);
                    if (AProjectionLegoPlot.reverse) {
                        etabin = AProjectionLegoPlot.nEtaCells - etabin;
                    }
                    int phibin = (int)((double)(compositeParticles.getPhi(list) * (float)AProjectionLegoPlot.nPhiCells) / (Math.PI * 2));
                    double pt = Math.abs(compositeParticles.getPT(list));
                    pt = ALegoData.scaleValue(pt);
                    if (Math.abs(compositeParticles.getPdgId(list)) == 13) {
                        ALegoDraw.drawBox(window, ag, phibin, etabin, -2, 0.0, pt, maxEt);
                        continue;
                    }
                    if (Math.abs(compositeParticles.getPdgId(list)) == 11) {
                        ALegoDraw.drawBox(window, ag, phibin, etabin, -3, 0.0, pt, maxEt);
                        continue;
                    }
                    if (Math.abs(compositeParticles.getPdgId(list)) == 22) {
                        ALegoDraw.drawBox(window, ag, phibin, etabin, -4, 0.0, pt, maxEt);
                        continue;
                    }
                    if (Math.abs(compositeParticles.getPdgId(list)) == 5) {
                        ALegoDraw.drawBox(window, ag, phibin, etabin, -7, 0.0, pt, maxEt);
                        continue;
                    }
                    if (Math.abs(compositeParticles.getPdgId(list)) == 15) {
                        ALegoDraw.drawBox(window, ag, phibin, etabin, -8, 0.0, pt, maxEt);
                        continue;
                    }
                    if (compositeParticles.getTypeEV(list).equals("EVParticleJet")) {
                        ALegoDraw.drawBox(window, ag, phibin, etabin, -9, 0.0, pt, maxEt);
                        continue;
                    }
                    ALegoDraw.drawBox(window, ag, phibin, etabin, -6, 0.0, pt, maxEt);
                }
            }
        }
    }

    public static void drawROIs(Stack ROIstack, AWindow window, AGraphics ag, AEvent event) {
        List hitsAndTracks = event.getHitsAndTracks(window.getProjection());
        while (ROIstack.size() > 0) {
            int h = (Integer)ROIstack.pop();
            AData datatype = (AData)hitsAndTracks.get(h);
            AROIData ROIData = (AROIData)datatype;
            ROIData.makeDrawList();
            byte[] ROIColor = datatype.getColor();
            double deltaEta = APar.get(datatype.getName(), "deta").getD();
            double deltaPhi = APar.get(datatype.getName(), "dphi").getD();
            for (int j = 0; j < ROIData.getNumDraw(); ++j) {
                int i;
                Point2D.Double p;
                double[][] hvWrap;
                int numPoints = 4;
                int list = ROIData.getDrawIndex(j);
                double ROIphi = ROIData.getPhi(list);
                double ROIeta = ROIData.getEta(list);
                if (AProjectionLegoPlot.reverse) {
                    ROIeta = -ROIeta;
                }
                double leftPhi = ROIphi - deltaPhi;
                double rightPhi = ROIphi + deltaPhi;
                double topEta = ROIeta + deltaEta;
                double bottomEta = ROIeta - deltaEta;
                if (ROIColor[list] < AProjectionLegoPlot.defaultColorMap.length && ROIColor[list] >= 0) {
                    ag.setColor(AProjectionLegoPlot.defaultColorMap[ROIColor[list]]);
                }
                ag.setLineWidth(3);
                double ROIx = 0.0;
                double ROIy = 0.0;
                double[][] hv = new double[2][numPoints];
                if (rightPhi <= Math.PI * 2 && leftPhi >= 0.0) {
                    for (int p2 = 0; p2 < numPoints; ++p2) {
                        switch (p2) {
                            case 0: {
                                ROIx = rightPhi * 360.0 / (Math.PI * 2);
                                ROIy = bottomEta;
                                break;
                            }
                            case 1: {
                                ROIx = leftPhi * 360.0 / (Math.PI * 2);
                                ROIy = bottomEta;
                                break;
                            }
                            case 2: {
                                ROIx = leftPhi * 360.0 / (Math.PI * 2);
                                ROIy = topEta;
                                break;
                            }
                            case 3: {
                                ROIx = rightPhi * 360.0 / (Math.PI * 2);
                                ROIy = topEta;
                            }
                        }
                        if (ROIy <= -5.0) {
                            ROIy = -5.0;
                        }
                        if (ROIy >= 5.0) {
                            ROIy = 5.0;
                        }
                        hv[0][p2] = ROIx = AProjectionLegoPlot.adjustPhi(window, ROIx, ROIy);
                        hv[1][p2] = ROIy;
                    }
                } else if (rightPhi > Math.PI * 2 && leftPhi < 0.0) {
                    for (int p3 = 0; p3 < numPoints; ++p3) {
                        switch (p3) {
                            case 0: {
                                ROIx = 360.0;
                                ROIy = bottomEta;
                                break;
                            }
                            case 1: {
                                ROIx = 0.0;
                                ROIy = bottomEta;
                                break;
                            }
                            case 2: {
                                ROIx = 0.0;
                                ROIy = topEta;
                                break;
                            }
                            case 3: {
                                ROIx = 360.0;
                                ROIy = topEta;
                            }
                        }
                        if (ROIy <= -5.0) {
                            ROIy = -5.0;
                        }
                        if (ROIy >= 5.0) {
                            ROIy = 5.0;
                        }
                        hv[0][p3] = ROIx = AProjectionLegoPlot.adjustPhi(window, ROIx, ROIy);
                        hv[1][p3] = ROIy;
                    }
                } else if (rightPhi > Math.PI * 2) {
                    hvWrap = new double[2][numPoints];
                    double ROIxWrap = 0.0;
                    for (int p4 = 0; p4 < numPoints; ++p4) {
                        switch (p4) {
                            case 0: {
                                ROIx = 360.0;
                                ROIxWrap = (rightPhi - Math.PI * 2) * 360.0 / (Math.PI * 2);
                                ROIy = bottomEta;
                                break;
                            }
                            case 1: {
                                ROIx = leftPhi * 360.0 / (Math.PI * 2);
                                ROIxWrap = 0.0;
                                ROIy = bottomEta;
                                break;
                            }
                            case 2: {
                                ROIx = leftPhi * 360.0 / (Math.PI * 2);
                                ROIxWrap = 0.0;
                                ROIy = topEta;
                                break;
                            }
                            case 3: {
                                ROIx = 360.0;
                                ROIxWrap = (rightPhi - Math.PI * 2) * 360.0 / (Math.PI * 2);
                                ROIy = topEta;
                            }
                        }
                        if (ROIy <= -5.0) {
                            ROIy = -5.0;
                        }
                        if (ROIy >= 5.0) {
                            ROIy = 5.0;
                        }
                        hv[0][p4] = ROIx = AProjectionLegoPlot.adjustPhi(window, ROIx, ROIy);
                        hv[1][p4] = ROIy;
                        hvWrap[0][p4] = ROIxWrap = AProjectionLegoPlot.adjustPhi(window, ROIxWrap, ROIy);
                        hvWrap[1][p4] = ROIy;
                    }
                    p = new Point2D.Double(0.0, 0.0);
                    for (i = 0; i < numPoints; ++i) {
                        p = window.calculateDisplay(hvWrap[0][i], hvWrap[1][i]);
                        hvWrap[0][i] = p.x;
                        hvWrap[1][i] = p.y;
                    }
                    ag.fillPolygon(hvWrap[0], hvWrap[1], numPoints);
                } else {
                    hvWrap = new double[2][numPoints];
                    double ROIxWrap = 0.0;
                    for (int p5 = 0; p5 < numPoints; ++p5) {
                        switch (p5) {
                            case 0: {
                                ROIx = rightPhi * 360.0 / (Math.PI * 2);
                                ROIxWrap = 360.0;
                                ROIy = bottomEta;
                                break;
                            }
                            case 1: {
                                ROIx = 0.0;
                                ROIxWrap = (leftPhi + Math.PI * 2) * 360.0 / (Math.PI * 2);
                                ROIy = bottomEta;
                                break;
                            }
                            case 2: {
                                ROIx = 0.0;
                                ROIxWrap = (leftPhi + Math.PI * 2) * 360.0 / (Math.PI * 2);
                                ROIy = topEta;
                                break;
                            }
                            case 3: {
                                ROIx = rightPhi * 360.0 / (Math.PI * 2);
                                ROIxWrap = 360.0;
                                ROIy = topEta;
                            }
                        }
                        if (ROIy <= -5.0) {
                            ROIy = -5.0;
                        }
                        if (ROIy >= 5.0) {
                            ROIy = 5.0;
                        }
                        hv[0][p5] = ROIx = AProjectionLegoPlot.adjustPhi(window, ROIx, ROIy);
                        hv[1][p5] = ROIy;
                        hvWrap[0][p5] = ROIxWrap = AProjectionLegoPlot.adjustPhi(window, ROIxWrap, ROIy);
                        hvWrap[1][p5] = ROIy;
                    }
                    p = new Point2D.Double(0.0, 0.0);
                    for (i = 0; i < numPoints; ++i) {
                        p = window.calculateDisplay(hvWrap[0][i], hvWrap[1][i]);
                        hvWrap[0][i] = p.x;
                        hvWrap[1][i] = p.y;
                    }
                    ag.fillPolygon(hvWrap[0], hvWrap[1], numPoints);
                }
                Point2D.Double p6 = new Point2D.Double(0.0, 0.0);
                for (int i2 = 0; i2 < numPoints; ++i2) {
                    p6 = window.calculateDisplay(hv[0][i2], hv[1][i2]);
                    hv[0][i2] = p6.x;
                    hv[1][i2] = p6.y;
                }
                ag.fillPolygon(hv[0], hv[1], numPoints);
            }
        }
    }
}

