/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.ACalorimeterData;
import atlantis.data.ACalorimeterRPSPLT;
import atlantis.data.ATILEData;
import atlantis.event.AEvent;
import atlantis.geometry.ACalorimeterDetector;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import atlantis.utils.APulseShapePlot;

public class AMBTSData
extends ACalorimeterData {
    private static ALogger logger = ALogger.getLogger(AMBTSData.class);
    protected float[] quality;
    protected float[] time;
    private int[][] adcCounts = null;
    private float[] cellPedestal = null;
    private float[] cellRawTime = null;
    private float[] cellRawAmplitude = null;
    private static boolean pulseShapesDataAvailable = false;
    private static final String LOOKUP_TABLE_FILE = Atlantis.getHomeDirectory() + "configuration" + Atlantis.FILE_SEPAR + "rpsplt_tile.csv";
    private static final short NUMBER_OF_LOOKUP_VALUES = 401;
    protected ACalorimeterDetector[] MBTSlayers = new ACalorimeterDetector[2];

    AMBTSData(AHashMap p, AEvent e) {
        super(p, e);
        int i;
        int[] inteta;
        int i2;
        int[] intphi;
        this.channel = p.getIntArray("channel");
        this.et = p.getFloatArray("energy");
        this.etSum = p.getFloatArray("energy");
        this.quality = p.getFloatArray("quality");
        this.sampling = p.getIntArray("sampling");
        this.time = p.getFloatArray("time");
        if (p.containsKey("module")) {
            intphi = p.getIntArray("module");
        } else {
            float[] tempphi = p.getFloatArray("phi");
            intphi = new int[this.numData];
            for (i2 = 0; i2 < this.numData; ++i2) {
                intphi[i2] = (int)((double)(8.0f * tempphi[i2]) / (Math.PI * 2) - 0.0);
            }
        }
        if (p.containsKey("type")) {
            inteta = p.getIntArray("type");
        } else {
            float[] tempeta = p.getFloatArray("eta");
            inteta = new int[this.numData];
            for (i2 = 0; i2 < this.numData; ++i2) {
                inteta[i2] = tempeta[i2] < 0.0f ? -1 : 1;
            }
        }
        this.eta = new float[this.numData];
        this.phi = new float[this.numData];
        for (i = 0; i < this.numData; ++i) {
            this.eta[i] = inteta[i];
            this.phi[i] = intphi[i];
        }
        for (i = 0; i < this.numData; ++i) {
            if (this.eta[i] < 0.0f) {
                this.sub[i] = 0;
                this.side[i] = -1;
                continue;
            }
            this.sub[i] = 1;
            this.side[i] = 1;
        }
        for (i = 0; i < ACalorimeterDetector.count(); ++i) {
            ACalorimeterDetector detector = ACalorimeterDetector.get(i);
            if (!detector.getName().equals("Minimum Bias Trigger Scintillators")) continue;
            this.MBTSlayers[detector.getSampling()] = detector;
        }
        this.readPulseShapePlotData(p);
    }

    private void readPulseShapePlotData(AHashMap p) {
        this.adcCounts = super.getADCCountsData(p);
        this.cellPedestal = p.get("cellPedestal") != null ? p.getFloatArray("cellPedestal") : null;
        this.cellRawTime = p.get("cellRawTime") != null ? p.getFloatArray("cellRawTime") : null;
        this.cellRawAmplitude = p.get("cellRawAmplitude") != null ? p.getFloatArray("cellRawAmplitude") : null;
        pulseShapesDataAvailable = false;
        if (this.adcCounts != null && this.cellPedestal != null && this.cellRawTime != null && this.cellRawAmplitude != null) {
            pulseShapesDataAvailable = true;
            logger.debug(this.CALORIMETER_NAME + ": data for real pulse shape plots available");
            if (ACalorimeterRPSPLT.areTileLookupTablesInitialized()) {
                logger.debug(this.CALORIMETER_NAME + ": lookup tables have already been read in");
            } else {
                logger.debug(this.CALORIMETER_NAME + ": lookup table values have not been read in yet\n" + "  trying to read file: " + LOOKUP_TABLE_FILE);
                try {
                    ATILEData.readLookupTableFile();
                    logger.debug(this.CALORIMETER_NAME + ": values from " + LOOKUP_TABLE_FILE + " successfully read in");
                }
                catch (AAtlantisException ex) {
                    logger.debug(this.CALORIMETER_NAME + ": reading " + LOOKUP_TABLE_FILE + " failed, real pulse shapes plots will not " + "be available, reason: " + ex.getMessage(), ex);
                    pulseShapesDataAvailable = false;
                }
            }
        }
    }

    public String getParameterGroup() {
        return "TILE";
    }

    public String getName() {
        return "MBTS";
    }

    public String getNameScreenName() {
        return "MBTS";
    }

    public String getCalorimeterType(int index) {
        return "HCAL";
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        int mode = APar.get("YX", "Mode").getI();
        if (mode != 22) {
            return ACoord.NO_DATA;
        }
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            double rMax = this.MBTSlayers[this.sampling[j]].getRMax();
            double rMin = this.MBTSlayers[this.sampling[j]].getRMin();
            int numPhi = this.MBTSlayers[this.sampling[j]].getNumPhi();
            double phiMin = Math.PI * 2 * (double)this.phi[j] / (double)numPhi;
            double phiMax = Math.PI * 2 * (double)(1.0f + this.phi[j]) / (double)numPhi;
            hv[0][i] = new double[]{rMax * Math.cos(phiMin), rMax * Math.cos(phiMax), rMin * Math.cos(phiMax), rMin * Math.cos(phiMin)};
            hv[1][i] = new double[]{rMax * Math.sin(phiMin), rMax * Math.sin(phiMax), rMin * Math.sin(phiMax), rMin * Math.sin(phiMin)};
            index[i] = j;
        }
        return new ACoord(hv, index, (ADrawable)this);
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            int sign = this.MBTSlayers[this.sampling[j]].getRSign((int)this.phi[j]);
            double zMax = this.MBTSlayers[this.sampling[j]].getZMax() * (double)this.side[j];
            double zMin = this.MBTSlayers[this.sampling[j]].getZMin() * (double)this.side[j];
            double rMax = this.MBTSlayers[this.sampling[j]].getRMax() * (double)sign;
            double rMin = this.MBTSlayers[this.sampling[j]].getRMin() * (double)sign;
            hv[0][i] = new double[]{zMax, zMin, zMin, zMax};
            hv[1][i] = new double[]{rMax, rMax, rMin, rMin};
            index[i] = j;
        }
        return new ACoord(hv, index, (ADrawable)this);
    }

    protected void applyCuts() {
        super.applyCuts();
        this.cut("CutsCalo", "MBTSEnergy", "MBTSEnergy", this.et);
        int cutSub = APar.get("CutsCalo", "MBTS").getI();
        if (cutSub != -1) {
            this.cutArray(this.sub, cutSub, "Endcap");
        }
    }

    public ACoord getFRUser() {
        return this.getYXUser().convertYXToFR().includePhiWrapAround("FR");
    }

    public String getHitInfo(int index) {
        String cellplus;
        String cellminus;
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n Energy=" + this.correctEnergy(this.energy[index]) + " GeV\n ";
        }
        double tempEnergy = 0.0;
        for (int i = 0; i < this.energy.length; ++i) {
            if ((double)this.eta[i] != -1.0 * (double)this.eta[index] || this.phi[i] != this.phi[index] || this.sampling[i] != this.sampling[index]) continue;
            tempEnergy = this.energy[i];
        }
        if (this.eta[index] < 0.0f) {
            cellminus = this.correctEnergy(this.energy[index]);
            cellplus = this.correctEnergy(tempEnergy);
        } else {
            cellplus = this.correctEnergy(this.energy[index]);
            cellminus = this.correctEnergy(tempEnergy);
        }
        StringBuffer msg = new StringBuffer(this.CALORIMETER_NAME + " cell ");
        msg.append(" (id: " + this.id[index] + " index: " + index + ")");
        msg.append("\n Energy = " + this.correctEnergy(this.energy[index]));
        msg.append("\n (MBTS + = " + cellplus + " MBTS - = " + cellminus + ")");
        msg.append("\n time = " + this.time[index]);
        msg.append("\n quality = " + this.quality[index]);
        msg.append("\n type = " + AMath.d2s(this.eta[index], 4));
        msg.append("\n module = " + AMath.d2s(this.phi[index], 1));
        msg.append("\n sampling = " + this.sampling[index]);
        msg.append("\n channel = " + this.channel[index]);
        msg.append("\n cell pedestal = ");
        String m = this.cellPedestal != null ? Float.toString(this.cellPedestal[index]) + " ADC counts" : "n/a";
        msg.append(m);
        m = pulseShapesDataAvailable ? "" : "\n data for real pulse shapes plot n/a";
        msg.append(m);
        return msg.toString();
    }

    private String correctEnergy(double energy) {
        String energyOutput = energy > 1.0 ? AMath.d2s(energy, 2) + " MeV" : (energy > 0.001 ? AMath.d2s(energy *= 1000.0, 2) + " KeV" : AMath.d2s(energy *= 1000000.0, 2) + " eV");
        return energyOutput;
    }

    protected ACoord[] getUserHistograms(AProjection2D projection) {
        ACoord[] data = ACoord.NO_HISTOGRAMS;
        return projection.nonLinearTransform(data);
    }

    private double getPhysicsPulseShape(double xTime, double pmtTime, double pmtPedestal, double pmtEnergy, float[] amplitude, float[] time) throws AAtlantisException {
        double tdiv = 0.0;
        int lookup = 0;
        double localTime = 0.0;
        double xpulse = 0.0;
        double centerOfSamples = ((double)this.adcCounts[0].length + 1.0) / 2.0;
        localTime = (xTime - centerOfSamples) * 25.0 - pmtTime;
        tdiv = time[1] - time[0];
        lookup = (int)((localTime - (double)time[0]) / tdiv);
        if (lookup < 0) {
            lookup = 0;
        }
        if (lookup >= 400) {
            lookup = 399;
        }
        try {
            xpulse = lookup == 0 || lookup == 399 ? (double)amplitude[lookup] : (double)amplitude[lookup] + (double)(amplitude[lookup + 1] - amplitude[lookup]) / tdiv * (localTime - (double)time[lookup]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            String m = "AMBTSData.getPhysicsPulseShape():\n  lookup index out of bound: lookup = " + lookup;
            throw new AAtlantisException(m);
        }
        return xpulse * pmtEnergy + pmtPedestal;
    }

    public void plotPulseShapes(int index) {
        double[][] realPulse;
        double step;
        int[][] adcCountsLocal;
        String title;
        if (pulseShapesDataAvailable) {
            title = this.CALORIMETER_NAME + " cell index: " + index;
            adcCountsLocal = new int[][]{this.adcCounts[index]};
            if (!ACalorimeterData.checkADCCountsAvailability(adcCountsLocal)) {
                AOutput.append("\nADC counts are not available for this cell, can't plot pulse shapes.", "WARNING");
                return;
            }
            logger.debug(this.CALORIMETER_NAME + " adc counts (digits) are " + "available for pulse shapes plots for this cell.");
            step = (float)(this.adcCounts[0].length - 1) / 401.0f;
            realPulse = new double[1][401];
            double d = 1.0;
            float cellPedestalLocal = this.cellPedestal[index];
            if (cellPedestalLocal == 0.0f) {
                logger.debug("MBTS cellPedestal is not available (i.e. are 0.0f), using first adcCount digit as pedestal.");
                cellPedestalLocal = this.adcCounts[index][0];
            }
            try {
                for (int i = 0; i < 401; ++i) {
                    realPulse[0][i] = this.getPhysicsPulseShape(d += step, (double)this.cellRawTime[index], (double)cellPedestalLocal, this.cellRawAmplitude[index], ACalorimeterRPSPLT.TILE_AMPLITUDE, ACalorimeterRPSPLT.TILE_TIME);
                }
            }
            catch (AAtlantisException aaex) {
                AOutput.append(aaex.getMessage(), "WARNING");
                return;
            }
        } else {
            logger.warn(this.CALORIMETER_NAME + " plotPulseShapes() method called, " + "but data is not available.");
            return;
        }
        APulseShapePlot.plotRealPulseShapes(adcCountsLocal, realPulse, step, null, title);
    }
}

