/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.AMuonHitData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AIdHelper;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;

public class AMDTData
extends AMuonHitData {
    protected float[] driftR;
    protected float[] length;
    private static final int BARREL = 1;
    private static ALogger logger = ALogger.getLogger(AMDTData.class);

    public String getParameterGroup() {
        return "MDT";
    }

    public String getName() {
        return "MDT";
    }

    public String getNameScreenName() {
        return "MDT";
    }

    AMDTData(AHashMap p, AEvent e) {
        super(p, e);
        this.driftR = p.getFloatArray("driftR");
        this.length = p.getFloatArray("length");
        for (int i = 0; i < this.numData; ++i) {
            if (!((double)this.driftR[i] > 1.46)) continue;
            this.driftR[i] = 1.46f;
        }
    }

    protected int getStation(int index) {
        try {
            String stationName = AIdHelper.stationName(this.id[index]);
            if (stationName.charAt(1) == 'I') {
                return 0;
            }
            if (stationName.charAt(1) == 'E') {
                return 1;
            }
            if (stationName.charAt(1) == 'M') {
                return 2;
            }
            if (stationName.charAt(1) == 'O') {
                return 3;
            }
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding MDT identifier", e);
        }
        return 0;
    }

    protected int getSub(int index) {
        try {
            if (AIdHelper.stationName(this.id[index]).charAt(0) == 'B') {
                return 1;
            }
            if (AIdHelper.stationEta(this.id[index]) < 0) {
                return 0;
            }
            return 2;
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding MDT identifier", e);
            return 1;
        }
    }

    public int getSector(int index) {
        try {
            String stationName = AIdHelper.stationName(this.id[index]);
            if (stationName.charAt(2) == 'L') {
                return 2 * (AIdHelper.stationPhi(this.id[index]) - 1);
            }
            return 2 * (AIdHelper.stationPhi(this.id[index]) - 1) + 1;
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding MDT identifier", e);
            return 0;
        }
    }

    protected boolean getMeasuresPhi(int index) {
        return false;
    }

    protected void applyCuts() {
        super.applyCuts();
        if (APar.get("CutsATLAS", "CutPhi").getStatus()) {
            this.cutPhi(this.phi, this.getDPhi());
        }
        this.cutEta(this.rho, this.z);
    }

    private float[] getDPhi() {
        float[] dphi = new float[this.numData];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            dphi[list] = (float)Math.abs(Math.atan2((double)this.length[list] / 2.0, this.rho[list]));
        }
        return dphi;
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n" + "\u03c1" + " = " + AMath.d2s(this.rho[index], 3) + "\n " + "z = " + AMath.d2s(this.z[index], 3) + " cm\n" + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
        }
        String temp = this.getNameScreenName() + " (id: " + this.identifier[index] + " index: " + index + ")\n " + "\u03c1" + " = " + AMath.d2s(this.rho[index], 3) + " cm" + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0" + "  (" + AMath.d2s(this.phi[index], 3) + " rad)\n " + "z = " + AMath.d2s(this.z[index], 3) + " cm\n " + "driftR = " + AMath.d2s(this.driftR[index], 3) + " cm";
        if (this.sector[index] != -1) {
            temp = temp + "\n sector = " + this.sector[index];
        }
        return temp;
    }

    private void makeDrawListYX() {
        int mode = APar.get("YX", "Mode").getI();
        if (mode > 0 && mode < 5) {
            this.numDraw = 0;
        } else {
            this.makeDrawList();
            if (mode == 0) {
                this.cut(" Barrel ", this.sub, "==", 1);
            } else {
                this.cut(" Endcaps", this.sub, "!=", 1);
                this.cut(" Station", this.station, "==", mode - 5);
            }
        }
    }

    private void makeDrawListFZ() {
        int mode = APar.get("FZ", "Mode").getI();
        if (mode > 0 && mode < 4) {
            this.numDraw = 0;
        } else {
            this.makeDrawList();
            if (mode == 0) {
                this.cut(" Endcaps", this.sub, "!=", 1);
            } else {
                this.cut(" Barrel ", this.sub, "==", 1);
                if (mode == 4) {
                    this.cut(" Station", this.station, "<=", mode - 3);
                } else {
                    this.cut(" Station", this.station, "==", mode - 3);
                }
            }
        }
    }

    protected ACoord getYXUser() {
        return this.getYXUser(0);
    }

    private ACoord getYXUser(int flag) {
        this.makeDrawListYX();
        int numPieces = 13;
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double r = this.rho[list];
            double cosPhi = Math.cos(this.phi[list]);
            double sinPhi = Math.sin(this.phi[list]);
            double phiM = Math.rint((double)this.phi[list] / 0.39269908169872414) * 0.39269908169872414;
            double cosPhiM = Math.cos(phiM);
            double sinPhiM = Math.sin(phiM);
            double d = (double)this.length[list] / 2.0;
            double x = r * cosPhi;
            double y = r * sinPhi;
            hv[0][i] = AMath.splitLineIntoPieces(new double[]{x + d * sinPhiM, x - d * sinPhiM}, numPieces);
            hv[1][i] = AMath.splitLineIntoPieces(new double[]{y - d * cosPhiM, y + d * cosPhiM}, numPieces);
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    protected ACoord getFRUser() {
        return this.getYXUser(1).convertYXToFR().includePhiWrapAround("FR");
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        int[] sign = new int[this.numDraw];
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        for (int i = 0; i < this.numDraw; ++i) {
            double phiDiff = Math.abs((double)this.phi[this.listdl[i]] - phiMid);
            sign[i] = -1;
            if (!(phiDiff < 1.5707963267948966) && !(phiDiff > 4.71238898038469)) continue;
            sign[i] = 1;
        }
        return this.getXZRZUser(sign);
    }

    protected ACoord getXZUser() {
        this.makeDrawList();
        this.cutMuonSector(this.sector);
        int[] sign = new int[this.numDraw];
        int sect = (int)Math.round(APar.get("XZ", "Phi").getD() / 22.5);
        for (int i = 0; i < this.numDraw; ++i) {
            sign[i] = 1;
            if (this.sector[this.listdl[i]] == sect) continue;
            sign[i] = -1;
        }
        return this.getXZRZUser(sign);
    }

    protected ACoord getXZRZUser(int[] sign) {
        int muonMode = APar.get("MDT", "Mode").getI();
        int numPoints = muonMode == 0 ? 48 : 2;
        double[][][] hv = new double[2][this.numDraw][numPoints];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double rC = (double)sign[i] * AMDTData.getSectorRho(this.sector[list], this.rho[list], this.phi[list]);
            double zC = this.z[list];
            double d = this.driftR[list];
            if (muonMode == 0) {
                for (int j = 0; j < numPoints; ++j) {
                    hv[0][i][j] = zC + d * Math.cos(Math.PI * 2 * (double)j / (double)(numPoints - 1));
                    hv[1][i][j] = rC + d * Math.sin(Math.PI * 2 * (double)j / (double)(numPoints - 1));
                }
            } else {
                double radius = Math.sqrt(rC * rC + zC * zC);
                double sinTheta = rC / radius;
                double cosTheta = zC / radius;
                hv[0][i][0] = zC + d * sinTheta;
                hv[1][i][0] = rC - d * cosTheta;
                hv[0][i][1] = zC - d * sinTheta;
                hv[1][i][1] = rC + d * cosTheta;
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    protected ACoord getFZUser() {
        this.makeDrawListFZ();
        double[][][] hv = new double[2][this.numDraw][2];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list;
            index[i] = list = this.listdl[i];
            hv[0][i][0] = this.z[list];
            hv[0][i][1] = this.z[list];
            double deltaPhi = Math.atan2((double)this.length[list] / 2.0, this.rho[list]);
            hv[1][i][0] = Math.toDegrees((double)this.phi[list] - deltaPhi);
            hv[1][i][1] = Math.toDegrees((double)this.phi[list] + deltaPhi);
        }
        return new ACoord(hv, index, (ADrawable)this, 3).includePhiWrapAround("FZ");
    }
}

