/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.AHelixAODData;
import atlantis.event.AEvent;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public class AMuonData
extends AHelixAODData {
    private float[] chi2;

    AMuonData(AHashMap p, AEvent e) {
        super(p, e);
        this.chi2 = p.getFloatArray("chi2");
    }

    public String getParameterGroup() {
        return "Muon";
    }

    public float getchi2(int index) {
        return this.chi2[index];
    }

    protected void applyCuts() {
        super.applyCuts();
        this.cut("CutsObjects", "MuonPt", " |ET|", this.pT);
        this.cut("CutsObjects", "Muonchi2", " |chi2|", this.chi2);
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n PT=" + AMath.d2s(this.pT[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Px=" + AMath.d2s((double)this.pT[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Py=" + AMath.d2s((double)this.pT[index] * Math.sin(this.phi[index]), 3) + " GeV " + "\n Pz=" + AMath.d2s((double)this.pT[index] * Math.sinh(this.eta[index]), 3) + " GeV ";
            }
            return output;
        }
        String k = this.getStoreGateKey();
        String sgKey = k != null ? k : "n/a";
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" (id: " + this.id[index] + " index: " + index + ")");
        msg.append("\n storegate key: ");
        msg.append(sgKey);
        msg.append("\n PT = ");
        msg.append(AMath.d2s(this.pT[index], 3));
        msg.append(" GeV\n P = ");
        msg.append(AMath.d2s(Math.abs((double)this.pT[index] / Math.cos(AMath.lambda(this.eta[index]))), 3));
        msg.append(" GeV\n ");
        msg.append("\u03b7");
        msg.append(" = ");
        msg.append(AMath.d2s(this.eta[index], 3));
        msg.append("\n ");
        msg.append("\u03a6");
        msg.append(" = ");
        msg.append(AMath.d2s(Math.toDegrees(this.phi[index]), 3));
        msg.append("\u00b0");
        msg.append("  (" + AMath.d2s(this.phi[index], 3) + " rad)");
        msg.append("\n chi2 = ");
        msg.append(this.chi2[index]);
        return msg.toString();
    }

    public double getP(int index) {
        return Math.abs((double)this.pT[index] / Math.cos(AMath.lambda(this.eta[index])));
    }

    public double getPt(int index) {
        return this.pT[index];
    }
}

