/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.AHitData;
import atlantis.data.ARPCData;
import atlantis.data.ATrackData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.parameters.AEnumeratorParameter;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public abstract class AMuonHitData
extends AHitData {
    protected float[] rho;
    protected float[] phi;
    protected float[] x;
    protected float[] y;
    protected float[] z;
    protected int[] sector;
    protected int[] station;
    protected boolean[] measuresPhi;
    public static final int DOES_NOT_MEASURE_PHI = 0;
    public static final int MEASURES_PHI = 1;
    String[] identifier;

    AMuonHitData(AHashMap p, AEvent e) {
        super(p, e);
        int i;
        this.x = p.getFloatArray("x");
        this.y = p.getFloatArray("y");
        this.z = p.getFloatArray("z");
        this.rho = new float[this.numData];
        this.phi = new float[this.numData];
        for (i = 0; i < this.numData; ++i) {
            this.rho[i] = (float)Math.sqrt(this.x[i] * this.x[i] + this.y[i] * this.y[i]);
            this.phi[i] = (float)Math.atan2(this.y[i], this.x[i]);
            if (!((double)this.phi[i] < 0.0)) continue;
            int n = i;
            this.phi[n] = (float)((double)this.phi[n] + Math.PI * 2);
        }
        this.identifier = p.getStringArray("identifier");
        this.station = new int[this.numData];
        this.sector = new int[this.numData];
        this.measuresPhi = new boolean[this.numData];
        for (i = 0; i < this.numData; ++i) {
            this.sub[i] = this.getSub(i);
            this.sector[i] = this.getSector(i);
            this.station[i] = this.getStation(i);
            this.measuresPhi[i] = this.getMeasuresPhi(i);
        }
    }

    protected int internalColor() {
        int numColorTypes = super.internalColor();
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == numColorTypes + 1) {
            this.colorBy(this.getSegments());
        }
        return numColorTypes + 1;
    }

    protected abstract int getStation(int var1);

    public abstract int getSector(int var1);

    protected abstract int getSub(int var1);

    protected abstract boolean getMeasuresPhi(int var1);

    protected String getSegments() {
        AEnumeratorParameter key = (AEnumeratorParameter)APar.get("MuonSegment", "MuonSegmentCollections");
        return "MuonSegment" + key.getCurrentText();
    }

    public int getRZSign(int index) {
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        double phiDiff = Math.abs((double)this.phi[index] - phiMid);
        int sign = -1;
        if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
            sign = 1;
        }
        return sign;
    }

    protected String getReconstructedTracks() {
        ATrackData tracks = this.event.getTrackData("MuonTrack");
        if (tracks == null) {
            return null;
        }
        return tracks.getName() + tracks.getStoreGateKey();
    }

    protected String getHits() {
        if (!(this instanceof ARPCData)) {
            return this.getName();
        }
        ARPCData rpc = this.event.getRPCData();
        if (rpc == null) {
            return null;
        }
        return ((AData)rpc).getName() + rpc.getStoreGateKey();
    }

    static double getSectorRho(int sector, double rho, double phi) {
        return rho * Math.abs(Math.cos(phi - (double)sector * 0.39269908169872414));
    }

    protected void applyCuts() {
        AData.printCut(this.getName(), this.numDraw);
        this.cutIndex();
        this.cutSimulatedTracks();
        this.cutReconstructedTracks();
        this.cutSegments();
    }

    protected void cutMuonSector(int[] sector) {
        AParameter p = APar.get("XZ", "Phi");
        if (p.getD() % 22.5 < 0.01) {
            int sect = (int)Math.round(p.getD() % 360.0 / 22.5);
            int num = 0;
            for (int i = 0; i < this.numDraw; ++i) {
                int s = sector[this.listdl[i]];
                if (s != sect && s != sect - 8 && s != sect + 8) continue;
                this.listdl[num++] = this.listdl[i];
            }
            this.numDraw = num;
        } else {
            this.numDraw = 0;
        }
        AData.printCut(" Sector", this.numDraw);
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n" + "\u03c1" + " = " + AMath.d2s(this.rho[index], 3) + "\n " + "z = " + AMath.d2s(this.z[index], 3) + "cm\n" + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
        }
        String temp = this.getNameScreenName() + " (id: " + this.identifier[index] + " index: " + index + ")" + "\n " + "\u03c1" + " = " + AMath.d2s(this.rho[index], 3) + " cm" + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0" + "  (" + AMath.d2s(this.phi[index], 3) + " rad)" + "\n z = " + AMath.d2s(this.z[index], 3) + " cm";
        if (this.sector[index] != -1) {
            temp = temp + "\n sector = " + this.sector[index];
        }
        return temp;
    }

    protected void setType() {
        int[][] recon = this.event.getAssociationManager().get(this.getName(), this.getReconstructedTracks());
        for (int i = 0; i < this.numData; ++i) {
            this.type[i] = recon != null && recon[i] != null ? (byte)1 : 0;
        }
    }

    protected void cutReconstructedTracks() {
        int cutOption = APar.get("CutsMuon", "HitsByRTr").getI();
        if (TEST_CUTS.getStatus()) {
            TEST_CUTS.setStatus(false);
            this.cutByAssociationTo(this.getReconstructedTracks(), this.getHits(), cutOption);
            TEST_CUTS.setStatus(true);
        } else {
            this.cutByAssociationTo(this.getReconstructedTracks(), this.getHits(), cutOption);
        }
        AData.printCut(" RTr", this.numDraw);
    }

    protected void cutSegments() {
        int cutOption = APar.get("CutsMuon", "HitsBySegment").getI();
        if (TEST_CUTS.getStatus()) {
            TEST_CUTS.setStatus(false);
            this.cutByAssociationTo(this.getSegments(), this.getHits(), cutOption);
            TEST_CUTS.setStatus(true);
        } else {
            this.cutByAssociationTo(this.getSegments(), this.getHits(), cutOption);
        }
        AData.printCut(" Segment", this.numDraw);
    }
}

