/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.data.ASegmentData;
import atlantis.event.AAssociation;
import atlantis.event.AEvent;
import atlantis.parameters.APar;
import atlantis.projection.AProjectionYX;
import atlantis.utils.AHashMap;

public class AMuonSegmentData
extends ASegmentData {
    AMuonSegmentData(AHashMap p, AEvent e) {
        super(p, e);
        String assocKey = this.getName() + this.getStoreGateKey();
        this.event.getAssociationManager().add(new AAssociation(assocKey, "MDT" + this.getDetectorStoreGateKey("MDT"), this.numHits, this.hits, this.event));
        this.event.getAssociationManager().add(new AAssociation(assocKey, "RPC" + this.getDetectorStoreGateKey("RPC"), this.numHits, this.hits, this.event));
        this.event.getAssociationManager().add(new AAssociation(assocKey, "TGC" + this.getDetectorStoreGateKey("TGC"), this.hits, this.event));
        this.event.getAssociationManager().add(new AAssociation(assocKey, "CSC" + this.getDetectorStoreGateKey("CSC"), this.numHits, this.hits, this.event));
    }

    public String getDetectorStoreGateKey(String detectorPart) {
        String detectorSGK = "";
        try {
            if (detectorPart.equals("MDT")) {
                detectorSGK = this.event.getMDTData().getStoreGateKey();
            }
            if (detectorPart.equals("RPC")) {
                detectorSGK = this.event.getRPCData().getStoreGateKey();
            }
            if (detectorPart.equals("TGC")) {
                detectorSGK = this.event.getTGCData().getStoreGateKey();
            }
            if (detectorPart.equals("CSC")) {
                detectorSGK = this.event.getCSCDData().getStoreGateKey();
            }
        }
        catch (Exception e) {
            return detectorSGK;
        }
        if (detectorSGK == null) {
            detectorSGK = "";
        }
        return detectorSGK;
    }

    public void makeDrawList() {
        super.makeDrawList();
        if (this.currentProjection instanceof AProjectionYX) {
            if (APar.get("YX", "Mode").getI() != 0) {
                this.numDraw = 0;
            } else {
                int num = 0;
                for (int i = 0; i < this.numDraw; ++i) {
                    int j = this.listdl[i];
                    if (!(Math.sqrt(this.x[j] * this.x[j] + this.y[j] * this.y[j]) > 650.0) || !((double)Math.abs(this.z[j]) < 1300.0)) continue;
                    this.listdl[num++] = j;
                }
                this.numDraw = num;
            }
        }
    }

    public String getParameterGroup() {
        return "MuonSegment";
    }

    public String getName() {
        return "MuonSegment";
    }

    public String getNameScreenName() {
        return "MuonSegment";
    }
}

