/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.canvas.AWindow;
import atlantis.data.ADHelix;
import atlantis.data.AHelix;
import atlantis.data.ATrackData;
import atlantis.event.AAssociation;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.graphics.AGraphics;
import atlantis.parameters.APar;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionVP;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;

public class AMuonTrackData
extends ATrackData {
    private static ALogger logger = ALogger.getLogger(AMuonTrackData.class);
    protected float[] phi0;
    protected float[] pT;
    protected float[] cotTheta;
    protected int[] author;

    AMuonTrackData(AHashMap p, AEvent e) throws AAtlantisException {
        super(p, e);
        String assocKey = this.getName() + this.getStoreGateKey();
        if (p.get("numHits") != null) {
            int[] numHits = p.getIntArray("numHits");
            int[] hits = p.getIntArray("hits");
            this.event.getAssociationManager().add(new AAssociation(assocKey, "MDT" + this.getDetectorStoreGateKey("MDT"), numHits, hits, this.event));
            this.event.getAssociationManager().add(new AAssociation(assocKey, "RPC" + this.getDetectorStoreGateKey("RPC"), numHits, hits, this.event));
            this.event.getAssociationManager().add(new AAssociation(assocKey, "TGC" + this.getDetectorStoreGateKey("TGC"), numHits, hits, this.event));
            this.event.getAssociationManager().add(new AAssociation(assocKey, "CSC" + this.getDetectorStoreGateKey("CSC"), numHits, hits, this.event));
        }
        this.phi0 = p.getFloatArray("phi0");
        this.pT = p.getFloatArray("pt");
        this.cotTheta = p.getFloatArray("cotTheta");
        this.author = p.getUnsureIntArray("trackAuthor");
    }

    public String getDetectorStoreGateKey(String detectorPart) {
        String detectorSGK = "";
        try {
            if (detectorPart.equals("MDT")) {
                detectorSGK = this.event.getMDTData().getStoreGateKey();
            }
            if (detectorPart.equals("RPC")) {
                detectorSGK = this.event.getRPCData().getStoreGateKey();
            }
            if (detectorPart.equals("TGC")) {
                detectorSGK = this.event.getTGCData().getStoreGateKey();
            }
            if (detectorPart.equals("CSC")) {
                detectorSGK = this.event.getCSCDData().getStoreGateKey();
            }
        }
        catch (Exception e) {
            return detectorSGK;
        }
        if (detectorSGK == null) {
            detectorSGK = "";
        }
        return detectorSGK;
    }

    public String getParameterGroup() {
        return "MuonTrack";
    }

    public String getName() {
        return "MuonTrack";
    }

    public String getNameScreenName() {
        return "MuonTrack";
    }

    protected void finalizeConstruction() {
        super.finalizeConstruction();
        this.h = new AHelix[this.numData];
        for (int i = 0; i < this.numData; ++i) {
            double p = AMath.getPFromPttL(this.pT[i], this.cotTheta[i]);
            double xVtx = APar.get("Event", "XVtx").getD();
            double yVtx = APar.get("Event", "YVtx").getD();
            double phiVtx = Math.atan2(yVtx, xVtx);
            double rho = Math.sqrt(xVtx * xVtx + yVtx * yVtx);
            double d0 = -rho * Math.sin((double)this.phi0[i] - phiVtx);
            double pTCorrected = (double)this.pT[i] * (p + 3.7) / p;
            this.h[i] = new AHelix((float)d0, (float)APar.get("Event", "ZVtx").getD(), (float)Math.toDegrees(this.phi0[i]), this.cotTheta[i], (float)pTCorrected);
        }
    }

    public void draw(AWindow window, AGraphics ag, AProjection2D projection) {
        if (projection instanceof AProjectionVP) {
            ag.draw(window.calculateDisplay(this.getVPUser(window, projection)));
        } else {
            super.draw(window, ag, projection);
        }
    }

    protected ACoord getVPUser(AWindow window, AProjection projection) {
        this.makeDrawList();
        double[][][] hv = new double[2][2 * this.numDraw][];
        int[] index = new int[2 * this.numDraw];
        int num = 0;
        for (int j = 0; j < this.numDraw; ++j) {
            int list = this.listdl[j];
            ADHelix dhelix = new ADHelix(this.h[list], this.event);
            double s1 = dhelix.getAStart();
            double s2 = 179.0;
            s1 = dhelix.intersectWithRadialCylinder(((AProjection2D)projection).getMinRho(), s1, s2);
            double sEnd = dhelix.intersectWithCylinder(true, AProjectionVP.getRhoVPlot(), true, AProjectionVP.getZVPlot());
            s2 = Math.max(Math.min(s2, sEnd), s1);
            if (s1 == 0.0 && s2 == 180.0) {
                s2 = 179.0;
            }
            if (APar.get("VP", "ShortV").getStatus() && !APar.get("Data", "S3D").getStatus()) {
                s1 = s2 - APar.get("VP", "ShortV").getD() * (s2 - s1);
            }
            if (!(s2 > s1)) continue;
            for (int sign = -1; sign <= 1; sign += 2) {
                AProjectionVP.sign = sign;
                ACoord pointsOnHelix = dhelix.drawHelix(window, (AProjection2D)projection, s1, s2);
                hv[0][num] = pointsOnHelix.hv[0][0];
                hv[1][num] = pointsOnHelix.hv[1][0];
                index[num] = list;
                ++num;
            }
        }
        ACoord coord = null;
        if (hv[0].length > 0 && hv[0][0] == null) {
            logger.warn("AMuonTrackData.getVPUser(): \"" + this.getName() + ":" + this.getStoreGateKey() + "\" can't be drawn in eta-phi");
            coord = ACoord.NO_DATA;
        } else {
            coord = new ACoord(hv, index, (ADrawable)this, 6);
        }
        return window.calculateUser(coord).includePhiWrapAround(projection.getName());
    }

    private float[] getEta() {
        float[] eta = new float[this.numData];
        if (this.polylinedTrack) {
            for (int i = 0; i < this.numData; ++i) {
                eta[i] = this.h != null && this.h[i] != null ? (float)this.h[i].eta : (float)AMath.eta(this.z[i][0], this.rho[i][0]);
            }
        } else {
            for (int i = 0; i < this.numData; ++i) {
                eta[i] = (float)this.h[i].eta;
            }
        }
        return eta;
    }

    protected void applyCuts() {
        AData.printCut(this.getName(), this.numDraw);
        this.cutIndex();
        this.cut("CutsInDet", "Pt", " |Pt|", this.pT);
        this.cut("CutsMuon", "Pt", " |Pt|", this.pT);
        this.cut("CutsInDet", "trackAuthor", " Author", this.author);
        this.cutPhi(this.phi0);
        if (APar.get("CutsATLAS", "CutEta").getStatus()) {
            this.cutEta(this.getEta());
        }
    }
}

