/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.AAODData;
import atlantis.event.AEvent;
import atlantis.parameters.APar;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;
import java.util.Vector;

public class APhotonData
extends AAODData {
    private int[] isEM;
    private Vector<Enum> isEMEnum = new Vector();
    private String[] label;

    APhotonData(AHashMap p, AEvent e) {
        super(p, e);
        String[] isEMString = p.getUnsureStringArray("isEMString");
        this.label = p.getUnsureStringArray("label");
        this.isEM = p.getUnsureIntArray("isEM");
        if (isEMString != null) {
            for (String s : isEMString) {
                try {
                    this.isEMEnum.add(isEMe.valueOf(s));
                }
                catch (IllegalArgumentException q) {
                    this.isEMEnum.add(isEMe.none);
                }
            }
        } else {
            for (int i = 0; i < this.numData; ++i) {
                this.isEMEnum.add(isEMe.none);
            }
        }
    }

    public String getParameterGroup() {
        return "Photon";
    }

    public String getName() {
        return "Photon";
    }

    public String getisEMEnum(int index) {
        return this.isEMEnum.get(index).toString();
    }

    public int getisEM(int index) {
        return this.isEM[index];
    }

    public String getlabel(int index) {
        return this.label[index];
    }

    protected void applyCuts() {
        super.applyCuts();
        this.cut("CutsObjects", "PhotonPt", " |ET|", this.pT);
        if (this.isEM != null) {
            for (int i = 0; i < this.isEM.length; ++i) {
                if (this.isEM[i] != 2048) continue;
                this.isEM[i] = 0;
            }
        }
        this.cut("CutsObjects", "PhotonisEM", " isEM", this.isEM);
        if (APar.get("CutsObjects", "PhotonisEMString").getStatus()) {
            int cutSub = APar.get("CutsObjects", "PhotonisEMString").getI();
            this.cutArrayEnum(this.isEMEnum, cutSub, "Photon isEMString");
        }
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n PT=" + AMath.d2s(this.pT[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Px=" + AMath.d2s((double)this.pT[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Py=" + AMath.d2s((double)this.pT[index] * Math.sin(this.phi[index]), 3) + " GeV " + "\n Pz=" + AMath.d2s((double)this.pT[index] * Math.sinh(this.eta[index]), 3) + " GeV ";
            }
            return output;
        }
        String k = this.getStoreGateKey();
        String sgKey = k != null ? k : "n/a";
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" (id: " + this.id[index] + " index: " + index + ")");
        msg.append("\n storegate key: ");
        msg.append(sgKey);
        msg.append("\n PT = ");
        msg.append(AMath.d2s(this.pT[index], 3));
        msg.append(" GeV\n P = ");
        msg.append(AMath.d2s(Math.abs((double)this.pT[index] / Math.cos(AMath.lambda(this.eta[index]))), 3));
        msg.append(" GeV\n ");
        msg.append("\u03b7");
        msg.append(" = ");
        msg.append(AMath.d2s(this.eta[index], 3));
        msg.append("\n ");
        msg.append("\u03a6");
        msg.append(" = ");
        msg.append(AMath.d2s(Math.toDegrees(this.phi[index]), 3));
        msg.append("\u00b0");
        msg.append("  (" + AMath.d2s(this.phi[index], 3) + " rad)");
        if (this.isEM != null) {
            msg.append("\n isEM = ");
            msg.append(this.isEM[index]);
        }
        if (this.label != null) {
            msg.append("\n label = ");
            msg.append(this.label[index]);
        }
        return msg.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum isEMe {
        Tight,
        Loose,
        none;

    }
}

