/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.AHitData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjectionVP;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public class APixelClusterData
extends AHitData {
    private float[] x;
    private float[] y;
    private float[] z;
    private float[] widthx;
    private float[] widthy;
    private int[] etaModule;
    private int[] phiModule;
    private float[] eloss;
    private float[][] rho;
    private float[][] phi;
    private int[] layer;
    public static final int U_CLUSTER = -1;
    public static final int PHI_CLUSTER = 0;
    public static final int V_CLUSTER = 1;
    public static final int ENDCAP_MINUS = 0;
    public static final int BARREL = 1;
    public static final int ENDCAP_PLUS = 2;

    public String getParameterGroup() {
        return "PixelCluster";
    }

    public String getName() {
        return "PixelCluster";
    }

    public String getNameScreenName() {
        return "PixelCluster";
    }

    public float[] getX() {
        return this.x;
    }

    public float[] getY() {
        return this.y;
    }

    public float[] getZ() {
        return this.z;
    }

    APixelClusterData(AHashMap p, AEvent e) {
        super(p, e);
        this.x = p.getFloatArray("x0");
        this.y = p.getFloatArray("y0");
        this.z = p.getFloatArray("z0");
        this.widthx = p.getFloatArray("widthx");
        this.widthy = p.getFloatArray("widthy");
        this.eloss = p.getFloatArray("eloss");
        this.rho = new float[2][this.numData];
        this.phi = new float[2][this.numData];
        this.layer = new int[this.numData];
        for (int i = 0; i < this.numData; ++i) {
            this.sub[i] = this.getSub(this.id[i]);
            this.layer[i] = this.getLayer(this.id[i]);
        }
        this.etaModule = p.get("etaModule") != null ? p.getIntArray("etaModule") : null;
        this.phiModule = p.get("phiModule") != null ? p.getIntArray("phiModule") : null;
    }

    protected void calculateRhoPhi() {
        this.calculateRhoPhi(this.x, this.y, this.rho[0], this.phi[0]);
        for (int i = 0; i < this.numData; ++i) {
            if (!((double)Math.abs(0.0f - this.phi[0][i]) > Math.PI) || !(0.0f - this.phi[0][i] > 0.0f)) continue;
            float[] fArray = this.phi[0];
            int n = i;
            fArray[n] = (float)((double)fArray[n] + Math.PI * 2);
        }
    }

    private void cutSubdetector() {
        AParameter par = APar.get("CutsInDet", "SCT");
        if (par.getI() != -1) {
            this.cutArray(this.sub, par.getI(), "Barrel/Endcap");
        }
    }

    protected void applyCuts() {
        AData.printCut("PixelCluster", this.numDraw);
        this.cutIndex();
        this.cutOrientation();
        this.cutSubdetector();
        this.cut("CutsInDet", "Layer", "Layer", this.layer);
        this.cutSimulatedTracks();
        this.cutReconstructedTracks();
        this.cutPhi(this.phi[0]);
        this.cutEta();
    }

    private void cutEta() {
        AParameter par = APar.get("CutsATLAS", "CutEta");
        if (!par.getStatus()) {
            return;
        }
        double etaCut = par.getD();
        double etaMid = APar.get("CutsATLAS", "EtaMiddle").getD();
        double etaLowerCut = etaMid - etaCut;
        double etaUpperCut = etaMid + etaCut;
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double eta1 = AMath.eta(this.z[list], this.rho[0][list]);
            if (!(eta1 > etaLowerCut) || !(eta1 < etaUpperCut)) continue;
            this.listdl[num++] = list;
        }
        this.numDraw = num;
        AData.printCut(" Eta", this.numDraw);
    }

    public int getLayer(int id) {
        int layer = id >> 27 & 3;
        int sub = this.getSub(id);
        if (sub != 1) {
            layer += 7;
        }
        return layer;
    }

    public int getSub(int id) {
        return id >> 29 & 3;
    }

    public int getOrientation(int id) {
        int side = (id & 0x400) >> 10;
        int sub = this.getSub(id);
        if (side == 1 && sub == 1 || side == 0 && sub != 1) {
            return 0;
        }
        int layer = this.getLayer(id);
        if (layer % 2 == 1) {
            return -1;
        }
        return 1;
    }

    protected void cutOrientation() {
        int num = 0;
        AParameter stereoAnglePar = APar.get("PixelCluster", "Stereo");
        if (!stereoAnglePar.getStatus()) {
            return;
        }
        int orientation = stereoAnglePar.getI();
        for (int i = 0; i < this.numDraw; ++i) {
            if (orientation != this.getOrientation(this.id[this.listdl[i]])) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
        AData.printCut("Orientation", this.numDraw);
    }

    protected int internalColor() {
        int numColorTypes = super.internalColor();
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == numColorTypes + 1) {
            this.colorBy(this.layer);
        } else if (colorFunction == numColorTypes + 2) {
            this.colorByOrientation();
        } else if (colorFunction == numColorTypes + 3) {
            this.colorByEloss();
        }
        return numColorTypes + 2;
    }

    protected void colorByOrientation() {
        int numColors = APar.get("HitColors", "Number").getI();
        numColors = Math.min(7, numColors);
        int[] col = APar.getArray("HitColors", "C1", numColors);
        for (int i = 0; i < this.numData; ++i) {
            this.color[i] = (byte)col[this.getOrientation(this.id[i]) + 1 % numColors];
        }
    }

    protected void colorByEloss() {
        int numColors = APar.get("HitColors", "Number").getI();
        numColors = Math.min(7, numColors);
        int[] col = APar.getArray("HitColors", "C1", numColors);
        for (int i = 0; i < this.numData; ++i) {
            if ((double)this.eloss[i] < 0.5) {
                this.color[i] = (byte)col[1 + 1 % numColors];
                continue;
            }
            if ((double)this.eloss[i] >= 0.5 && this.eloss[i] < 2.0f) {
                this.color[i] = (byte)col[5 + 1 % numColors];
                continue;
            }
            if (!(this.eloss[i] >= 2.0f)) continue;
            this.color[i] = (byte)col[2 + 1 % numColors];
        }
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index;
        }
        String temp = this.getNameScreenName() + " (id: " + this.id[index] + " index: " + index + ")\n" + " orientation = " + this.getOrientation(this.id[index]);
        temp = temp + "\n x = " + this.x[index];
        temp = temp + "\n y = " + this.y[index];
        temp = temp + "\n z = " + this.z[index];
        temp = temp + "\n \u03c1 = " + this.rho[0][index] + "  " + this.rho[1][index];
        temp = temp + "\n \u03b7 module = ";
        temp = temp + (this.etaModule != null ? Integer.toString(this.etaModule[index]) : "n/a");
        temp = temp + "\n \u03a6 module = ";
        temp = temp + (this.phiModule != null ? Integer.toString(this.phiModule[index]) : "n/a");
        temp = temp + "\n widthx = ";
        temp = temp + (this.widthx != null ? Float.toString(this.widthx[index]) : "n/a");
        temp = temp + "\n widthy = ";
        temp = temp + (this.widthy != null ? Float.toString(this.widthx[index]) : "n/a");
        temp = temp + "\n eloss = ";
        temp = temp + (this.eloss != null ? Float.toString(this.eloss[index]) : "n/a");
        temp = temp + super.getHitInfo(index);
        return temp;
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 1; ++j) {
                hv[0][j][i] = this.x[list];
                hv[1][j][i] = this.y[list];
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 1);
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiDiff = Math.abs((double)this.phi[0][list] - phiMid);
            double sign = phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469 ? 1.0 : -1.0;
            for (int j = 0; j < 1; ++j) {
                hv[0][j][i] = this.z[list];
                hv[1][j][i] = sign * (double)this.rho[j][list];
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 1);
    }

    protected ACoord getFRUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 1; ++j) {
                hv[0][j][i] = this.rho[j][list];
                hv[1][j][i] = Math.toDegrees(AMath.getPhiStereo(this.rho[j][list], this.phi[j][list], this.z[list]));
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 1).includePhiWrapAround("FR");
    }

    protected ACoord getFZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 1; ++j) {
                hv[0][j][i] = this.z[list];
                hv[1][j][i] = Math.toDegrees(AMath.getPhiStereo(this.rho[j][list], this.phi[j][list], this.z[list]));
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 1).includePhiWrapAround("FZ");
    }

    protected ACoord getVPUser() {
        this.makeDrawList();
        int numTotal = 2 * this.numDraw;
        double[][][] hv = new double[2][numTotal][2];
        int[] index = new int[numTotal];
        double[] sign = new double[]{-1.0, 1.0};
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double deltaEta = AProjectionVP.getDeltaEta(this.rho[0][list], this.z[list]);
            double eta = AMath.eta(this.z[list], this.rho[0][list]);
            for (int j = 0; j < 2; ++j) {
                hv[0][2 * i + j][0] = 2.0 * (eta + sign[j] * deltaEta);
                hv[1][2 * i + j][0] = 2.0 * Math.toDegrees(this.phi[0][list]);
                index[2 * i + j] = list;
            }
        }
        return new ACoord(hv, index, (ADrawable)this, 3).includePhiWrapAround("VP");
    }
}

