/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.AS3DData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public class APixelRDOData
extends AS3DData {
    private int[] etaModule = null;
    private int[] phiModule = null;

    public String getParameterGroup() {
        return "PixelRDO";
    }

    public String getName() {
        return "PixelRDO";
    }

    public String getNameScreenName() {
        return "PixelRDO";
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n" + "\u03c1" + " = " + AMath.d2s(this.rho[index], 3) + "\n " + "z = " + AMath.d2s(this.z[index], 3) + " cm\n" + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
        }
        String temp = this.getNameScreenName() + " (id: " + this.id[index] + " index: " + index + ")" + "\n " + "\u03c1" + " = " + AMath.d2s(this.rho[index], 3) + " cm" + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0" + "  (" + AMath.d2s(this.phi[index], 3) + " rad)" + "\n z = " + AMath.d2s(this.z[index], 3) + " cm";
        temp = temp + "\n \u03b7 module = ";
        temp = temp + (this.etaModule != null ? Integer.toString(this.etaModule[index]) : "n/a");
        temp = temp + "\n \u03a6 module = ";
        temp = temp + (this.phiModule != null ? Integer.toString(this.phiModule[index]) : "n/a");
        return temp;
    }

    APixelRDOData(AHashMap p, AEvent e) {
        super(p, e);
        this.id = p.getIntArray("id");
        this.etaModule = p.get("etaModule") != null ? p.getIntArray("etaModule") : null;
        this.phiModule = p.get("phiModule") != null ? p.getIntArray("phiModule") : null;
    }

    protected int internalColor() {
        int numColorTypes = super.internalColor();
        return numColorTypes + 1;
    }

    protected void applyCuts() {
        AData.printCut("PixelRDO", this.numDraw);
        this.cutIndex();
        this.cutPhi(this.phi);
        this.cutEta(this.rho, this.z);
        if (this.etaModule != null) {
            this.cut("CutsInDet", "EtaModule", " EtaModule", this.etaModule);
        }
        if (this.phiModule != null) {
            this.cut("CutsInDet", "PhiModule", " PhiModule", this.phiModule);
        }
        this.cutSubdetector();
    }

    private void cutSubdetector() {
        AParameter subPar = APar.get("CutsInDet", "SCT");
        if (subPar.getI() != -1) {
            this.cutArray(this.sub, subPar.getI(), "Barrel/Endcap");
        }
    }

    protected ACoord getFRUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.rho[list];
            v[i] = Math.toDegrees(AMath.getPhiStereo(this.rho[list], this.phi[list], this.z[list]));
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("FR");
    }

    protected ACoord getFZUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.z[list];
            v[i] = Math.toDegrees(AMath.getPhiStereo(this.rho[list], this.phi[list], this.z[list]));
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("FZ");
    }
}

