/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public abstract class AROIData
extends AData {
    protected float[] eta;
    protected float[] phi;
    protected float[] energy;
    private int drawOrFill = 1;

    AROIData(AHashMap p, AEvent e) {
        super(p, e);
        this.eta = p.getFloatArray("eta");
        this.phi = p.getFloatArray("phi");
        this.energy = p.getFloatArray("energy");
    }

    public float getEnergy(int index) {
        return this.energy[index];
    }

    public float getEta(int index) {
        return this.eta[index];
    }

    public float getPhi(int index) {
        return this.phi[index];
    }

    public float[] getEnergy() {
        return this.energy;
    }

    public float[] getEta() {
        return this.eta;
    }

    public float[] getPhi() {
        return this.phi;
    }

    protected int getDrawOrFill() {
        return this.drawOrFill;
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n Energy=" + AMath.d2s(this.energy[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
        }
        double deta = APar.get(this.PARAMETER_GROUP, "deta").getD();
        double dphi = APar.get(this.PARAMETER_GROUP, "dphi").getD();
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" (id: " + this.id[index] + " index: " + index + ")");
        msg.append("\n energy = ");
        msg.append(AMath.d2s(this.energy[index], 3));
        msg.append(" GeV\n ");
        msg.append("\u03b7");
        msg.append(" = ");
        msg.append(AMath.d2s(this.eta[index], 3));
        msg.append("\n ");
        msg.append("\u03a6");
        msg.append(" = ");
        msg.append(AMath.d2s(Math.toDegrees(this.phi[index]), 3));
        msg.append("\u00b0");
        msg.append("  (" + AMath.d2s(this.phi[index], 3) + " rad)");
        msg.append("\n deta = ");
        msg.append(AMath.d2s(deta, 3));
        msg.append("\n dphi = ");
        msg.append(AMath.d2s(Math.toDegrees(dphi), 3));
        msg.append("\u00b0");
        msg.append("  (" + AMath.d2s(dphi, 3) + " rad)");
        return msg.toString();
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == 0) {
            this.colorByConstant();
        } else if (colorFunction == 1) {
            this.colorByIndex();
        }
        return 1;
    }

    protected void applyCuts() {
        AData.printCut("ROI", this.numDraw);
        this.cutIndex();
        this.cutPhi(this.phi);
        this.cutEta(this.eta);
    }

    protected ACoord getVPUser() {
        this.drawOrFill = 0;
        double deta = APar.get(this.PARAMETER_GROUP, "deta").getD() / 2.0;
        double dphiDeg = Math.toDegrees(APar.get(this.PARAMETER_GROUP, "dphi").getD()) / 2.0;
        double phiDeg = 0.0;
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            phiDeg = Math.toDegrees(this.phi[list]);
            hv[0][i] = new double[]{(double)this.eta[list] - deta, (double)this.eta[list] - deta, (double)this.eta[list] + deta, (double)this.eta[list] - deta, (double)this.eta[list] + deta, (double)this.eta[list] - deta, (double)this.eta[list] + deta, (double)this.eta[list] + deta};
            hv[1][i] = new double[]{phiDeg - dphiDeg, phiDeg + dphiDeg, phiDeg - dphiDeg, phiDeg - dphiDeg, phiDeg + dphiDeg, phiDeg + dphiDeg, phiDeg - dphiDeg, phiDeg + dphiDeg};
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this).includePhiWrapAround("VP");
    }

    protected ACoord getYXUser() {
        this.drawOrFill = 1;
        double dphi = APar.get(this.PARAMETER_GROUP, "dphi").getD() / 2.0;
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiPlus = (double)this.phi[list] + dphi;
            double phiMinus = (double)this.phi[list] - dphi;
            double cosPlus = Math.cos(phiPlus);
            double sinPlus = Math.sin(phiPlus);
            double cosMinus = Math.cos(phiMinus);
            double sinMinus = Math.sin(phiMinus);
            double rhoPlus = 1150.0;
            double rhoMinus = 1130.0;
            hv[0][i][0] = rhoMinus * cosPlus;
            hv[1][i][0] = rhoMinus * sinPlus;
            hv[0][i][1] = rhoPlus * cosPlus;
            hv[1][i][1] = rhoPlus * sinPlus;
            hv[0][i][2] = rhoPlus * cosMinus;
            hv[1][i][2] = rhoPlus * sinMinus;
            hv[0][i][3] = rhoMinus * cosMinus;
            hv[1][i][3] = rhoMinus * sinMinus;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 4);
    }

    protected ACoord getFRUser() {
        ACoord coordFR = this.getYXUser().convertYXToFR().includePhiWrapAround("FR");
        return coordFR;
    }

    protected ACoord getRZUser() {
        this.drawOrFill = 1;
        double deta = APar.get(this.PARAMETER_GROUP, "deta").getD() / 2.0;
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][4];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
            double phiDiff = Math.abs((double)this.phi[list] - phiMid);
            double rSign = phiDiff > 1.5707963267948966 && phiDiff <= 4.71238898038469 ? -1.0 : 1.0;
            double theta = Math.atan(Math.exp(-Math.abs(this.eta[list]))) * 2.0;
            double thetaPlus = Math.atan(Math.exp(-((double)Math.abs(this.eta[list]) - deta))) * 2.0;
            double thetaMinus = Math.atan(Math.exp(-((double)Math.abs(this.eta[list]) + deta))) * 2.0;
            if ((double)this.eta[list] > 0.0 && rSign == -1.0) {
                theta = Math.PI * 2 - theta;
                thetaPlus = Math.PI * 2 - thetaPlus;
                thetaMinus = Math.PI * 2 - thetaMinus;
            } else if ((double)this.eta[list] < 0.0 && rSign == -1.0) {
                theta += Math.PI;
                thetaPlus += Math.PI;
                thetaMinus += Math.PI;
            } else if ((double)this.eta[list] < 0.0 && rSign == 1.0) {
                theta = Math.PI - theta;
                thetaPlus = Math.PI - thetaPlus;
                thetaMinus = Math.PI - thetaMinus;
            }
            double cosPlus = Math.cos(thetaPlus);
            double sinPlus = Math.sin(thetaPlus);
            double cosMinus = Math.cos(thetaMinus);
            double sinMinus = Math.sin(thetaMinus);
            boolean TOP_BOTTOM = false;
            boolean LEFT_RIGHT = true;
            int region = 0;
            if (Math.abs(Math.tan(theta)) < 0.8) {
                region = 1;
            }
            double radiusMinus = 0.0;
            switch (region) {
                case 0: {
                    radiusMinus = 1330.0 / Math.abs(Math.sin(theta));
                    break;
                }
                case 1: {
                    radiusMinus = 1630.0 / Math.abs(Math.cos(theta));
                }
            }
            double radiusPlus = radiusMinus + 20.0;
            hv[0][i][0] = radiusMinus * cosPlus;
            hv[1][i][0] = radiusMinus * sinPlus;
            hv[0][i][1] = radiusPlus * cosPlus;
            hv[1][i][1] = radiusPlus * sinPlus;
            hv[0][i][2] = radiusPlus * cosMinus;
            hv[1][i][2] = radiusPlus * sinMinus;
            hv[0][i][3] = radiusMinus * cosMinus;
            hv[1][i][3] = radiusMinus * sinMinus;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 4);
    }
}

