/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.data.AMDTData;
import atlantis.data.AMuonHitData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AIdHelper;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;

public class ARPCData
extends AMuonHitData {
    protected float[] width;
    protected float[] length;
    protected int[] gasGap;
    private static ALogger logger = ALogger.getLogger(ARPCData.class);

    public String getParameterGroup() {
        return "RPC";
    }

    public String getName() {
        return "RPC";
    }

    public String getNameScreenName() {
        return "RPC";
    }

    ARPCData(AHashMap p, AEvent e) {
        super(p, e);
        this.length = p.getFloatArray("length");
        this.width = p.getFloatArray("width");
        this.gasGap = new int[this.numData];
        for (int i = 0; i < this.numData; ++i) {
            this.gasGap[i] = this.getGasGap(i);
        }
    }

    protected int getStation(int index) {
        try {
            String stationName = AIdHelper.stationName(this.id[index]);
            if (stationName.charAt(1) == 'M') {
                return AIdHelper.rpcDoubletR(this.id[index]) - 1;
            }
            return AIdHelper.rpcDoubletR(this.id[index]) + 1;
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding RPC identifier", e);
            return 0;
        }
    }

    protected int getSub(int index) {
        return 0;
    }

    public int getSector(int index) {
        try {
            String stationName = AIdHelper.stationName(this.id[index]);
            if (stationName.charAt(2) == 'L') {
                return 2 * (AIdHelper.stationPhi(this.id[index]) - 1);
            }
            return 2 * (AIdHelper.stationPhi(this.id[index]) - 1) + 1;
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding RPC identifier", e);
            return 0;
        }
    }

    protected int getGasGap(int index) {
        try {
            return AIdHelper.rpcGasGap(this.id[index]);
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding RPC identifier", e);
            return 0;
        }
    }

    protected boolean getMeasuresPhi(int index) {
        try {
            if (AIdHelper.rpcMeasuresPhi(this.id[index]) == 1) {
                return true;
            }
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding RPC identifier", e);
        }
        return false;
    }

    protected void applyCuts() {
        super.applyCuts();
        if (APar.get("CutsATLAS", "CutPhi").getStatus()) {
            this.cutPhi(this.phi, this.getDPhi());
        }
        if (APar.get("CutsATLAS", "CutEta").getStatus()) {
            this.cutEtaDZ(this.rho, this.z, this.getDZ());
        }
    }

    private float[] getDPhi() {
        float[] dphi = new float[this.numData];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            dphi[list] = this.measuresPhi[list] ? (float)Math.abs(Math.atan2((double)this.width[list] / 2.0, this.rho[list])) : (float)Math.abs(Math.atan2((double)this.length[list] / 2.0, this.rho[list]));
        }
        return dphi;
    }

    private float[] getDZ() {
        float[] dz = new float[this.numData];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            dz[list] = this.measuresPhi[list] ? (float)((double)this.length[list] / 2.0) : (float)((double)this.width[list] / 2.0);
        }
        return dz;
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        this.cutArray(this.measuresPhi, true, " Strip");
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double r = this.rho[list];
            double cosPhi = Math.cos(this.phi[list]);
            double sinPhi = Math.sin(this.phi[list]);
            double phiSector = (double)this.sector[list] * 0.39269908169872414;
            double cosPhiSector = Math.cos(phiSector);
            double sinPhiSector = Math.sin(phiSector);
            double d = (double)this.width[list] / 2.0;
            if (!this.measuresPhi[list]) {
                d = (double)this.length[list] / 2.0;
            }
            double x = r * cosPhi;
            double y = r * sinPhi;
            double dx = d * sinPhiSector;
            double dy = d * cosPhiSector;
            hv[0][0][i] = x + dx;
            hv[1][0][i] = y - dy;
            hv[0][1][i] = x - dx;
            hv[1][1][i] = y + dy;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        this.cutArray(this.measuresPhi, false, " Strip");
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiDiff = Math.abs((double)this.phi[list] - phiMid);
            int sign = -1;
            if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
                sign = 1;
            }
            double rC = (double)sign * AMDTData.getSectorRho(this.sector[list], this.rho[list], this.phi[list]);
            double zC = this.z[list];
            double w = (double)this.width[list] / 2.0;
            hv[0][0][i] = zC - w;
            hv[1][0][i] = rC;
            hv[0][1][i] = zC + w;
            hv[1][1][i] = rC;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getXZUser() {
        this.makeDrawList();
        this.cutMuonSector(this.sector);
        this.cutArray(this.measuresPhi, false, " Strip");
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        int sect = (int)Math.round(APar.get("XZ", "Phi").getD() / 22.5);
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            int sign = 1;
            if (this.sector[list] != sect) {
                sign = -1;
            }
            double rC = (double)sign * AMDTData.getSectorRho(this.sector[list], this.rho[list], this.phi[list]);
            double zC = this.z[list];
            double w = (double)this.width[list] / 2.0;
            hv[0][0][i] = zC - w;
            hv[1][0][i] = rC;
            hv[0][1][i] = zC + w;
            hv[1][1][i] = rC;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getFRUser() {
        this.makeDrawList();
        this.cutArray(this.measuresPhi, true, " Strip");
        return this.getYXUser().convertYXToFR().includePhiWrapAround("FR");
    }

    private void makeDrawListFZ() {
        int mode = APar.get("FZ", "Mode").getI();
        if (mode == 0 || mode >= 4) {
            this.numDraw = 0;
        } else {
            this.makeDrawList();
            this.cut(" Station", this.station, "==", mode - 1);
        }
        this.cut("FZ", "RPCGasGap", " RPC Gas Gap", this.gasGap);
    }

    protected ACoord getFZUser() {
        this.makeDrawListFZ();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list;
            index[i] = list = this.listdl[i];
            if (this.measuresPhi[list]) {
                hv[0][i] = AMath.xBox(this.z[list], (double)this.length[list] / 2.0);
                hv[1][i] = AMath.yBox(Math.toDegrees(this.phi[list]), Math.toDegrees((double)this.width[list] / 2.0 / (double)this.rho[list]));
                continue;
            }
            double zC = this.z[list];
            double r = this.rho[list];
            double cosPhi = Math.cos(this.phi[list]);
            double sinPhi = Math.sin(this.phi[list]);
            double phiSector = (double)this.sector[list] * 0.39269908169872414;
            double cosPhiSector = Math.cos(phiSector);
            double sinPhiSector = Math.sin(phiSector);
            double d = (double)this.length[list] / 2.0;
            double w = (double)this.width[list] / 2.0;
            double x = r * cosPhi;
            double y = r * sinPhi;
            double dx = d * sinPhiSector;
            double dy = d * cosPhiSector;
            double phi1 = Math.toDegrees(Math.atan2(y - dy, x + dx));
            double phi2 = Math.toDegrees(Math.atan2(y + dy, x - dx));
            hv[0][i] = AMath.xBox(zC, w);
            hv[1][i] = AMath.yBox((phi1 + phi2) / 2.0, (phi1 - phi2) / 2.0);
        }
        return new ACoord(hv, index, (ADrawable)this).includePhiWrapAround("FZ");
    }
}

